; View compressed files with packer92 'CPkP' or shrink92 'CPkS'
;
	xdef	_main
	xdef	_comment

	xdef	_ti89
	xdef	_ti92plus

	include "tios.h"
	include "pk92lib.h"
	include "shrnklib.h"

PACKER92_COMPA	EQU	1

_main:
	bra.s	ok_main
hd:	dc.w	0
ok_main:
	; Get handle...
	move.w	hd(pc),d0
	bne.s	\hd_found
		; Get adress of the string
		move.l	tios::top_estack,a0
		subq.l	#1,a0		; We don't test the string TAG
		clr.w	-(a7)
		move.l	a0,-(a7)
		jsr	tios::SymFindPtr
		addq.l	#6,a7
		; Found ?
		move.l	a0,d0
		beq	notfound
		; Get handle
		move.w	SYM_ENTRY.hVal(a0),d0
\hd_found:
	clr.w	hd

	; Get adress of the file
	tios::DEREF	d0,a0

	; Skip the size of the string
	addq.l	#2,a0

	lea	extracting(pc),a2
	bsr.s	show_help

	move.w	#$700,d0
	trap	#1
	
	; Cmp signature
	move.l	(a0)+,d0
		ifne	PACKER92_COMPA
		cmp.l	#'CPkP',d0
		bne.s	test_shk92
	
			; Open archive with packer92
			moveq	#0,d0
			jsr	pk92lib::Extract
			tst.b	d0
			bne.s	illegal_prgm
			move.l	a1,a0
			bra.s	run
test_shk92
		endif
	cmp.l	#'CPkS',d0
	bne	test_arch

		; Open archive with Shrink92
		bsr.s	ShkOpen
		tst.w	d0
		beq.s	illegal_prgm
			moveq	#0,d1
			move.l	d1,a0
			bsr.s	ShkExtract
			bsr.s	ShkClose
			move.w	d2,d1
			beq.s	illegal_prgm

	; Run file with handle d1.w & adr: a0.l
run:
	move.w	d1,-(a7)	; Save it to free it later

	; Get adress of the prgm
;	move.l	a0,a5
;	addq.l	#2,a5		; Skip size of the prgm
	; Relocation...
;	moveq	#0,d1
;	move.w	(a0),d1
;	lea	1(a0,d1.l),a0
;	moveq	#0,d0
;\rloop:	
;	move.w	-(a0),d0
;	beq.s	\endr
;		moveq	#0,d1
;		move.w	-(a0),d1
;		add.l	a5,d1
;		move.l	d1,0(a5,d0.l)
;		bra.s	\rloop
;\endr:
	moveq	#0,d1
	move.w	(a0)+,d1
	move.l	a0,a5

	pea	-1(a0,d1.l)
	move.l	a5,-(a7)
	jsr	tios::EX_patch
	addq.l	#8,a7
	
	; Lock it ????????????
	move.w	(a7),d0
	bsr.s	HLock

	; Find libraries
	bsr	FindLibraries
	move.w	d4,-(a7)
	
	moveq	#000,d0
	trap	#1

	; Execution
	jsr	(a5)
	
	; Final
	bra	DelLibraries
	

	; Affiche un message
show_help:
	movem.l	d0-d7/a0-a6,-(a7)
	move.l	a2,-(a7)
	jsr	tios::ST_helpMsg
	addq.l  #4,a7
	movem.l	(a7)+,d0-d7/a0-a6
	rts

	; Libere l'handle alloue

Free:	move.w	d0,-(a7)
Free_stack:
	jsr	tios::HeapFree
	addq.w	#2,a7
	rts
	
illegal_prgm:
	lea	illegal_prgm_str(pc),a2
	bra.s	show_string

notfound:
	lea	pas_trouve_str(pc),a2
show_string:
	bsr.s	show_help
	moveq	#000,d0
	trap	#1
	clr.l	-(a7)
	clr.w	-(a7)
	jsr	tios::GKeyIn
	addq.l	#6,a7
	rts

ShkOpen:	jmp	shrnklib::OpenArchive
ShkExtract:	jmp	shrnklib::Extract
ShkClose:	jmp	shrnklib::CloseArchive

HLock	
	movem.l	d0-d7/a0-a6,-(a7)
	move.w	d0,-(a7)
	jsr	tios::HeapLock
	addq.w	#2,a7
	movem.l	(a7)+,d0-d7/a0-a6
	rts	

test_arch
	cmp.l	#'CPkA',d0
	bne.s	illegal_prgm

	; Plusieurs paquets a recreer.
	; Adr -> a0
	bsr.s	ShkOpen
	move.w	d0,d7
	beq.s	\error

	; Extraction de la table des noms
	moveq	#0,d1
	move.l	d1,a0
	bsr	ShkExtract
	move.l	a0,d0
	beq.s	\error
	move.w	d2,d4
	move.w	d2,d0
	bsr.s	HLock

	move.l	a0,a6

	moveq	#0,d6	
\loop:		bsr.s	find_next		; Recherche le nom suivant (a6)
		cmp.b	#-1,-1(a6)		; Test si fin table
		beq.s	\end
		
		addq.l	#1,d6			; 1 fichier de plus

		movea.w	#0,a0
		move.w	d6,d1			; Num fichier
		move.w	d7,d0			; Handle du fichier compresse
		bsr.s	ShkExtract		; Extraction donnes
		move.l	a0,d0
		beq.s	\loop			; Test erreur
		move.w	d2,d5
		
		move.l	a6,-(a7)
		jsr	tios::SymAdd		; Ajout variable
		addq.l	#4,a7
		tst.l	d0
		beq.s	\next_in_loop		; Erreur

		move.l	d0,-(a7)
		jsr	tios::DerefSym		; HSym
		addq.l	#4,a7
		
		move.w	d5,tios::SYM_ENTRY.hVal(a0)	; Sauve handle
		bra.s	\loop
\next_in_loop
		move.w	d5,d0			; Erreur creation fichier 
		bsr	Free			; Desallouer handle
		bra.s	\loop
\end:
\error:
	move.w	d4,d0				; Desalloue la table de fichiers
	bsr	Free
	
	moveq	#000,d0				; Reactive les int
	trap	#1

	move.w	d7,d0
	bra	ShkClose			; Ferme le fichier compresse
		

find_next:
	addq.l	#1,a6
\next		tst.b	(a6)+
		bne.s	\next
	subq.l	#1,a6
	rts

; Recherche fichier
; In:
;	a0 -> ANSI Str 
;	d0.w = 0 si folder courant / 4 si folder main
; Out:
;	a0 -> File
;	a1 -> SYM_ENTRY
;	d0.w = Handle
Find:
	movem.l	d1-d7/a2-a6,-(a7)
	
	lea	name_lib_end(pc),a1			; Copie nom
	move.l	a0,a2
\loop1		subq.l	#1,a1
		tst.b	(a2)+
		bne.s	\loop1
	clr.b	(a1)+

	; Recopie
	moveq	#8-1,d1
\loop		move.b	(a0)+,(a1)+
		beq.s	\stop
		dbf	d1,\loop
	addq.l	#1,a1
\stop	

	move.w	d0,-(a7)			; Search in folder (current or main)
	pea	name_lib_end(pc)		; -1(a1)
	jsr	tios::SymFindPtr
	addq.l	#6,a7
	move.l	a0,d0				; Found ?
	beq.s	\error
		move.w	SYM_ENTRY.hVal(a0),d0		; Get handle
		move.w	d0,d1
		move.l	a0,a1
		tios::DEREF	d1,a0			; Get adress of the file
\error	movem.l	(a7)+,d1-d7/a2-a6
	rts
	
;	EVEN
	; a5 -> Program
FindLibraries
	; 1er : recherche du fichier 'LIBCPKA' si echec on quitte.
	moveq	#4,d0				; Main
	lea	libcpka_str(pc),a0
	bsr.s	Find
	tst.w	d0				; Found ?
	beq.s	\quit
	
	addq.l	#2,a0				; Skip the size of the string
	move.l	(a0)+,d0			; Read Signa
	cmp.l	#'CPkA',d0
	bne.s	\quit				; Not good file.

	; Plusieurs paquets a recreer.
	bsr	ShkOpen
	move.w	d0,d7
	beq.s	\quit

	; Extraction de la table des noms
	moveq	#0,d1
	moveq	#0,d4		; Son handle est nul
	move.l	d1,a0
	bsr	ShkExtract
	move.l	a0,d0
	beq.s	\error

	; Sauvegarde et lock
	move.w	d2,d4
	move.w	d2,d0
	bsr	HLock
	move.l	a0,a4

	bsr	FindLibRecur

	; Libere le fichier des noms et le fichier compresse
	move.w	d4,-(a7)
	jsr	tios::HeapUnlock
	addq.l	#2,a7
\error:	move.w	d7,d0
	bsr	Free
\quit	rts
	
;	a5 -> Current file
;	a4 -> Table des noms
;	d7.w = Fichier compresse
;	d4.W = Handle table des noms
; Registres 
FindLibRecur:
	movem.l	a0-a6/d0-d7,-(a7)
	
	; Test si c un prog kernel sinon quitte.
	move.l	4(a5),d0
	cmp.l	#"68kP",d0
	beq.s	\ok_prgm
	cmp.l	#"68kL",d0
	bne	\quit
\ok_prgm:

	; Table d'import Nbr_lib = $1A(a5)
	lea	$1A(a5),a3
	move.w	(a3)+,d6
	beq	\quit			; Pas de libs importees

	; Pour chaque lib faire
	subq.w	#1,d6
\loop_lib	; Nom = 8 char + 2 null (a3)
 		; Si lib non-presente dans la vat
		move.l	a3,a0
		moveq	#0,d0	; Repertoire courant
		bsr	Find
		tst.w	d0
		bne	\next	; Trouve dans le repertoire courant

		move.l	a3,a0
		moveq	#4,d0	; Repertoire main
		bsr	Find
		tst.w	d0
		bne	\next	; Trouve dans le repertoire main
		
		; Test si lib presente dans le fichier des noms
		move.l	a4,a6	
		moveq	#0,d5
\loop_table:	bsr	find_next
		cmp.b	#-1,-1(a6)		; Test si fin de table
		beq.s	\next
			addq.w	#1,d5		; Un fichier en plus

			lea	name_lib_end(pc),a0
			move.l	a6,a1
	
\loop_cmp			move.b	-(a0),d0
				beq.s	\final_cmp
				cmp.b	-(a1),d0
				beq.s	\loop_cmp
				bra.s	\loop_table
\final_cmp			cmp.b	#'\',-(a1)
				bne.s	\loop_table

				; La marquer pour effacement
				pea	(a1)
				
				; Afficher 'Extracting 'graphlib'",0
				lea	1(a0),a2
				bsr	show_help

				; extraire ce fichier
				movea.w	#0,a0
				move.w	d5,d1			; Num fichier
				move.w	d7,d0			; Handle du fichier compresse
				bsr	ShkExtract		; Extraction donnes
				move.l	a0,d0
				beq.s	\next			; Test erreur
				move.w	d2,-(a7)		; Sauve handle
		
				; L'ajouter dans la vat
				move.l	a6,-(a7)
				jsr	tios::SymAdd		; Ajout variable
				addq.l	#4,a7
				tst.l	d0
				bne.s	\ok		; Erreur
					move.w	(a7)+,d0
					bsr	Free
					bra.s	\next
\ok:

				move.l	d0,-(a7)
				jsr	tios::DerefSym		; HSym
				addq.l	#4,a7
				
				move.w	(a7)+,d0
				move.w	d0,tios::SYM_ENTRY.hVal(a0)	; Sauve handle
				
				; Sauver son nom pour effacement futur...
				move.l	(a7)+,a1
				move.b	#'/',(a1)

				; FindLibRecur(Libraries)
				tios::DEREF	d0,a5	; Get Adr of lib
				addq.l	#2,a5
				bsr	FindLibRecur
		; Lib  += 10
\next		lea	10(a3),a3	; Next lib
		dbf	d6,\loop_lib

\quit	movem.l	(a7)+,a0-a6/d0-d7
	rts

	
DelLibraries:
	move.w	(a7),d4
	tios::DEREF	d4,a6
	clr.b	d4
\loop		
		addq.l	#1,a6
		cmp.b	#'/',(a6)
		bne.s	\not_marked
			move.b	#'\',(a6)
			st.b	d4
\not_marked:	
		tst.b	(a6)
		bne.s	\skip
			tst.b	d4
			beq.s	\skip
				clr.b	d4
				pea	(a6)
				jsr	tios::SymDel
				addq.l	#4,a7
\skip		cmp.b	#$FF,(a6)
		bne.s	\loop

	move.w	(a7)+,d0
	bsr	Free
	bra	Free_stack
	
libcpka_str		dc.b "libcpka",0
pas_trouve_str:		dc.b "File not found",0
illegal_prgm_str:	dc.b "Illegal archive",0
extracting:		dc.b "Extracting...",0
name_lib		dc.b 0,0,0,0,0,0,0,0
name_lib_end		dc.b 0

_comment:	dc.b "RunC 1.50",0

	end
