; View compressed files with packer92 'CPkP' or shrink92 'CPkS'
;
	xdef	_main
	xdef	_comment

	xdef	_ti89
	xdef	_ti92plus

	include "tios.h"
	include "pk92lib.h"
	include "shrnklib.h"
	include "api92.h"
	include	"api92cst.h"

	include "pctplug.h"             ;and after we include pctplug.h

;--------------------------------------------------------------------
; Header of PCTOOLS 98 plugin
;--------------------------------------------------------------------

	PRG_AS_PLUGIN

EXTENSION_FILTER:
	dc.b	1,EXT_STR
	ds.w	0

PLUGIN_TABLE:
	dc.l	NOT_USED		;start_of_pct98
	dc.l	NOT_USED		;end_of_pct98
	dc.l	NOT_USED		;key_pressed
	dc.l	NOT_USED		;key_pressed_first
	dc.l	RunPrgm			;enter_pressed
	dc.l	CursorMoved		;cursor_moved
	dc.l	NOT_USED		;draw_item
	dc.l	NOT_USED		;menu_string
	dc.l	NOT_USED		;menu_function
	dc.l	NOT_USED		;compression_service
	dc.l	NOT_USED		;use_menu


;--------------------------------------------------------------------
; Normal launch of the program
;--------------------------------------------------------------------
END_PLUGIN_TABLE:
	rts
	

;-----------------------------------------------------
; Plugin Function :	when the user select a
;			a PIC file in PCT98
;
;-----------------------------------------------------
CursorMoved:
	move.w	$10(a0),d0		;Handle of selected file
	beq.s	exit

	bsr.s	check
	beq.s	exit
	
	lea	pk92_file(pc),a2
	subq.w	#1,d0
	beq.s	\ok
		lea	shk_file(pc),a2
\ok:	bsr.s	show_help
	rtplugin	SKIP_PCTPROCESS+SKIP_NEXTPLUGINS

exit	rtplugin 0

;-----------------------------------------------------
; Signature check
;
;-----------------------------------------------------
; In: d0.W =Handle
check:
	tios::DEREF	d0,a0
	addq.l	#2,a0
	move.l	(a0)+,d0
	cmp.l	#'CPkP',d0
	beq.s	\packer92
	cmp.l	#'CPkS',d0
	beq.s	\shrink
	moveq	#0,d0
	rts
\packer92
	moveq	#1,d0
	rts
\shrink	moveq	#2,d0
	rts

;-----------------------------------------------------
; Show help
;
;-----------------------------------------------------
show_help:
	movem.l	d0-d7/a0-a6,-(a7)
	move.l	a2,-(a7)
	jsr	tios::ST_helpMsg
	addq.l  #4,a7
	movem.l	(a7)+,d0-d7/a0-a6
	rts
	
;-----------------------------------------------------
; Run program
;
;-----------------------------------------------------
RunPrgm:
	move.w	$10(a0),d0			;Handle of selected item

	bsr.s	check
	beq.s	exit
	
	lea	extracting(pc),a2
	bsr.s	show_help
	
	subq.w	#1,d0
	beq.s	\packer92
	
\shrink		; Open archive with Shrink92
		jsr	shrnklib::OpenArchive
		tst.w	d0
		beq.s	exit
		moveq	#0,d1
		move.l	d1,a0
		jsr	shrnklib::Extract
		jsr	shrnklib::CloseArchive
		move.w	d2,d1
		beq.s	exit
		bra.s	\run

		; Open archive with packer92
		; 's', 'n' or 'd'
\packer92:
		moveq	#0,d0
		jsr	pk92lib::Extract
		tst.b	d0
		bne	exit

	; Open file with handle d1.w
\run:
	lea	extract_done(pc),a2
	bsr.s	show_help

	move.w	d1,-(a7)	; Save it to free it later

	; Get adress of the prgm
	tios::DEREF	d1,a0
	move.l	a0,a5
	addq.l	#2,a5		; Skip size of the prgm
	cmp.l	#"68kP",4(a5)	
	bne.s	\format

	; Relocation...
	moveq	#0,d1
	move.w	(a0),d1
	lea	1(a0,d1.l),a0
\rloop:		moveq	#0,d0
		move.w	-(a0),d0
		beq.s	\endr
		moveq	#0,d1
		move.w	-(a0),d1
		add.l	a5,d1
		move.l	d1,0(a5,d0.l)
		bra.s	\rloop
\endr:	jsr	(a5)		; Exec the prgm
\format:
	jsr	tios::HeapFree	; Free the handle
	addq.l	#2,a7
	
	rtplugin	SKIP_PCTPROCESS+SKIP_NEXTPLUGINS+REDRAW_SCREEN

extracting:		dc.b "Extracting...",0
extract_done:		dc.b "Extracting done !",0
pk92_file:		dc.b "Program compressed by pk92lib",0
shk_file:		dc.b "Program compressed by shrnklib",0
pas_trouve_str		dc.b "Prgm not found",0
illegal_prgm_str	dc.b "Illegal prgm",0
_comment:		dc.b "PkSk viewer",0

	end
