/***************
 *  STRING92.C                    by David Khling
 *************** 
 *
 * This file contains a routine, `Create92S', that creates a TI-Graph Link
 * string variable.
 *
 * You can contact me via email till june 2000 by:
 *   dkuehlin@hell1og.be.schule.de (don't mix up 'l' and '1')
 * Since this email address is at my account at school, it is possible that
 * sometimes can't receive your mails (hollidays, weekend, server crashes
 * etc.) So it is safer to contact me by normal mail:
 *   David Khling
 *   Lion-Feuchtwanger-Str. 44
 *   12619 Berlin
 *   GERMANY
 *
 * Last modification: january 1999
 *
 * This program is Freeware and may be used for any non commercial purpose.
 * `(Of course I would appreceateto be informed about modifications, releases
 * using its source etc.)
 *
 */


#include <stdio.h>
#include <malloc.h>
#include <string.h>
#include <time.h>

/**
 * Create a checksum by adding all bytes from `data' into an unsigned
 * variable.
 */
unsigned short GenerateChecksum (unsigned char *data, long len)
{
   unsigned short sum;
   long     I;

   for (sum = I = 0; I < len; I++)
      sum += data[I];

   return (sum);
}

/**
 * Create a TI-92 Graph Link string variable (*.92s) of the data, given by
 * `data' and `len'. The size-of-variable-word at the beginning of the
 * variable and the string-identifier at the end are automatically added.
 * An additional zero-byte is also added to the string variable's end to
 * make the TI-92 display the string as an empty string (strings are
 * processed from the end to the beginning).
 * Returns nonzero on error. In this case the `errno' variable will specify
 * the error.
 */
int Create92S (unsigned char *data, long len, char *fileName)
{
   FILE     *h;                    // handle of output file
   char     *name,                 // pointer to name part of file
            *tmp;
   unsigned varLen = len+3,        // length-field of TIOS-variable
            checksum;              // Graph Link file's checksum
   long     fileLen = varLen+0x5A; // length-field of Graph Link file
   time_t   now;                   // current time

   time(&now);

   if (!(h = fopen (fileName, "wb")))
      return (1);

   /** get the name part of the filename (without fnsplit) */
   name = (tmp = strrchr (fileName, '/')) ? tmp+1: fileName;
   name = (tmp = strrchr (name, '\\')) ? tmp+1 : name;
   name = (tmp = strrchr (name, ':')) ? tmp+1 : name;
   name = strncpy (malloc (9), name, 8);
   name[8] = '\0';
   if ((tmp = strrchr (name, '.')))     // remove extension, if exists
     *tmp = '\0';

   /** create the header */
   fwrite ("**TI92**\x01\x00", 1, 10, h);       // TI-Graph Link signature
   fwrite ("main\0\0\0\0", 1, 8, h);            // name of folder
   fwrite ("Archive dated ", 1, 14, h);         // file description
   fwrite (asctime (localtime (&now)), 1, 24, h);
   fwrite ("\x00\x00\x01\x00", 1, 4, h);        // end of description
   fwrite ("\x52\x00\x00\x00", 1, 4, h);        // ??
   fwrite (name, 1, 8, h);                      // name of variable
   fwrite ("\x0C\x00\x00\x00", 1, 4, h);        // ??
   fputc (fileLen     & 0xFF, h);               // length of Graph Link file
   fputc (fileLen>> 8 & 0xFF, h);               // (Intel byte order)
   fputc (fileLen>>16 & 0xFF, h);
   fputc (fileLen>>24 & 0xFF, h);
   fwrite ("\xA5\x5A\x00\x00\x00\x00", 1, 6, h);// ??

   /** output the string variable */
   fputc (varLen>>8 & 0xFF, h);                 // length of variable
   fputc (varLen    & 0xFF, h);                 // (Motorola byte order)
   fwrite (data, 1, len, h);                    // DATA
   fputc (0x00, h);                             // make it an empty string
   fputc (0x00, h);                             // string token
   fputc (0x2D, h);
   /** end of string variable */

   checksum = GenerateChecksum (data, len) +    // output Graph Link checksum
              (varLen>>8) + (varLen&0xFF) + 0x2D;
   fputc (checksum    & 0xFF, h);               // (Intel byte order)
   fputc (checksum>>8 & 0xFF, h);

   fclose (h);

   return (0);
}
