/***************
 *  STRING92.H                    by David Khling
 ***************
 *
 * Header file of the TI-Graph Link string variable creation module
 * `STRING92.C'
 *
 * You can contact me via email till june 2000 by:
 *   dkuehlin@hell1og.be.schule.de (don't mix up 'l' and '1')
 * Since this email address is at my account at school, it is possible that
 * sometimes can't receive your mails (hollidays, weekend, server crashes
 * etc.) So it is safer to contact me by normal mail:
 *   David Khling
 *   Lion-Feuchtwanger-Str. 44
 *   12619 Berlin
 *   GERMANY
 *
 * Last modification: january 1999
 *
 * This programm is Freeware and may be used for any non commercial purpose.
 * `(Of course I would appreceateto be informed about modifications, releases
 * using its source etc.)
 *
 */

/** 
 * Create a TI-92 Graph Link string variable (*.92s) named `fileName' of
 * the data, given by `data' and `len'. The size-of-variable-word at the
 * beginning of the variable and the string-identifier at the end are
 * automatically added. An additional zero-byte is also added to the string
 * variable's end to make the TI-92 display the string as an empty string
 * (strings are processed from the end to the beginning).
 * Returns nonzero on error. In this case the `errno' variable will specify
 * the error.
 */
int Create92S (char *data, long len, char *fileName);

/**
 * Create a checksum by adding all bytes from `data' into an unsigned
 * variable.
 */
unsigned short GenerateChecksum (unsigned char *data, long len);
