/******************************************************************************
*
* project name:  TICT-Explorer
* file name:     tictex.c
* initial date:  19/12/2000
* author:        thomas.nussbaumer@gmx.net
*                Benjamin Canou aKa janjan2 (mods for TI92p/V200 fullscreen)
*
* description:   main program
*
* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
* Many THANX to Zeljko Juric !!
*
* Without his advices about the internals of the AMS 2.05 protection schemes
* this program wouldn't exists.
* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
*
* NOTE: This program is supposed to be started from its own launcher (tictex)
*
*
* $Id: tictexpl.c,v 1.14 2002/10/01 09:08:18 tnussb Exp $
*
******************************************************************************/

//-----------------------------------------------------------------------------
// check for -DUSE_TI89 commandline flag (for TI-89 version)
// *** or ***
// check for -DUSE_TI92P commandline flag (for TI-92p/V200 version)
//
// ONLY ONE IS ALLOWED PER COMPILE RUN
//-----------------------------------------------------------------------------
#if defined(USE_TI89) && defined(USE_TI92P)
#error cannot produce both versions at once
#elif defined(USE_TI89)
#define C89_92(x,y) (x)
#elif defined(USE_TI92P)
#define USE_V200           // treat V200 as TI92p
#define C89_92(x,y) (y)
#else
#error Please define either USE_TI89 or USE_TI92P (V200 will be treated as TI92p)
#endif


#define NO_EXIT_SUPPORT
#define OPTIMIZE_ROM_CALLS
#include <tigcclib.h>


//-----------------------------------------------------------------------------
// messages.c is shared between the launcher (tictex.c) and the explorer
// (messages.c includes interface.h internally)
//-----------------------------------------------------------------------------
#define MSGS_EXPLORER
#include "messages.c"


//-----------------------------------------------------------------------------
// NOTE: the following two long words are searched by the launcher (tictex.c)
//       and the first long word is replaced with a pointer to a
//       TICTEX_INTERFACE structure. The second long word is replaced by a
//       version number string to make sure that the launcher and this explorer
//       fits together
//-----------------------------------------------------------------------------
volatile unsigned long magic[2] = {MAGIC_EXPLORER1,MAGIC_EXPLORER2};


//-----------------------------------------------------------------------------
// just used for easy typing (will be taken from magic[0] after the launcher
// had entered there a valid pointer to an instance of structure
// TICTEX_INTERFACE)
//-----------------------------------------------------------------------------
volatile TICTEX_INTERFACE* pti  = NULL;


//-----------------------------------------------------------------------------
// Some debug defines which enables additionally testing functionalities
// (I cannot garantee that all still works after all my restructurings)
//
// NOTE: some of the defines are VERY dangerous! The HALT defines will force
//       the program into an endless loop (not a good idea on a real calc)
//-----------------------------------------------------------------------------
//#define DEBUG_SHOW_FILETAGS   // uncomment to show filetags instead of exp
//#define DEBUG_MAX_SIZE        // uncomment for layout debug reasons
//#define DEBUG_HALT_BEFORE     // uncomment this to halt VTI before execute prg
//#define DEBUG_HALT_AFTER      // uncomment this to halt VTI after execute prg
//#define DEBUG_10SEC_APD       // uncomment to set APD to 10 seconds
//#define DEBUG_SHOWTWIN        // uncomment this to show TWIN   symbols
//#define DEBUG_SHOWLOCAL       // uncomment this to show LOCAL  symbols
//#define DEBUG_SHOWHIDDEN      // uncomment this to show HIDDEN symbols
#define START_DOORS_EXE         // uncomment this to start kernel-based prgs
#define DISABLE_SOME_PRGS       // uncomment to disable "install","kernel" and
                                // "doorsos" programs

//-----------------------------------------------------------------------------
// smart debug macro
//-----------------------------------------------------------------------------
#define DBGOUT(_msg_) {ST_showHelp((_msg_));ngetchx();}


//-----------------------------------------------------------------------------
// calculator depended definitions and globals
//-----------------------------------------------------------------------------
#define PIX_WIDTH   C89_92(160,240)
#define PIX_HEIGHT  C89_92(100,128)
#define OFFSET_X    C89_92(0,40)
#define OFFSET_Y    C89_92(0,14)
#define KEY_UP2ND   C89_92(4433,4434)
#define KEY_DOWN2ND C89_92(4436,4440)

#define VAL_DIAMOND C89_92(16384,8192)
#define VAL_SHIFT   C89_92(8192,16384)

#define NR1_2ND   C89_92(34,  149)
#define NR2_2ND   C89_92(92,  4146)
#define NR3_2ND   C89_92(4147,4147)
#define NR4_2ND   C89_92(58,  4148)
#define NR5_2ND   C89_92(4149,4149)
#define NR6_2ND   C89_92(4150,4150)
#define NR7_2ND   C89_92(4151,4151)
#define NR8_2ND   C89_92(4152,4152)
#define NR9_2ND   C89_92(59,  4153)

#define X_FOLDER       1
#define X_SCROLL      50

#define X_MARK        52
#define X_STATE       58
#define X_NAME        64
#define X_TYPE        113

SCR_RECT fullscreen     = {{ 0, 0,C89_92(159,239),C89_92(99,127)}};
SCR_RECT top            = {{ 1, 1,C89_92(158,238), 6}};
SCR_RECT scroll_folders = {{ 1, 7, 48,C89_92(86,111)}};
SCR_RECT scroll_files   = {{52, 7,C89_92(158,238),C89_92(86,111)}};

//-----------------------------------------------------------------------------
// definitions of mode (where we are: in the folder list or in the file list)
// and the global which is used to store the active mode
//-----------------------------------------------------------------------------
#define SCROLL_FOLDER 0
#define SCROLL_FILE   1

short  global_mode = SCROLL_FOLDER;


//-----------------------------------------------------------------------------
// number of maximum characters used for a file comment
//-----------------------------------------------------------------------------
#define MAX_COMMENT 32


//-----------------------------------------------------------------------------
// special structure similiar to SYM_ENTRY, but with some nice extensions like
// 0-ending strings (easier to print ;-)
//-----------------------------------------------------------------------------
typedef struct {
    unsigned char  name[9];
    unsigned char  type;
    unsigned char  ext[5];
    unsigned short marked;
    unsigned char  size[6];
    unsigned char  comment[MAX_COMMENT+1];

    union
      {
        unsigned short flags_n;
        struct
          {
            unsigned short busy      : 1, local       : 1, flag1_5     : 1, flag1_4     : 1,
                           collapsed : 1, twin        : 1, archived    : 1, in_view     : 1;
            unsigned short folder    : 1, overwritten : 1, checked     : 1, hidden      : 1,
                           locked    : 1, statvar     : 1, graph_ref_1 : 1, graph_ref_0 : 1;
          } bits;
      } flags;
} file_t;


//-----------------------------------------------------------------------------
// special structure used for folder entries (just the name ...)
//-----------------------------------------------------------------------------
typedef struct {
    unsigned char name[9];
} folder_t;


//-----------------------------------------------------------------------------
// value used to set a file to state MARKED
//-----------------------------------------------------------------------------
#define FILE_MARKED      1


//-----------------------------------------------------------------------------
// ... and here comes the globals ...
//-----------------------------------------------------------------------------
file_t*   file_list         = NULL;
short     file_count        = 0;
short     file_max          = 0;
folder_t* folder_list       = NULL;
short     folder_count      = 0;
short     folder_max        = 0;
short     active_folder     = 0;
short     active_file       = 0;
short     folder_winpos     = 0;
short     file_winpos       = 0;
char      folder_backup[10] = {0};

void DrawStatusLine(const char* msg);
#if defined(USE_TI89)
unsigned short MapTI89Numbers(unsigned short input);
#endif

//-----------------------------------------------------------------------------
// vatutils.c contains useful routines for handling the VAT
//-----------------------------------------------------------------------------
#include "vatutils.c"


/*===========================================================================*/
/* returns 0 if not a [2ND]+[NUMBER] combo ([2ND]+[0] is NOT valid)          */
/* otherwise value of [NUMBER] is returned                                   */
/*===========================================================================*/
unsigned short Get2ndNumber(unsigned short input) {
    switch(input) {
        case NR1_2ND: return 1;
        case NR2_2ND: return 2;
        case NR3_2ND: return 3;
        case NR4_2ND: return 4;
        case NR5_2ND: return 5;
        case NR6_2ND: return 6;
        case NR7_2ND: return 7;
        case NR8_2ND: return 8;
        case NR9_2ND: return 9;
        default:      return 0;
    }
}


/*===========================================================================*/
/* get input key pressed by user                                             */
/*                                                                           */
/* replacement for ngetchx() and/or GKeyIn(), because:                       */
/*                                                                           */
/* (1) ngetchx() won't check the APD timer value                             */
/* (2) GKeyIn() destroys the display due to setting the status display       */
/*                                                                           */
/* additionally this function handles the CALCULATOR OFF combinations        */
/*                                                                           */
/*===========================================================================*/
unsigned short GetUserInput(void) {
    void           *kbq = kbd_queue();
    unsigned short  key;

    //-------------------------------------------
    // restart the APD timer now
    //-------------------------------------------
    OSTimerRestart(APD_TIMER);

    while (1) {
        //---------------------------------------
        // wait until we get a key
        // if the APD timer expires -> turn
        // calculator off
        //---------------------------------------
        while (OSdequeue(&key, kbq)) {
            idle();
            if (OSTimerExpired(APD_TIMER)) {
                off();
                OSTimerRestart(APD_TIMER);
            }
        }

        //---------------------------------------
        // handle calculator-off key combinations
        // if the APD timer expires
        // [2nd] + [ON] & [diamond]+[ON]
        // calculator off
        //---------------------------------------
#if defined(USE_TI89)
        if (key == 4363 || key == 16651) {
#else
        if (key == 4363 || key == 8459) {
#endif
            off();
            OSTimerRestart(APD_TIMER);
        }
        else {
            return key & ~(unsigned short)0x800; // map out key repeat flag
        }
    }
}


//=============================================================================
// fills a specified number of lines with given byte value (NOTE: on the TI89
// it will fill more than what is visible on the screen, but we don't care)
//=============================================================================
#define FillFullLines(y,nr,c)    memset(LCD_MEM+(y)*30,c,30*(nr))


#include "pvpicture.h"
#include "loadsave.c"
#include "battery.c"
#include "font5x5.c"
#include "extension.c"
#include "viewers.c"
#include "menu.c"
#include "file.c"
#include "start.c"

//=============================================================================
// cleanup program
//=============================================================================
#define RET_NORMAL        0
#define RET_NOFOLDER      1
#define RET_OUTMEM        2

void CleanupProgram(short msg) {
    if (!msg) {
        strcpy(configuration.last_folder,folder_list[active_folder].name);
        if (file_count) {
            strcpy(configuration.last_file,file_list[active_file].name);
        }
        else {
            memset(configuration.last_file,0,9);
        }
        SaveConfig(0);
    }

    CleanupFastString();

    if (file_list)   free(file_list);   file_list   = NULL;
    if (folder_list) free(folder_list); folder_list = NULL;

    if (!msg)         pti->message = MSG_PRGTITLE;
    else if (msg==1)  pti->message = MSG_ERR_NOFOLDERS;
    else              pti->message = MSG_ERR_OUTOFMEM;

    pti->command = COMMAND_EXIT;
}



//=============================================================================
// fills folder list
// returns 0 if fails otherwise 1
//=============================================================================
short FillFolderList(void) {
    SYM_ENTRY*  symptr;
    short i;

    FolderOp(NULL,FOP_ALL_FOLDERS | FOP_LOCK);

    symptr = SymFindFirst($(\x7F),1);

    // count all symbols in special top order -> number of folders
    folder_count = 0;
    while (symptr) {
#if defined(DEBUG_SHOWHIDDEN)
        if (1 &&
#else
        if (!(symptr->flags.bits.hidden) &&
#endif
#if !defined(DEBUG_SHOWTWIN)
            !(symptr->flags.bits.twin)   &&
#endif
#if !defined(DEBUG_SHOWLOCAL)
            !(symptr->flags.bits.local)  &&
#endif
            (symptr->flags.bits.folder))
        {
            if ((symptr->name[0] < '0' || symptr->name[0] > '9') && symptr->handle) folder_count++;
        }
        symptr=SymFindNext();
    }

    FolderOp(NULL,FOP_ALL_FOLDERS | FOP_UNLOCK);

    if (!folder_count) return 1;

    if (folder_count > folder_max || !folder_list) {
        if (folder_list == NULL) {
            folder_list = (folder_t*)malloc(folder_count*sizeof(folder_t));
            if (!folder_list) return 0;
        }
        else {
            folder_t* tmp = realloc(folder_list,folder_count*sizeof(folder_t));
            if (!tmp) return 0;
            folder_list = tmp;
        }
        folder_max = folder_count;

    }

    FolderOp(NULL,FOP_ALL_FOLDERS | FOP_LOCK);

    symptr = SymFindFirst($(\x7F),1); // make sure that symptr is still valid

    i=0;
    while (symptr) {
#if defined(DEBUG_SHOWHIDDEN)
        if (1 &&
#else
        if (!(symptr->flags.bits.hidden) &&
#endif
#if !defined(DEBUG_SHOWTWIN)
            !(symptr->flags.bits.twin)   &&
#endif
#if !defined(DEBUG_SHOWLOCAL)
            !(symptr->flags.bits.local)  &&
#endif
            (symptr->flags.bits.folder))
        {
            if ((symptr->name[0] < '0' || symptr->name[0] > '9') && symptr->handle) {
                memcpy(&(folder_list[i].name[0]),symptr->name,8);
                folder_list[i].name[8] = 0;
                i++;
            }
        }
        symptr=SymFindNext();
    }

    FolderOp(NULL,FOP_ALL_FOLDERS | FOP_UNLOCK);

    return 1;
}


//=============================================================================
// fill single file entry
//=============================================================================
short FillFileEntry(SYM_ENTRY* symptr,file_t* buffer) {
    unsigned char *src;
    unsigned short size;
    HANDLE         h = symptr->handle;

#if defined(DEBUG_SHOWHIDDEN)
    if (1 ||
#else
    if (symptr->flags.bits.hidden ||  /* add no hidden symbols */
#endif
#if !defined(DEBUG_SHOWTWIN)
        symptr->flags.bits.twin   ||  /* add no twin symbols   */
#endif
#if !defined(DEBUG_SHOWLOCAL)
        symptr->flags.bits.local ||   /* add no local ones     */
#endif
        (symptr->name[0] >= '0' && symptr->name[0] <= '9') || !h)
    {
        return 0;
    }

    if (!(src = SaveHeapLock(h))) return 0;

    size = *(unsigned short*)(src)+2;

    memset(buffer,0,sizeof(file_t));

#if defined(DEBUG_MAX_SIZE)
    sprintf(buffer->size,"88888");
    buffer->marked = FILE_MARKED;
    buffer->type   = TYPE_NONE;
    memset(buffer->ext, 'm',4);
    memset(buffer->name,'m',8);
    memset(buffer->comment,'m',29);
#else
    SetFileType(src,buffer,size);
    memcpy(buffer->name,symptr->name,8);
    buffer->flags.flags_n = symptr->flags.flags_n;
    sprintf(buffer->size,"%u",size);
    buffer->marked = !FILE_MARKED;
#endif

    SaveHeapUnLock();
    return 1;
}


//=============================================================================
// fill complete file_list
// returns 0 if fails otherwise 1
//=============================================================================
short FillFileList(char* foldername) {
    char        tname[30];
    char*       symname;
    SYM_ENTRY*  symptr;
    short       i = 0;

    symname = GenerateTIOSName(foldername,tname);

    FolderCur(symname,1);

    FolderOp(NULL,FOP_ALL_FOLDERS | FOP_LOCK);

    symptr = SymFindFirst(symname,1);

    file_count = 0;

    while (symptr) {
        if (!symptr->flags.bits.folder && symptr->handle) file_count++;
        symptr=SymFindNext();
    }

    FolderOp(NULL,FOP_ALL_FOLDERS | FOP_UNLOCK);

    if (file_count > file_max || file_list == NULL) {
        if (file_list == NULL) {
            file_list = (file_t*)malloc(file_count*sizeof(file_t));
            if (!file_list) return 0;
        }
        else {
            file_t* tmp = realloc(file_list,file_count*sizeof(file_t));
            if (!tmp) return 0;
            file_list = tmp;
        }
        file_max = file_count;
    }

    FolderOp(NULL,FOP_ALL_FOLDERS | FOP_LOCK);

    // make sure that symptr is still valid
    symptr = SymFindFirst(symname,1);

    while (symptr) {
        if (FillFileEntry(symptr,&file_list[i])) i++;
        symptr=SymFindNext();
    }

    FolderOp(NULL,FOP_ALL_FOLDERS | FOP_UNLOCK);

    file_count = i; // make sure we have the right count

    return 1;
}


//=============================================================================
// draw message in status line
//=============================================================================
void DrawStatusLine(const char* msg) {
#if defined(USE_TI89)
    FillFullLines(100 - 6,6,0x0);
#else
    FillFullLines(128 - 6,6,0x0);
#endif

    if (msg) {
        // if msg is too long -> truncate it ...
        if (FastStringWidth(msg)>234) { // for sure clip to a little bit shorter
            unsigned char buf[128];     // length (234+2=236)
            short endpos;
            buf[127] = 0;
            memcpy(buf,msg,127);
            endpos = strlen(buf);
            while (FastStringWidth(buf)>237) buf[endpos--]=0;
            FastStringXY(2,C89_92(95,123),buf);
        }
        else {
            FastStringXY(2,C89_92(95,123), msg);
        }
    }
}


//=============================================================================
// draw bottombar
//=============================================================================
void DrawBottomBar(short statistics) {
    SCR_RECT bottom = {{1,C89_92(87,115),C89_92(158,238),C89_92(93,121)}};

    ScrRectFill(&bottom,&fullscreen,A_NORMAL);
    if (statistics) {
        char sbuffer[30];

        HeapCompress(); // compress heap first !!!

        //------------------------------------------------
        // if-else statement is smaller than a switch() !!
        //------------------------------------------------
        if (!file_count) {
            strcpy(sbuffer,MSGDIRECT_NOFILES);
        }
        else if (file_count==1) {
            strcpy(sbuffer,MSGDIRECT_ONEFILE);
        }
        else {
            sprintf(sbuffer,MSGDIRECT_MOREFILES,file_count);
        }
        DrawStr(2,C89_92(88,116), sbuffer, A_REVERSE);
        sprintf(sbuffer,MSGDIRECT_AVAILRAM,HeapAvail());

        DrawStr(C89_92(157,237)-FastStringWidth(sbuffer),C89_92(88,116),sbuffer, A_REVERSE);
    }
}


//=============================================================================
// inverts given folder entry (0<=idx<=9)
//=============================================================================
void InvertFolderEntry(short idx,short smaller) {
    SCR_RECT fe = {{1,8+idx*8+smaller,48,7+(idx+1)*8-1-smaller}};

    ScrRectFill(&fe,&fullscreen,A_XOR);
}


//=============================================================================
// inverts given file entry (0<=idx<=9)
//=============================================================================
void InvertFileEntry(short idx) {
    SCR_RECT fe = {{50+2,8+idx*8,C89_92(158,238),7+(idx+1)*8-1}};

    if (file_count < 11) fe.xy.x0-=2;
    ScrRectFill(&fe,&fullscreen,A_XOR);
}


//=============================================================================
// draws file mark
//=============================================================================
void DrawFileMark(short idx,short marked) {
    if (marked == FILE_MARKED) {
        DrawChar(X_MARK, idx*8+9,15, A_REPLACE);
    }
    else {
        FastStringXY(X_MARK,  idx*8+9,"  ");
    }
}


//=============================================================================
// draws file data at index idx
//=============================================================================
void DrawFileData(short idx,short file_idx) {
    file_t* data = &file_list[file_idx];
    DrawFileMark(idx,data->marked);

    if (data->flags.bits.locked && !data->flags.bits.archived) {
        DrawChar(X_STATE, idx*8+9,14, A_REPLACE);
    }
    else if (data->flags.bits.archived) {
        DrawChar(X_STATE, idx*8+9,164, A_REPLACE);
    }
    else {
        FastStringXY(X_STATE, idx*8+9,"   ");
    }

    FastStringXY(X_NAME,  idx*8+9,data->name);
    FastStringXY(X_TYPE,  idx*8+9,data->ext);
    FastStringXY(158-FastStringWidth(data->size),idx*8+9,data->size);

#if defined USE_TI92P
    if (FastStringWidth(data->comment)>77) {
        unsigned char buf[MAX_COMMENT+2];
        short endpos;
        buf[MAX_COMMENT+1] = 0;
        memcpy(buf,data->comment,MAX_COMMENT+1);
        endpos = strlen(buf);
        while (FastStringWidth(buf)>77) buf[endpos--]=0;
        FastStringXY(160,idx*8+9,buf);
    }
    else {
        FastStringXY(160,idx*8+9,data->comment);
    }
#endif
}


//=============================================================================
// draws scrollbar
//=============================================================================
void DrawScrollBar(void) {
    //---------------------------------------------------------------------
    // if there are no files or files fit on one page -> draw NO scrollbar
    //---------------------------------------------------------------------
    if (file_count == 0 || file_count < C89_92(11,14)) {
        DrawLine(X_SCROLL,  7, X_SCROLL,  C89_92(86,114),A_REVERSE);
        DrawLine(X_SCROLL+1,7, X_SCROLL+1,C89_92(86,114),A_REVERSE);
    }
    else {
        //-----------------------------------------------------------------
        // calculate virtual height,start and end positions ...
        //-----------------------------------------------------------------
        long vir_h  = 8L * file_count;
        long start  = 8L * ((long)active_file - (long)file_winpos);
        long end    = start + C89_92(80L,114L);

        // draw right side of scrollbar (full line)
        DrawLine(X_SCROLL+1,7, X_SCROLL+1,C89_92(86,114),A_REPLACE);

        //-----------------------------------------------------------------
        // scale it down to the visible screen ...
        //-----------------------------------------------------------------
        start = (start*C89_92(79L,107L))/vir_h  + 7 ;
        end   = (end*C89_92(79L,103L))/vir_h    + 7 ;

        //-----------------------------------------------------------------
        // draw empty line before position indicator
        //-----------------------------------------------------------------
        if (start > 8) {
            DrawLine(X_SCROLL,7,X_SCROLL,(short)(start-1),A_REVERSE);
        }
        else {
            start = 7;
        }

        //-----------------------------------------------------------------
        // if we are on the last page -> set end to last end
        //-----------------------------------------------------------------
        if ((active_file-file_winpos) >= file_count-C89_92(10,13)) end = C89_92(86,114);

        //-----------------------------------------------------------------
        // draw scroll indicator
        //-----------------------------------------------------------------
        DrawLine(X_SCROLL,(short)start,X_SCROLL,(short)end+1,A_NORMAL);

        //-----------------------------------------------------------------
        // draw scroll indicator
        //-----------------------------------------------------------------
        if (end < C89_92(86L,114L)) {
            DrawLine(X_SCROLL,(short)(end+1L),X_SCROLL,C89_92(86,114),A_REVERSE);
        }
    }
}


char* search_for_file = NULL;   // HACK: will be set in RefetchLists !!!

#define DONT_REFETCH 0
#define EXEC_REFETCH 1


//=============================================================================
// refresh the filelist display depending on active_folder
//=============================================================================
short RefreshFileList(short refetch) {
    short i,j;

    if (refetch == EXEC_REFETCH) {
        if (!FillFileList(folder_list[active_folder].name)) return 0;
    }
    DrawBottomBar(1);
    ScrRectFill(&scroll_files,&fullscreen,A_REVERSE);

    if (search_for_file) {
        for (i=0;i<file_count;i++) {
            if (!strcmp(search_for_file,file_list[i].name)) {
                active_file = i;
                if (active_file > C89_92(9,12)) {
                    file_winpos = C89_92(9,12);
                }
                else {
                    file_winpos = active_file;
                }
            }
        }
    }

    j = active_file - file_winpos;

    for (i=0;i<C89_92(10,13) && (j+i)<file_count;i++) DrawFileData(i,j+i);

    DrawScrollBar();

    return 1;
}


//=============================================================================
// maps TI89 keys to 'alphabetic' keys without pressing alpha key previously
//=============================================================================
#if defined(USE_TI89)
unsigned short MapTI89Keys(unsigned short input) {
    switch(input) {
        case '=': return 'a';
        case '(': return 'b';
        case ')': return 'c';
        case ',': return 'd';
        case '/': return 'e';
        case '|': return 'f';
        case '7': return 'g';
        case '8': return 'h';
        case '9': return 'i';
        case '*': return 'j';
        case 149: return 'k'; // EE
        case '4': return 'l';
        case '5': return 'm';
        case '6': return 'n';
        case '-': return 'o';
        case 258: return 'p';  // STO
        case '1': return 'q';
        case '2': return 'r';
        case '3': return 's';
        case '+': return 'u';
        case '0': return 'v';
        case '.': return 'w';
        default:  return input;
    }
}

unsigned short MapTI89Numbers(unsigned short input) {
    switch(input) {
        case 'v': return '0';
        case 'q': return '1';
        case 'r': return '2';
        case 's': return '3';
        case 'l': return '4';
        case 'm': return '5';
        case 'n': return '6';
        case 'g': return '7';
        case 'h': return '8';
        case 'i': return '9';
        default:  return input;
    }
}
#endif

//=============================================================================
// refresh display
//=============================================================================
short RefreshFolderList(void) {
    short i,j;
    if (folder_winpos<C89_92(9,12)) j = 0;
    else                            j = active_folder-C89_92(9,12);

    ScrRectFill(&scroll_folders,&fullscreen,A_REVERSE);

    for (i=0;i<C89_92(10,13) && i<folder_count;i++) {
        FastStringXY(X_FOLDER, i*8+9,folder_list[j+i].name);
    }

    InvertFolderEntry(folder_winpos,0);

    active_file = 0;
    file_winpos = 0;

    return RefreshFileList(EXEC_REFETCH);
}


//=============================================================================
// tries to set active_folder and folder_winpos to given foldername
//=============================================================================
void TryToSetActiveFolder(char* name) {
    short i;
    active_folder = 0;
    folder_winpos = 0;

    for (i=0;i<folder_count;i++) {
        if (!strcmp(name,folder_list[i].name)) {
            active_folder = i;
            if (i<C89_92(10,13)) folder_winpos = i;
            else                 folder_winpos = C89_92(9,12);
            break;
        }
    }
}


//=============================================================================
// Refetches both lists and try to locate where we were previously
//
// returns: 0 if out of memory
//        : 1 if okay
//        : 2 if mode back to SCROLL_FOLDER due to empty directory
//
//=============================================================================
short RefetchLists(void) {
    char  back_folder_name[C89_92(9,12)];
    char  back_file_name[C89_92(9,12)];

    strcpy(back_folder_name,folder_list[active_folder].name);
    strcpy(back_file_name,file_list[active_file].name);

    if (!FillFolderList()) return 0;
    if (!folder_count)     return 0;


    TryToSetActiveFolder(back_folder_name);

    search_for_file = back_file_name;
    if (!RefreshFolderList()) return 0;
    search_for_file = NULL;

    if (global_mode == SCROLL_FILE) {
        if (file_count > 0) {
            InvertFolderEntry(folder_winpos,1);
            InvertFileEntry(file_winpos);
        }
        else {
            global_mode = SCROLL_FOLDER;
        }
    }

    return 1;
}


//=============================================================================
// initializes program (allocates space, sets font, retrieve widths, etc)
//=============================================================================
short InitializeProgram(void) {
    file_list    = NULL;
    file_count   = 0;
    file_max     = 0;
    folder_list  = NULL;
    folder_list  = 0;
    folder_list  = 0;

    //-------------------------------------------------------------------------
    // initialize fast string output stuff
    //-------------------------------------------------------------------------
    if (!(InitializeFastString())) return 0;

    //-------------------------------------------------------------------------
    // load configuration
    //-------------------------------------------------------------------------
    LoadConfig();

    //-------------------------------------------------------------------------
    // backup current folder ASAP ...
    //-------------------------------------------------------------------------
    FolderGetCur(folder_backup);

    //-------------------------------------------------------------------------
    // clear the backbuffer and use PortSet() to tell AMS to draw into it ...
    //-------------------------------------------------------------------------
    memset(pti->lcdbuffer,0,LCD_SIZE);
    PortSet(pti->lcdbuffer,239,127);

    //-------------------------------------------------------------------------
    // draw screen frame ....
    //-------------------------------------------------------------------------
    used_lcdbuffer = pti->lcdbuffer;
    DrawWindow(0,0,C89_92(159,239),C89_92(93,121)," ");
    DrawStr(1,1,MSGDIRECT_HEADER,A_REVERSE);
    DrawLine(X_SCROLL-1,6, X_SCROLL-1,C89_92(87,115),A_REPLACE);
    DrawBottomBar(0);
    used_lcdbuffer = LCD_MEM;
    PortRestore();

#if defined(DEBUG_10SEC_APD)
    // sets the APD to 10 seconds (just for debugging reasons)
    OSFreeTimer(APD_TIMER);
    OSRegisterTimer(APD_TIMER, 10*20);
#endif


#if defined(USE_TI89)
    memcpy(LCD_MEM,pti->lcdbuffer,94*30);  // copy everything beside the statusbar
#else
    memcpy(LCD_MEM,pti->lcdbuffer,122*30); // copy everything beside the statusbar
#endif
    return 1;
}


//=============================================================================
// handles scrolling if necessary
//=============================================================================
short HandlePossibleScroll(short direction) {
    short scroll_amount;
    short where;
    if (global_mode == SCROLL_FOLDER) {
        InvertFolderEntry(folder_winpos,0);
        folder_winpos+=direction;
        active_folder+=direction;
        if (folder_winpos < 0 || folder_winpos > C89_92(9,12)) {
            if (folder_winpos>C89_92(9,12)) {
                scroll_amount = 8;
                where         = C89_92(9,12)*8;
                folder_winpos = C89_92(9,12);
            }
            else {
                scroll_amount = -8;
                where         = 0;
                folder_winpos = 0;
            }
            ScrRectScroll(&scroll_folders,&scroll_folders,scroll_amount,A_REVERSE);
            FastStringXY(X_FOLDER, where+9,folder_list[active_folder].name);
        }
        InvertFolderEntry(folder_winpos,0);
        active_file = 0;
        file_winpos = 0;

        if (!RefreshFileList(EXEC_REFETCH)) {
            CleanupProgram(RET_OUTMEM);
            return 0;
        }
    }
    else {
        file_winpos+=direction;
        active_file+=direction;
        if (file_winpos >= 0 && file_winpos <= C89_92(9,12)) return 1;

        if (file_winpos>C89_92(9,12)) {
            scroll_amount = 8;
            where         = C89_92(9,12);
            file_winpos   = C89_92(9,12);
        }
        else {
            scroll_amount = -8;
            where         = 0;
            file_winpos   = 0;

        }

        ScrRectScroll(&scroll_files,&scroll_files,scroll_amount,A_REVERSE);
        DrawFileData(where,active_file);
        DrawScrollBar();
    }

    return 1;
}


//=============================================================================
// where all the fun starts ...
//=============================================================================
void _main(void) {
    short          i;
    unsigned short input;
    char           msg[100];
    char*          tmpptr;
    short          firsttime       = 1;
    short          redraw_fileinfo = 0;
    short          tmpshort;

    global_mode = SCROLL_FOLDER;

    if (magic[0] == MAGIC_EXPLORER1) {
        ST_showHelp(MSGDIRECT_INTERFACENOTFOUND);
        ngetchx();
        return;
    }

    pti = (TICTEX_INTERFACE*)magic[0];

    if (magic[1] != TICTEX_VERSION) {
        pti->message = MSG_ERR_WRONGVERSION;
        pti->command = COMMAND_EXIT;
        return;
    }


    if (!InitializeProgram() || !FillFolderList()) {
        CleanupProgram(RET_OUTMEM);
        return;
    }

    //if (!FillFolderList()) {
    //    CleanupProgram(RET_OUTMEM);
    //    return;
    //}

    if (!folder_count) {
        CleanupProgram(RET_NOFOLDER);
        return;
    }

    //-------------------------------------------------------------------------
    // evaluate last visited folder and file ...
    //-------------------------------------------------------------------------
    if (configuration.last_folder[0]) tmpptr = configuration.last_folder;
    else                              tmpptr = folder_backup;

    if (configuration.last_file[0])   search_for_file = configuration.last_file;
    else                              search_for_file = NULL;

    //-------------------------------------------------------------------------
    // try to find active folder ...
    //-------------------------------------------------------------------------
    TryToSetActiveFolder(tmpptr);

    //-------------------------------------------------------------------------
    // draw initial folder list ....
    //-------------------------------------------------------------------------
    if (!RefreshFolderList()) {
        CleanupProgram(RET_OUTMEM);
        return;
    }

    LCD_save(pti->lcdbuffer);
    //-------------------------------------------------------------------------
    // if no password set, forth user to set one
    //-------------------------------------------------------------------------
    if (!configuration.pwd[0]) {
        if (!HandlePassword(PASSWORD_CHANGE)) {
            DrawStatusLine(MSGDIRECT_SETPASSWDFAILED);
            GetUserInput();
        }
        LCD_restore(pti->lcdbuffer);
    }

    //-------------------------------------------------------------------------
    //-------------------------------------------------------------------------
    // MAIN LOOP (loop until user gets bored) ....
    //-------------------------------------------------------------------------
    //-------------------------------------------------------------------------
    do {
        if (firsttime) {
            search_for_file = NULL;
            firsttime = 0;
            if (file_count > 0) {
                InvertFolderEntry(folder_winpos,1);
                InvertFileEntry(file_winpos);
                global_mode = SCROLL_FILE;
            }
            if (pti->message) {
                DrawStatusLine(GetMsg(pti->message));
                pti->message = MSG_OKAY;
            }
            else if (pti->command == COMMAND_FIRSTTIME) {
                redraw_fileinfo = 1;
            }
        }

        if (redraw_fileinfo) {
            if (global_mode == SCROLL_FILE && file_list[active_file].comment[0]) {
                DrawStatusLine(file_list[active_file].comment);
            }
            else {
                DrawStatusLine(NULL);
            }
            redraw_fileinfo = 0;
        }

        input = GetUserInput();

        DrawStatusLine(NULL);

#if defined(USE_TI89)
        input = MapTI89Keys(input);
#endif

        FontSetSys(F_4x6);

        //---------------------------------------------------------------------
        // Scroll Down Functionality AND Jump to first line ...
        //---------------------------------------------------------------------
        if (input == KEY_DOWN || input == KEY_UP2ND) {
            if (global_mode == SCROLL_FOLDER) {
                if (input == KEY_DOWN && active_folder < folder_count-1) {
                    if (!HandlePossibleScroll(1)) return;
                }
                else {
                    // WRAP ARROUND FOLDER (to first position)
                    folder_winpos = 0;
                    active_folder = 0;
                    active_file   = 0;
                    file_winpos   = 0;
                    if (!RefetchLists()) {
                        CleanupProgram(RET_OUTMEM);
                        return;
                    }
                }
            }
            else {
                InvertFileEntry(file_winpos);
                if (input == KEY_DOWN && active_file < file_count-1) {
                    HandlePossibleScroll(1);
                }
                else {
                    // WARP AROUND FILES (to first position)
                    active_file = 0;
                    file_winpos = 0;
                    if (!RefreshFileList(DONT_REFETCH)) {
                        CleanupProgram(RET_OUTMEM);
                        return;
                    }
                }
                InvertFileEntry(file_winpos);
            }
            redraw_fileinfo = 1;
        }

        //---------------------------------------------------------------------
        // Scroll Up Functionality AND Jump to last line ...
        //---------------------------------------------------------------------
        else if (input == KEY_UP || input == KEY_DOWN2ND) {
            if (global_mode == SCROLL_FOLDER) {
                if (input == KEY_UP && active_folder > 0) {
                    if (!HandlePossibleScroll(-1)) return;
                }
                else {
                    // WRAP ARROUND FOLDER (to last position)
                    if (folder_count > C89_92(9,12)) folder_winpos = C89_92(9,12);
                    else                             folder_winpos = folder_count-1;
                    active_folder = folder_count-1;
                    active_file   = 0;
                    file_winpos   = 0;
                    if (!RefetchLists()) {
                        CleanupProgram(RET_OUTMEM);
                        return;
                    }
                }
            }
            else {
                InvertFileEntry(file_winpos);
                if (input == KEY_UP && active_file > 0) {
                    HandlePossibleScroll(-1);
                }
                else {
                    // WARP AROUND FILES (to last position)
                    active_file = file_count-1;

                    if (file_count >= C89_92(10,13)) file_winpos = C89_92(9,12);
                    else                             file_winpos = file_count-1;

                    if (!RefreshFileList(DONT_REFETCH)) {
                        CleanupProgram(RET_OUTMEM);
                        return;
                    }
                }
                InvertFileEntry(file_winpos);
            }
            redraw_fileinfo = 1;
        }

        //---------------------------------------------------------------------
        // Cursor To Folder List Functionality
        //---------------------------------------------------------------------
        else if (input == KEY_LEFT) {
            if (global_mode == SCROLL_FILE) {
                global_mode = SCROLL_FOLDER;
                InvertFileEntry(file_winpos);
                InvertFolderEntry(folder_winpos,1);
            }
            redraw_fileinfo = 1;
        }

        //---------------------------------------------------------------------
        // Cursor To File List Functionality
        //---------------------------------------------------------------------
        else if (input == KEY_RIGHT) {
            if (global_mode == SCROLL_FOLDER && file_count > 0) {
                global_mode = SCROLL_FILE;
                InvertFolderEntry(folder_winpos,1);
                InvertFileEntry(file_winpos);
            }
            redraw_fileinfo = 1;
        }

        //---------------------------------------------------------------------
        // Favorites starting or Favorites Popup Functionality
        //---------------------------------------------------------------------
        else if (input == KEY_F2 || input & VAL_DIAMOND) {
            unsigned short v   = input & ~VAL_DIAMOND;
            short          use = -1;

            if (v>='1' && v <= '9') use = v-'1';
            if (!HandleFavoriteMenu(msg,use)) {
                if (msg[0]) DrawStatusLine(msg);
                else        redraw_fileinfo = 1;
            }
            else {
                if (pti->exemode != EXEMODE_NONE) {
                    CleanupProgram(RET_NORMAL);
                    pti->command = COMMAND_EXECUTE;
                    return;
                }
            }
        }

        //---------------------------------------------------------------------
        // Setting Favorites Functionality
        //---------------------------------------------------------------------
        else if (Get2ndNumber(input)) {
            if (global_mode == SCROLL_FILE) {
                i = Get2ndNumber(input);
                SetFavorite(msg,i-1,folder_list[active_folder].name,
                            file_list[active_file].name,
                            file_list[active_file].type);
                if (!msg[0]) sprintf(msg,MSGDIRECT_SHORTCUTSET,i,
                                     folder_list[active_folder].name,
                                     file_list[active_file].name);
                DrawStatusLine(msg);
            }
        }

        //---------------------------------------------------------------------
        // File Menu Functionalities + Archive/Unarchive functionality
        //---------------------------------------------------------------------
        else if (input == KEY_F1 || input == KEY_BACKSPACE || input == KEY_F3) {
            short      selection;
            short      refetch_lists = 0;
            SYM_ENTRY* entry;
            char*      name;
            char       tname[30];

            msg[0] = 0;

            LCD_save(pti->lcdbuffer);

            if (input == KEY_BACKSPACE) {
                selection = 0;
            }
            else if (input == KEY_F3) {
                selection = 99;
            }
            else {
                selection = HandleSelectionPopup(X_FOLDER-1,C89_92(0,6),f1_entries,NULL);
                LCD_restore(pti->lcdbuffer);
            }

            TRY
            switch(selection) {
                case 0: // delete
                    refetch_lists = HandleDeleteFiles(msg);
                    break;
                case 1: // copy
                    refetch_lists = HandleCopyOrMoveFiles(msg,OPERATION_COPY);
                    break;
                case 2: // rename
                    refetch_lists = HandleRenameFile(msg);
                    break;
                case 3: // move
                    refetch_lists = HandleCopyOrMoveFiles(msg,OPERATION_MOVE);
                    break;
                case 4: // create folder
                    refetch_lists = HandleCreateFolder(msg);
                    break;
                case 5: // view file
                    if (global_mode==SCROLL_FILE) name = file_list[active_file].name;
                    else                          name = folder_list[active_folder].name;
                    entry=DerefSym(SymFind(GenerateTIOSName(name,tname)));
                    if (entry) ViewHEX(entry);
                    break;
                case 6: //lock/unlock
                    refetch_lists = HandleArchiveOrLock(msg,OPERATION_LOCK);
                    break;
                case 8: // CALC off with password
                    if (!configuration.pwd[0]) {
                        strcpy(msg,MSGDIRECT_SETPASSWDFIRST);
                        break;
                    }
                    else {
                        if (!HandlePassword(PASSWORD_TEST)) {
                            strcpy(msg,MSGDIRECT_WRONGPASSWD);
                        }
                        else {
                            LCD_restore(pti->lcdbuffer);
                            off();
                            do {
                            } while (!HandlePassword(PASSWORD_TEST));
                        }
                        break;
                    }
                case 7: // change default password
                    if (configuration.pwd[0]) {
                        if (!HandlePassword(PASSWORD_TEST)) {
                            strcpy(msg,MSGDIRECT_WRONGPASSWD);
                            break;
                        }
                    }
                    if (!HandlePassword(PASSWORD_CHANGE)) {
                        strcpy(msg,MSGDIRECT_SETPASSWDFAILED2);
                    }
                    break;
                case 9:  // help
                    DrawHelpPage();
                    break;
                case 10: // about
                    DrawAboutDialog();
                    break;
                case 99: // archive/unarchive
                    refetch_lists = HandleArchiveOrLock(msg,OPERATION_ARCHIVE);
                    break;
            }
            ONERR
                strcpy(msg,MSGDIRECT_EXCEPTIONCAUGHT);
            ENDTRY
            FontSetSys(F_4x6);
            LCD_restore(pti->lcdbuffer);
            if (refetch_lists) {
                if (!RefetchLists()) {
                    CleanupProgram(RET_OUTMEM);
                    return;
                }
            }
            if (msg[0]) DrawStatusLine(msg);
            else        redraw_fileinfo = 1;
        }

        //---------------------------------------------------------------------
        // Select/Unselect Functionality
        //---------------------------------------------------------------------
        else if (input == KEY_F4) {
            redraw_fileinfo = 1;
            if (file_count) {
                if (global_mode == SCROLL_FILE) {
                    if (IsInUse(file_list[active_file].name)) {
                        DrawStatusLine(MSGDIRECT_CANNOTSELECTUSED);
                        redraw_fileinfo = 0;
                    }
                    else {
                        file_list[active_file].marked = !(file_list[active_file].marked);
                        InvertFileEntry(file_winpos);
                        DrawFileMark(file_winpos,file_list[active_file].marked);
                        InvertFileEntry(file_winpos);
                    }
                }
                else {
                    short count = 0;

                    //---------------------------------------------------------
                    // check if anything is already selected -> unselect all in
                    // this case
                    //---------------------------------------------------------
                    tmpshort = FILE_MARKED;
                    for (i=0;i<file_count;i++) {
                        if (!IsInUse(file_list[i].name)) {
                            if (file_list[i].marked == FILE_MARKED) {
                                tmpshort = !FILE_MARKED;
                                break;
                            }
                        }
                    }

                    for (i=0;i<file_count;i++) {
                        if (!IsInUse(file_list[i].name)) {
                            file_list[i].marked = tmpshort;
                            count++;
                        }
                    }
                    if (count) {
                        RefreshFileList(DONT_REFETCH);
                    }
                }
            }
        }

        //---------------------------------------------------------------------
        // drawing of Info Page
        //---------------------------------------------------------------------
        else if (input == KEY_F5) {
            LCD_save(pti->lcdbuffer);
            DrawInfoPage();
            LCD_restore(pti->lcdbuffer);
            redraw_fileinfo = 1;
        }

        //---------------------------------------------------------------------
        // Start Functionality
        //---------------------------------------------------------------------
        else if (input == KEY_ENTER || input == KEY_APPS) {
            if (global_mode == SCROLL_FILE) {
                short result;
                pti->exemode = EXEMODE_NONE;
                result = HandleStart(&file_list[active_file],folder_list[active_folder].name);

                if (pti->exemode != EXEMODE_NONE) {
                    CleanupProgram(RET_NORMAL);
                    pti->command = COMMAND_EXECUTE;
                    return;
                }

                if (result) DrawStatusLine(GetMsg(result));
                else        redraw_fileinfo = 1;
            }
        }

        //---------------------------------------------------------------------
        // "Quick Jump" Functionality
        //---------------------------------------------------------------------
        else if (input >= 'a' && input <= 'z') {
            if (global_mode == SCROLL_FOLDER) {
                short start = active_folder;
                do {
                    start++;
                    if (start >= folder_count) start = 0;
                    if (folder_list[start].name[0] == input) {
                        active_folder = start;
                        if (start<C89_92(10,13)) folder_winpos = start;
                        else                     folder_winpos = C89_92(9,12);
                        RefreshFolderList();
                        break;
                    }
                }
                while (start != active_folder);
            }
            else if (file_count>1) {
                short start = active_file;
                do {
                    start++;
                    if (start >= file_count) start = 0;
                    if (file_list[start].name[0] == input) {
                        active_file = start;
                        if (start<C89_92(10,13)) file_winpos = start;
                        else                     file_winpos = C89_92(9,12);
                        RefreshFileList(DONT_REFETCH);
                        InvertFileEntry(file_winpos);
                        break;
                    }
                }
                while (start != active_file);
            }
            redraw_fileinfo = 1;

        }
        else {
            redraw_fileinfo = 1;
        }
    }
    while (input!=KEY_ESC);

    CleanupProgram(RET_NORMAL);
}


//#############################################################################
// Revision History
//#############################################################################
//
// $Log: tictexpl.c,v $
// Revision 1.14  2002/10/01 09:08:18  tnussb
// (1) missing FontSetSys() at start of major input loop added
// (2) display distortion when marked file gets unmarked fixed
//
// Revision 1.13  2002/09/23 09:37:39  tnussb
// generic commit (see history.txt: changes up to v1.30 Beta 7)
//
// Revision 1.11  2002/03/15 15:13:54  tnussb
// (1) changes for V200
// (2) minor size optimizations
//
// Revision 1.10  2002/02/25 12:54:45  tnussb
// minor size optimizations and beautifying
//
// Revision 1.9  2002/02/21 09:31:23  tnussb
// VERSION_TI89 and VERSION_TI92P replaced by new standard USE_TI89 and USE_TI92P
//
// Revision 1.8  2002/02/07 18:01:18  tnussb
// generic commit
//
// Revision 1.7  2001/02/11 15:38:28  Thomas Nussbaumer
// length of displayed comments raised to 32 characters
//
// Revision 1.6  2001/02/10 10:27:20  Thomas Nussbaumer
// [APPS] can now be used to start or view programs, too
//
// Revision 1.5  2001/02/04 13:11:28  Thomas Nussbaumer
// changes up to version 1.00 RC2 (see history.txt)
//
// Revision 1.4  2001/01/26 21:04:44  Thomas Nussbaumer
// changes for version 0.80 [see history.txt]
//
// Revision 1.3  2001/01/21 17:05:10  Thomas Nussbaumer
// changes related to v0.65
//
// Revision 1.2  2001/01/21 00:20:16  Thomas Nussbaumer
// additionally changes related to version 0.60
//
// Revision 1.1  2001/01/20 21:35:56  Thomas Nussbaumer
// content moved from main.c
