/******************************************************************************
*
* project name:  TICT-Explorer
* file name:     tictex.c
* initial date:  19/12/2000
* author:        thomas.nussbaumer@gmx.net
*
* description:   special PPG launcher for TICT-Explorer
*
*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
*
* !!! IMPORTANT WARNING !!!
*
*
* Don't modify anything nor recompile this program with any other TIGCC Library
* than 2.41 and TIGCC 0.93, BEFORE you have complete understand the
* mechanism of the stack backup. Otherwise the TICT-Explorer won't run stable.
*
* Please use batchfile build.bat to rebuild !!!
*
* The STACK_CORRECT_VALUE is evaluated by running tool tststack() twice:
* (1) one time from the commandline
* (2) one time from the explorer
*
* The difference of the two values is used as STACK_CORRECT_VALUE
*
*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
*
* $Id: tictex.c,v 1.17 2002/10/29 09:07:25 tnussb Exp $
*
******************************************************************************/

//-----------------------------------------------------------------------------
// check for -DUSE_TI89 commandline flag (for TI-89 version)
// *** or ***
// check for -DUSE_TI92P commandline flag (for TI-92p version)
//
// ONLY ONE IS ALLOWED PER COMPILE RUN
//-----------------------------------------------------------------------------
#if defined(USE_TI89) && defined(USE_TI92P)
#error cannot produce both versions at once
#elif defined(USE_TI89)
#define C89_92(x,y) (x)
#elif defined(USE_TI92P)
#define USE_V200           // V200 support !!!
#define C89_92(x,y) (y)
#else
#error Please define either USE_TI89 or USE_TI92P (V200 will be treated as TI92p)
#endif

#define NO_EXIT_SUPPORT
#define OPTIMIZE_ROM_CALLS
#include <tigcclib.h>


//#define CAUSE_CRASH      // when you uncomment this a crash will be produced


//-----------------------------------------------------------------------------
// to evaluate the correct STACK_CORRECT_VALUE set it to 0 and run tststack()
// twice: one time from the commandline and one time from the explorer.
// Then set CORRECT_VALUE to the difference of both runs.
//-----------------------------------------------------------------------------
#define STACK_CORRECT_VALUE (168)
#define STACK_MAX_SIZE (220+STACK_CORRECT_VALUE)
unsigned char* stack_buffer = NULL;
unsigned char* stack_orig   = NULL;
unsigned char* stack_tmp    = NULL;

#if 0
char st_show_buf[30] = {0};
unsigned long st_show_val = 0;
#define SHOW_STACK(a) ({\
   asm volatile ("move.l %sp,st_show_val");\
   sprintf(st_show_buf,"ST%d=0x%08lX (press a key)",a,st_show_val);\
   ST_showHelp(st_show_buf);ngetchx();})

#else
#define SHOW_STACK(a)
#endif

//----------------------------------------------------------------------
// sophisticated macro to give started program as much stack as possible
//----------------------------------------------------------------------
#define SAVE_STACK() ({ \
    /*__HALT;*/\
    asm volatile("movem.l %d0-%d7/%a0-%a6,-(%sp)\n"\
                 "move.l %sp,stack_tmp\n"\
                 "move.l stack_tmp,%d0\n"\
                 "move.l stack_orig,%d1\n"\
                 "move.l %d0,%a0\n"\
                 "sub.l %d0,%d1\n"\
                 "move.l stack_buffer,%a1\n"\
                 "0: move.b  (%a0),(%a1)+\n"\
                 "move.b  0,(%a0)+\n"\
                 "dbra %d1,0b\n"\
                 "move.l stack_orig,%sp");})

//----------------------------------------------------------------------
// restores stack state saved with SAVE_STACK
//----------------------------------------------------------------------
#define RESTORE_STACK() ({ \
    /*__HALT;*/\
    asm volatile("move.l stack_tmp,%d0\n"\
                 "move.l stack_orig,%d1\n"\
                 "move.l %d0,%a0\n"\
                 "sub.l %d0,%d1\n"\
                 "move.l stack_buffer,%a1\n"\
                 "0:move.b  (%a1)+,(%a0)+\n"\
                 "dbra %d1,0b\n"\
                 "move.l stack_tmp,%sp\n"\
                 "movem.l (%sp)+,%d0-%d7/%a0-%a6");})


#include "messages.c"           // includes interface.h
#define MINIMIZE_VATUTILS
#include "vatutils.c"
#include "protect.c"


#include "tts/ttunpack.h"


volatile TICTEX_INTERFACE interface = EMPTY_INTERFACE_INIT;
unsigned char* patch_addr           = NULL;
ESI            top_backup           = 0;
char           sbuffer[40]          = {};
char           tmpname[30]          = {};
char           initial_folder[30]   = {};
//char*          lcdbuffer            = NULL;
char           explorer_folder[9]   = {};

//---------------------------------------------------------------------
// NOTE: the NOPs are very important due to a hack with RETURN_VALUE
//       (they must be exactly after the call!!)
//---------------------------------------------------------------------
#define ASM_NOP_CALL(x) ({\
asm volatile("movem.l %d0-%d7/%a0-%a6,-(%sp)"); \
ASM_fastcall(x);\
asm volatile("nop;nop;nop;nop;");\
asm volatile("movem.l (%sp)+,%d0-%d7/%a0-%a6");})


PROTECTION_T   temporary_protection;
ERROR_FRAME    temporary_errorframe;

PROTECTION_T   main_protection;
ERROR_FRAME    main_errorframe;


/*===========================================================================*/
/* executes a block of memory in a TRY/CATCH block (secure)                  */
/* if execution failed exe_okay will be set to 0 otherwise 1                 */
/*===========================================================================*/
void ExecuteSecure(unsigned char* addr,unsigned char* reloc_end) {
    FontSetSys(F_6x8);
    EX_patch(addr,reloc_end);

    InstallCrashProtection(&temporary_protection);
    if (!ER_catch(temporary_errorframe)) {
        #if defined(DEBUG_HALT_BEFORE)
        __HALT;
        #endif
        SHOW_STACK(1);
        ASM_NOP_CALL(addr);
        ER_success();
    }

    #if defined(DEBUG_HALT_AFTER)
    __HALT;
    #endif
    RemoveCrashProtection(&temporary_protection);
}


/*===========================================================================*/
/* try to execute a PPG file                                                 */
/*                                                                           */
/* returns MSG_OKAY if everything is okay                                    */
/*===========================================================================*/
short StartPPG(HANDLE handle) {
    unsigned char*   src;
    unsigned char*   dest;
    unsigned short   length;
    unsigned short   retval;
    HANDLE           uncomp_h;

    if (!(src=SaveHeapLock(handle))) return MSG_ERR_LOCKINGFAILED;

    length = *(unsigned short*)(src)+2;

    src+=2;

    if (memcmp(src+length-7,"ppg\x00\xF8",5) && !ttunpack_valid(src)) {
        SaveHeapUnLock();
        return MSG_ERR_PPGINVALID;
    }

    length = ttunpack_size(src);

    // NOTE: we don't use malloc, but the low level routines
    //       otherwise compressed kernel-dependent progs will crash
    if (!(uncomp_h=HeapAllocHigh(length))) {
        SaveHeapUnLock();
        return MSG_ERR_OUTOFMEM;
    }
    dest = HeapDeref(uncomp_h);

    //-------- OLD BLOCK - replaced by above one!
    //if (!(dest=malloc(length))) {     // allocate memory for original
    //    SaveHeapUnLock();
    //    return MSG_ERR_OUTOFMEM;
    //}

    ST_showHelp("decompressing ...");
    retval = ttunpack_decompress(src,dest);
    ST_eraseHelp();

    //------------------------------
    // "houston we got problems ..."
    //------------------------------
    if (retval) {
        HeapFree(uncomp_h); // free(dest); -- using now HeapFree() for kernel-ppg support
        SaveHeapUnLock();
        return MSG_ERR_PPGINVALID;
    }

    //-------------------------------------------------------------------------
    // relocate program and start it
    //-------------------------------------------------------------------------
    SAVE_STACK();  // MUST BE DONE OUTSIDE DUE TO ER_CATCH() !!!!
    ExecuteSecure(dest+0x40002,dest+length+0x3FFFF);
    RESTORE_STACK();

    HeapFree(uncomp_h); //free(dest); -- using now HeapFree() for kernel-ppg support
    SaveHeapUnLock();

    if (EXCEPTION_TRIGGERED()) {
        retval = GET_EXCEPTION_CODE()+MSG_ERR_CRASHOFFSET;
        RESET_EXCEPTION();
        return retval;
    }
    else {
        return MSG_OKAY;
    }
}


/*===========================================================================*/
/* try to patch the interface address into the explorer                      */
/* returns 1 if okay                                                         */
/*===========================================================================*/
short PatchInterfaceAddress(unsigned char* cptr,unsigned short len) {
    unsigned char* endptr;

    cptr  += 0x40000; // necessary? I don't think so ...
    endptr = cptr + len - len % 2;

    patch_addr = NULL;

    do {
        if (*(unsigned short*)cptr     == MAGIC_EXPLORER14 &&
            *(unsigned short*)(cptr+2) == MAGIC_EXPLORER24 &&
            *(unsigned short*)(cptr+4) == MAGIC_EXPLORER34 &&
            *(unsigned short*)(cptr+6) == MAGIC_EXPLORER44)
        {
#if defined(CAUSE_CRASH)
            *endptr=*cptr/0;
#endif

            (*(unsigned long*)cptr)     = (unsigned long)&interface;
            (*(unsigned long*)(cptr+4)) = (unsigned long)TICTEX_VERSION;
            patch_addr = cptr;

            return 1;
        }
        cptr+=2;
    }
    while (cptr < endptr);

    return 0;
}


/*===========================================================================*/
/* try to start an executable                                                */
/* returns MSG_OKAY if everything is okay                                    */
/*===========================================================================*/
short StartExecutable(SYM_ENTRY* symptr, short is_explorer) {
    char*           cptr;
    unsigned short  plen;
    HANDLE          h;
    HSym            twin = HS_NULL;
    char*           tmpptr = (char*)interface.foldername;
    SYM_ENTRY*      se;

    h = symptr->handle;

    if (symptr->flags.bits.archived) {
        strncpy(tmpname,symptr->name,8);
        tmpname[8]=0;
        if (is_explorer) tmpptr = explorer_folder;
        sprintf(sbuffer,"%s\\%s",tmpptr,tmpname);
        twin = EM_twinSymFromExtMem(GenerateTIOSName(sbuffer,tmpname),HS_NULL);
        if (!twin.folder) return MSG_ERR_TWINFAILED;
        se = DerefSym(twin);

        // !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
        // we set the hidden flag on TWIN symbols, otherwise
        // it may get deleted to soon by the an well-known AMS bug!
        // !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
        se->flags.bits.hidden = 1;
        h = se->handle;
    }

    if (!(cptr = SaveHeapLock(h))) return MSG_ERR_LOCKINGFAILED;

    if (is_explorer) cptr+=2;

    plen = *(unsigned short*)(cptr) + 2;

    if (is_explorer) {
        if (!PatchInterfaceAddress(cptr,plen)) {
            SaveHeapUnLock();
            if (twin.folder) {
                twin = SymFind(GenerateTIOSName(sbuffer,tmpname));
                if (!twin.folder) return MSG_ERR_TWINDEL;
                se = DerefSym(twin);
                if (!(se->flags.bits.twin)) return MSG_ERR_TWINDEL;
                se->flags.bits.hidden = 0;
                if (!SymDelTwin(se)) return MSG_ERR_TWINDEL;
            }
            return MSG_ERR_INVALIDEXPLLIB;
        }
    }

    SAVE_STACK();  // MUST BE DONE OUTSIDE DUE TO ER_CATCH() !!!!
    ExecuteSecure(cptr+0x40002,cptr+plen+0x3FFFF);
    RESTORE_STACK();

    if (is_explorer) {
        (*(unsigned long*)patch_addr)     = (unsigned long)MAGIC_EXPLORER1;
        (*(unsigned long*)(patch_addr+4)) = (unsigned long)MAGIC_EXPLORER2;
    }

    SaveHeapUnLock();

    if (twin.folder) {
        twin = SymFind(GenerateTIOSName(sbuffer,tmpname));
        if (!twin.folder) return MSG_ERR_TWINDEL;
        se = DerefSym(twin);
        if (!(se->flags.bits.twin)) return MSG_ERR_TWINDEL;
        se->flags.bits.hidden = 0;
        if (!SymDelTwin(se)) return MSG_ERR_TWINDEL;
    }

    if (EXCEPTION_TRIGGERED()) {
        plen = GET_EXCEPTION_CODE()+MSG_ERR_CRASHOFFSET;
        RESET_EXCEPTION();
        return plen;
    }
    else {
        return MSG_OKAY;
    }
}


/*===========================================================================*/
/* hides or unhides all files related to the explorer                        */
/*===========================================================================*/
void HideUnHideTICTFiles(short bhidden) {
    short          type;
    SYM_ENTRY*     tmp_entry;
    unsigned char* tmp_src;
    unsigned short tmp_len;

    tmp_entry = SymFindFirst(NULL,2);
    while (tmp_entry) {
        if (!tmp_entry->flags.bits.folder && tmp_entry->handle) {
            type = 0;
            if (!strncmp(tmp_entry->name,"tictex",8))        type = 1;
            else if (!strncmp(tmp_entry->name,"tictexpl",8)) type = 2;
            else {
                tmp_entry = SymFindNext();
                continue;
            }
            tmp_src = HeapDeref(tmp_entry->handle);
            tmp_len = *(unsigned short*)(tmp_src)+2;
            tmp_src += tmp_len-1;

            if ((type == 1 && *tmp_src == 0xF3)                   ||
                (type == 2 && !memcmp(tmp_src-4,"LIB\x00\xF8",5)))
            {
                tmp_entry->flags.bits.hidden = bhidden;
            }
        }
        tmp_entry = SymFindNext();
    }
}

#include "hsr.c" // home screen restore

/*===========================================================================*/
/* does cleanup of launcher if necessary (protected function)                */
/*===========================================================================*/
void HandleCleanup(short msg) {
    InstallCrashProtection(&temporary_protection);
    if (!ER_catch(temporary_errorframe)) {
        SaveHeapUnLock();
        HomeScreenRestore();
        if (stack_buffer) free(stack_buffer);
        stack_buffer = NULL;
        if (interface.lcdbuffer)
        free(interface.lcdbuffer);
        interface.lcdbuffer = NULL;
        SaveHeapUnLock();
        HideUnHideTICTFiles(0);
        top_estack = top_backup;
        FolderCur(GenerateTIOSName(initial_folder,tmpname),1);
        ER_success();
    }
    if (msg != MSG_OKAY) ST_showHelp(GetMsg(msg));
    RemoveCrashProtection(&temporary_protection);
}

/*===========================================================================*/
/* MAIN ROUTINE: where all the fun starts ...                                */
/*===========================================================================*/
void _main(void) {
    short          msg_number;
    char           temp_folder[30];
    SYM_ENTRY*     s_explorer = NULL;
    SYM_ENTRY*     tmp_entry;
    HANDLE         h_myself;
    HANDLE         tmp_h;
    unsigned char* tmp_src;
    unsigned short tmp_len;
    short          firsttime;
    EVENT          ev;

    unsigned long program_counter;
    asm volatile("bsr 0f; 0:move.l (%%sp)+,%0":"=g"(program_counter));
    asm volatile("move.l %sp,stack_orig");


    SHOW_STACK(0);
    //-------------------------------------------------------------------------
    // initialize some variables ...
    //-------------------------------------------------------------------------
    memset((void*)&interface,0,sizeof(TICTEX_INTERFACE));
    SAVEHEAPLOCK_RESET();
    //lcdbuffer    = NULL;
    stack_buffer = NULL;
    top_backup   = top_estack;
    h_myself     = 0;
    firsttime    = 1;
    FolderGetCur(initial_folder);

    //-------------------------------------------------------------------------
    // the correction value is evaluated by calling tststack() twice.
    // Once from the explorer and one time from the commandline
    //-------------------------------------------------------------------------
    stack_orig+=STACK_CORRECT_VALUE;
    ((unsigned long)stack_orig) &= 0xfffffffe;

    //-------------------------------------------------------------------------
    // find myself and relocate myself if necessary (thanx Zeljko!)
    //-------------------------------------------------------------------------
    tmp_entry = SymFindFirst(NULL,2);
    while (tmp_entry) {
        tmp_h=tmp_entry->handle;
        if (tmp_h && HeapGetLock(tmp_h)) {
            tmp_src = HeapDeref(tmp_h);
            tmp_len = *(unsigned short*)tmp_src+2;
            if ((program_counter & 0x3FFFF) > (unsigned long)tmp_src &&
                (program_counter & 0x3FFFF) < (unsigned long)tmp_src+tmp_len-2)
            {
                h_myself  = tmp_h;
                break;
            }
        }
        tmp_entry = SymFindNext();
    }

    if (h_myself) {
        if (program_counter<0x40000) {
            tmp_src = HeapDeref(h_myself);
            enter_ghost_space();
            EX_patch(tmp_src+0x40002,tmp_src + 0x40001 + *(unsigned short*)tmp_src);
        }
    }
    else {
        ST_showHelp(GetMsg(MSG_ERR_FINDMYSELF));
        return;
    }

    //-------------------------------------------------------------------------
    // allocate space which is used later to support programs with a full
    // 16kB stack (we need around 1500 bytes only)
    //-------------------------------------------------------------------------
    if (!(stack_buffer = (unsigned char*)malloc(STACK_MAX_SIZE))) {
        HandleCleanup(MSG_ERR_OUTOFMEM);
        return;
    }

    InstallCrashProtection(&main_protection);
    if (!ER_catch(main_errorframe)) {

        //-------------------------------------------------------------------------
        // hide all files related to the explorer
        //-------------------------------------------------------------------------
        HideUnHideTICTFiles(1);

        //-------------------------------------------------------------------------
        // main loop
        //-------------------------------------------------------------------------
        do {
            interface.command = COMMAND_EXIT;

            //----------------------------------------------
            // find file tictexpl.LIB and start the explorer
            //----------------------------------------------
            explorer_folder[8] = 0;
            tmp_entry = SymFindFirst(NULL,2);
            while (tmp_entry) {
                if (tmp_entry->flags.bits.folder) {
                    strncpy(explorer_folder,tmp_entry->name,8);
                }
                else if (!strncmp(tmp_entry->name,"tictexpl",8)) {
                    if (!IsEntryInUse(tmp_entry)) {
                        tmp_src = HeapDeref(tmp_entry->handle);
                        tmp_len = *(unsigned short*)(tmp_src)+2;
                        tmp_src += tmp_len-1;

                        if (!memcmp(tmp_src-4,"LIB\x00\xF8",5)) {
                            s_explorer = tmp_entry;
                            break;
                        }
                    }
                }
                tmp_entry = SymFindNext();
            }

            if (!s_explorer) {
                interface.message = MSG_ERR_EXPLLIBNOTFOUND;
                break;
            }

            //------------------------------------------------
            // allocate screen memory for the explorer and
            // start it (afterwards give the memory free again
            //------------------------------------------------
            if (!(interface.lcdbuffer = malloc(LCD_SIZE))) {
                 interface.message = MSG_ERR_OUTOFMEM;
                 break;
            }
            if (firsttime) {
                interface.command = COMMAND_FIRSTTIME;
                firsttime = 0;
            }
            else {
                interface.command = COMMAND_RUN;
            }

            interface.exemode = EXEMODE_NONE;
            msg_number = StartExecutable(s_explorer,1);

            free(interface.lcdbuffer);
            interface.lcdbuffer = NULL;

            if (msg_number) {
                interface.command = COMMAND_EXIT;
                interface.message = msg_number;
            }
            else if (interface.command != COMMAND_EXECUTE ||
                     interface.exemode == EXEMODE_BASIC)
            {
                break;
            }

            top_estack = top_backup;

            push_END_TAG();

            if (interface.exemode & EXEMODE_INTERPRET_FILE) {
                OSClearBreak();
                push_ANSI_string((char*)(interface.interpret_file));
            }
            else if (interface.exemode & EXEMODE_INTERPRET_FOLDERFILE) {
                sprintf(sbuffer,"%s\\%s",interface.interpret_folder,interface.interpret_file);
                OSClearBreak();
                push_ANSI_string(sbuffer);
            }

            sprintf(sbuffer,"%s\\%s",interface.foldername,interface.filename);
            tmp_entry = GetSymByName(sbuffer);

            if (!tmp_entry || !tmp_entry->handle) {
                interface.message = MSG_ERR_FILENOTFOUND;
            }
            else if (IsEntryInUse(tmp_entry)) {
                interface.message = MSG_ERR_FILEINUSE;
            }
            else {
                FolderGetCur(temp_folder);
                FolderCur(GenerateTIOSName((char*)interface.foldername,tmpname),1);
                if (interface.exemode & EXEMODE_PPG) {
                    interface.message = StartPPG(tmp_entry->handle);
                }
                else {
                    interface.message = StartExecutable(tmp_entry,0);
                }
                // restore old folder again
                FolderCur(GenerateTIOSName(temp_folder,tmpname),1);
            }

            //---------------------------------------------------------------------
            // if a program leaves some keypresses in the queue -> remove them and
            // restore the graphics port as well
            //---------------------------------------------------------------------
            PortRestore();
            GKeyFlush();

            top_estack = top_backup;
        }
        while (interface.command != COMMAND_EXIT);
        ER_success();
    }
    RemoveCrashProtection(&main_protection);

    //---------------------------------------------------------------------
    // is something triggered by myself ??? (shouldn't happen in any cause)
    //---------------------------------------------------------------------
    if (EXCEPTION_TRIGGERED()) {
        HandleCleanup(GET_EXCEPTION_CODE()+MSG_ERR_CRASHOFFSET);
        return;
    }

    HandleCleanup(MSG_OKAY);
    //------------------------------------------------------------------------
    // paste BASIC program string if wanted
    //------------------------------------------------------------------------
    if (interface.exemode == EXEMODE_BASIC) {
        ev.Type = CM_CLR;
        EV_sendEvent(EV_getAppID("TIHOME"),&ev);
        sprintf(sbuffer,"%s\\%s()",interface.foldername,interface.filename);
        CB_replaceTEXT(sbuffer, strlen(sbuffer), 0);
        ev.Type = CM_MENU_PASTE;
        EV_sendEvent(EV_getAppID("TIHOME"),&ev);
    }

    if (interface.message) ST_showHelp(GetMsg(interface.message));
    if (interface.message) ST_showHelp(GetMsg(interface.message));

    OSClearBreak();        // clear the break key for sure ...
    OSqclear(kbd_queue()); // clear keyboard queue for sure ..
}


//#############################################################################
//###################### NO MORE FAKES BEYOND THIS LINE #######################
//#############################################################################
//
//=============================================================================
// Revision History
//=============================================================================
//
// $Log: tictex.c,v $
// Revision 1.17  2002/10/29 09:07:25  tnussb
// workaround for the TWIN symbol deletion bug of the AMS: sets now the
// inuse-bit (hidden-bit) if we generate a TWIN symbol for executing an
// archived program. Thanx for Samuel Stearley who reported this AMS bug
// first.
//
// Revision 1.16  2002/09/10 11:28:42  tnussb
// changes up to v1.30 Beta 4 / examine history.txt for details
//
// Revision 1.15  2002/03/15 15:11:25  tnussb
// (1) necessary modifications for V200 (EX_patch fix etc.)
// (2) OSClearBreak() and OSqclear() added to end of program
//
// Revision 1.14  2002/02/21 09:31:23  tnussb
// VERSION_TI89 and VERSION_TI92P replaced by new standard USE_TI89 and USE_TI92P
//
// Revision 1.13  2002/02/07 18:01:18  tnussb
// generic commit
//
// Revision 1.12  2001/02/04 13:11:28  Thomas Nussbaumer
// changes up to version 1.00 RC2 (see history.txt)
//
// Revision 1.11  2001/01/26 21:04:44  Thomas Nussbaumer
// changes for version 0.80 [see history.txt]
//
// Revision 1.10  2001/01/21 17:05:09  Thomas Nussbaumer
// changes related to v0.65
//
// Revision 1.9  2001/01/21 00:20:16  Thomas Nussbaumer
// additionally changes related to version 0.60
//
// Revision 1.8  2001/01/20 21:36:30  Thomas Nussbaumer
// changes due to version 0.60
//
// Revision 1.7  2001/01/17 23:39:22  Thomas Nussbaumer
// (1) moved complete source to main.c
// (2) implemented here a custom startup utility
//
//
