/******************************************************************************
*
* project name:  TICT-Explorer
* file name:     start.c
* initial date:  06/01/2001
* author:        thomas.nussbaumer@gmx.net
*
* description:   handles starting of files
*
* $Id: start.c,v 1.11 2002/02/07 18:01:18 tnussb Exp $
*
******************************************************************************/

#define INTERPRET_EBOOK          "ebook"
#define INTERPRET_EBOOK_ERR      MSG_ERR_EBOOKNOTFOUND
#define INTERPRET_EBOOK_MODE     (EXEMODE_NORMAL | EXEMODE_INTERPRET_FOLDERFILE)

#define INTERPRET_QUILL          "quill"
#define INTERPRET_QUILL_ERR      MSG_ERR_QUILLNOTFOUND
#define INTERPRET_QUILL_MODE     (EXEMODE_NORMAL | EXEMODE_INTERPRET_FILE)

#define INTERPRET_SCOTTFREE      "scottpck"
#define INTERPRET_SCOTTFREE_ERR  MSG_ERR_SCOTTNOTFOUND
#define INTERPRET_SCOTTFREE_MODE (EXEMODE_PPG | EXEMODE_INTERPRET_FILE)

#define INTERPRET_PVPIC          "tictexpv"
#define INTERPRET_PVPIC_ERR      MSG_ERR_PVVIEWNOTFOUND
#define INTERPRET_PVPIC_MODE     (EXEMODE_NORMAL | EXEMODE_INTERPRET_FOLDERFILE)


//=============================================================================
// try to start a file by an interpreter
//
// NOTE: an interpreter will not get the complete stack as normal programs
//       due to the overhead of this routine !!!
//=============================================================================
short StartInterpreter(file_t* data,char* folder) {
    SYM_ENTRY*  entry;
    short       msg;
    const char* interpreter;
    char        directory[9];

    directory[8] = 0;
    strcpy((char*)pti->interpret_folder,folder);
    strcpy((char*)pti->interpret_file,data->name);

    //-------------------------------------------------------------------------
    // use ebook reader as interpreter ...
    //-------------------------------------------------------------------------
    if (data->type == TYPE_EBOOK) {
        interpreter  = INTERPRET_EBOOK;
        msg          = INTERPRET_EBOOK_ERR;
        pti->exemode = INTERPRET_EBOOK_MODE;
    }
    //-------------------------------------------------------------------------
    // use quill interpreter ...
    //-------------------------------------------------------------------------
    else if (data->type == TYPE_QUILL) {
        interpreter  = INTERPRET_QUILL;
        msg          = INTERPRET_QUILL_ERR;
        pti->exemode = INTERPRET_QUILL_MODE;
    }
    //-------------------------------------------------------------------------
    // use scottfree driver (PPG) as interpreter ...
    //-------------------------------------------------------------------------
    else if (data->type == TYPE_SCOTTFREE) {
        interpreter  = INTERPRET_SCOTTFREE;
        msg          = INTERPRET_SCOTTFREE_ERR;
        pti->exemode = INTERPRET_SCOTTFREE_MODE;
    }
    //-------------------------------------------------------------------------
    // use tictexpv as interpreter ...
    //-------------------------------------------------------------------------
    else { //if (data->type == TYPE_PVPIC) {
        interpreter  = INTERPRET_PVPIC;
        msg          = INTERPRET_PVPIC_ERR;
        pti->exemode = INTERPRET_PVPIC_MODE;
    }

    entry = SymFindFirst(NULL,2);

    while (entry) {
        if (entry->flags.bits.folder) strncpy(directory,entry->name,8);
        else if (!strncmp(interpreter,entry->name,8) && !IsEntryInUse(entry)) {
            unsigned char* src = SaveHeapLock(entry->handle);
            if (src) {
                src += *(unsigned short*)src+1;
                if ((*src) == ASM_TAG || (*src) == OTH_TAG) {
                    SaveHeapUnLock();
                    break;
                }
                SaveHeapUnLock();
            }
        }
        entry = SymFindNext();
    }

    if (!entry) {
        pti->exemode = EXEMODE_NONE;
        return msg;
    }

    strcpy((char*)pti->foldername,directory);
    strcpy((char*)pti->filename,interpreter);
    return MSG_OKAY;
}


//=============================================================================
// tries to start a given file (direct or by interpreter)
//=============================================================================
short HandleStart(file_t* data,char* folder) {
    SYM_ENTRY* symptr;
    short      msg  = MSG_OKAY;
    char       fullname[30];

    sprintf(fullname,"%s\\%s",folder,data->name);

    LCD_save(pti->lcdbuffer);

    if (IsInUse(fullname)) {
        msg = MSG_ERR_FILEINUSE;
    }
    else if (!(symptr=GetSymByName(fullname))) {
        msg = MSG_ERR_FILENOTFOUND;
    }
    else {
        strcpy((char*)pti->foldername,folder);
        strcpy((char*)pti->filename,data->name);
        pti->interpret_file[0]   = 0;
        pti->interpret_folder[0] = 0;
#if defined(DISABLE_SOME_PRGS)
        if (!strcmp(data->name,"install") ||
            !strcmp(data->name,"kernel")  ||
            !strcmp(data->name,"doorsos"))
        {
            msg = MSG_ERR_PRGNOTALLOWED;
        }
        else
#endif
        if (data->type == TYPE_NOSTUB_EXE) {
            pti->exemode = EXEMODE_NORMAL;
            return MSG_OKAY;
        }
        else if (data->type == TYPE_PPG_EXE) {
            pti->exemode = EXEMODE_PPG;
            return MSG_OKAY;
        }
#if defined(START_DOORS_EXE)
        else if (data->type == TYPE_DOORS_EXE) {
            pti->exemode = EXEMODE_NORMAL;
            return MSG_OKAY;
        }
#endif
        else if (data->type == TYPE_BASIC) {
            pti->exemode = EXEMODE_BASIC;
            return MSG_OKAY;
        }
        else if (data->type == TYPE_PIC) {
            ViewPIC(symptr->handle);
        }
        else if (data->type == TYPE_TEXT) {
            ViewTEXT(symptr);
        }
        else if (data->type == TYPE_EBOOK     ||
                 data->type == TYPE_QUILL     ||
                 data->type == TYPE_SCOTTFREE ||
                 data->type == TYPE_PVPIC)
        {
            msg = StartInterpreter(data,folder);
            if (pti->exemode != EXEMODE_NONE) return MSG_OKAY;
        }
        else {
            ViewHEX(symptr);
        }
    }

    //----------------------------------------------------------------
    // if a program leaves some keypresses in the queue -> remove them
    //----------------------------------------------------------------
    GKeyFlush();

    LCD_restore(pti->lcdbuffer);

    return msg;
}


//=============================================================================
// Revision History
//=============================================================================
//
// $Log: start.c,v $
// Revision 1.11  2002/02/07 18:01:18  tnussb
// generic commit
//
// Revision 1.10  2001/02/04 13:11:28  Thomas Nussbaumer
// changes up to version 1.00 RC2 (see history.txt)
//
// Revision 1.9  2001/01/26 21:04:44  Thomas Nussbaumer
// changes for version 0.80 [see history.txt]
//
// Revision 1.8  2001/01/21 17:05:09  Thomas Nussbaumer
// changes related to v0.65
//
// Revision 1.7  2001/01/21 00:20:16  Thomas Nussbaumer
// additionally changes related to version 0.60
//
// Revision 1.6  2001/01/20 21:36:30  Thomas Nussbaumer
// changes due to version 0.60
//
// Revision 1.5  2001/01/17 23:38:41  Thomas Nussbaumer
// changes related to version 0.50 (see history.txt)
//
// Revision 1.4  2001/01/16 03:42:25  Thomas Nussbaumer
// see history.txt (up to version 0.40)
//
// Revision 1.3  2001/01/15 00:08:19  Thomas Nussbaumer
// see history.txt (up to v0.34) for what's new
//
// Revision 1.2  2001/01/06 23:14:00  Thomas Nussbaumer
// unused variable from routine StartInterpreter() removed
//
// Revision 1.1  2001/01/06 23:09:46  Thomas Nussbaumer
// initial version
//
//
//
