/******************************************************************************
*
* project name:  TICT-Explorer
* file name:     protect.c
* initial date:  16/01/2001
* author:        thomas.nussbaumer@gmx.net
*
* description:   anticrash handler ported from DoorOS 0.98 source code
*                extended by FLINE 1111 support by Greg Dietsche (taken from
*                KernNO 2.0)
*
* $Id: protect.c,v 1.4 2002/09/10 11:28:42 tnussb Exp $
*
******************************************************************************/

#define EXCEPTION_NONE  (-1)

volatile short exception_occured = EXCEPTION_NONE;

#define RESET_EXCEPTION()     {exception_occured = EXCEPTION_NONE;}
#define EXCEPTION_TRIGGERED() (exception_occured != -1)
#define GET_EXCEPTION_CODE()  (exception_occured)


extern void exceptionhandlers(void);

#define FLINE1111SUPPORT

#if defined(FLINE1111SUPPORT)

asm ("exceptionhandlers:\n"\
"    move.w  #0x2700,%sr\n"\
"    move.w  #0,%d0\n"\
"    bra.w   crash\n"\
"    move.w  #0x2700,%sr\n"\
"    move.w  #1,%d0\n"\
"    bra.w   crash\n"\
"    move.w  #0x2700,%sr\n"\
"    move.w  #2,%d0\n"\
"    bra.w   crash\n"\
"    move.w  #0x2700,%sr\n"\
"    move.w  #3,%d0\n"\
"    bra.w   crash\n"\
"    move.w  #0x2700,%sr\n"\
"    move.w  #4,%d0\n"\
"    bra.w   crash\n"\
"    move.w  #0x2700,%sr\n"\
"    move.w  #5,%d0\n"\
"    bra.w   crash\n"\
"    move.w  #0x2700,%sr\n"\
"    move.w  #6,%d0\n"\
"    bra.w   crash\n"\
"    nop\n"\
"    nop\n"\
"    nop\n"\
"    nop\n"\
"    bra.w   __line1111_emulator__\n"\
"    move.w  #0x2700,%sr\n"\
"    move.w  #8,%d0\n"\
"    bra.w   crash\n"\
"    move.w  #0x2700,%sr\n"\
"    move.w  #9,%d0\n"\
"    bra.w   crash\n"\
"    move.w  #0x2700,%sr\n"\
"    move.w  #10,%d0\n"\
"    bra.w   crash\n"\
"    move.w  #0x2700,%sr\n"\
"    move.w  #11,%d0\n"\
"    bra.w   crash\n"\
"    move.w  #0x2700,%sr\n"\
"    move.w  #12,%d0\n"\
"    bra.w   crash\n"\
"    move.w  #0x2700,%sr\n"\
"    move.w  #13,%d0\n"\
"    bra.w   crash\n"\
"    move.w  #0x2700,%sr\n"\
"    move.w  #14,%d0\n"\
"    bra.w   crash\n"\
"    move.w  #0x2700,%sr\n"\
"    move.w  #15,%d0\n"\
"crash:\n"\
"    move.w  %d0,exception_occured\n"\
"    move.w  #0x700,%sr\n | user mode, no interrupts\n"\
"    dc.w    0xa006 | trigger line1010 exception with value 0x6 -> throws exception!\n"\
"__line1111_emulator__:\n"\
"    movem.l %a0-%a1/%d0,-(%sp) | saving registers for bra/bsr w/long word displacement emulation\n"\
"    move.l  14(%sp),%a0      | get the old pc\n"\
"    moveq.l #0,%d0          | clear all of d0...it may be used in long addition (moveq is faster than clr)\n"\
"    move.w  (%a0),%d0        | get the instruction that caused the interrupt\n"\
"    addq.l  #2,%a0          | go past the 2 byte 1111Emulator Code; point to the accompanying data/or next instruction\n"\
"    move.l  0xc8,%a1         | initialize rom call table pointer\n"\
"    cmpi.w  #0xFFF0,%d0      | 6 byte bsr w/long word displacement  ($FFF0)\n"\
"    bne.s   __NotFFF0\n"\
"    move.l  %a0,%a1           | a1=a0=pc\n"\
"    adda.l  (%a0)+,%a1        | a1+displacment=new pc=function address\n"\
"    move.l  %a1,14(%sp)       | save new pc (return address for _this_ interrupt)\n"\
"    bra.s   __Quit1111\n"\
"__NotFFF0:                  | 6 byte bra w/long word displacement ($FFF1)\n"\
"    cmpi.w  #0xFFF1,%d0\n"\
"    bne.s   __NotFFF1\n"\
"    adda.l  (%a0),%a0\n"\
"    move.l  %a0,14(%sp)\n"\
"    movem.l (%sp)+,%a0-%a1/%d0  | ti saves registers, so i do too. What about condition code flags??\n"\
"    rte\n"\
"__NotFFF1:\n"\
"    cmpi.w  #0xFFF2,%d0       | 4 byte ROM CALL     ($FFF2)\n"\
"    bne.s   __NotFFF2\n"\
"    move.w  (%a0),%d0\n"\
"    move.l  0(%a1,%d0),14(%sp)\n"\
"    addq.l  #2,%a0           | set pc to the correct location (old pc + 4)\n"\
"    bra     __Quit1111\n"\
"__NotFFF2:\n"\
"    subi.w  #0xF800,%d0       | 2 byte ROM CALL     ($F800 + Rom Call)\n"\
"    bmi.s   __Bad1111       | branch if less than zero (blt #$F800)\n"\
"    cmp.l   -4(%a1),%d0       | currently, handle a rom call index greater than the total # avail\n"\
"    bgt     __Bad1111       | rom calls as a crash. Would calling the AMS emulator be better....\n"\
"    lsl.l   #2,%d0           | *4\n"\
"    move.l  0(%a1,%d0),14(%sp) | save new pc (return address for _this_ interrupt)\n"\
"__Quit1111:\n"\
"    move    %usp,%a1\n"\
"    move.l  %a0,-(%a1)        | a0.l = return address to push on user stack\n"\
"    move    %a1,%usp\n"\
"    movem.l (%sp)+,%a0-%a1/%d0\n"\
"    rte\n"\
"    | rte calls the rom call, the rom call will return to the program that\n"\
"    | called it thru the return address pushed on the user stack. \n"\
"__Bad1111:\n"\
"    | note to self, if displaying regs for debug info, they must be restored...\n"\
"    lea     18(%sp),%sp      | restore supervisor stack (6 + 12)\n"\
"    move.w  #7,%d0\n"\
"    bra     crash");

#else

asm (".even\n"\
"exceptionhandlers:\n"\
"    move.w  #0x2700,%sr\n"\
"    move.w  #0,%d0\n"\
"    bra.w   crash\n"\
"    move.w  #0x2700,%sr\n"\
"    move.w  #1,%d0\n"\
"    bra.w   crash\n"\
"    move.w  #0x2700,%sr\n"\
"    move.w  #2,%d0\n"\
"    bra.w   crash\n"\
"    move.w  #0x2700,%sr\n"\
"    move.w  #3,%d0\n"\
"    bra.w   crash\n"\
"    move.w  #0x2700,%sr\n"\
"    move.w  #4,%d0\n"\
"    bra.w   crash\n"\
"    move.w  #0x2700,%sr\n"\
"    move.w  #5,%d0\n"\
"    bra.w   crash\n"\
"    move.w  #0x2700,%sr\n"\
"    move.w  #6,%d0\n"\
"    bra.w   crash\n"\
"    move.w  #0x2700,%sr\n"\
"    move.w  #7,%d0\n"\
"    bra.w   crash\n"\
"    move.w  #0x2700,%sr\n"\
"    move.w  #8,%d0\n"\
"    bra.w   crash\n"\
"    move.w  #0x2700,%sr\n"\
"    move.w  #9,%d0\n"\
"    bra.w   crash\n"\
"    move.w  #0x2700,%sr\n"\
"    move.w  #10,%d0\n"\
"    bra.w   crash\n"\
"    move.w  #0x2700,%sr\n"\
"    move.w  #11,%d0\n"\
"    bra.w   crash\n"\
"    move.w  #0x2700,%sr\n"\
"    move.w  #12,%d0\n"\
"    bra.w   crash\n"\
"    move.w  #0x2700,%sr\n"\
"    move.w  #13,%d0\n"\
"    bra.w   crash\n"\
"    move.w  #0x2700,%sr\n"\
"    move.w  #14,%d0\n"\
"    bra.w   crash\n"\
"    move.w  #0x2700,%sr\n"\
"    move.w  #15,%d0\n"\
"crash:\n"\
"    move.w  %d0,exception_occured\n"\
"    move.w  #0x700,%sr\n"\
"    dc.w    0xa006");    // trigger line1010 exception with value 0x6 -> throws exception!

#endif


unsigned char vec_offsets[16] = {
    0xC,            // ADDRESS ERROR
    0x10,           // ILLEGAL INSTRUCTION
    0x14,           // DIV BY ZERO
    0x18,           // CHK
    0x1C,           // TRAPV
    0x20,           // PRIV VIOLATION
    0x24,           // TRACE
    0x2C,           // LINE 1111
    0x60,           // SPURIOUS
    0x7C,           // MEMORY VIOLATION
    0x80+4*5,       // TRAP 5
    0x80+4*6,       // TRAP 6
    0x80+4*7,       // TRAP 7
    0x80+4*13,      // TRAP 13
    0x80+4*14,      // TRAP 14
    0x80+4*15};     // TRAP 15 : ER_Throw


typedef unsigned long PROTECTION_T[23];


//=============================================================================
// backups interrupts 1-7 and install special error vectors
// if you nesting this calls
//=============================================================================
void InstallCrashProtection(PROTECTION_T* backup) {
    short i = 16;

    OSSetSR(0x700); // interrupts off
    memcpy(&((*backup)[16]),(void*)0x40064, 7*4); // Saves the 7 auto_ints

    while (i--) {
        unsigned long **vector = (unsigned long **)(vec_offsets[i]+0x40000);
        (*backup)[i] = (unsigned long)*vector;
        *vector      = (unsigned long*)exceptionhandlers+3*i;
    }

    RESET_EXCEPTION();

    OSSetSR(0); // interrupts on
}

//=============================================================================
// restores interrupts 1-7 and the error vectors
//=============================================================================
void RemoveCrashProtection(PROTECTION_T* backup) {
    short i = 16;

    OSSetSR(0x700);  // interrupts off
    memcpy((void*)0x40064, &((*backup)[16]), 7*4); // restore the 7 auto_ints
    while (i--) {
        unsigned long **vector = (unsigned long **)(vec_offsets[i]+0x40000);
        *vector = (unsigned long*)(*backup)[i];
    }
    OSSetSR(0); // interrupts on
}


//#############################################################################
// Revision History
//#############################################################################
//
// $Log: protect.c,v $
// Revision 1.4  2002/09/10 11:28:42  tnussb
// changes up to v1.30 Beta 4 / examine history.txt for details
//
// Revision 1.3  2002/02/07 18:01:18  tnussb
// generic commit
//
// Revision 1.2  2001/01/26 21:04:44  Thomas Nussbaumer
// changes for version 0.80 [see history.txt]
//
// Revision 1.1  2001/01/20 21:33:37  Thomas Nussbaumer
// initial version
//
//
