/******************************************************************************
*
* project name:  TICT-Explorer
* file name:     msg_spanish.c
* initial date:  30/01/2001
* author:        Marcos Lopez (marcos.lopez@gmx.net)
*
* description:   defines for spanish version of messages
*
* $Id: msg_spanish.c,v 1.6 2002/09/10 11:28:42 tnussb Exp $
*
******************************************************************************/

#include "interface.h"

#define MSG_OKAY                   0
#define MSG_PRGTITLE               1
#define MSG_ERR_CRASHOFFSET        2

#define MSG_ERR_WRONGVERSION      18
#define MSG_ERR_OUTOFMEM          19
#define MSG_ERR_LOCKINGFAILED     20
#define MSG_ERR_PPGINVALID        21
#define MSG_ERR_EXECFAILED        22
#define MSG_ERR_NOFOLDERS         23
#define MSG_ERR_FILEINUSE         24
#define MSG_ERR_FILENOTFOUND      25
#define MSG_ERR_INVALIDEXPLLIB    26
#define MSG_ERR_EXPLLIBNOTFOUND   27
#define MSG_ERR_TWINFAILED        28
#define MSG_ERR_TWINDEL           29

#if defined(MSGS_EXPLORER)
#define MSG_ERR_EBOOKNOTFOUND      30
#define MSG_ERR_QUILLNOTFOUND      31
#define MSG_ERR_SCOTTNOTFOUND      32
#define MSG_ERR_PVVIEWNOTFOUND     33
#define MSG_ERR_PRGNOTALLOWED      34
#else
#define MSG_ERR_FINDMYSELF         30
#endif

//-----------------------------------------------------------------------------
// common ERROR and FATAL messages
//-----------------------------------------------------------------------------
const unsigned char* explorer_msgs[] = {
/*  0 */    NULL,                    // NOT USED
/*  1 */    TICTEX_VERSION_STRING,
/*  2 */  //"Address-Error",
            "Error de direccion",         // MSG_ERR_CRASHOFFSET ...
/*  3 */  //"Illegal-Instruction",
            "Instruccion Ilegal",
/*  4 */  //"Divide-By-Zero",
            "Division por 0",
/*  5 */  //"CHK-Instruction",
            "Instruccion CHK",
/*  6 */  //"TRAPV-Instruction",
            "Instruccion TRAPV",
/*  7 */  //"Trace",
            "Trace",
/*  8 */  //"Privilege-Violation",
            "Violacion de privilegios",
/*  9 */  //"Line-1111-Emulator",
            "Linea-1111-Emulador",
/* 10 */  //"Spurious-Interrupt",
            "Interrupcion erronea",
/* 11 */  //"Memory-Violation",
            "Violacion de memoria",
/* 12 */  //"Trap-5",
            "Trap-5",
/* 13 */  //"Trap-6",
            "Trap-6",
/* 14 */  //"Trap-7",
            "Trap-7",
/* 15 */  //"Trap-13",
            "Trap-13",
/* 16 */  //"Trap-14",
            "Trap-14",
/* 17 */  //"Trap-15",
            "Trap-15",
/* 18 */  //"version number missmatch",
            "version incorrecta",
/* 19 */  //"out of memory",
            "sin memoria",
/* 20 */  //"locking variable failed",
            "bloqueo de variable fallido",
/* 21 */  //"no valid ppg file",
            "fichero ppg no valido",
/* 22 */  //"execution failed",
            "ejecucion fallida",
/* 23 */  //"no folders found",
            "no se encontraron carpetas",
/* 24 */  //"file currently in use",
            "fichero en uso",
/* 25 */  //"file not found",
            "fichero no encontrado",
/* 26 */  //"invalid tictexpl.LIB",
            "tictexpl.LIB no valido",
/* 27 */  //"tictexpl.LIB not found",
            "tictexpl.LIB no encontrado",
/* 28 */  //"creating TWIN symbol failed",
            "creacion de TWIN-Symbol fallida",
/* 29 */  //"cannot delete TWIN symbol",
            "no se puede borrar el TWIN-Symbol",

#if defined(MSGS_EXPLORER)
/* 30 */  //"viewer ebook.EXE not found",
            "visor ebook.EXE no encontrado",
/* 31 */  //"viewer quill.EXE not found",
            "visor quill.EXE no encontrado",
/* 32 */  //"viewer scottpck.ppg not found",
            "visor scottpck.ppg no encontrado",
/* 33 */  //"viewer tictexpv.EXE not found",
            "visor tictexpv.EXE no encontrado",
/* 34 */  //"file not allowed for execution",
            "ejecucion de fichero no permitida"
#else
/* 30 */  //"cannot find myself"
            "no me puedo encontrar"
#endif
};


char msg_buf[80] = {};
const char* GetMsg(short idx) {
    if (idx == 0)    return NULL;
    else if (idx==1) return explorer_msgs[1];

    if (idx < 18) {
        sprintf(msg_buf,"FATAL: %s",explorer_msgs[idx]);
    }
    else {
        sprintf(msg_buf,"ERR: %s",explorer_msgs[idx]);
    }
    return msg_buf;
}

#if defined(MSGS_EXPLORER)

//-----------------------------------------------------------------------------
// direct messages from tictexpl.c
//-----------------------------------------------------------------------------

//#define MSGDIRECT_INTERFACENOTFOUND "ERR: interface not found [press key]"
#define MSGDIRECT_INTERFACENOTFOUND   "ERR: interfaz no encontrado [press key]"
//#define MSGDIRECT_SETPASSWDFAILED   "ERR: set password failed [press key]"
#define MSGDIRECT_SETPASSWDFAILED     "ERR: fallo al poner password [pulsa tecla]"
//#define MSGDIRECT_SETPASSWDFAILED2  "ERR: set password failed"
#define MSGDIRECT_SETPASSWDFAILED2    "ERR: fallo al poner password"
//#define MSGDIRECT_SHORTCUTSET       "shortcut \x7F%d set to %s\\%s"
#define MSGDIRECT_SHORTCUTSET         "favorito \x7F%d puesto a %s\\%s"
//#define MSGDIRECT_SETPASSWDFIRST    "ERR: set password first"
#define MSGDIRECT_SETPASSWDFIRST      "ERR: pon password primero"
//#define MSGDIRECT_WRONGPASSWD       "ERR: wrong password"
#define MSGDIRECT_WRONGPASSWD         "ERR: password incorrecto"
//#define MSGDIRECT_EXCEPTIONCAUGHT   "ERR: exception caught"
#define MSGDIRECT_EXCEPTIONCAUGHT     "ERR: excepcion encontrada"
//#define MSGDIRECT_CANNOTSELECTUSED  "can't select files in use"
#define MSGDIRECT_CANNOTSELECTUSED    "no se puede selec. archivos en uso"
//#define MSGDIRECT_NOFILES           "no files"
#define MSGDIRECT_NOFILES             "no hay ficheros"
//#define MSGDIRECT_ONEFILE           "1 file"
#define MSGDIRECT_ONEFILE             "1 fichero"
//#define MSGDIRECT_MOREFILES         "%d files"
#define MSGDIRECT_MOREFILES           "%d ficheros"
//#define MSGDIRECT_AVAILRAM          "%lu bytes RAM free"
#define MSGDIRECT_AVAILRAM            "%lu Bytes RAM libres"
//#define MSGDIRECT_HEADER            "F1 File   F2 Favorites   F3 Arch.  F4 Sel.  F5 Info"
#define MSGDIRECT_HEADER              " F1 Fich  F2 Favoritos  F3 Arch  F4 Sel  F5 Info"

const char* f1_entries[] = {
    //"1:Delete File(s)  \x15",
    "1:Eliminar \x15",
    //"2:Copy File(s)",
    "2:Copiar",
    //"3:Rename File",
    "3:Renombrar",
    //"4:Move File(s)",
    "4:Mover",
    //"5:Create Folder",
    "5:Crear carpeta",
    //"6:View File (HEX)",
    "6:Ver en hexadecimal",
    //"7:Lock/Unlock File(s)",
    "7:(Des)Bloquear",
    //"8:Change Password",
    "8:Cambiar password",
    //"9:Lock Calculator",
    "9:Bloquear calc.",
    //"0:Help",
    "0:Ayuda",
    //"   About ....",
    "   Acerca de ...",
    NULL};

//-----------------------------------------------------------------------------
// direct messages from file.c
//-----------------------------------------------------------------------------

//#define MSGDIRECT_PLEASESELECT         "Please select or highlight a file"
#define MSGDIRECT_PLEASESELECT           "Por favor seleccione un fichero"
//#define MSGDIRECT_PROCESSARCHIVE       "process (un)archiving ..."
#define MSGDIRECT_PROCESSARCHIVE         "(Des-)Archivando ..."
//#define MSGDIRECT_PROCESSLOCKING       "process (un)locking ..."
#define MSGDIRECT_PROCESSLOCKING         "(Des-)bloqueando ..."
//#define MSGDIRECT_CURRENTINUSE         "ERR: %s is currently in use"
#define MSGDIRECT_CURRENTINUSE           "ERR: %s esta en uso"
//#define MSGDIRECT_LOCKEDORARCHIVED     "ERR: file %s is locked or archived"
#define MSGDIRECT_LOCKEDORARCHIVED       "ERR: fichero %s esta bloq. o arch."
//#define MSGDIRECT_UNARCHIVEFAILED      "ERR: unarchiving failed"
#define MSGDIRECT_UNARCHIVEFAILED        "ERR: desarchivado incorrecto"
//#define MSGDIRECT_ARCHIVEFAILED        "ERR: archiving failed"
#define MSGDIRECT_ARCHIVEFAILED          "ERR: archivado correcto"
//#define MSGDIRECT_NOFILEPROCESSED      "NO files processed"
#define MSGDIRECT_NOFILEPROCESSED        "Ningun fichero procesado"
//#define MSGDIRECT_ONEFILEPROCESSED     "1 file processed"
#define MSGDIRECT_ONEFILEPROCESSED       "1 fichero procesado"
//#define MSGDIRECT_MULTIFILEPROCESSED   "%d files processed"
#define MSGDIRECT_MULTIFILEPROCESSED     "%d ficheros procesados"
//#define MSGDIRECT_ENTERFOLDERTOCREATE  "Enter Folder Name to Create"
#define MSGDIRECT_ENTERFOLDERTOCREATE    "Introduce Nombre de la Carpeta"
//#define MSGDIRECT_FOLDERNAME           "Foldername:"
#define MSGDIRECT_FOLDERNAME             "Nombre carp:"
//#define MSGDIRECT_STARTWITHLETTER      "ERR: folders MUST start with a letter"
#define MSGDIRECT_STARTWITHLETTER        "ERR: carpetas DEBEN empezar por letra"
//#define MSGDIRECT_FOLDEREXISTS         "ERR: folder already exists"
#define MSGDIRECT_FOLDEREXISTS           "ERR: carpeta ya existente"
//#define MSGDIRECT_FOLDERCREATIONFAILED "ERR: folder creation failed"
#define MSGDIRECT_FOLDERCREATIONFAILED   "ERR: creacion de carpeta fallida"
//#define MSGDIRECT_FOLDERSUCCESS        "Folder %s successfully created"
#define MSGDIRECT_FOLDERSUCCESS          "Carpeta %s creada correctamente"
//#define MSGDIRECT_FOLDERNOTFOUND       "ERR: cannot find folder %s"
#define MSGDIRECT_FOLDERNOTFOUND         "ERR: no puedo encontrar la carpeta %s"
//#define MSGDIRECT_FOLDERNOTEMPTY       "ERR: cannot delete non-empty folder"
#define MSGDIRECT_FOLDERNOTEMPTY         "ERR: no se puede eliminar carpeta no vacia"
//#define MSGDIRECT_CANNOTDELETEMAIN     "ERR: cannot delete main folder"
#define MSGDIRECT_CANNOTDELETEMAIN       "ERR: no se puede eliminar carpeta main"
//#define MSGDIRECT_REQUEST              "Request"
#define MSGDIRECT_REQUEST                "Peticion"
//#define MSGDIRECT_SURETODELETEFOLDER   "Sure to Delete Active Folder?"
#define MSGDIRECT_SURETODELETEFOLDER     "Eliminar Carpeta Activa?"
//#define MSGDIRECT_SUCCESSDELFOLDER     "folder %s deleted"
#define MSGDIRECT_SUCCESSDELFOLDER       "Carpeta %s eliminada"
//#define MSGDIRECT_FAILEDDELFOLDER      "deleting folder %s failed"
#define MSGDIRECT_FAILEDDELFOLDER        "Eliminacion de carpeta %s fallida"
//#define MSGDIRECT_SUREDELACTIVE        "Sure to Delete Active File?"
#define MSGDIRECT_SUREDELACTIVE          "Eliminar Fichero activo?"
//#define MSGDIRECT_SUREDELMARKED        "Sure to Delete Marked Files?"
#define MSGDIRECT_SUREDELMARKED          "Eliminar Ficheros marcados?"
//#define MSGDIRECT_FAILEDDELFILE        "ERR: deleting %s failed"
#define MSGDIRECT_FAILEDDELFILE          "ERR: eliminacin de %s fallida"
//#define MSGDIRECT_SUCESSDELFILE        "file %s deleted"
#define MSGDIRECT_SUCESSDELFILE          "Fichero %s eliminado"
//#define MSGDIRECT_SUCESSDELONEFILE     "1 file deleted"
#define MSGDIRECT_SUCESSDELONEFILE       "1 fichero eliminado"
//#define MSGDIRECT_SUCESSDELMULTIFILE   "%d files deleted"
#define MSGDIRECT_SUCESSDELMULTIFILE     "%d ficheros eliminados"
//#define MSGDIRECT_FILENAMEEXISTS       "ERR: %s already exists"
#define MSGDIRECT_FILENAMEEXISTS         "ERR: %s ya existe"
//#define MSGDIRECT_CANNOTOPENFILE       "ERR: cannot open %s"
#define MSGDIRECT_CANNOTOPENFILE         "ERR: no puedo abrir %"
//#define MSGDIRECT_CANNOTCREATEFILE     "ERR: cannot create %s"
#define MSGDIRECT_CANNOTCREATEFILE       "ERR: no puedo crear %s"
//#define MSGDIRECT_SELECTDESTINATION    "Select Destination Folder"
#define MSGDIRECT_SELECTDESTINATION      "Selecciona Carpeta Destino"
//#define MSGDIRECT_COPYTO               "Copy To:"
#define MSGDIRECT_COPYTO                 "Copiar a:"
//#define MSGDIRECT_MOVETO               "Move To:"
#define MSGDIRECT_MOVETO                 "Mover a:"
//#define MSGDIRECT_COPYMSGPOSTFIX       "copied"
#define MSGDIRECT_COPYMSGPOSTFIX         "copiado"
//#define MSGDIRECT_MOVEMSGPOSTFIX       "moved"
#define MSGDIRECT_MOVEMSGPOSTFIX         "movido"
//#define MSGDIRECT_FILE_POSTFIX_TO_FILE "%s %s nach %s"
#define MSGDIRECT_FILE_POSTFIX_TO_FILE   "%s %s a %s"
//#define MSGDIRECT_ONEFILE_POSTFIX      "1 file %s"
#define MSGDIRECT_ONEFILE_POSTFIX        "1 fichero %s"
//#define MSGDIRECT_MULTIFILE_POSTFIX    "%d files %s"
#define MSGDIRECT_MULTIFILE_POSTFIX      "%d ficheros %s"
//#define MSGDIRECT_FAILEDMOVEFILE       "ERR: moving %s to %s failed"
#define MSGDIRECT_FAILEDMOVEFILE         "ERR: mover %s a %s fallido"
//#define MSGDIRECT_ENTERNEWFILENAME     "Enter New Name for File"
#define MSGDIRECT_ENTERNEWFILENAME       "Introduce nuevo nombre"
//#define MSGDIRECT_CANNOTRENAMEMAIN     "ERR: cannot rename main folder"
#define MSGDIRECT_CANNOTRENAMEMAIN       "ERR: no se puede renombrar carpeta main"
//#define MSGDIRECT_ENTERNEWFOLDERNAME   "Enter New Name for Folder"
#define MSGDIRECT_ENTERNEWFOLDERNAME     "Introduce nuevo nombre"
//#define MSGDIRECT_NEWNAME              "New Name:"
#define MSGDIRECT_NEWNAME                "Nombre:"
//#define MSGDIRECT_INVALIDFILENAME      "ERR: invalid file name"
#define MSGDIRECT_INVALIDFILENAME        "ERR: nombre de fichero no valido"
//#define MSGDIRECT_INVALIDFOLDERNAME    "ERR: invalid folder name"
#define MSGDIRECT_INVALIDFOLDERNAME      "ERR: nombre de carpeta no valido"
//#define MSGDIRECT_FAILEDRENAME         "ERR: renaming %s to %s failed"
#define MSGDIRECT_FAILEDRENAME           "ERR: renombrar %s a %s fallido"
//#define MSGDIRECT_SUCCESSRENAME        "%s renamed to %s"
#define MSGDIRECT_SUCCESSRENAME          "%s renombrado a %s"

//-----------------------------------------------------------------------------
// direct messages from menu.c
//-----------------------------------------------------------------------------

const char* infopage[] = {
    //"Active Folder",
    "Carpeta Activa",
    //"Active File",
    "Fichero Activo",
    //"Handle/Address",
    "Handle/Direccion",
    //"Handles free",
    "Handles libres",
    //"RAM free",
    "RAM libre",
    //"Archive used",
    "M Archivo usada",
    //"Archive free",
    "M Archivo libre",
    //"Top of EStack",
    "EStack llega hasta",
    //"Battery State"
    "Estado de pilas"
};

const char* helppage[] = {
    //"[2ND]+[UP]",     "Jump to First Line",
    "[2ND]+[ARRIBA]",       "Saltar a la primera linea",
    //"[2ND]+[DOWN]",   "Jump to Last Line",
    "[2ND]+[ABAJO]",     "Saltar a la ultima linea",
    //"[2ND]+[NR]",     "File to Favorite NUMBER",
    "[2ND]+[NUM]",       "Fichero a Favorito NUM",
    //"[\x7F]+[NUM]","Start Favorite NUMBER",
    "[\x7F]+[NUM]",  "Empezar Favorito NUM",
    //"[a]-[z]",        "Quick Jump",
    "[a]-[z]",          "Salto directo",
    //"[BACKSPACE]",    "Delete",
    "[BORRAR]",      "Eliminar",
    NULL};

//#define MSGDIRECT_HELPTITLE        "Help-Page"
#define MSGDIRECT_HELPTITLE          "Pagina de ayuda"
//#define MSGDIRECT_TESTPASSWORD     "Do you know the Password?"
#define MSGDIRECT_TESTPASSWORD       "Cual es el password?"
//#define MSGDIRECT_ENTERNEWPASSWORD "Please enter new Password"
#define MSGDIRECT_ENTERNEWPASSWORD   "Introduce nuevo password"
//#define MSGDIRECT_PASSWORD         "Password:"
#define MSGDIRECT_PASSWORD           "Password:"
//#define MSGDIRECT_REENTERPASSWORD  "Please re-enter Password"
#define MSGDIRECT_REENTERPASSWORD    "Reintroduce password"


//-----------------------------------------------------------------------------
// direct messages from loadsave.c
//-----------------------------------------------------------------------------

//#define MSGDIRECT_WARNINGCANNOTSAVE "WARN: can't save tictexco.nfig"
#define MSGDIRECT_WARNINGCANNOTSAVE   "AVISO: no se puede grabar config."
//#define MSGDIRECT_CLEARALLFAVORITES "0: Clear All Favorites"
#define MSGDIRECT_CLEARALLFAVORITES   "0: Borrar Favoritos"

//-----------------------------------------------------------------------------
// direct messages from extension.c
//-----------------------------------------------------------------------------

//#define MSGDIRECT_COMMENT_STRING "String"
#define MSGDIRECT_COMMENT_STRING   "Cadena"
//#define MSGDIRECT_COMMENT_TEXT   "Text"
#define MSGDIRECT_COMMENT_TEXT     "Texto"
//#define MSGDIRECT_COMMENT_PIC    "Picture"
#define MSGDIRECT_COMMENT_PIC      "Imagen"
//#define MSGDIRECT_COMMENT_GDB    "Gfx Database"
#define MSGDIRECT_COMMENT_GDB      "Base de datos de Gfx"
//#define MSGDIRECT_COMMENT_FIG    "Figure"
#define MSGDIRECT_COMMENT_FIG      "Figura"
//#define MSGDIRECT_COMMENT_MACR   "Macro"
#define MSGDIRECT_COMMENT_MACR     "Macro"
//#define MSGDIRECT_COMMENT_DATA   "Data"
#define MSGDIRECT_COMMENT_DATA     "Datos"
//#define MSGDIRECT_COMMENT_MAT    "Matrix"
#define MSGDIRECT_COMMENT_MAT      "Matriz"
//#define MSGDIRECT_COMMENT_LIST   "List"
#define MSGDIRECT_COMMENT_LIST     "Lista"
//#define MSGDIRECT_COMMENT_PRGM   "BASIC Program"
#define MSGDIRECT_COMMENT_PRGM     "Programa BASIC"
//#define MSGDIRECT_COMMENT_FUNC   "BASIC Function"
#define MSGDIRECT_COMMENT_FUNC     "Funcion BASIC"
//#define MSGDIRECT_COMMENT_EXE    "NOSTUB Program"
#define MSGDIRECT_COMMENT_EXE      "Programa NOSTUB"
//#define MSGDIRECT_COMMENT_PPG    "NOSTUB Program (exepacked)"
#define MSGDIRECT_COMMENT_PPG      "Programa (comprim.)"
//#define MSGDIRECT_COMMENT_ASM    "kernel-based Program"
#define MSGDIRECT_COMMENT_ASM      "Programa basado en kernel"
//#define MSGDIRECT_COMMENT_LIB    "kernel-based Library"
#define MSGDIRECT_COMMENT_LIB      "Libreria de kernel"
//#define MSGDIRECT_COMMENT_EXPR   "unknown Expression"
#define MSGDIRECT_COMMENT_EXPR     "Expresion desconocida"
//#define MSGDIRECT_COMMENT_EBOOK  "eBook"
#define MSGDIRECT_COMMENT_EBOOK    "Libro electronico"
//#define MSGDIRECT_COMMENT_ANIM   "Animation"
#define MSGDIRECT_COMMENT_ANIM     "Animation"


//-----------------------------------------------------------------------------
// About dialog message
//-----------------------------------------------------------------------------

const char* about[] = {
    "Una produccion TI-Chess Team",
    "Por",
    "Thomas Nussbaumer",
    "Y",
    "Marcos Lopez",
    "VISITA NUESTRA PAGINA WEB EN",
    "http://tict.ticalc.org",
};

//-----------------------------------------------------------------------------
// direct messages from battery.c for info box
//-----------------------------------------------------------------------------

//#define MSGDIRECT_BAT_FULL         "6/6 (FULL)"
#define MSGDIRECT_BAT_FULL         "6/6 (ALTO)"
//#define MSGDIRECT_BAT_OK           "5/6 (OK)"
#define MSGDIRECT_BAT_OK           "5/6 (MEDIO ALTO)"
//#define MSGDIRECT_BAT_MEDIUM       "4/6 (MEDIUM)"
#define MSGDIRECT_BAT_MEDIUM       "4/6 (MEDIO)"
//#define MSGDIRECT_BAT_LOW          "3/6 (LOW)"
#define MSGDIRECT_BAT_LOW          "3/6 (BAJO)"
//#define MSGDIRECT_BAT_VERYLOW      "2/6 (VERY LOW)"
#define MSGDIRECT_BAT_VERYLOW      "2/6 (MUY BAJO)"
//#define MSGDIRECT_BAT_ALMOSTDEAD   "1/6 (ALMOST DEAD)"
#define MSGDIRECT_BAT_ALMOSTDEAD   "1/6 (CASI MUERTA)"
//#define MSGDIRECT_BAT_CHANGE       "0/6 (!!CHANGE!!)"
#define MSGDIRECT_BAT_CHANGE       "0/6 (!!CAMBIO!!)"
//#define MSGDIRECT_BAT_RESET        "0/6 (*RESET*)"
#define MSGDIRECT_BAT_RESET        "0/6 (*RESET*)"


//-----------------------------------------------------------------------------
// direct messages from menu.c for info box
//-----------------------------------------------------------------------------

#define MSGDIRECT_NUMFILES         "%s  [%d fich.]"
#define MSGDIRECT_FILESIZE         "%s (%u bytes)"
#define MSGDIRECT_FILELOCKED       "bloq."
#define MSGDIRECT_FILEMOVABLE      "movible"
#define MSGDIRECT_MEMSIZE          "%lu bytes"


#endif

//=============================================================================
// Revision History
//=============================================================================
//
// $Log: msg_spanish.c,v $
// Revision 1.6  2002/09/10 11:28:42  tnussb
// changes up to v1.30 Beta 4 / examine history.txt for details
//
// Revision 1.5  2002/02/21 09:12:19  tnussb
// translations for new battery support added
//
// Revision 1.4  2002/02/07 18:01:18  tnussb
// generic commit
//
// Revision 1.3  2001/02/10 10:28:40  Thomas Nussbaumer
// generic commit
//
// Revision 1.2  2001/02/05 21:35:46  Thomas Nussbaumer
// slightly modified
//
// Revision 1.1  2001/02/04 12:37:23  Thomas Nussbaumer
// initial version
//
//
