/******************************************************************************
*
* project name:  TICT-Explorer
* file name:     msg_portuguese.c
* initial date:  25/02/2002
* author:        Gustavo Muller (blazter_br@hotmail.com)
*
* description:   defines for portuguese version of messages
*
* $Id: msg_portuguese.c,v 1.2 2002/09/10 11:28:42 tnussb Exp $
*
******************************************************************************/

#include "interface.h"

#define MSG_OKAY                   0
#define MSG_PRGTITLE               1
#define MSG_ERR_CRASHOFFSET        2

#define MSG_ERR_WRONGVERSION      18
#define MSG_ERR_OUTOFMEM          19
#define MSG_ERR_LOCKINGFAILED     20
#define MSG_ERR_PPGINVALID        21
#define MSG_ERR_EXECFAILED        22
#define MSG_ERR_NOFOLDERS         23
#define MSG_ERR_FILEINUSE         24
#define MSG_ERR_FILENOTFOUND      25
#define MSG_ERR_INVALIDEXPLLIB    26
#define MSG_ERR_EXPLLIBNOTFOUND   27
#define MSG_ERR_TWINFAILED        28
#define MSG_ERR_TWINDEL           29

#if defined(MSGS_EXPLORER)
#define MSG_ERR_EBOOKNOTFOUND      30
#define MSG_ERR_QUILLNOTFOUND      31
#define MSG_ERR_SCOTTNOTFOUND      32
#define MSG_ERR_PVVIEWNOTFOUND     33
#define MSG_ERR_PRGNOTALLOWED      34
#else
#define MSG_ERR_FINDMYSELF         30
#endif

//-----------------------------------------------------------------------------
// common ERROR and FATAL messages
//-----------------------------------------------------------------------------
const unsigned char* explorer_msgs[] = {
/*  0 */    NULL,                    // NOT USED
/*  1 */    TICTEX_VERSION_STRING,
/*  2 */  //"Address-Error",
            "Erro de endereco",         // MSG_ERR_CRASHOFFSET ...
/*  3 */  //"Illegal-Instruction",
            "Instrucao ilegal",
/*  4 */  //"Divide-By-Zero",
            "Divisao por zero",
/*  5 */  //"CHK-Instruction",
            "Instrucao CHK",
/*  6 */  //"TRAPV-Instruction",
            "Instrucao TRAPV",
/*  7 */  //"Trace",
            "Trace",
/*  8 */  //"Privilege-Violation",
            "Violacao de privilegios",
/*  9 */  //"Line-1111-Emulator",
            "Linha-1111-Emulador",
/* 10 */  //"Spurious-Interrupt",
            "Interrupcao invalida",
/* 11 */  //"Memory-Violation",
            "Violacao de memoria",
/* 12 */  //"Trap-5",
            "Trap-5",
/* 13 */  //"Trap-6",
            "Trap-6",
/* 14 */  //"Trap-7",
            "Trap-7",
/* 15 */  //"Trap-13",
            "Trap-13",
/* 16 */  //"Trap-14",
            "Trap-14",
/* 17 */  //"Trap-15",
            "Trap-15",
/* 18 */  //"version number missmatch",
            "versao incorreta",
/* 19 */  //"out of memory",
            "falta de memoria",
/* 20 */  //"locking variable failed",
            "bloqueio de var. falhou",
/* 21 */  //"no valid ppg file",
            "arquivo ppg invalido",
/* 22 */  //"execution failed",
            "execucao falhou",
/* 23 */  //"no folders found",
            "nenhuma pasta encontrada",
/* 24 */  //"file currently in use",
            "arquivo sendo usado",
/* 25 */  //"file not found",
            "arquivo nao encontrado",
/* 26 */  //"invalid tictexpl.LIB",
            "tictexpl.LIB nao valido",
/* 27 */  //"tictexpl.LIB not found",
            "tictexpl.LIB nao encontrado",
/* 28 */  //"creating TWIN symbol failed",
            "falha ao criar TWIN-Symbol",
/* 29 */  //"cannot delete TWIN symbol",
            "TWIN-Symbol nao pode ser deletado",

#if defined(MSGS_EXPLORER)
/* 30 */  //"viewer ebook.EXE not found",
            "ebook.EXE nao encontrado",
/* 31 */  //"viewer quill.EXE not found",
            "quill.EXE nao encontrado",
/* 32 */  //"viewer scottpck.ppg not found",
            "scottpck.ppg nao encontrado",
/* 33 */  //"viewer tictexpv.EXE not found",
            "tictexpv.EXE nao encontrado",
/* 34 */  //"file not allowed for execution",
            "execucaao de arquivo nao permitida"
#else
/* 30 */  //"cannot find myself"
            "nao pude encontrar"
#endif
};


char msg_buf[80] = {};
const char* GetMsg(short idx) {
    if (idx == 0)    return NULL;
    else if (idx==1) return explorer_msgs[1];

    if (idx < 18) {
        sprintf(msg_buf,"FATAL: %s",explorer_msgs[idx]);
    }
    else {
        sprintf(msg_buf,"ERR: %s",explorer_msgs[idx]);
    }
    return msg_buf;
}

#if defined(MSGS_EXPLORER)

//-----------------------------------------------------------------------------
// direct messages from tictexpl.c
//-----------------------------------------------------------------------------

//#define MSGDIRECT_INTERFACENOTFOUND "ERR: interface not found [press key]"
#define MSGDIRECT_INTERFACENOTFOUND   "ERR: interface nao encontrada [press tecla]"
//#define MSGDIRECT_SETPASSWDFAILED   "ERR: set password failed [press key]"
#define MSGDIRECT_SETPASSWDFAILED     "ERR: ajustar password falhou [press tecla]"
//#define MSGDIRECT_SETPASSWDFAILED2  "ERR: set password failed"
#define MSGDIRECT_SETPASSWDFAILED2    "ERR: ajustar password falhou"
//#define MSGDIRECT_SHORTCUTSET       "shortcut \x7F%d set to %s\\%s"
#define MSGDIRECT_SHORTCUTSET         "atalho \x7F%d posto em %s\\%s"
//#define MSGDIRECT_SETPASSWDFIRST    "ERR: set password first"
#define MSGDIRECT_SETPASSWDFIRST      "ERR: ajuste password primeiro"
//#define MSGDIRECT_WRONGPASSWD       "ERR: wrong password"
#define MSGDIRECT_WRONGPASSWD         "ERR: password incorreta"
//#define MSGDIRECT_EXCEPTIONCAUGHT   "ERR: exception caught"
#define MSGDIRECT_EXCEPTIONCAUGHT     "ERR: excessao encontrada"
//#define MSGDIRECT_CANNOTSELECTUSED  "can't select files in use"
#define MSGDIRECT_CANNOTSELECTUSED    "nao se pode sel. arq. em uso"
//#define MSGDIRECT_NOFILES           "no files"
#define MSGDIRECT_NOFILES             "nenhum arquivo"
//#define MSGDIRECT_ONEFILE           "1 file"
#define MSGDIRECT_ONEFILE             "1 arquivo"
//#define MSGDIRECT_MOREFILES         "%d files"
#define MSGDIRECT_MOREFILES           "%d arquivos"
//#define MSGDIRECT_AVAILRAM          "%lu bytes RAM free"
#define MSGDIRECT_AVAILRAM            "%lu bytes de RAM livres"
//#define MSGDIRECT_HEADER            "F1 File   F2 Favorites   F3 Arch.  F4 Sel.  F5 Info"
#define MSGDIRECT_HEADER              "F1 Arquivo  F2 Atalhos  F3 Arqui.  F4 Sel.  F5 Info"

const char* f1_entries[] = {
    //"1:Delete File(s)  \x15",
    "1:Deletar \x15",
    //"2:Copy File(s)",
    "2:Copiar",
    //"3:Rename File",
    "3:Renomear Arq.",
    //"4:Move File(s)",
    "4:Mover Arq.(s)",
    //"5:Create Folder",
    "5:Criar Pasta",
    //"6:View File (HEX)",
    "6:Abrir com (HEX)",
    //"7:Lock/Unlock File(s)",
    "7:(Des)Bloquear Arq.(s)",
    //"8:Change Password",
    "8:Mudar password",
    //"9:Lock Calculator",
    "9:Bloquear calc.",
    //"0:Help",
    "0:Ajuda",
    //"   About ....",
    "   Sobre ...",
    NULL};

//-----------------------------------------------------------------------------
// direct messages from file.c
//-----------------------------------------------------------------------------

//#define MSGDIRECT_PLEASESELECT         "Please select or highlight a file"
#define MSGDIRECT_PLEASESELECT           "Por favor selecione um arquivo"
//#define MSGDIRECT_PROCESSARCHIVE       "process (un)archiving ..."
#define MSGDIRECT_PROCESSARCHIVE         "(Des-)Arquivando ..."
//#define MSGDIRECT_PROCESSLOCKING       "process (un)locking ..."
#define MSGDIRECT_PROCESSLOCKING         "(Des-)bloqueando ..."
//#define MSGDIRECT_CURRENTINUSE         "ERR: %s is currently in use"
#define MSGDIRECT_CURRENTINUSE           "ERR: %s esta em uso"
//#define MSGDIRECT_LOCKEDORARCHIVED     "ERR: file %s is locked or archived"
#define MSGDIRECT_LOCKEDORARCHIVED       "ERR: arquivo %s esta bloq. ou arqui."
//#define MSGDIRECT_UNARCHIVEFAILED      "ERR: unarchiving failed"
#define MSGDIRECT_UNARCHIVEFAILED        "ERR: desarquivacao falhou"
//#define MSGDIRECT_ARCHIVEFAILED        "ERR: archiving failed"
#define MSGDIRECT_ARCHIVEFAILED          "ERR: arquivacao ok"
//#define MSGDIRECT_NOFILEPROCESSED      "NO files processed"
#define MSGDIRECT_NOFILEPROCESSED        "Nenhum arquivo processado"
//#define MSGDIRECT_ONEFILEPROCESSED     "1 file processed"
#define MSGDIRECT_ONEFILEPROCESSED       "1 arquivo processado"
//#define MSGDIRECT_MULTIFILEPROCESSED   "%d files processed"
#define MSGDIRECT_MULTIFILEPROCESSED     "%d arquivos processados"
//#define MSGDIRECT_ENTERFOLDERTOCREATE  "Enter Folder Name to Create"
#define MSGDIRECT_ENTERFOLDERTOCREATE    "Entre o Nome da Pasta a Criar"
//#define MSGDIRECT_FOLDERNAME           "Foldername:"
#define MSGDIRECT_FOLDERNAME             "Nome da Pasta:"
//#define MSGDIRECT_STARTWITHLETTER      "ERR: folders MUST start with a letter"
#define MSGDIRECT_STARTWITHLETTER        "ERR: pastas precisao comecar com letra"
//#define MSGDIRECT_FOLDEREXISTS         "ERR: folder already exists"
#define MSGDIRECT_FOLDEREXISTS           "ERR: pasta ja existe"
//#define MSGDIRECT_FOLDERCREATIONFAILED "ERR: folder creation failed"
#define MSGDIRECT_FOLDERCREATIONFAILED   "ERR: criacao de pasta falhou"
//#define MSGDIRECT_FOLDERSUCCESS        "Folder %s successfully created"
#define MSGDIRECT_FOLDERSUCCESS          "Pasta %s criada corretamente"
//#define MSGDIRECT_FOLDERNOTFOUND       "ERR: cannot find folder %s"
#define MSGDIRECT_FOLDERNOTFOUND         "ERR: pasta %s nao pode ser encontrada"
//#define MSGDIRECT_FOLDERNOTEMPTY       "ERR: cannot delete non-empty folder"
#define MSGDIRECT_FOLDERNOTEMPTY         "ERR: pasta cheia nao pode ser deletada"
//#define MSGDIRECT_CANNOTDELETEMAIN     "ERR: cannot delete main folder"
#define MSGDIRECT_CANNOTDELETEMAIN       "ERR: pasta main nao pode ser deletada"
//#define MSGDIRECT_REQUEST              "Request"
#define MSGDIRECT_REQUEST                "Pedido"
//#define MSGDIRECT_SURETODELETEFOLDER   "Sure to Delete Active Folder?"
#define MSGDIRECT_SURETODELETEFOLDER     "Deletar Pasta Ativa?"
//#define MSGDIRECT_SUCCESSDELFOLDER     "folder %s deleted"
#define MSGDIRECT_SUCCESSDELFOLDER       "pasta %s deletada"
//#define MSGDIRECT_FAILEDDELFOLDER      "deleting folder %s failed"
#define MSGDIRECT_FAILEDDELFOLDER        "delecao da pasta %s falhou"
//#define MSGDIRECT_SUREDELACTIVE        "Sure to Delete Active File?"
#define MSGDIRECT_SUREDELACTIVE          "Deletar arquivo Ativo?"
//#define MSGDIRECT_SUREDELMARKED        "Sure to Delete Marked Files?"
#define MSGDIRECT_SUREDELMARKED          "Deletar Arquivos Marcados?"
//#define MSGDIRECT_FAILEDDELFILE        "ERR: deleting %s failed"
#define MSGDIRECT_FAILEDDELFILE          "ERR: delecao de %s falhou"
//#define MSGDIRECT_SUCESSDELFILE        "file %s deleted"
#define MSGDIRECT_SUCESSDELFILE          "arquivo %s deletado"
//#define MSGDIRECT_SUCESSDELONEFILE     "1 file deleted"
#define MSGDIRECT_SUCESSDELONEFILE       "1 arquivo deletado"
//#define MSGDIRECT_SUCESSDELMULTIFILE   "%d files deleted"
#define MSGDIRECT_SUCESSDELMULTIFILE     "%d arquivos deletados"
//#define MSGDIRECT_FILENAMEEXISTS       "ERR: %s already exists"
#define MSGDIRECT_FILENAMEEXISTS         "ERR: %s ja existe"
//#define MSGDIRECT_CANNOTOPENFILE       "ERR: cannot open %s"
#define MSGDIRECT_CANNOTOPENFILE         "ERR: s% nao pode ser aberto"
//#define MSGDIRECT_CANNOTCREATEFILE     "ERR: cannot create %s"
#define MSGDIRECT_CANNOTCREATEFILE       "ERR: %s nao pode ser criado"
//#define MSGDIRECT_SELECTDESTINATION    "Select Destination Folder"
#define MSGDIRECT_SELECTDESTINATION      "Selecione a Pasta de Destino"
//#define MSGDIRECT_COPYTO               "Copy To:"
#define MSGDIRECT_COPYTO                 "Copiar para:"
//#define MSGDIRECT_MOVETO               "Move To:"
#define MSGDIRECT_MOVETO                 "Mover para:"
//#define MSGDIRECT_COPYMSGPOSTFIX       "copied"
#define MSGDIRECT_COPYMSGPOSTFIX         "copiado"
//#define MSGDIRECT_MOVEMSGPOSTFIX       "moved"
#define MSGDIRECT_MOVEMSGPOSTFIX         "movido"
//#define MSGDIRECT_FILE_POSTFIX_TO_FILE "%s %s nach %s"
#define MSGDIRECT_FILE_POSTFIX_TO_FILE   "%s %s para %s"
//#define MSGDIRECT_ONEFILE_POSTFIX      "1 file %s"
#define MSGDIRECT_ONEFILE_POSTFIX        "1 arquivo %s"
//#define MSGDIRECT_MULTIFILE_POSTFIX    "%d files %s"
#define MSGDIRECT_MULTIFILE_POSTFIX      "%d arquivos %s"
//#define MSGDIRECT_FAILEDMOVEFILE       "ERR: moving %s to %s failed"
#define MSGDIRECT_FAILEDMOVEFILE         "ERR: movendo %s para %s falhou"
//#define MSGDIRECT_ENTERNEWFILENAME     "Enter New Name for File"
#define MSGDIRECT_ENTERNEWFILENAME       "Entre o Novo Nome do Arquivo"
//#define MSGDIRECT_CANNOTRENAMEMAIN     "ERR: cannot rename main folder"
#define MSGDIRECT_CANNOTRENAMEMAIN       "ERR: pasta main nao pode ser renomeada"
//#define MSGDIRECT_ENTERNEWFOLDERNAME   "Enter New Name for Folder"
#define MSGDIRECT_ENTERNEWFOLDERNAME     "Entre o Novo Nome da Pasta"
//#define MSGDIRECT_NEWNAME              "New Name:"
#define MSGDIRECT_NEWNAME                "Novo Nome:"
//#define MSGDIRECT_INVALIDFILENAME      "ERR: invalid file name"
#define MSGDIRECT_INVALIDFILENAME        "ERR: nome de arquivo invalido"
//#define MSGDIRECT_INVALIDFOLDERNAME    "ERR: invalid folder name"
#define MSGDIRECT_INVALIDFOLDERNAME      "ERR: nome de pasta invalida"
//#define MSGDIRECT_FAILEDRENAME         "ERR: renaming %s to %s failed"
#define MSGDIRECT_FAILEDRENAME           "ERR: renomeando %s para %s falhou"
//#define MSGDIRECT_SUCCESSRENAME        "%s renamed to %s"
#define MSGDIRECT_SUCCESSRENAME          "%s renomeado para %s"

//-----------------------------------------------------------------------------
// direct messages from menu.c
//-----------------------------------------------------------------------------

const char* infopage[] = {
    //"Active Folder",
    "Pasta Ativa",
    //"Active File",
    "Arquivo Ativo",
    //"Handle/Address",
    "Handle/Endereco",
    //"Handles free",
    "Handles livres",
    //"RAM free",
    "RAM livre",
    //"Archive used",
    "Arquivo usado",
    //"Archive free",
    "Arquivo livre",
    //"Top of EStack",
    "Topo do EStack",
    //"Battery State"
    "Estado das Baterias"
};

const char* helppage[] = {
    //"[2ND]+[UP]",     "Jump to First Line",
    "[2ND]+[CIMA]", 	"Vai pra primeira linha",
    //"[2ND]+[DOWN]",   "Jump to Last Line",
    "[2ND]+[BAIXO]",    "Vai pra ultima linha",
    //"[2ND]+[NR]",     "File to Favorite NUMBER",
    "[2ND]+[NUM]",      "Arq. para atalho NUMERO",
    //"[\x7F]+[NUM]",	"Start Favorite NUMBER",
    "[\x7F]+[NUM]",  	"Executa Atalho NUMERO",
    //"[a]-[z]",        "Quick Jump",
    "[a]-[z]",          "Pulo rapido",
    //"[BACKSPACE]",    "Delete",
    "[BACKSPACE]",     	"Deletar",
    NULL};

//#define MSGDIRECT_HELPTITLE        "Help-Page"
#define MSGDIRECT_HELPTITLE          "Pagina de ajuda"
//#define MSGDIRECT_TESTPASSWORD     "Do you know the Password?"
#define MSGDIRECT_TESTPASSWORD       "Voce sabe a Password?"
//#define MSGDIRECT_ENTERNEWPASSWORD "Please enter new Password"
#define MSGDIRECT_ENTERNEWPASSWORD   "Entre a nova Password"
//#define MSGDIRECT_PASSWORD         "Password:"
#define MSGDIRECT_PASSWORD           "Password:"
//#define MSGDIRECT_REENTERPASSWORD  "Please re-enter Password"
#define MSGDIRECT_REENTERPASSWORD    "Re-entre a password"


//-----------------------------------------------------------------------------
// direct messages from loadsave.c
//-----------------------------------------------------------------------------

//#define MSGDIRECT_WARNINGCANNOTSAVE "WARN: can't save tictexco.nfig"
#define MSGDIRECT_WARNINGCANNOTSAVE   "AVISO: tictexco.nfig nao pode ser salvo"
//#define MSGDIRECT_CLEARALLFAVORITES "0: Clear All Favorites"
#define MSGDIRECT_CLEARALLFAVORITES   "0: Apagua Todos Atalhos"

//-----------------------------------------------------------------------------
// direct messages from extension.c
//-----------------------------------------------------------------------------

//#define MSGDIRECT_COMMENT_STRING "String"
#define MSGDIRECT_COMMENT_STRING   "String"
//#define MSGDIRECT_COMMENT_TEXT   "Text"
#define MSGDIRECT_COMMENT_TEXT     "Texto"
//#define MSGDIRECT_COMMENT_PIC    "Picture"
#define MSGDIRECT_COMMENT_PIC      "Imagem"
//#define MSGDIRECT_COMMENT_GDB    "Gfx Database"
#define MSGDIRECT_COMMENT_GDB      "Base de dados Gfx"
//#define MSGDIRECT_COMMENT_FIG    "Figure"
#define MSGDIRECT_COMMENT_FIG      "Figura"
//#define MSGDIRECT_COMMENT_MACR   "Macro"
#define MSGDIRECT_COMMENT_MACR     "Macro"
//#define MSGDIRECT_COMMENT_DATA   "Data"
#define MSGDIRECT_COMMENT_DATA     "Data"
//#define MSGDIRECT_COMMENT_MAT    "Matrix"
#define MSGDIRECT_COMMENT_MAT      "Matriz"
//#define MSGDIRECT_COMMENT_LIST   "List"
#define MSGDIRECT_COMMENT_LIST     "Lista"
//#define MSGDIRECT_COMMENT_PRGM   "BASIC Program"
#define MSGDIRECT_COMMENT_PRGM     "Programa BASIC"
//#define MSGDIRECT_COMMENT_FUNC   "BASIC Function"
#define MSGDIRECT_COMMENT_FUNC     "Funcao BASIC"
//#define MSGDIRECT_COMMENT_EXE    "NOSTUB Program"
#define MSGDIRECT_COMMENT_EXE      "Programa NOSTUB"
//#define MSGDIRECT_COMMENT_PPG    "NOSTUB Program (exepacked)"
#define MSGDIRECT_COMMENT_PPG      "Programa (exepacked)"
//#define MSGDIRECT_COMMENT_ASM    "kernel-based Program"
#define MSGDIRECT_COMMENT_ASM      "Programa kernel-based"
//#define MSGDIRECT_COMMENT_LIB    "kernel-based Library"
#define MSGDIRECT_COMMENT_LIB      "Biblioteca kernel-based"
//#define MSGDIRECT_COMMENT_EXPR   "unknown Expression"
#define MSGDIRECT_COMMENT_EXPR     "Expressao desconhecida"
//#define MSGDIRECT_COMMENT_EBOOK  "eBook"
#define MSGDIRECT_COMMENT_EBOOK    "eBook"
//#define MSGDIRECT_COMMENT_ANIM   "Animation"
#define MSGDIRECT_COMMENT_ANIM     "Animacao"


//-----------------------------------------------------------------------------
// About dialog message
//-----------------------------------------------------------------------------

const char* about[] = {
    "Uma producao de TI-Chess Team",
    "Por",
    "Thomas Nussbaumer",
    "E",
    "Marcos Lopez",
    "Visite em:",
    "http://tict.ticalc.org",
};

//-----------------------------------------------------------------------------
// direct messages from battery.c for info box
//-----------------------------------------------------------------------------

//#define MSGDIRECT_BAT_FULL        "6/6 (FULL)"
#define MSGDIRECT_BAT_FULL         	"6/6 (CHEIA)"
//#define MSGDIRECT_BAT_OK           "5/6 (OK)"
#define MSGDIRECT_BAT_OK           	"5/6 (OK)"
//#define MSGDIRECT_BAT_MEDIUM       "4/6 (MEDIUM)"
#define MSGDIRECT_BAT_MEDIUM       	"4/6 (MEDIA)"
//#define MSGDIRECT_BAT_LOW          "3/6 (LOW)"
#define MSGDIRECT_BAT_LOW          	"3/6 (BAIXA)"
//#define MSGDIRECT_BAT_VERYLOW      "2/6 (VERY LOW)"
#define MSGDIRECT_BAT_VERYLOW      	"2/6 (MUITO BAIXA)"
//#define MSGDIRECT_BAT_ALMOSTDEAD   "1/6 (ALMOST DEAD)"
#define MSGDIRECT_BAT_ALMOSTDEAD   	"1/6 (QUASE NO FIM)"
//#define MSGDIRECT_BAT_CHANGE       "0/6 (!!CHANGE!!)"
#define MSGDIRECT_BAT_CHANGE       	"0/6 (!!MUDE!!)"
//#define MSGDIRECT_BAT_RESET        "0/6 (*RESET*)"
#define MSGDIRECT_BAT_RESET        	"0/6 (*RESET*)"


//-----------------------------------------------------------------------------
// direct messages from menu.c for info box
//-----------------------------------------------------------------------------

#define MSGDIRECT_NUMFILES         "%s  [%d arq.]"
#define MSGDIRECT_FILESIZE         "%s (%u bytes)"
#define MSGDIRECT_FILELOCKED       "bloq."
#define MSGDIRECT_FILEMOVABLE      "movivel"
#define MSGDIRECT_MEMSIZE          "%lu bytes"


#endif

//=============================================================================
// Revision History
//=============================================================================
//
// $Log: msg_portuguese.c,v $
// Revision 1.2  2002/09/10 11:28:42  tnussb
// changes up to v1.30 Beta 4 / examine history.txt for details
//
// Revision 1.1  2002/02/25 11:08:16  tnussb
// initial version
//
//
//
