/******************************************************************************
*
* project name:  TICT-Explorer
* file name:     msg_italian.c
* initial date:  16/03/2001
* authors:       Andrea Rimondi (andrea.rimo@libero.it)
*                Kevin Kofler (kevin.kofler@chello.at) - battery state messages
*
* description:   defines for italian version of messages
*
* $Id: msg_italian.c,v 1.3 2002/09/10 11:28:42 tnussb Exp $
*
******************************************************************************/

#include "interface.h"

#define MSG_OKAY                   0
#define MSG_PRGTITLE               1
#define MSG_ERR_CRASHOFFSET        2

#define MSG_ERR_WRONGVERSION      18
#define MSG_ERR_OUTOFMEM          19
#define MSG_ERR_LOCKINGFAILED     20
#define MSG_ERR_PPGINVALID        21
#define MSG_ERR_EXECFAILED        22
#define MSG_ERR_NOFOLDERS         23
#define MSG_ERR_FILEINUSE         24
#define MSG_ERR_FILENOTFOUND      25
#define MSG_ERR_INVALIDEXPLLIB    26
#define MSG_ERR_EXPLLIBNOTFOUND   27
#define MSG_ERR_TWINFAILED        28
#define MSG_ERR_TWINDEL           29

#if defined(MSGS_EXPLORER)
#define MSG_ERR_EBOOKNOTFOUND      30
#define MSG_ERR_QUILLNOTFOUND      31
#define MSG_ERR_SCOTTNOTFOUND      32
#define MSG_ERR_PVVIEWNOTFOUND     33
#define MSG_ERR_PRGNOTALLOWED      34
#else
#define MSG_ERR_FINDMYSELF         30
#endif

//-----------------------------------------------------------------------------
// common ERROR and FATAL messages
//-----------------------------------------------------------------------------
const unsigned char* explorer_msgs[] = {
/*  0 */    NULL,                    // NOT USED
/*  1 */    TICTEX_VERSION_STRING,
/*  2 */  //"Address-Error",
            "Errore di indirizzo",      // MSG_ERR_CRASHOFFSET ...
/*  3 */  //"Illegal-Instruction",
            "instruzione illegale",
/*  4 */  //"Divide-By-Zero",
            "Divisione per 0",
/*  5 */  //"CHK-Instruction",
            "Instruzione CHK",
/*  6 */  //"TRAPV-Instruction",
            "Instruzione TRAPV",
/*  7 */  //"Trace",
            "Trace",
/*  8 */  //"Privilege-Violation",
            "violazione di privilegio",
/*  9 */  //"Line-1111-Emulator",
            "emulazione 1111",
/* 10 */  //"Spurious-Interrupt",
            "Falso-Interrupt",
/* 11 */  //"Memory-Violation",
            "Violazione di memoria",
/* 12 */  //"Trap-5",
            "Trap-5",
/* 13 */  //"Trap-6",
            "Trap-6",
/* 14 */  //"Trap-7",
            "Trap-7",
/* 15 */  //"Trap-13",
            "Trap-13",
/* 16 */  //"Trap-14",
            "Trap-14",
/* 17 */  //"Trap-15",
            "Trap-15",
/* 18 */  //"version number missmatch",
            "numero di versione non adatto",
/* 19 */  //"out of memory",
            "fuori memoria",
/* 20 */  //"locking variable failed",
            "Blocco variabile fallito",
/* 21 */  //"no valid ppg file",
            "ppg file non valido",
/* 22 */  //"execution failed",
            "esecuzione fallita",
/* 23 */  //"no folders found",
            "nessuna cartella trovata",
/* 24 */  //"file currently in use",
            "file in uso",
/* 25 */  //"file not found",
            "file non trovato",
/* 26 */  //"invalid tictexpl.LIB",
            "tictexpl.LIB invalido",
/* 27 */  //"tictexpl.LIB not found",
            "tictexpl.LIB non trovato",
/* 28 */  //"creating TWIN symbol failed",
            "crazione simbolo TWIN fallita",
/* 29 */  //"cannot delete TWIN symbol",
            "impossibile cancellare simbolo TWIN",

#if defined(MSGS_EXPLORER)
/* 30 */  //"viewer ebook.EXE not found",
            "prog ebook.EXE non trovato",
/* 31 */  //"viewer quill.EXE not found",
            "prog quill.EXE non trovato",
/* 32 */  //"viewer scottpck.ppg not found",
            "prog scottpck.ppg non trovato",
/* 33 */  //"viewer tictexpv.EXE not found",
            "prog tictexpv.EXE non trovato",
/* 34 */  //"file not allowed for execution",
            "file non eseguibile"
#else
/* 30 */  //"cannot find myself"
            "non mi trovo"
#endif
};


char msg_buf[80] = {};
const char* GetMsg(short idx) {
    if (idx == 0)    return NULL;
    else if (idx==1) return explorer_msgs[1];

    if (idx < 18) {
        sprintf(msg_buf,"FATAL: %s",explorer_msgs[idx]);
    }
    else {
        sprintf(msg_buf,"ERR: %s",explorer_msgs[idx]);
    }
    return msg_buf;
}

#if defined(MSGS_EXPLORER)

//-----------------------------------------------------------------------------
// direct messages from tictexpl.c
//-----------------------------------------------------------------------------

//#define MSGDIRECT_INTERFACENOTFOUND "ERR: interface not found [press key]"
#define MSGDIRECT_INTERFACENOTFOUND   "ERR: interfaccia non trovata [premi un tasto]"
//#define MSGDIRECT_SETPASSWDFAILED   "ERR: set password failed [press key]"
#define MSGDIRECT_SETPASSWDFAILED     "ERR: impossibile settare password [premi un tasto]"
//#define MSGDIRECT_SETPASSWDFAILED2  "ERR: set password failed"
#define MSGDIRECT_SETPASSWDFAILED2    "ERR: impossibile settare password"
//#define MSGDIRECT_SHORTCUTSET       "shortcut \x7F%d set to %s\\%s"
#define MSGDIRECT_SHORTCUTSET         "collegamento \x7F%d impostato a %s\\%s"
//#define MSGDIRECT_SETPASSWDFIRST    "ERR: set password first"
#define MSGDIRECT_SETPASSWDFIRST      "ERR: prima imposta la password"
//#define MSGDIRECT_WRONGPASSWD       "ERR: wrong password"
#define MSGDIRECT_WRONGPASSWD         "ERR: password errata"
//#define MSGDIRECT_EXCEPTIONCAUGHT   "ERR: exception caught"
#define MSGDIRECT_EXCEPTIONCAUGHT     "ERR: eccezione presa"
//#define MSGDIRECT_CANNOTSELECTUSED  "can't select files in use"
#define MSGDIRECT_CANNOTSELECTUSED    "impossibile selezionare file in uso"
//#define MSGDIRECT_NOFILES           "no files"
#define MSGDIRECT_NOFILES             "nessun file"
//#define MSGDIRECT_ONEFILE           "1 file"
#define MSGDIRECT_ONEFILE             "1 file"
//#define MSGDIRECT_MOREFILES         "%d files"
#define MSGDIRECT_MOREFILES           "%d file"
//#define MSGDIRECT_AVAILRAM          "%lu bytes RAM free"
#define MSGDIRECT_AVAILRAM            "Memoria libera %lu byte"
//#define MSGDIRECT_HEADER            "F1 File   F2 Favorites   F3 Arch.  F4 Sel.  F5 Info"
#define MSGDIRECT_HEADER              "F1 File  F2 Preferiti  F3 Arch.  F4 Sel.  F5 Info"

const char* f1_entries[] = {
    //"1:Delete File(s)  \x15",
    "1:Cancellare File(\x15)",
    //"2:Copy File(s)",
    "2:Copia File(s)",
    //"3:Rename File",
    "3:Rinomina File",
    //"4:Move File(s)",
    "4:Sposta File(s)",
    //"5:Create Folder",
    "5:Crea Cartella",
    //"6:View File (HEX)",
    "6:Visualizza File (HEX)",
    //"7:Lock/Unlock File(s)",
    "7:(S)Blocca file",
    //"8:Change Password",
    "8:Cambia Password",
    //"9:Lock Calculator",
    "9:Blocca Calcolatrice",
    //"0:Help",
    "0:Aiuto",
    //"   About ....",
    "   Informazioni ...",
    NULL};

//-----------------------------------------------------------------------------
// direct messages from file.c
//-----------------------------------------------------------------------------

//#define MSGDIRECT_PLEASESELECT         "Please select or highlight a file"
#define MSGDIRECT_PLEASESELECT           "Selezionare un file"
//#define MSGDIRECT_PROCESSARCHIVE       "process (un)archiving ..."
#define MSGDIRECT_PROCESSARCHIVE         "(De)archiviazione in corso ..."
//#define MSGDIRECT_PROCESSLOCKING       "process (un)locking ..."
#define MSGDIRECT_PROCESSLOCKING         "(S)bloccaggio in corso ..."
//#define MSGDIRECT_CURRENTINUSE         "ERR: %s is currently in use"
#define MSGDIRECT_CURRENTINUSE           "ERR: %s in uso"
//#define MSGDIRECT_LOCKEDORARCHIVED     "ERR: file %s is locked or archived"
#define MSGDIRECT_LOCKEDORARCHIVED       "ERR: file %s bloccato o archiviato"
//#define MSGDIRECT_UNARCHIVEFAILED      "ERR: unarchiving failed"
#define MSGDIRECT_UNARCHIVEFAILED        "ERR: de-archiviazione falliata"
//#define MSGDIRECT_ARCHIVEFAILED        "ERR: archiving failed"
#define MSGDIRECT_ARCHIVEFAILED          "ERR: archiviazione fallita"
//#define MSGDIRECT_NOFILEPROCESSED      "NO files processed"
#define MSGDIRECT_NOFILEPROCESSED        "nessun file trattato"
//#define MSGDIRECT_ONEFILEPROCESSED     "1 file processed"
#define MSGDIRECT_ONEFILEPROCESSED       "1 file trattato"
//#define MSGDIRECT_MULTIFILEPROCESSED   "%d files processed"
#define MSGDIRECT_MULTIFILEPROCESSED     "%d file trattati"
//#define MSGDIRECT_ENTERFOLDERTOCREATE  "Enter Folder Name to Create"
#define MSGDIRECT_ENTERFOLDERTOCREATE    "Nome Nuova Cartella da Creare"
//#define MSGDIRECT_FOLDERNAME           "Foldername:"
#define MSGDIRECT_FOLDERNAME             "Nome:"
//#define MSGDIRECT_STARTWITHLETTER      "ERR: folders MUST start with a letter"
#define MSGDIRECT_STARTWITHLETTER        "ERR: il nome DEVE iniziare con una lettera"
//#define MSGDIRECT_FOLDEREXISTS         "ERR: folder already exists"
#define MSGDIRECT_FOLDEREXISTS           "ERR: la cartella esiste gi"
//#define MSGDIRECT_FOLDERCREATIONFAILED "ERR: folder creation failed"
#define MSGDIRECT_FOLDERCREATIONFAILED   "ERR: creazione cartella fallita"
//#define MSGDIRECT_FOLDERSUCCESS        "Folder %s successfully created"
#define MSGDIRECT_FOLDERSUCCESS          "Cartella %s creata correttamente"
//#define MSGDIRECT_FOLDERNOTFOUND       "ERR: cannot find folder %s"
#define MSGDIRECT_FOLDERNOTFOUND         "ERR: cartella %s non trovata"
//#define MSGDIRECT_FOLDERNOTEMPTY       "ERR: cannot delete non-empty folder"
#define MSGDIRECT_FOLDERNOTEMPTY         "ERR: impossibile canc. cartella non vuota"
//#define MSGDIRECT_CANNOTDELETEMAIN     "ERR: cannot delete main folder"
#define MSGDIRECT_CANNOTDELETEMAIN       "ERR: impossibile cancellare cartella main"
//#define MSGDIRECT_REQUEST              "Request"
#define MSGDIRECT_REQUEST                "Richiesta"
//#define MSGDIRECT_SURETODELETEFOLDER   "Sure to Delete Active Folder?"
#define MSGDIRECT_SURETODELETEFOLDER     "Cancellare la cartella attiva?"
//#define MSGDIRECT_SUCCESSDELFOLDER     "folder %s deleted"
#define MSGDIRECT_SUCCESSDELFOLDER       "Cartella %s cancellata"
//#define MSGDIRECT_FAILEDDELFOLDER      "deleting folder %s failed"
#define MSGDIRECT_FAILEDDELFOLDER        "Cancellazione cartella %s fallita"
//#define MSGDIRECT_SUREDELACTIVE        "Sure to Delete Active File?"
#define MSGDIRECT_SUREDELACTIVE          "Cancellare file attivo?"
//#define MSGDIRECT_SUREDELMARKED        "Sure to Delete Marked Files?"
#define MSGDIRECT_SUREDELMARKED          "Cancellare file selezionati?"
//#define MSGDIRECT_FAILEDDELFILE        "ERR: deleting %s failed"
#define MSGDIRECT_FAILEDDELFILE          "ERR: cancellazione di %s fallita"
//#define MSGDIRECT_SUCESSDELFILE        "file %s deleted"
#define MSGDIRECT_SUCESSDELFILE          "file %s cancellato"
//#define MSGDIRECT_SUCESSDELONEFILE     "1 file deleted"
#define MSGDIRECT_SUCESSDELONEFILE       "1 file cancellato"
//#define MSGDIRECT_SUCESSDELMULTIFILE   "%d files deleted"
#define MSGDIRECT_SUCESSDELMULTIFILE     "%d file cancallati"
//#define MSGDIRECT_FILENAMEEXISTS       "ERR: %s already exists"
#define MSGDIRECT_FILENAMEEXISTS         "ERR: %s esiste gi"
//#define MSGDIRECT_CANNOTOPENFILE       "ERR: cannot open %s"
#define MSGDIRECT_CANNOTOPENFILE         "ERR: impossibile aprire %s"
//#define MSGDIRECT_CANNOTCREATEFILE     "ERR: cannot create %s"
#define MSGDIRECT_CANNOTCREATEFILE       "ERR: impossibile creare %s"
//#define MSGDIRECT_SELECTDESTINATION    "Select Destination Folder"
#define MSGDIRECT_SELECTDESTINATION      "Cartella di destinazione"
//#define MSGDIRECT_COPYTO               "Copy To:"
#define MSGDIRECT_COPYTO                 "Copiare in:"
//#define MSGDIRECT_MOVETO               "Move To:"
#define MSGDIRECT_MOVETO                 "Spostare in:"
//#define MSGDIRECT_COPYMSGPOSTFIX       "copied"
#define MSGDIRECT_COPYMSGPOSTFIX         "copiato"
//#define MSGDIRECT_MOVEMSGPOSTFIX       "moved"
#define MSGDIRECT_MOVEMSGPOSTFIX         "spostato"
//#define MSGDIRECT_FILE_POSTFIX_TO_FILE "%s %s nach %s"
#define MSGDIRECT_FILE_POSTFIX_TO_FILE   "%s %s in %s"
//#define MSGDIRECT_ONEFILE_POSTFIX      "1 file %s"
#define MSGDIRECT_ONEFILE_POSTFIX        "1 file %s"
//#define MSGDIRECT_MULTIFILE_POSTFIX    "%d files %s"
#define MSGDIRECT_MULTIFILE_POSTFIX      "%d file %s"
//#define MSGDIRECT_FAILEDMOVEFILE       "ERR: moving %s to %s failed"
#define MSGDIRECT_FAILEDMOVEFILE         "ERR: impossibile spostare %s in %s"
//#define MSGDIRECT_ENTERNEWFILENAME     "Enter New Name for File"
#define MSGDIRECT_ENTERNEWFILENAME       "Immettrere nuovo nome file"
//#define MSGDIRECT_CANNOTRENAMEMAIN     "ERR: cannot rename main folder"
#define MSGDIRECT_CANNOTRENAMEMAIN       "ERR: impossibile rinominare cartella main"
//#define MSGDIRECT_ENTERNEWFOLDERNAME   "Enter New Name for Folder"
#define MSGDIRECT_ENTERNEWFOLDERNAME     "Immettrere nuovo nome cartella"
//#define MSGDIRECT_NEWNAME              "New Name:"
#define MSGDIRECT_NEWNAME                "Nuovo nome:"
//#define MSGDIRECT_INVALIDFILENAME      "ERR: invalid file name"
#define MSGDIRECT_INVALIDFILENAME        "ERR: nome file non valido"
//#define MSGDIRECT_INVALIDFOLDERNAME    "ERR: invalid folder name"
#define MSGDIRECT_INVALIDFOLDERNAME      "ERR: nome cartella non valido"
//#define MSGDIRECT_FAILEDRENAME         "ERR: renaming %s to %s failed"
#define MSGDIRECT_FAILEDRENAME           "ERR: impossibile rinominare %s in %s"
//#define MSGDIRECT_SUCCESSRENAME        "%s renamed to %s"
#define MSGDIRECT_SUCCESSRENAME          "%s renominato in %s"

//-----------------------------------------------------------------------------
// direct messages from menu.c
//-----------------------------------------------------------------------------

const char* infopage[] = {
    //"Active Folder",
    "Cartella Attiva",
    //"Active File",
    "File Attivo",
    //"Handle/Address",
    "Handle/Indirizzo",
    //"Handles free",
    "Handle liberi",
    //"RAM free",
    "RAM libera",
    //"Archive used",
    "Archivio usato",
    //"Archive free",
    "Archivio libero",
    //"Top of EStack",
    "Inizio di EStack",
    //"Battery State"
    "Stato Batterie"
};

const char *helppage[] = {
    //"[2ND]+[UP]",     "Jump to First Line",
    "[2ND]+[SU]",     "Salta alla Prima Linea",
    //"[2ND]+[DOWN]",   "Jump to Last Line",
    "[2ND]+[GIU']",      "Salta all'Ultima Linea",
    //"[2ND]+[NR]",     "File to Favorite NUMBER",
    "[2ND]+[N.]",       "Aggiungi a Preferito N.",
    //"[\x7F]+[NUMBER]","Start Favorite NUMBER",
    "[\x7F]+[N]",       "Lancia Preferito N. (1->9)",
    //"[a]-[z]",        "Quick Rapido",
    "[a]-[z]",          "Salto Rapido",
    //"[BACKSPACE]",    "Delete",
    "[<--]",           "Cancellare",
    NULL};

//#define MSGDIRECT_HELPTITLE        "Help-Page"
#define MSGDIRECT_HELPTITLE          "Aiuto"
//#define MSGDIRECT_TESTPASSWORD     "Do you know the Password?"
#define MSGDIRECT_TESTPASSWORD       "Conosci la Password?"
//#define MSGDIRECT_ENTERNEWPASSWORD "Please enter new Password"
#define MSGDIRECT_ENTERNEWPASSWORD   "Immettere nuova Password"
//#define MSGDIRECT_PASSWORD         "Password:"
#define MSGDIRECT_PASSWORD           "Password:"
//#define MSGDIRECT_REENTERPASSWORD  "Please Re-Enter Password"
#define MSGDIRECT_REENTERPASSWORD    "Re-immettere la password"


//-----------------------------------------------------------------------------
// direct messages from loadsave.c
//-----------------------------------------------------------------------------

//#define MSGDIRECT_WARNINGCANNOTSAVE "WARN: can't save tictexco.nfig"
#define MSGDIRECT_WARNINGCANNOTSAVE   "AVV: imposs. salvare tictexco.nfig"
//#define MSGDIRECT_CLEARALLFAVORITES "0: Clear All Favorites"
#define MSGDIRECT_CLEARALLFAVORITES   "0: Cancellare Preferiti"

//-----------------------------------------------------------------------------
// direct messages from extension.c
//-----------------------------------------------------------------------------

//#define MSGDIRECT_COMMENT_STRING "String"
#define MSGDIRECT_COMMENT_STRING   "Stringa"
//#define MSGDIRECT_COMMENT_TEXT   "Text"
#define MSGDIRECT_COMMENT_TEXT     "Testo"
//#define MSGDIRECT_COMMENT_PIC    "Picture"
#define MSGDIRECT_COMMENT_PIC      "Immagine"
//#define MSGDIRECT_COMMENT_GDB    "Gfx Database"
#define MSGDIRECT_COMMENT_GDB      "Database GFX"
//#define MSGDIRECT_COMMENT_FIG    "Figure"
#define MSGDIRECT_COMMENT_FIG      "Figura"
//#define MSGDIRECT_COMMENT_MACR   "Macro"
#define MSGDIRECT_COMMENT_MACR     "Macro"
//#define MSGDIRECT_COMMENT_DATA   "Data"
#define MSGDIRECT_COMMENT_DATA     "Dati"
//#define MSGDIRECT_COMMENT_MAT    "Matrix"
#define MSGDIRECT_COMMENT_MAT      "Matrice"
//#define MSGDIRECT_COMMENT_LIST   "List"
#define MSGDIRECT_COMMENT_LIST     "Lista"
//#define MSGDIRECT_COMMENT_PRGM   "BASIC Program"
#define MSGDIRECT_COMMENT_PRGM     "Programma BASIC"
//#define MSGDIRECT_COMMENT_FUNC   "BASIC Function"
#define MSGDIRECT_COMMENT_FUNC     "Funzione BASIC"
//#define MSGDIRECT_COMMENT_EXE    "NOSTUB Program"
#define MSGDIRECT_COMMENT_EXE      "Programma NOSTUB"
//#define MSGDIRECT_COMMENT_PPG    "NOSTUB Program (exepacked)"
#define MSGDIRECT_COMMENT_PPG      "Programma compresso"
//#define MSGDIRECT_COMMENT_ASM    "kernel-based Program"
#define MSGDIRECT_COMMENT_ASM      "Programma basato su kernel"
//#define MSGDIRECT_COMMENT_LIB    "kernel-based Library"
#define MSGDIRECT_COMMENT_LIB      "Libreria basata su kernel"
//#define MSGDIRECT_COMMENT_EXPR   "unknown Expression"
#define MSGDIRECT_COMMENT_EXPR     "Espressione sconosciuta"
//#define MSGDIRECT_COMMENT_EBOOK  "eBook"
#define MSGDIRECT_COMMENT_EBOOK    "eBook"
//#define MSGDIRECT_COMMENT_ANIM   "Animation"
#define MSGDIRECT_COMMENT_ANIM     "Animazione"


//-----------------------------------------------------------------------------
// About dialog message
//-----------------------------------------------------------------------------

//char* about[] = {
//    "A TI-Chess Team Production",
//    "By",
//    "Thomas Nussbaumer",
//    "And",
//    "Marcos Lopez",
//    "VISIT OUR WEBSITE AT",
//    "http://tict.ticalc.org",
//};
const char* about[] = {
    "Una Produzione TI-Chess Team ",
    "Di",
    "Thomas Nussbaumer",
    "E",
    "Marcos Lopez",
    "VISITATE IL NOSTRO SITO WEB",
    "http://tict.ticalc.org",
};

//-----------------------------------------------------------------------------
// direct messages from battery.c for info box
//-----------------------------------------------------------------------------

//#define MSGDIRECT_BAT_FULL         "6/6 (FULL)"
#define MSGDIRECT_BAT_FULL         "6/6 (PIENE)"
//#define MSGDIRECT_BAT_OK           "5/6 (OK)"
#define MSGDIRECT_BAT_OK           "5/6 (QUASI PIENE)"
//#define MSGDIRECT_BAT_MEDIUM       "4/6 (MEDIUM)"
#define MSGDIRECT_BAT_MEDIUM       "4/6 (MEDIO)"
//#define MSGDIRECT_BAT_LOW          "3/6 (LOW)"
#define MSGDIRECT_BAT_LOW          "3/6 (BASSO)"
//#define MSGDIRECT_BAT_VERYLOW      "2/6 (VERY LOW)"
#define MSGDIRECT_BAT_VERYLOW      "2/6 (SCARICHE)"
//#define MSGDIRECT_BAT_ALMOSTDEAD   "1/6 (ALMOST DEAD)"
#define MSGDIRECT_BAT_ALMOSTDEAD   "1/6 (QUASI VUOTE)"
//#define MSGDIRECT_BAT_CHANGE       "0/6 (!!CHANGE!!)"
#define MSGDIRECT_BAT_CHANGE       "0/6 (!CAMBIARE!)"
//#define MSGDIRECT_BAT_RESET        "0/6 (*RESET*)"
#define MSGDIRECT_BAT_RESET        "0/6 (*RESET*)"


//-----------------------------------------------------------------------------
// direct messages from menu.c for info box
//-----------------------------------------------------------------------------

//#define MSGDIRECT_NUMFILES         "%s  [%d file(s)]"
#define MSGDIRECT_NUMFILES           "%s  [%d file]"
//#define MSGDIRECT_FILESIZE         "%s (%u bytes)"
#define MSGDIRECT_FILESIZE           "%s (%u bytes)"
//#define MSGDIRECT_FILELOCKED       "locked"
#define MSGDIRECT_FILELOCKED         "bloccato"
//#define MSGDIRECT_FILEMOVABLE      "movable"
#define MSGDIRECT_FILEMOVABLE        "mobile"
//#define MSGDIRECT_MEMSIZE          "%lu bytes"
#define MSGDIRECT_MEMSIZE            "%lu bytes"


#endif

//=============================================================================
// Revision History
//=============================================================================
//
// $Log: msg_italian.c,v $
// Revision 1.3  2002/09/10 11:28:42  tnussb
// changes up to v1.30 Beta 4 / examine history.txt for details
//
// Revision 1.2  2002/02/21 09:12:19  tnussb
// translations for new battery support added
//
// Revision 1.1  2002/02/07 17:58:51  tnussb
// initial version
//
// Revision 1.0  2001/03/16 15:47:40  Andrea Rimondi
// initial version
//
//
