/******************************************************************************
*
* project name:  TICT-Explorer
* file name:     msg_french.c
* initial date:  30/01/2001
* authors:       Claude Boulade (claude.boulade@bull.net)
*                Kevin Kofler (kevin.kofler@chello.at) - battery state messages
*
* description:   defines for french version of messages
*
* $Id: msg_french.c,v 1.6 2002/09/10 11:28:42 tnussb Exp $
*
******************************************************************************/

#include "interface.h"

#define MSG_OKAY                   0
#define MSG_PRGTITLE               1
#define MSG_ERR_CRASHOFFSET        2

#define MSG_ERR_WRONGVERSION      18
#define MSG_ERR_OUTOFMEM          19
#define MSG_ERR_LOCKINGFAILED     20
#define MSG_ERR_PPGINVALID        21
#define MSG_ERR_EXECFAILED        22
#define MSG_ERR_NOFOLDERS         23
#define MSG_ERR_FILEINUSE         24
#define MSG_ERR_FILENOTFOUND      25
#define MSG_ERR_INVALIDEXPLLIB    26
#define MSG_ERR_EXPLLIBNOTFOUND   27
#define MSG_ERR_TWINFAILED        28
#define MSG_ERR_TWINDEL           29

#if defined(MSGS_EXPLORER)
#define MSG_ERR_EBOOKNOTFOUND      30
#define MSG_ERR_QUILLNOTFOUND      31
#define MSG_ERR_SCOTTNOTFOUND      32
#define MSG_ERR_PVVIEWNOTFOUND     33
#define MSG_ERR_PRGNOTALLOWED      34
#else
#define MSG_ERR_FINDMYSELF         30
#endif

//-----------------------------------------------------------------------------
// common ERROR and FATAL messages
//-----------------------------------------------------------------------------
const unsigned char* explorer_msgs[] = {
/*  0 */    NULL,                    // NOT USED
/*  1 */    TICTEX_VERSION_STRING,
/*  2 */  //"Address-Error",
            "erreur d'adresse",      // MSG_ERR_CRASHOFFSET ...
/*  3 */  //"Illegal-Instruction",
            "instruction illegale",
/*  4 */  //"Divide-By-Zero",
            "Division par 0",
/*  5 */  //"CHK-Instruction",
            "Instruction CHK",
/*  6 */  //"TRAPV-Instruction",
            "Instruction TRAPV",
/*  7 */  //"Trace",
            "Trace",
/*  8 */  //"Privilege-Violation",
            "violation de privilege",
/*  9 */  //"Line-1111-Emulator",
            "emulation 1111",
/* 10 */  //"Spurious-Interrupt",
            "interruption parasite",
/* 11 */  //"Memory-Violation",
            "violation de memoire",
/* 12 */  //"Trap-5",
            "Trap-5",
/* 13 */  //"Trap-6",
            "Trap-6",
/* 14 */  //"Trap-7",
            "Trap-7",
/* 15 */  //"Trap-13",
            "Trap-13",
/* 16 */  //"Trap-14",
            "Trap-14",
/* 17 */  //"Trap-15",
            "Trap-15",
/* 18 */  //"version number missmatch",
            "mauvais numero de version",
/* 19 */  //"out of memory",
            "en dehors de la memoire",
/* 20 */  //"locking variable failed",
            "echec verrouillage variable",
/* 21 */  //"no valid ppg file",
            "pas de fichier ppg valide",
/* 22 */  //"execution failed",
            "echec a l'execution",
/* 23 */  //"no folders found",
            "dossiers non trouves",
/* 24 */  //"file currently in use",
            "fichier deja utilise",
/* 25 */  //"file not found",
            "fichier non trouve",
/* 26 */  //"invalid tictexpl.LIB",
            "tictexpl.LIB invalide",
/* 27 */  //"tictexpl.LIB not found",
            "tictexpl.LIB non trouve",
/* 28 */  //"creating TWIN symbol failed",
            "echec duplication symbole",
/* 29 */  //"cannot delete TWIN symbol",
            "echec effacement symb. duplique",

#if defined(MSGS_EXPLORER)
/* 30 */  //"viewer ebook.EXE not found",
            "visionneur ebook.EXE non trouve",
/* 31 */  //"viewer quill.EXE not found",
            "visionneur quill.EXE non trouve",
/* 32 */  //"viewer scottpck.ppg not found",
            "visionneur scottpck.ppg non trouve",
/* 33 */  //"viewer tictexpv.EXE not found",
            "visionneur tictexpv.EXE non trouve",
/* 34 */  //"file not allowed for execution",
            "fichier non executable"
#else
/* 30 */  //"cannot find myself"
            "je ne me trouve pas moi-meme"
#endif
};


char msg_buf[80] = {};
const char* GetMsg(short idx) {
    if (idx == 0)    return NULL;
    else if (idx==1) return explorer_msgs[1];

    if (idx < 18) {
        sprintf(msg_buf,"FATAL: %s",explorer_msgs[idx]);
    }
    else {
        sprintf(msg_buf,"ERR: %s",explorer_msgs[idx]);
    }
    return msg_buf;
}

#if defined(MSGS_EXPLORER)

//-----------------------------------------------------------------------------
// direct messages from tictexpl.c
//-----------------------------------------------------------------------------

//#define MSGDIRECT_INTERFACENOTFOUND "ERR: interface not found [press key]"
#define MSGDIRECT_INTERFACENOTFOUND   "ERR: Interface invalide [frapper une touche]"
//#define MSGDIRECT_SETPASSWDFAILED   "ERR: set password failed [press key]"
#define MSGDIRECT_SETPASSWDFAILED     "ERR: echec mot de passe [frapper une touche]"
//#define MSGDIRECT_SETPASSWDFAILED2  "ERR: set password failed"
#define MSGDIRECT_SETPASSWDFAILED2    "ERR: echec mot de passe"
//#define MSGDIRECT_SHORTCUTSET       "shortcut \x7F%d set to %s\\%s"
#define MSGDIRECT_SHORTCUTSET         "favori \x7F%d etabli a %s\\%s"
//#define MSGDIRECT_SETPASSWDFIRST    "ERR: set password first"
#define MSGDIRECT_SETPASSWDFIRST      "ERR: etablir mot de passe d'abord"
//#define MSGDIRECT_WRONGPASSWD       "ERR: wrong password"
#define MSGDIRECT_WRONGPASSWD         "ERR: mauvais mot de passe"
//#define MSGDIRECT_EXCEPTIONCAUGHT   "ERR: exception caught"
#define MSGDIRECT_EXCEPTIONCAUGHT     "ERR: exception detectee"
//#define MSGDIRECT_CANNOTSELECTUSED  "can't select files in use"
#define MSGDIRECT_CANNOTSELECTUSED    "impossible selectionner fichiers utilises"
//#define MSGDIRECT_NOFILES           "no files"
#define MSGDIRECT_NOFILES             "aucun fichier"
//#define MSGDIRECT_ONEFILE           "1 file"
#define MSGDIRECT_ONEFILE             "1 fichier"
//#define MSGDIRECT_MOREFILES         "%d files"
#define MSGDIRECT_MOREFILES           "%d fichiers"
//#define MSGDIRECT_AVAILRAM          "%lu bytes RAM free"
#define MSGDIRECT_AVAILRAM            "Memoire libre %lu octets"
//#define MSGDIRECT_HEADER            "F1 File   F2 Favorites   F3 Arch.  F4 Sel.  F5 Info"
#define MSGDIRECT_HEADER              "F1 Fichier  F2 Favoris  F3 Arch.  F4 Sel.  F5 Info"

const char* f1_entries[] = {
    //"1:Delete File(s)  \x15",
    "1:Effacer (\x15)",
    //"2:Copy File(s)",
    "2:Copier fichier(s)",
    //"3:Rename File",
    "3:Renommer fichier",
    //"4:Move File(s)",
    "4:Deplacer fichier(s)",
    //"5:Create Folder",
    "5:Creer dossier",
    //"6:View File (HEX)",
    "6:Voir fichier (HEX)",
    //"7:Lock/Unlock File(s)",
    "7:(De)verrouiller fichier",
    //"8:Change Password",
    "8:Changer mot de passe",
    //"9:Lock Calculator",
    "9:Arreter machine",
    //"0:Help",
    "0:Aide",
    //"   About ....",
    "   A propos de ...",
    NULL};

//-----------------------------------------------------------------------------
// direct messages from file.c
//-----------------------------------------------------------------------------

//#define MSGDIRECT_PLEASESELECT         "Please select or highlight a file"
#define MSGDIRECT_PLEASESELECT           "Selectionner ou surligner un fichier"
//#define MSGDIRECT_PROCESSARCHIVE       "process (un)archiving ..."
#define MSGDIRECT_PROCESSARCHIVE         "(des)archivage en cours ..."
//#define MSGDIRECT_PROCESSLOCKING       "process (un)locking ..."
#define MSGDIRECT_PROCESSLOCKING         "(de)verrouillage en cours ..."
//#define MSGDIRECT_CURRENTINUSE         "ERR: %s is currently in use"
#define MSGDIRECT_CURRENTINUSE           "ERR: %s deja utilise"
//#define MSGDIRECT_LOCKEDORARCHIVED     "ERR: file %s is locked or archived"
#define MSGDIRECT_LOCKEDORARCHIVED       "ERR: fichier %s verrouille ou archive"
//#define MSGDIRECT_UNARCHIVEFAILED      "ERR: unarchiving failed"
#define MSGDIRECT_UNARCHIVEFAILED        "ERR: echec desarchivage"
//#define MSGDIRECT_ARCHIVEFAILED        "ERR: archiving failed"
#define MSGDIRECT_ARCHIVEFAILED          "ERR: echec archivage"
//#define MSGDIRECT_NOFILEPROCESSED      "NO files processed"
#define MSGDIRECT_NOFILEPROCESSED        "aucun fichier traite"
//#define MSGDIRECT_ONEFILEPROCESSED     "1 file processed"
#define MSGDIRECT_ONEFILEPROCESSED       "1 fichier traite"
//#define MSGDIRECT_MULTIFILEPROCESSED   "%d files processed"
#define MSGDIRECT_MULTIFILEPROCESSED     "%d fichiers traites"
//#define MSGDIRECT_ENTERFOLDERTOCREATE  "Enter Folder Name to Create"
#define MSGDIRECT_ENTERFOLDERTOCREATE    "entrer le nom du dossier a creer"
//#define MSGDIRECT_FOLDERNAME           "Foldername:"
#define MSGDIRECT_FOLDERNAME             "nom dossier:"
//#define MSGDIRECT_STARTWITHLETTER      "ERR: folders MUST start with a letter"
#define MSGDIRECT_STARTWITHLETTER        "ERR: le nom doit debuter par une lettre"
//#define MSGDIRECT_FOLDEREXISTS         "ERR: folder already exists"
#define MSGDIRECT_FOLDEREXISTS           "ERR: le dossier existe deja"
//#define MSGDIRECT_FOLDERCREATIONFAILED "ERR: folder creation failed"
#define MSGDIRECT_FOLDERCREATIONFAILED   "ERR: echec creation de dossier"
//#define MSGDIRECT_FOLDERSUCCESS        "Folder %s successfully created"
#define MSGDIRECT_FOLDERSUCCESS          "dossier %s cree avec succes"
//#define MSGDIRECT_FOLDERNOTFOUND       "ERR: cannot find folder %s"
#define MSGDIRECT_FOLDERNOTFOUND         "ERR: dossier %s introuvable"
//#define MSGDIRECT_FOLDERNOTEMPTY       "ERR: cannot delete non-empty folder"
#define MSGDIRECT_FOLDERNOTEMPTY         "ERR: impossible effacer dossier non vide"
//#define MSGDIRECT_CANNOTDELETEMAIN     "ERR: cannot delete main folder"
#define MSGDIRECT_CANNOTDELETEMAIN       "ERR: impossible effacer dossier main"
//#define MSGDIRECT_REQUEST              "Request"
#define MSGDIRECT_REQUEST                "Confirmation"
//#define MSGDIRECT_SURETODELETEFOLDER   "Sure to Delete Active Folder?"
#define MSGDIRECT_SURETODELETEFOLDER     "Effacer le dossier surligne?"
//#define MSGDIRECT_SUCCESSDELFOLDER     "folder %s deleted"
#define MSGDIRECT_SUCCESSDELFOLDER       "dossier %s efface"
//#define MSGDIRECT_FAILEDDELFOLDER      "deleting folder %s failed"
#define MSGDIRECT_FAILEDDELFOLDER        "echec effacement dossier %s"
//#define MSGDIRECT_SUREDELACTIVE        "Sure to Delete Active File?"
#define MSGDIRECT_SUREDELACTIVE          "Effacer le fichier surligne?"
//#define MSGDIRECT_SUREDELMARKED        "Sure to Delete Marked Files?"
#define MSGDIRECT_SUREDELMARKED          "Effacer les fichiers marques?"
//#define MSGDIRECT_FAILEDDELFILE        "ERR: deleting %s failed"
#define MSGDIRECT_FAILEDDELFILE          "ERR: echec effacement de %s"
//#define MSGDIRECT_SUCESSDELFILE        "file %s deleted"
#define MSGDIRECT_SUCESSDELFILE          "fichier %s efface"
//#define MSGDIRECT_SUCESSDELONEFILE     "1 file deleted"
#define MSGDIRECT_SUCESSDELONEFILE       "1 fichier efface"
//#define MSGDIRECT_SUCESSDELMULTIFILE   "%d files deleted"
#define MSGDIRECT_SUCESSDELMULTIFILE     "%d fichiers effaces"
//#define MSGDIRECT_FILENAMEEXISTS       "ERR: %s already exists"
#define MSGDIRECT_FILENAMEEXISTS         "ERR: %s existe deja"
//#define MSGDIRECT_CANNOTOPENFILE       "ERR: cannot open %s"
#define MSGDIRECT_CANNOTOPENFILE         "ERR: echec ouverture %s"
//#define MSGDIRECT_CANNOTCREATEFILE     "ERR: cannot create %s"
#define MSGDIRECT_CANNOTCREATEFILE       "ERR: echec creation %s"
//#define MSGDIRECT_SELECTDESTINATION    "Select Destination Folder"
#define MSGDIRECT_SELECTDESTINATION      "selectionner dossier destination"
//#define MSGDIRECT_COPYTO               "Copy To:"
#define MSGDIRECT_COPYTO                 "Copier vers:"
//#define MSGDIRECT_MOVETO               "Move To:"
#define MSGDIRECT_MOVETO                 "Deplacer vers:"
//#define MSGDIRECT_COPYMSGPOSTFIX       "copied"
#define MSGDIRECT_COPYMSGPOSTFIX         "copie"
//#define MSGDIRECT_MOVEMSGPOSTFIX       "moved"
#define MSGDIRECT_MOVEMSGPOSTFIX         "deplace"
//#define MSGDIRECT_FILE_POSTFIX_TO_FILE "%s %s nach %s"
#define MSGDIRECT_FILE_POSTFIX_TO_FILE   "%s %s vers %s"
//#define MSGDIRECT_ONEFILE_POSTFIX      "1 file %s"
#define MSGDIRECT_ONEFILE_POSTFIX        "1 fichier %s"
//#define MSGDIRECT_MULTIFILE_POSTFIX    "%d files %s"
#define MSGDIRECT_MULTIFILE_POSTFIX      "%d fichiers %s"
//#define MSGDIRECT_FAILEDMOVEFILE       "ERR: moving %s to %s failed"
#define MSGDIRECT_FAILEDMOVEFILE         "ERR: echec deplacement %s vers %s"
//#define MSGDIRECT_ENTERNEWFILENAME     "Enter New Name for File"
#define MSGDIRECT_ENTERNEWFILENAME       "Entrer nouveau nom de fichier"
//#define MSGDIRECT_CANNOTRENAMEMAIN     "ERR: cannot rename main folder"
#define MSGDIRECT_CANNOTRENAMEMAIN       "ERR: impossible renommer dossier main"
//#define MSGDIRECT_ENTERNEWFOLDERNAME   "Enter New Name for Folder"
#define MSGDIRECT_ENTERNEWFOLDERNAME     "Entrer nouveau nom de dossier"
//#define MSGDIRECT_NEWNAME              "New Name:"
#define MSGDIRECT_NEWNAME                "Nouveau nom:"
//#define MSGDIRECT_INVALIDFILENAME      "ERR: invalid file name"
#define MSGDIRECT_INVALIDFILENAME        "ERR: nom de fichier invalide"
//#define MSGDIRECT_INVALIDFOLDERNAME    "ERR: invalid folder name"
#define MSGDIRECT_INVALIDFOLDERNAME      "ERR: nom de dossier invalide"
//#define MSGDIRECT_FAILEDRENAME         "ERR: renaming %s to %s failed"
#define MSGDIRECT_FAILEDRENAME           "ERR: echec changement de nom %s en %s"
//#define MSGDIRECT_SUCCESSRENAME        "%s renamed to %s"
#define MSGDIRECT_SUCCESSRENAME          "%s renomme en %s"

//-----------------------------------------------------------------------------
// direct messages from menu.c
//-----------------------------------------------------------------------------

const char* infopage[] = {
    //"Active Folder",
    "Dossier actif",
    //"Active File",
    "Fichier actif",
    //"Handle/Address",
    "Ident./Adresse",
    //"Handles free",
    "Ident. libres",
    //"RAM free",
    "Memoire libre",
    //"Archive used",
    "Archive utilisee",
    //"Archive free",
    "Archive libre",
    //"Top of EStack",
    "Sommet pile exp.",
    //"Battery State"
    "Etat batteries"
};

const char *helppage[] = {
    //"[2ND]+[UP]",     "Jump to First Line",
    "[2ND]+[HAUT]",     "Vers premiere ligne",
    //"[2ND]+[DOWN]",   "Jump to Last Line",
    "[2ND]+[BAS]",      "Vers derniere ligne",
    //"[2ND]+[NR]",     "File to Favorite NUMBER",
    "[2ND]+[N]",        "Affecter prog. a favori N",
    //"[\x7F]+[NUMBER]","Start Favorite NUMBER",
    "[\x7F]+[N]",       "Lancer favori N (N=1 a 9)",
    //"[a]-[z]",        "Quick Jump",
    "[a]-[z]",          "Saut rapide",
    //"[BACKSPACE]",    "Delete",
    "[\x15]",           "Effacer",
    NULL};

//#define MSGDIRECT_HELPTITLE        "Help-Page"
#define MSGDIRECT_HELPTITLE          "Aide"
//#define MSGDIRECT_TESTPASSWORD     "Do you know the Password?"
#define MSGDIRECT_TESTPASSWORD       "Entrez le mot de passe courant"
//#define MSGDIRECT_ENTERNEWPASSWORD "Please enter new Password"
#define MSGDIRECT_ENTERNEWPASSWORD   "Entrez le nouveau mot de passe"
//#define MSGDIRECT_PASSWORD         "Password:"
#define MSGDIRECT_PASSWORD           "Mot de passe:"
//#define MSGDIRECT_REENTERPASSWORD  "Please Re-Enter Password"
#define MSGDIRECT_REENTERPASSWORD    "Rentrez le mot de passe"


//-----------------------------------------------------------------------------
// direct messages from loadsave.c
//-----------------------------------------------------------------------------

//#define MSGDIRECT_WARNINGCANNOTSAVE "WARN: can't save tictexco.nfig"
#define MSGDIRECT_WARNINGCANNOTSAVE   "AVIS: impossible de sauver tictexco.nfig"
//#define MSGDIRECT_CLEARALLFAVORITES "0: Clear All Favorites"
#define MSGDIRECT_CLEARALLFAVORITES   "0: Effacer tous les favoris"

//-----------------------------------------------------------------------------
// direct messages from extension.c
//-----------------------------------------------------------------------------

//#define MSGDIRECT_COMMENT_STRING "String"
#define MSGDIRECT_COMMENT_STRING   "Chaine de caracteres"
//#define MSGDIRECT_COMMENT_TEXT   "Text"
#define MSGDIRECT_COMMENT_TEXT     "Texte"
//#define MSGDIRECT_COMMENT_PIC    "Picture"
#define MSGDIRECT_COMMENT_PIC      "Image"
//#define MSGDIRECT_COMMENT_GDB    "Gfx Database"
#define MSGDIRECT_COMMENT_GDB      "Base de donnees GFX"
//#define MSGDIRECT_COMMENT_FIG    "Figure"
#define MSGDIRECT_COMMENT_FIG      "Figure"
//#define MSGDIRECT_COMMENT_MACR   "Macro"
#define MSGDIRECT_COMMENT_MACR     "Macro"
//#define MSGDIRECT_COMMENT_DATA   "Data"
#define MSGDIRECT_COMMENT_DATA     "Donnees"
//#define MSGDIRECT_COMMENT_MAT    "Matrix"
#define MSGDIRECT_COMMENT_MAT      "Matrice"
//#define MSGDIRECT_COMMENT_LIST   "List"
#define MSGDIRECT_COMMENT_LIST     "Liste"
//#define MSGDIRECT_COMMENT_PRGM   "BASIC Program"
#define MSGDIRECT_COMMENT_PRGM     "Programme BASIC"
//#define MSGDIRECT_COMMENT_FUNC   "BASIC Function"
#define MSGDIRECT_COMMENT_FUNC     "Fonction BASIC"
//#define MSGDIRECT_COMMENT_EXE    "NOSTUB Program"
#define MSGDIRECT_COMMENT_EXE      "Programme autonome"
//#define MSGDIRECT_COMMENT_PPG    "NOSTUB Program (exepacked)"
#define MSGDIRECT_COMMENT_PPG      "Programme compresse"
//#define MSGDIRECT_COMMENT_ASM    "kernel-based Program"
#define MSGDIRECT_COMMENT_ASM      "Programme demandant noyau"
//#define MSGDIRECT_COMMENT_LIB    "kernel-based Library"
#define MSGDIRECT_COMMENT_LIB      "Librairie demandant noyau"
//#define MSGDIRECT_COMMENT_EXPR   "unknown Expression"
#define MSGDIRECT_COMMENT_EXPR     "Expression inconnue"
//#define MSGDIRECT_COMMENT_EBOOK  "eBook"
#define MSGDIRECT_COMMENT_EBOOK    "Livre electronique"
//#define MSGDIRECT_COMMENT_ANIM   "Animation"
#define MSGDIRECT_COMMENT_ANIM     "Animation"


//-----------------------------------------------------------------------------
// About dialog message
//-----------------------------------------------------------------------------

//char* about[] = {
//    "A TI-Chess Team Production",
//    "By",
//    "Thomas Nussbaumer",
//    "And",
//    "Marcos Lopez",
//    "VISIT OUR WEBSITE AT",
//    "http://tict.ticalc.org",
//};
const char* about[] = {
    "Une Production TI-Chess Team ",
    "Par",
    "Thomas Nussbaumer",
    "Et",
    "Marcos Lopez",
    "VISITEZ NOTRE SITE WEB A",
    "http://tict.ticalc.org",
};

//-----------------------------------------------------------------------------
// direct messages from battery.c for info box
//-----------------------------------------------------------------------------

//#define MSGDIRECT_BAT_FULL         "6/6 (FULL)"
#define MSGDIRECT_BAT_FULL         "6/6 (PLEINES)"
//#define MSGDIRECT_BAT_OK           "5/6 (OK)"
#define MSGDIRECT_BAT_OK           "5/6 (BON)"
//#define MSGDIRECT_BAT_MEDIUM       "4/6 (MEDIUM)"
#define MSGDIRECT_BAT_MEDIUM       "4/6 (MOYEN)"
//#define MSGDIRECT_BAT_LOW          "3/6 (LOW)"
#define MSGDIRECT_BAT_LOW          "3/6 (BAS)"
//#define MSGDIRECT_BAT_VERYLOW      "2/6 (VERY LOW)"
#define MSGDIRECT_BAT_VERYLOW      "2/6 (TRES BAS)"
//#define MSGDIRECT_BAT_ALMOSTDEAD   "1/6 (ALMOST DEAD)"
#define MSGDIRECT_BAT_ALMOSTDEAD   "1/6 (ASSEZ VIDES)"
//#define MSGDIRECT_BAT_CHANGE       "0/6 (!!CHANGE!!)"
#define MSGDIRECT_BAT_CHANGE       "0/6 (!!CHANGER!!)"
//#define MSGDIRECT_BAT_RESET        "0/6 (*RESET*)"
#define MSGDIRECT_BAT_RESET        "0/6 (*RESET*)"



//-----------------------------------------------------------------------------
// direct messages from menu.c for info box
//-----------------------------------------------------------------------------

//#define MSGDIRECT_NUMFILES         "%s  [%d file(s)]"
#define MSGDIRECT_NUMFILES           "%s  [%d fichier(s)]"
//#define MSGDIRECT_FILESIZE         "%s (%u bytes)"
#define MSGDIRECT_FILESIZE           "%s (%u octets)"
//#define MSGDIRECT_FILELOCKED       "locked"
#define MSGDIRECT_FILELOCKED         "verr."
//#define MSGDIRECT_FILEMOVABLE      "movable"
#define MSGDIRECT_FILEMOVABLE        "mobile"
//#define MSGDIRECT_MEMSIZE          "%lu bytes"
#define MSGDIRECT_MEMSIZE            "%lu octets"


#endif

//=============================================================================
// Revision History
//=============================================================================
//
// $Log: msg_french.c,v $
// Revision 1.6  2002/09/10 11:28:42  tnussb
// changes up to v1.30 Beta 4 / examine history.txt for details
//
// Revision 1.5  2002/02/21 09:12:19  tnussb
// translations for new battery support added
//
// Revision 1.4  2002/02/07 18:01:18  tnussb
// generic commit
//
// Revision 1.3  2001/02/10 10:28:40  Thomas Nussbaumer
// generic commit
//
// Revision 1.2  2001/02/05 21:35:46  Thomas Nussbaumer
// slightly modified
//
// Revision 1.1  2001/02/04 12:37:23  Thomas Nussbaumer
// initial version
//
//
