/******************************************************************************
*
* project name:  TICT-Explorer
* file name:     msg_english.c
* initial date:  30/01/2001
* author:        thomas.nussbaumer@gmx.net
*
* description:   defines for english version of messages
*
* $Id: msg_english.c,v 1.6 2002/09/23 09:37:39 tnussb Exp $
*
******************************************************************************/

#include "interface.h"

#define MSG_OKAY                   0
#define MSG_PRGTITLE               1
#define MSG_ERR_CRASHOFFSET        2

#define MSG_ERR_WRONGVERSION      18
#define MSG_ERR_OUTOFMEM          19
#define MSG_ERR_LOCKINGFAILED     20
#define MSG_ERR_PPGINVALID        21
#define MSG_ERR_EXECFAILED        22
#define MSG_ERR_NOFOLDERS         23
#define MSG_ERR_FILEINUSE         24
#define MSG_ERR_FILENOTFOUND      25
#define MSG_ERR_INVALIDEXPLLIB    26
#define MSG_ERR_EXPLLIBNOTFOUND   27
#define MSG_ERR_TWINFAILED        28
#define MSG_ERR_TWINDEL           29

#if defined(MSGS_EXPLORER)
#define MSG_ERR_EBOOKNOTFOUND      30
#define MSG_ERR_QUILLNOTFOUND      31
#define MSG_ERR_SCOTTNOTFOUND      32
#define MSG_ERR_PVVIEWNOTFOUND     33
#define MSG_ERR_PRGNOTALLOWED      34
#else
#define MSG_ERR_FINDMYSELF         30
#endif


const unsigned char* explorer_msgs[] = {
/*  0 */    NULL,                    // NOT USED
/*  1 */    TICTEX_VERSION_STRING,
/*  2 */    "Address-Error",         // MSG_ERR_CRASHOFFSET ...
/*  3 */    "Illegal-Instruction",
/*  4 */    "Divide-By-Zero",
/*  5 */    "CHK-Instruction",
/*  6 */    "TRAPV-Instruction",
/*  7 */    "Trace",
/*  8 */    "Privilege-Violation",
/*  9 */    "Line-1111-Emulator",
/* 10 */    "Spurious-Interrupt",
/* 11 */    "Memory-Violation",
/* 12 */    "Trap-5",
/* 13 */    "Trap-6",
/* 14 */    "Trap-7",
/* 15 */    "Trap-13",
/* 16 */    "Trap-14",
/* 17 */    "Trap-15",
/* 18 */    "version number missmatch",
/* 19 */    "out of memory",
/* 20 */    "locking variable failed",
/* 21 */    "no valid ppg file",
/* 22 */    "execution failed",
/* 23 */    "no folders found",
/* 24 */    "file currently in use",
/* 25 */    "file not found",
/* 26 */    "invalid tictexpl.LIB",
/* 27 */    "tictexpl.LIB not found",
/* 28 */    "creating TWIN symbol failed",
/* 29 */    "cannot delete TWIN symbol",

#if defined(MSGS_EXPLORER)
/* 30 */    "viewer ebook.EXE not found",
/* 31 */    "viewer quill.EXE not found",
/* 32 */    "viewer scottpck.ppg not found",
/* 33 */    "viewer tictexpv.EXE not found",
/* 34 */    "file not allowed for execution"
#else
/* 30 */    "cannot find myself"
#endif
};


char msg_buf[80] = {};
const char* GetMsg(short idx) {
    if (idx == 0)    return NULL;
    else if (idx==1) return explorer_msgs[1];

    if (idx < 18) {
        sprintf(msg_buf,"FATAL: %s",explorer_msgs[idx]);
    }
    else {
        sprintf(msg_buf,"ERR: %s",explorer_msgs[idx]);
    }
    return msg_buf;
}

#if defined(MSGS_EXPLORER)

//-----------------------------------------------------------------------------
// direct messages from tictexpl.c
//-----------------------------------------------------------------------------

#define MSGDIRECT_INTERFACENOTFOUND "ERR: interface not found [press key]"
#define MSGDIRECT_SETPASSWDFAILED   "ERR: set password failed [press key]"
#define MSGDIRECT_SETPASSWDFAILED2  "ERR: set password failed"
#define MSGDIRECT_SHORTCUTSET       "shortcut \x7F%d set to %s\\%s"
#define MSGDIRECT_SETPASSWDFIRST    "ERR: set password first"
#define MSGDIRECT_WRONGPASSWD       "ERR: wrong password"
#define MSGDIRECT_EXCEPTIONCAUGHT   "ERR: exception caught"
#define MSGDIRECT_CANNOTSELECTUSED  "can't select files in use"
#define MSGDIRECT_NOFILES           "no files"
#define MSGDIRECT_ONEFILE           "1 file"
#define MSGDIRECT_MOREFILES         "%d files"
#define MSGDIRECT_AVAILRAM          "%lu bytes RAM free"
#define MSGDIRECT_HEADER            "F1 File   F2 Favorites   F3 Arch.  F4 Sel.  F5 Info"

const char* f1_entries[] = {
    "1:Delete File(s)  \x15",
    "2:Copy File(s)",
    "3:Rename File",
    "4:Move File(s)",
    "5:Create Folder",
    "6:View File (HEX)",
    "7:Lock/Unlock File(s)",
    "8:Change Password",
    "9:Lock Calculator",
    "0:Help",
    "   About ....",
    NULL};

//-----------------------------------------------------------------------------
// direct messages from file.c
//-----------------------------------------------------------------------------

#define MSGDIRECT_PLEASESELECT         "Please select or highlight a file"
#define MSGDIRECT_PROCESSARCHIVE       "process (un)archiving ..."
#define MSGDIRECT_PROCESSLOCKING       "process (un)locking ..."
#define MSGDIRECT_CURRENTINUSE         "ERR: %s is currently in use"
#define MSGDIRECT_LOCKEDORARCHIVED     "ERR: file %s is locked or archived"
#define MSGDIRECT_UNARCHIVEFAILED      "ERR: unarchiving failed"
#define MSGDIRECT_ARCHIVEFAILED        "ERR: archiving failed"
#define MSGDIRECT_NOFILEPROCESSED      "NO files processed"
#define MSGDIRECT_ONEFILEPROCESSED     "1 file processed"
#define MSGDIRECT_MULTIFILEPROCESSED   "%d files processed"
#define MSGDIRECT_ENTERFOLDERTOCREATE  "Enter Folder Name to Create"
#define MSGDIRECT_FOLDERNAME           "Foldername:"
#define MSGDIRECT_STARTWITHLETTER      "ERR: folders MUST start with a letter"
#define MSGDIRECT_FOLDEREXISTS         "ERR: folder already exists"
#define MSGDIRECT_FOLDERCREATIONFAILED "ERR: folder creation failed"
#define MSGDIRECT_FOLDERSUCCESS        "Folder %s successfully created"
#define MSGDIRECT_FOLDERNOTFOUND       "ERR: cannot find folder %s"
#define MSGDIRECT_FOLDERNOTEMPTY       "ERR: cannot delete non-empty folder"
#define MSGDIRECT_CANNOTDELETEMAIN     "ERR: cannot delete main folder"
#define MSGDIRECT_REQUEST              "Request"
#define MSGDIRECT_SURETODELETEFOLDER   "Sure to Delete Active Folder?"
#define MSGDIRECT_SUCCESSDELFOLDER     "folder %s deleted"
#define MSGDIRECT_FAILEDDELFOLDER      "deleting folder %s failed"
#define MSGDIRECT_SUREDELACTIVE        "Sure to Delete Active File?"
#define MSGDIRECT_SUREDELMARKED        "Sure to Delete Marked Files?"
#define MSGDIRECT_FAILEDDELFILE        "ERR: deleting %s failed"
#define MSGDIRECT_SUCESSDELFILE        "file %s deleted"
#define MSGDIRECT_SUCESSDELONEFILE     "1 file deleted"
#define MSGDIRECT_SUCESSDELMULTIFILE   "%d files deleted"
#define MSGDIRECT_FILENAMEEXISTS       "ERR: %s already exists"
#define MSGDIRECT_CANNOTOPENFILE       "ERR: cannot open %s"
#define MSGDIRECT_CANNOTCREATEFILE     "ERR: cannot create %s"
#define MSGDIRECT_SELECTDESTINATION    "Select Destination Folder"
#define MSGDIRECT_COPYTO               "Copy To:"
#define MSGDIRECT_MOVETO               "Move To:"
#define MSGDIRECT_COPYMSGPOSTFIX       "copied"
#define MSGDIRECT_MOVEMSGPOSTFIX       "moved"
#define MSGDIRECT_FILE_POSTFIX_TO_FILE "%s %s to %s"
#define MSGDIRECT_ONEFILE_POSTFIX      "1 file %s"
#define MSGDIRECT_MULTIFILE_POSTFIX    "%d files %s"
#define MSGDIRECT_FAILEDMOVEFILE       "ERR: moving %s to %s failed"
#define MSGDIRECT_ENTERNEWFILENAME     "Enter New Name for File"
#define MSGDIRECT_CANNOTRENAMEMAIN     "ERR: cannot rename main folder"
#define MSGDIRECT_ENTERNEWFOLDERNAME   "Enter New Name for Folder"
#define MSGDIRECT_NEWNAME              "New Name:"
#define MSGDIRECT_INVALIDFILENAME      "ERR: invalid file name"
#define MSGDIRECT_INVALIDFOLDERNAME    "ERR: invalid folder name"
#define MSGDIRECT_FAILEDRENAME         "ERR: renaming %s to %s failed"
#define MSGDIRECT_SUCCESSRENAME        "%s renamed to %s"

//-----------------------------------------------------------------------------
// direct messages from menu.c
//-----------------------------------------------------------------------------

const char* infopage[] = {
    "Active Folder",
    "Active File",
    "Handle/Address",
    "Handles free",
    "RAM free",
    "Archive used",
    "Archive free",
    "Top of EStack",
    "Battery State"
};

const char *helppage[] = {
    "[2ND]+[UP]",     "Jump to First Line",
    "[2ND]+[DOWN]",   "Jump to Last Line",
    "[2ND]+[NR]",     "File to Favorite NUMBER",
    "[\x7F]+[NUMBER]","Start Favorite NUMBER",
    "[a]-[z]",       "Quick Jump",
    "[BACKSPACE]",   "Delete",
    NULL};

#define MSGDIRECT_HELPTITLE        "Help-Page"
#define MSGDIRECT_TESTPASSWORD     "Do you know the Password?"
#define MSGDIRECT_ENTERNEWPASSWORD "Please enter new Password"
#define MSGDIRECT_PASSWORD         "Password:"
#define MSGDIRECT_REENTERPASSWORD  "Please Re-Enter Password"


//-----------------------------------------------------------------------------
// direct messages from loadsave.c
//-----------------------------------------------------------------------------

#define MSGDIRECT_WARNINGCANNOTSAVE "WARN: can't save tictexco.nfig"
#define MSGDIRECT_CLEARALLFAVORITES "0: Clear All Favorites"

//-----------------------------------------------------------------------------
// direct messages from extension.c
//-----------------------------------------------------------------------------

#define MSGDIRECT_COMMENT_STRING "String"
#define MSGDIRECT_COMMENT_TEXT   "Text"
#define MSGDIRECT_COMMENT_PIC    "Picture"
#define MSGDIRECT_COMMENT_GDB    "Gfx Database"
#define MSGDIRECT_COMMENT_FIG    "Figure"
#define MSGDIRECT_COMMENT_MACR   "Macro"
#define MSGDIRECT_COMMENT_DATA   "Data"
#define MSGDIRECT_COMMENT_MAT    "Matrix"
#define MSGDIRECT_COMMENT_LIST   "List"
#define MSGDIRECT_COMMENT_PRGM   "BASIC Program"
#define MSGDIRECT_COMMENT_FUNC   "BASIC Function"
#define MSGDIRECT_COMMENT_EXE    "NOSTUB Program"
#define MSGDIRECT_COMMENT_PPG    "Program (exepacked)"
#define MSGDIRECT_COMMENT_ASM    "KERNEL Program"
#define MSGDIRECT_COMMENT_LIB    "KERNEL Library"
#define MSGDIRECT_COMMENT_EXPR   "unknown Expression"
#define MSGDIRECT_COMMENT_EBOOK  "eBook"
#define MSGDIRECT_COMMENT_ANIM   "Animation"


//-----------------------------------------------------------------------------
// About dialog message
//-----------------------------------------------------------------------------
const char* about[] = {
    "A TI-Chess Team Production",
    "By",
    "Thomas Nussbaumer",
    "And",
    "Marcos Lopez",
    "VISIT OUR WEBSITE AT",
    "http://tict.ticalc.org",
};

//-----------------------------------------------------------------------------
// direct messages from battery.c for info box
//-----------------------------------------------------------------------------
#define MSGDIRECT_BAT_FULL         "(6/6 FULL)"
#define MSGDIRECT_BAT_OK           "(5/6 OK)"
#define MSGDIRECT_BAT_MEDIUM       "(4/6 MEDIUM)"
#define MSGDIRECT_BAT_LOW          "(3/6 LOW)"
#define MSGDIRECT_BAT_VERYLOW      "(2/6 VERY LOW)"
#define MSGDIRECT_BAT_ALMOSTDEAD   "(1/6 ALMOST DEAD)"
#define MSGDIRECT_BAT_CHANGE       "(0/6 !!CHANGE!!)"
#define MSGDIRECT_BAT_RESET        "(0/6 *RESET*)"

//-----------------------------------------------------------------------------
// direct messages from menu.c for info box
//-----------------------------------------------------------------------------

#define MSGDIRECT_NUMFILES         "%s  [%d file(s)]"
#define MSGDIRECT_FILESIZE         "%s (%u bytes)"
#define MSGDIRECT_FILELOCKED       "locked"
#define MSGDIRECT_FILEMOVABLE      "movable"
#define MSGDIRECT_MEMSIZE          "%lu bytes"

#endif



//=============================================================================
// Revision History
//=============================================================================
//
// $Log: msg_english.c,v $
// Revision 1.6  2002/09/23 09:37:39  tnussb
// generic commit (see history.txt: changes up to v1.30 Beta 7)
//
// Revision 1.5  2002/09/10 11:28:42  tnussb
// changes up to v1.30 Beta 4 / examine history.txt for details
//
// Revision 1.4  2002/02/21 09:12:19  tnussb
// translations for new battery support added
//
// Revision 1.3  2002/02/07 18:01:18  tnussb
// generic commit
//
// Revision 1.2  2001/02/10 10:28:40  Thomas Nussbaumer
// generic commit
//
// Revision 1.1  2001/02/04 12:37:23  Thomas Nussbaumer
// initial version
//
//
