/******************************************************************************
*
* project name:  TICT-Explorer
* file name:     msg_deutsch.c
* initial date:  30/01/2001
* author:        thomas.nussbaumer@gmx.net
*
* description:   defines for german version of messages
*
* $Id: msg_deutsch.c,v 1.7 2002/09/23 09:37:38 tnussb Exp $
*
******************************************************************************/

#include "interface.h"

#define MSG_OKAY                   0
#define MSG_PRGTITLE               1
#define MSG_ERR_CRASHOFFSET        2

#define MSG_ERR_WRONGVERSION      18
#define MSG_ERR_OUTOFMEM          19
#define MSG_ERR_LOCKINGFAILED     20
#define MSG_ERR_PPGINVALID        21
#define MSG_ERR_EXECFAILED        22
#define MSG_ERR_NOFOLDERS         23
#define MSG_ERR_FILEINUSE         24
#define MSG_ERR_FILENOTFOUND      25
#define MSG_ERR_INVALIDEXPLLIB    26
#define MSG_ERR_EXPLLIBNOTFOUND   27
#define MSG_ERR_TWINFAILED        28
#define MSG_ERR_TWINDEL           29

#if defined(MSGS_EXPLORER)
#define MSG_ERR_EBOOKNOTFOUND      30
#define MSG_ERR_QUILLNOTFOUND      31
#define MSG_ERR_SCOTTNOTFOUND      32
#define MSG_ERR_PVVIEWNOTFOUND     33
#define MSG_ERR_PRGNOTALLOWED      34
#else
#define MSG_ERR_FINDMYSELF         30
#endif

//-----------------------------------------------------------------------------
// common ERROR and FATAL messages
//-----------------------------------------------------------------------------
const unsigned char* explorer_msgs[] = {
/*  0 */    NULL,                    // NOT USED
/*  1 */    TICTEX_VERSION_STRING,
/*  2 */  //"Address-Error",
            "Adress-Fehler",         // MSG_ERR_CRASHOFFSET ...
/*  3 */  //"Illegal-Instruction",
            "Illegale Instruktion",
/*  4 */  //"Divide-By-Zero",
            "Division durch 0",
/*  5 */  //"CHK-Instruction",
            "CHK-Instruktion",
/*  6 */  //"TRAPV-Instruction",
            "TRAPV-Instruktion",
/*  7 */  //"Trace",
            "Trace-Flag gesetzt",
/*  8 */  //"Privilege-Violation",
            "Rechte-Verletzung",
/*  9 */  //"Line-1111-Emulator",
            "Line-1111-Emulator",
/* 10 */  //"Spurious-Interrupt",
            "Fehlerhafter Interrupt",
/* 11 */  //"Memory-Violation",
            "Speicher-Verletzung",
/* 12 */  //"Trap-5",
            "Trap-5",
/* 13 */  //"Trap-6",
            "Trap-6",
/* 14 */  //"Trap-7",
            "Trap-7",
/* 15 */  //"Trap-13",
            "Trap-13",
/* 16 */  //"Trap-14",
            "Trap-14",
/* 17 */  //"Trap-15",
            "Trap-15",
/* 18 */  //"version number missmatch",
            "falsche Versionsnummer",
/* 19 */  //"out of memory",
            "zu wenig Speicher frei",
/* 20 */  //"locking variable failed",
            "kann Variable nicht oeffnen",
/* 21 */  //"no valid ppg file",
            "keine gueltige ppg-Datei",
/* 22 */  //"execution failed",
            "Ausfuehrung gescheitert",
/* 23 */  //"no folders found",
            "Keine Ordner gefunden",
/* 24 */  //"file currently in use",
            "Datei in Verwendung",
/* 25 */  //"file not found",
            "Datei nicht gefunden",
/* 26 */  //"invalid tictexpl.LIB",
            "ungueltige Datei tictexpl.LIB",
/* 27 */  //"tictexpl.LIB not found",
            "tictexpl.LIB nicht gefunden",
/* 28 */  //"creating TWIN symbol failed",
            "Erzeugung von TWIN-Symbol gescheitert",
/* 29 */  //"cannot delete TWIN symbol",
            "Loeschen von TWIN-Symbol gescheitert",

#if defined(MSGS_EXPLORER)
/* 30 */  //"viewer ebook.EXE not found",
            "Viewer ebook.EXE nicht gefunden",
/* 31 */  //"viewer quill.EXE not found",
            "Viewer quill.EXE nicht gefunden",
/* 32 */  //"viewer scottpck.ppg not found",
            "Viewer scottpck.ppg nicht gefunden",
/* 33 */  //"viewer tictexpv.EXE not found",
            "Viewer tictexpv.EXE nicht gefunden",
/* 34 */  //"file not allowed for execution",
            "Ausfuehrung dieser Datei verweigert"
#else
/* 30 */  //"cannot find myself"
            "kann mich selbst nicht finden"
#endif
};


char msg_buf[80] = {};
const char* GetMsg(short idx) {
    if (idx == 0)    return NULL;
    else if (idx==1) return explorer_msgs[1];

    if (idx < 18) {
        sprintf(msg_buf,"FATAL: %s",explorer_msgs[idx]);
    }
    else {
        sprintf(msg_buf,"ERR: %s",explorer_msgs[idx]);
    }
    return msg_buf;
}

#if defined(MSGS_EXPLORER)

//-----------------------------------------------------------------------------
// direct messages from tictexpl.c
//-----------------------------------------------------------------------------

//#define MSGDIRECT_INTERFACENOTFOUND "ERR: interface not found [press key]"
#define MSGDIRECT_INTERFACENOTFOUND   "ERR: Start gescheitert [press key]"
//#define MSGDIRECT_SETPASSWDFAILED   "ERR: set password failed [press key]"
#define MSGDIRECT_SETPASSWDFAILED     "ERR: ungueltige Eingabe [Taste druecken]"
//#define MSGDIRECT_SETPASSWDFAILED2  "ERR: set password failed"
#define MSGDIRECT_SETPASSWDFAILED2    "ERR: ungueltige Eingabe"
//#define MSGDIRECT_SHORTCUTSET       "shortcut \x7F%d set to %s\\%s"
#define MSGDIRECT_SHORTCUTSET         "Shortcut \x7F%d auf %s\\%s gesetzt"
//#define MSGDIRECT_SETPASSWDFIRST    "ERR: set password first"
#define MSGDIRECT_SETPASSWDFIRST      "ERR: Kein Passwort festgelegt"
//#define MSGDIRECT_WRONGPASSWD       "ERR: wrong password"
#define MSGDIRECT_WRONGPASSWD         "ERR: ungueltiges Passwort"
//#define MSGDIRECT_EXCEPTIONCAUGHT   "ERR: exception caught"
#define MSGDIRECT_EXCEPTIONCAUGHT     "ERR: Ausfuehrung gescheitert"
//#define MSGDIRECT_CANNOTSELECTUSED  "can't select files in use"
#define MSGDIRECT_CANNOTSELECTUSED    "kann offene Dateien nicht selektieren"
//#define MSGDIRECT_NOFILES           "no files"
#define MSGDIRECT_NOFILES             "keine Dateien"
//#define MSGDIRECT_ONEFILE           "1 file"
#define MSGDIRECT_ONEFILE             "1 Datei"
//#define MSGDIRECT_MOREFILES         "%d files"
#define MSGDIRECT_MOREFILES           "%d Dateien"
//#define MSGDIRECT_AVAILRAM          "%lu bytes RAM free"
#define MSGDIRECT_AVAILRAM            "%lu Bytes RAM frei"
//#define MSGDIRECT_HEADER            "F1 File   F2 Favorites   F3 Arch.  F4 Sel.  F5 Info"
#define MSGDIRECT_HEADER              "F1 Datei  F2 Favoriten   F3 Arch  F4 Sel  F5 Info"

const char* f1_entries[] = {
    //"1:Delete File(s)  \x15",
    "1:Loeschen  \x15",
    //"2:Copy File(s)",
    "2:Kopieren",
    //"3:Rename File",
    "3:Umbenennen",
    //"4:Move File(s)",
    "4:Verschieben",
    //"5:Create Folder",
    "5:Ordner erstellen",
    //"6:View File (HEX)",
    "6:Betrachten (HEX)",
    //"7:Lock/Unlock File(s)",
    "7:(Ent-)Sperren",
    //"8:Change Password",
    "8:Passwort aendern",
    //"9:Lock Calculator",
    "9:Rechner sperren",
    //"0:Help",
    "0:Hilfe",
    //"   About ....",
    "   Ueber ....",
    NULL};

//-----------------------------------------------------------------------------
// direct messages from file.c
//-----------------------------------------------------------------------------

//#define MSGDIRECT_PLEASESELECT         "Please select or highlight a file"
#define MSGDIRECT_PLEASESELECT           "Keine Datei selektiert oder markiert"
//#define MSGDIRECT_PROCESSARCHIVE       "process (un)archiving ..."
#define MSGDIRECT_PROCESSARCHIVE         "bearbeite (De-)Archivierung ..."
//#define MSGDIRECT_PROCESSLOCKING       "process (un)locking ..."
#define MSGDIRECT_PROCESSLOCKING         "bearbeite (Ent-)Sperren ..."
//#define MSGDIRECT_CURRENTINUSE         "ERR: %s is currently in use"
#define MSGDIRECT_CURRENTINUSE           "ERR: %s in Verwendung"
//#define MSGDIRECT_LOCKEDORARCHIVED     "ERR: file %s is locked or archived"
#define MSGDIRECT_LOCKEDORARCHIVED       "ERR: Datei %s gesperrt oder archiviert"
//#define MSGDIRECT_UNARCHIVEFAILED      "ERR: unarchiving failed"
#define MSGDIRECT_UNARCHIVEFAILED        "ERR: De-Archivierung fehlgeschlagen"
//#define MSGDIRECT_ARCHIVEFAILED        "ERR: archiving failed"
#define MSGDIRECT_ARCHIVEFAILED          "ERR: Archivierung fehlgeschlagen"
//#define MSGDIRECT_NOFILEPROCESSED      "NO files processed"
#define MSGDIRECT_NOFILEPROCESSED        "Keine Datei bearbeitet"
//#define MSGDIRECT_ONEFILEPROCESSED     "1 file processed"
#define MSGDIRECT_ONEFILEPROCESSED       "1 Datei bearbeitet"
//#define MSGDIRECT_MULTIFILEPROCESSED   "%d files processed"
#define MSGDIRECT_MULTIFILEPROCESSED     "%d Dateien bearbeitet"
//#define MSGDIRECT_ENTERFOLDERTOCREATE  "Enter Folder Name to Create"
#define MSGDIRECT_ENTERFOLDERTOCREATE    "Bitte Ordnernamen eingeben"
//#define MSGDIRECT_FOLDERNAME           "Foldername:"
#define MSGDIRECT_FOLDERNAME             "Ordnername:"
//#define MSGDIRECT_STARTWITHLETTER      "ERR: folders MUST start with a letter"
#define MSGDIRECT_STARTWITHLETTER        "ERR: ungueltiger Ordnername"
//#define MSGDIRECT_FOLDEREXISTS         "ERR: folder already exists"
#define MSGDIRECT_FOLDEREXISTS           "ERR: Ordner existiert bereits"
//#define MSGDIRECT_FOLDERCREATIONFAILED "ERR: folder creation failed"
#define MSGDIRECT_FOLDERCREATIONFAILED   "ERR: Kann Ordner nicht erzeugen"
//#define MSGDIRECT_FOLDERSUCCESS        "Folder %s successfully created"
#define MSGDIRECT_FOLDERSUCCESS          "Ordner %s erfolgreich erzeugt"
//#define MSGDIRECT_FOLDERNOTFOUND       "ERR: cannot find folder %s"
#define MSGDIRECT_FOLDERNOTFOUND         "ERR: Ordner %s nicht gefunden"
//#define MSGDIRECT_FOLDERNOTEMPTY       "ERR: cannot delete non-empty folder"
#define MSGDIRECT_FOLDERNOTEMPTY         "ERR: Ordner nicht leer"
//#define MSGDIRECT_CANNOTDELETEMAIN     "ERR: cannot delete main folder"
#define MSGDIRECT_CANNOTDELETEMAIN       "ERR: Kann Ordner main nicht loeschen"
//#define MSGDIRECT_REQUEST              "Request"
#define MSGDIRECT_REQUEST                "Sicherheitsabfrage"
//#define MSGDIRECT_SURETODELETEFOLDER   "Sure to Delete Active Folder?"
#define MSGDIRECT_SURETODELETEFOLDER     "Aktiven Ordner loeschen?"
//#define MSGDIRECT_SUCCESSDELFOLDER     "folder %s deleted"
#define MSGDIRECT_SUCCESSDELFOLDER       "Ordner %s geloescht"
//#define MSGDIRECT_FAILEDDELFOLDER      "deleting folder %s failed"
#define MSGDIRECT_FAILEDDELFOLDER        "Loeschen des Ordners %s fehlgeschlagen"
//#define MSGDIRECT_SUREDELACTIVE        "Sure to Delete Active File?"
#define MSGDIRECT_SUREDELACTIVE          "Aktive Datei loeschen?"
//#define MSGDIRECT_SUREDELMARKED        "Sure to Delete Marked Files?"
#define MSGDIRECT_SUREDELMARKED          "Markierte Dateien loeschen?"
//#define MSGDIRECT_FAILEDDELFILE        "ERR: deleting %s failed"
#define MSGDIRECT_FAILEDDELFILE          "ERR: Loeschen von %s fehlgeschlagen"
//#define MSGDIRECT_SUCESSDELFILE        "file %s deleted"
#define MSGDIRECT_SUCESSDELFILE          "Datei %s geloescht"
//#define MSGDIRECT_SUCESSDELONEFILE     "1 file deleted"
#define MSGDIRECT_SUCESSDELONEFILE       "1 Datei geloescht"
//#define MSGDIRECT_SUCESSDELMULTIFILE   "%d files deleted"
#define MSGDIRECT_SUCESSDELMULTIFILE     "%d Dateien geloescht"
//#define MSGDIRECT_FILENAMEEXISTS       "ERR: %s already exists"
#define MSGDIRECT_FILENAMEEXISTS         "ERR: %s existiert bereits"
//#define MSGDIRECT_CANNOTOPENFILE       "ERR: cannot open %s"
#define MSGDIRECT_CANNOTOPENFILE         "ERR: kann %s nicht oeffnen"
//#define MSGDIRECT_CANNOTCREATEFILE     "ERR: cannot create %s"
#define MSGDIRECT_CANNOTCREATEFILE       "ERR: kann %s nicht erzeugen"
//#define MSGDIRECT_SELECTDESTINATION    "Select Destination Folder"
#define MSGDIRECT_SELECTDESTINATION      "Ziel-Ordner auswaehlen"
//#define MSGDIRECT_COPYTO               "Copy To:"
#define MSGDIRECT_COPYTO                 "Kopieren nach:"
//#define MSGDIRECT_MOVETO               "Move To:"
#define MSGDIRECT_MOVETO                 "Verschieben nach:"
//#define MSGDIRECT_COPYMSGPOSTFIX       "copied"
#define MSGDIRECT_COPYMSGPOSTFIX         "kopiert"
//#define MSGDIRECT_MOVEMSGPOSTFIX       "moved"
#define MSGDIRECT_MOVEMSGPOSTFIX         "verschoben"
//#define MSGDIRECT_FILE_POSTFIX_TO_FILE "%s %s nach %s"
#define MSGDIRECT_FILE_POSTFIX_TO_FILE   "%s %s nach %s"
//#define MSGDIRECT_ONEFILE_POSTFIX      "1 file %s"
#define MSGDIRECT_ONEFILE_POSTFIX        "1 Datei %s"
//#define MSGDIRECT_MULTIFILE_POSTFIX    "%d files %s"
#define MSGDIRECT_MULTIFILE_POSTFIX      "%d Dateien %s"
//#define MSGDIRECT_FAILEDMOVEFILE       "ERR: moving %s to %s failed"
#define MSGDIRECT_FAILEDMOVEFILE         "ERR: Verschieben von %s fehlgeschlagen"
//#define MSGDIRECT_ENTERNEWFILENAME     "Enter New Name for File"
#define MSGDIRECT_ENTERNEWFILENAME       "Neuen Dateinamen eingeben"
//#define MSGDIRECT_CANNOTRENAMEMAIN     "ERR: cannot rename main folder"
#define MSGDIRECT_CANNOTRENAMEMAIN       "ERR: Main kann nicht umbenannt werden"
//#define MSGDIRECT_ENTERNEWFOLDERNAME   "Enter New Name for Folder"
#define MSGDIRECT_ENTERNEWFOLDERNAME     "Neuen Ordnernamen eingeben"
//#define MSGDIRECT_NEWNAME              "New Name:"
#define MSGDIRECT_NEWNAME                "Neuer Name:"
//#define MSGDIRECT_INVALIDFILENAME      "ERR: invalid file name"
#define MSGDIRECT_INVALIDFILENAME        "ERR: ungueltiger Dateiname"
//#define MSGDIRECT_INVALIDFOLDERNAME    "ERR: invalid folder name"
#define MSGDIRECT_INVALIDFOLDERNAME      "ERR: ungueltiger Ordnername"
//#define MSGDIRECT_FAILEDRENAME         "ERR: renaming %s to %s failed"
#define MSGDIRECT_FAILEDRENAME           "ERR: Umbenennen von %s fehlgeschlagen"
//#define MSGDIRECT_SUCCESSRENAME        "%s renamed to %s"
#define MSGDIRECT_SUCCESSRENAME          "%s umbenannt in %s"

//-----------------------------------------------------------------------------
// direct messages from menu.c
//-----------------------------------------------------------------------------

const char* infopage[] = {
    //"Active Folder",
    "Aktiver Ordner",
    //"Active File",
    "Aktive Datei",
    //"Handle/Address",
    "Handle/Adresse",
    //"Handles free",
    "Handles frei",
    //"RAM free",
    "RAM frei",
    //"Archive used",
    "Archiv benutzt",
    //"Archive free",
    "Archiv frei",
    //"Top of EStack",
    "Top of EStack",
    //"Battery State"
    "Batterie-Status"
};

const char *helppage[] = {
    //"[2ND]+[UP]",     "Jump to First Line",
    "[2ND]+[UP]",       "Zur ersten Zeile",
    //"[2ND]+[DOWN]",   "Jump to Last Line",
    "[2ND]+[DOWN]",     "Zur letzten Zeile",
    //"[2ND]+[NR]",     "File to Favorite NUMBER",
    "[2ND]+[NR]",       "Datei als Favorit NUMBER",
    //"[\x7F]+[NUMBER]","Start Favorite NUMBER",
    "[\x7F]+[NUMBER]",  "Starte Favoriten NUMBER",
    //"[a]-[z]",        "Quick Jump",
    "[a]-[z]",          "Quick Jump",
    //"[BACKSPACE]",    "Delete",
    "[BACKSPACE]",      "Loeschen",
    NULL};

//#define MSGDIRECT_HELPTITLE        "Help-Page"
#define MSGDIRECT_HELPTITLE          "Hilfe"
//#define MSGDIRECT_TESTPASSWORD     "Do you know the Password?"
#define MSGDIRECT_TESTPASSWORD       "Wie lautet das Passwort?"
//#define MSGDIRECT_ENTERNEWPASSWORD "Please enter new Password"
#define MSGDIRECT_ENTERNEWPASSWORD   "Bitte neues Passwort eingeben"
//#define MSGDIRECT_PASSWORD         "Password:"
#define MSGDIRECT_PASSWORD           "Passwort:"
//#define MSGDIRECT_REENTERPASSWORD  "Please Re-Enter Password"
#define MSGDIRECT_REENTERPASSWORD    "Bitte Passwort wiederholen"


//-----------------------------------------------------------------------------
// direct messages from loadsave.c
//-----------------------------------------------------------------------------

//#define MSGDIRECT_WARNINGCANNOTSAVE "WARN: can't save tictexco.nfig"
#define MSGDIRECT_WARNINGCANNOTSAVE   "WARN: tictexco.nfig nicht speicherbar"
//#define MSGDIRECT_CLEARALLFAVORITES "0: Clear All Favorites"
#define MSGDIRECT_CLEARALLFAVORITES   "0: Loesche alle Favoriten"

//-----------------------------------------------------------------------------
// direct messages from extension.c
//-----------------------------------------------------------------------------

//#define MSGDIRECT_COMMENT_STRING "String"
#define MSGDIRECT_COMMENT_STRING   "String"
//#define MSGDIRECT_COMMENT_TEXT   "Text"
#define MSGDIRECT_COMMENT_TEXT     "Text"
//#define MSGDIRECT_COMMENT_PIC    "Picture"
#define MSGDIRECT_COMMENT_PIC      "Bild"
//#define MSGDIRECT_COMMENT_GDB    "Gfx Database"
#define MSGDIRECT_COMMENT_GDB      "Gfx Databank"
//#define MSGDIRECT_COMMENT_FIG    "Figure"
#define MSGDIRECT_COMMENT_FIG      "Zeichnung"
//#define MSGDIRECT_COMMENT_MACR   "Macro"
#define MSGDIRECT_COMMENT_MACR     "Makro"
//#define MSGDIRECT_COMMENT_DATA   "Data"
#define MSGDIRECT_COMMENT_DATA     "Data"
//#define MSGDIRECT_COMMENT_MAT    "Matrix"
#define MSGDIRECT_COMMENT_MAT      "Matrix"
//#define MSGDIRECT_COMMENT_LIST   "List"
#define MSGDIRECT_COMMENT_LIST     "Liste"
//#define MSGDIRECT_COMMENT_PRGM   "BASIC Program"
#define MSGDIRECT_COMMENT_PRGM     "BASIC Programm"
//#define MSGDIRECT_COMMENT_FUNC   "BASIC Function"
#define MSGDIRECT_COMMENT_FUNC     "BASIC Funktion"
//#define MSGDIRECT_COMMENT_EXE    "NOSTUB Program"
#define MSGDIRECT_COMMENT_EXE      "NOSTUB Programm"
//#define MSGDIRECT_COMMENT_PPG    "NOSTUB Program (exepacked)"
#define MSGDIRECT_COMMENT_PPG      "Programm (kompr.)"
//#define MSGDIRECT_COMMENT_ASM    "kernel-based Program"
#define MSGDIRECT_COMMENT_ASM      "KERNEL Programm"
//#define MSGDIRECT_COMMENT_LIB    "kernel-based Library"
#define MSGDIRECT_COMMENT_LIB      "KERNEL Library"
//#define MSGDIRECT_COMMENT_EXPR   "unknown Expression"
#define MSGDIRECT_COMMENT_EXPR     "unbekannter Ausdruck"
//#define MSGDIRECT_COMMENT_EBOOK  "eBook"
#define MSGDIRECT_COMMENT_EBOOK    "eBook"
//#define MSGDIRECT_COMMENT_ANIM   "Animation"
#define MSGDIRECT_COMMENT_ANIM     "Animation"

//-----------------------------------------------------------------------------
// About dialog message
//-----------------------------------------------------------------------------

const char* about[] = {
    "Eine TI-Chess Team Produktion",
    "von",
    "Thomas Nussbaumer",
    "und",
    "Marcos Lopez",
    "BESUCHE UNSERE WEBSITE",
    "http://tict.ticalc.org",
};

//-----------------------------------------------------------------------------
// direct messages from battery.c for info box
//-----------------------------------------------------------------------------

#define MSGDIRECT_BAT_FULL         "6/6 (VOLL)"
#define MSGDIRECT_BAT_OK           "5/6 (OK)"
#define MSGDIRECT_BAT_MEDIUM       "4/6 (MITTEL)"
#define MSGDIRECT_BAT_LOW          "3/6 (SCHWACH)"
#define MSGDIRECT_BAT_VERYLOW      "2/6 (SEHR SCHWACH)"
#define MSGDIRECT_BAT_ALMOSTDEAD   "1/6 (FAST LEER)"
#define MSGDIRECT_BAT_CHANGE       "0/6 (!!LEER!!)"
#define MSGDIRECT_BAT_RESET        "0/6 (*RESET*)"


//-----------------------------------------------------------------------------
// direct messages from menu.c for info box
//-----------------------------------------------------------------------------

#define MSGDIRECT_NUMFILES         "%s  [%d Datei(en)]"
#define MSGDIRECT_FILESIZE         "%s (%u Bytes)"
#define MSGDIRECT_FILELOCKED       "locked"
#define MSGDIRECT_FILEMOVABLE      "movable"
#define MSGDIRECT_MEMSIZE          "%lu Bytes"

#endif

//=============================================================================
// Revision History
//=============================================================================
//
// $Log: msg_deutsch.c,v $
// Revision 1.7  2002/09/23 09:37:38  tnussb
// generic commit (see history.txt: changes up to v1.30 Beta 7)
//
// Revision 1.6  2002/09/10 11:28:42  tnussb
// changes up to v1.30 Beta 4 / examine history.txt for details
//
// Revision 1.5  2002/02/21 09:12:19  tnussb
// translations for new battery support added
//
// Revision 1.4  2002/02/07 18:01:18  tnussb
// generic commit
//
// Revision 1.3  2001/02/10 10:28:40  Thomas Nussbaumer
// generic commit
//
// Revision 1.2  2001/02/05 21:35:46  Thomas Nussbaumer
// slightly modified
//
// Revision 1.1  2001/02/04 12:37:23  Thomas Nussbaumer
// initial version
//
//
