/******************************************************************************
*
* project name:  TICT-Explorer
* file name:     menu.c
* initial date:  03/01/2001
* authors:       thomas.nussbaumer@gmx.net (coding and main design)
*                Benjamin Canou aKa janjan2 (mods for TI92p/V200 fullscreen)
*
* description:   menu handling routines
*
* $Id: menu.c,v 1.13 2002/09/23 09:37:38 tnussb Exp $
*
******************************************************************************/

#define INCLUDE_EASTER_EGG  // easter egg on info page if F3 is pressed


/*===========================================================================*/
/* draws a window (with or without titlebar) & background fade effect        */
/*===========================================================================*/
void DrawWindow(short x,short y,short width,short height,const char* title) {
    WIN_RECT w = {x,y,x+width,y+height};
    SCR_RECT s = {{x,y,x+width,y+height}};

    short i,j;
    unsigned char sprite[]={0xaa,0x55,0xaa,0x55,0xaa,0x55,0xaa,0x55};
    for (j=0;j<C89_92(12,16);j++) {
        for (i=0;i<30;i++) {
            Sprite8(8*i,8*j,8,sprite,used_lcdbuffer,SPRT_AND);
        }
    }

    ScrRectFill(&s,&fullscreen,A_REVERSE);
    DrawClipRect(&w,&fullscreen,A_NORMAL);

    if (title) {
        s.xy.y1 = s.xy.y0+6;
        ScrRectFill(&s,&fullscreen,A_NORMAL);
        DrawStr(x+((width-FastStringWidth(title))>>1),y+1,title,A_REVERSE);
    }
}


/*===========================================================================*/
/* inverts a menu entry                                                      */
/*===========================================================================*/
void InvertSelectionPopupEntry(short idx,SCR_RECT* s) {
    SCR_RECT fe = {{s->xy.x0,s->xy.y0+idx*8,s->xy.x1,s->xy.y0+(idx+1)*8-2}};
    ScrRectFill(&fe,&fullscreen,A_XOR);
}


/*===========================================================================*/
/* draws and handles an input field for 8 characters                         */
/* returns 1 if successful                                                   */
/*===========================================================================*/
short is_password = 0;
short DrawAndHandleInputField(short x,short y,char* buffer) {
    WIN_RECT w     = {x,y,x+8*6+2,y+8};
    SCR_RECT s     = {{w.x0+1,w.y0+1,w.x1-1,w.y1-1}};
    short    count = 0;
    short    input;
    short    redraw = 0;

    ScrRectFill(&s,&fullscreen,A_REVERSE);
    DrawClipRect(&w,&fullscreen,A_NORMAL);

    do {
        input = tolower(GetUserInput());
        if (input == KEY_ESC) return 0;
        else if (input == KEY_ENTER) {
            if (buffer[0]) return 1;
            else           return 0;
        }
        else if ((input >= 'a' && input <= 'z') || (input >= '0' && input <= '9')) {
            if (count < 8) {
                buffer[count++] = input;
                buffer[count]   = 0;
                redraw++;
            }
        }
        else if (input == KEY_BACKSPACE || input == KEY_LEFT) {
            if (count > 0) {
                count--;
                buffer[count] = 0;
                redraw++;
            }
        }
        else if (input == KEY_CLEAR) {
            count = 0;
            memset(buffer,0,8);
            redraw++;
        }

        if (redraw) {
            ScrRectFill(&s,&fullscreen,A_REVERSE);
            if (is_password) {
                char* tmp = buffer;
                int   i=0;
                while (*tmp) {
                    DrawChar(x+1+i*6,y+2,'*',A_REPLACE);
                    i++;
                    tmp++;
                }
            }
            else {
                FastStringXY(x+1,y+2,buffer);
            }
            redraw = 0;
        }

    }
    while (1);
}


/*===========================================================================*/
/* draws and handles a folder selection field                                */
/* returns -1 or index in list                                               */
/*===========================================================================*/
short DrawAndHandleFolderSelectField(short x,short y) {
    WIN_RECT w     = {x,y,x+8*6+2,y+8};
    SCR_RECT s     = {{w.x0+1,w.y0+1,w.x1-1,w.y1-1}};
    short    count = 0;
    short    input;
    short    redraw = 1;

    DrawClipRect(&w,&fullscreen,A_NORMAL);
    ScrRectFill(&s,&fullscreen,A_NORMAL);

    do {
        if (redraw) {
            ScrRectFill(&s,&fullscreen,A_NORMAL);
            DrawStr(x+1,y+2,folder_list[count].name,A_REVERSE);
            redraw = 0;
        }

        input = tolower(GetUserInput());
        if (input == KEY_ESC)        return -1;
        else if (input == KEY_ENTER) return count;
        else if (input == KEY_DOWN || input == KEY_RIGHT) {
            count++;
            if (count >= folder_count) count=0;
            redraw++;
        }
        else if (input == KEY_UP || input == KEY_LEFT) {
            count--;
            if (count<0) count = folder_count-1;
            redraw++;
        }
    }
    while (1);
}


/*===========================================================================*/
/* handles a selection popup                                                 */
/* returns selected index or -1                                              */
/*===========================================================================*/
short HandleSelectionPopup(short xpos,short ypos,const char* entries[],const char* shortcuts[]) {
    SCR_RECT   s;
    short      nr_entries = 0;
    short      i;
    short      max_width = 0;
    short      idx = 0;

    // Find maximum width
    while (entries[nr_entries] != NULL) {
        short tmp = FastStringWidth(entries[nr_entries]);
        if (shortcuts) tmp += FastStringWidth(shortcuts[nr_entries]);
        if (tmp > max_width) max_width = tmp;
        nr_entries++;
    }

    if (xpos == -1) xpos = (C89_92(160,240)-max_width)/2;

    s.xy.x0 = xpos+1;
    s.xy.y0 = ypos;
    s.xy.x1 = xpos+max_width+3;
    s.xy.y1 = ypos+nr_entries*8;

    DrawWindow(xpos,ypos,max_width+4,nr_entries*8,NULL);

    s.xy.y0+=2;
    for (i=0;i<nr_entries;i++) {
        DrawStr(s.xy.x0,s.xy.y0+i*8,entries[i],A_NORMAL);
        if (shortcuts) DrawStr(s.xy.x0+max_width-FastStringWidth(shortcuts[i]),
                               s.xy.y0+i*8,shortcuts[i],A_NORMAL);
    }

    s.xy.y0--;

    InvertSelectionPopupEntry(idx,&s);

    do {
        i = GetUserInput();
        if (i==KEY_DOWN) {
            InvertSelectionPopupEntry(idx,&s);
            idx++;
            if (idx>=nr_entries) idx=0;
            InvertSelectionPopupEntry(idx,&s);
        }
        else if (i==KEY_UP) {
            InvertSelectionPopupEntry(idx,&s);
            idx--;
            if (idx < 0) idx = nr_entries-1;
            InvertSelectionPopupEntry(idx,&s);
        }
#if defined(VERSION_TI89)
        i = MapTI89Numbers(i);
#endif
        if (i >= '1' && i <= '9') return i-'1';
        else if (i=='0')          return 9;
    }

    while (i != KEY_ESC && i != KEY_ENTER);

    if (i == KEY_ENTER) return idx;
    else                return -1;
}


//=============================================================================
// draws info page
//=============================================================================
#define INFO_X 65
unsigned short DrawInfoPage(void) {
    short         i;
    char          sbuffer[100];
    static char   date_and_time[] = __DATE__" "__TIME__;
    unsigned long inUse;
    unsigned long freeAfterGC;
    unsigned long freeB;
#if defined(INCLUDE_EASTER_EGG)
    short         first = 1;
#endif

    DrawWindow(OFFSET_X,OFFSET_Y,159,93," ");
    DrawStatusLine(NULL);

    DrawStr(OFFSET_X+2,1+OFFSET_Y,GetMsg(MSG_PRGTITLE),A_REVERSE);
    DrawStr(158-FastStringWidth(date_and_time)+OFFSET_X,1+OFFSET_Y,date_and_time,A_REVERSE);

    for (i=0;i<9;i++) {
        FastStringXY(OFFSET_X+2,i*8+9+OFFSET_Y,infopage[i]);
    }

    sprintf(sbuffer,MSGDIRECT_NUMFILES,folder_list[active_folder].name,file_count);

    FastStringXY(INFO_X+OFFSET_X,0*8+9+OFFSET_Y,sbuffer);

    if (global_mode==SCROLL_FILE) {
        SYM_ENTRY* entry;
        unsigned char buffer[60];
        unsigned char* src;
        unsigned char* name = file_list[active_file].name;
        unsigned short length;

        entry = DerefSym(SymFind(GenerateTIOSName(name,buffer)));
        if (entry && entry->handle) {
            src = HeapDeref(entry->handle);
            length = *(unsigned short*)(src)+2;
            sprintf(buffer,MSGDIRECT_FILESIZE,name,length);
            FastStringXY(INFO_X+OFFSET_X,1*8+9+OFFSET_Y,buffer);
            sprintf(buffer,"%u -> 0x%lX (%s)",entry->handle,src,
                    (HeapGetLock(entry->handle))?MSGDIRECT_FILELOCKED:MSGDIRECT_FILEMOVABLE);
            FastStringXY(INFO_X+OFFSET_X,2*8+9+OFFSET_Y,buffer);
        }
    }

    sprintf(sbuffer,"%d",FreeHandles());
    FastStringXY(INFO_X+OFFSET_X,3*8+9+OFFSET_Y,sbuffer);

    HeapCompress(); // compress heap first !!!
    sprintf(sbuffer,MSGDIRECT_MEMSIZE,HeapAvail());
    FastStringXY(INFO_X+OFFSET_X,4*8+9+OFFSET_Y,sbuffer);

    EM_survey(&inUse,&freeAfterGC,&freeB,NULL ,NULL ,NULL );

    sprintf(sbuffer,MSGDIRECT_MEMSIZE,inUse);
    FastStringXY(INFO_X+OFFSET_X,5*8+9+OFFSET_Y,sbuffer);
    sprintf(sbuffer,MSGDIRECT_MEMSIZE,(freeB+freeAfterGC));
    FastStringXY(INFO_X+OFFSET_X,6*8+9+OFFSET_Y,sbuffer);
    sprintf(sbuffer,"0x%lX",top_estack);
    FastStringXY(INFO_X+OFFSET_X,7*8+9+OFFSET_Y,sbuffer);

    DrawBatteryState(INFO_X+OFFSET_X,8*8+9+OFFSET_Y);

#if defined(INCLUDE_EASTER_EGG)
    // very dumb easter egg - just inverts the screen if F3 is pressed
    do {
        unsigned short s = GetUserInput();
        unsigned long* ptr;
        if (s!=KEY_F3) return s;
        if (first) {
            FastStringXY(OFFSET_X+2,9*8+11+OFFSET_Y,
                         "Congratulations: You've found the Easter Egg");
            first = 0;
        }
        for (i=0,ptr=LCD_MEM;i<960;i++,ptr++) *ptr = ~(*ptr);
    }
    while (1);
#else
    return GetUserInput();
#endif
}


//=============================================================================
// draws the about dialog
//=============================================================================
unsigned short DrawAboutDialog(void) {
    short i;
    short add_off = 0;

    DrawWindow(OFFSET_X+25, OFFSET_Y+13,110,72,GetMsg(MSG_PRGTITLE));
    DrawLine(OFFSET_X+30,OFFSET_Y+65,OFFSET_X+130,OFFSET_Y+65,A_REPLACE);

    for (i=0;i<7;i++) {
        if (i<5) add_off = 0;
        else     add_off = 5;
        FastStringXY(OFFSET_X+(160-FastStringWidth(about[i]))/2,
                     OFFSET_Y+24+i*8+add_off,about[i]);
    }

    return GetUserInput();
}


/*===========================================================================*/
/* shows the help page                                                       */
/*===========================================================================*/
unsigned short DrawHelpPage(void) {
    short i      = 0;
    char title[] = MSGDIRECT_HELPTITLE;

    DrawWindow(OFFSET_X,OFFSET_Y,159,93," ");
    DrawStatusLine(NULL);

    DrawStr(OFFSET_X+2,1+OFFSET_Y,GetMsg(MSG_PRGTITLE),A_REVERSE);
    DrawStr(158-FastStringWidth(title)+OFFSET_X,1+OFFSET_Y,title,A_REVERSE);

    while (helppage[i*2]) {
        FastStringXY(OFFSET_X+2,i*8+9+OFFSET_Y,helppage[i*2]);
        FastStringXY(65+OFFSET_X,i*8+9+OFFSET_Y,helppage[i*2+1]);
        i++;
    }

    return GetUserInput();

}


#define PASSWORD_CHANGE  0
#define PASSWORD_TEST    1

/*===========================================================================*/
/* handle password                                                           */
/*===========================================================================*/
short HandlePassword(short mode) {
    short retval;
    char  buffer1[9];
    char  buffer2[9];
    static const char offsets[9] = "TICTEXP";

    memset(buffer1,0,9);
    memset(buffer2,0,9);

    if (mode == PASSWORD_TEST) {
        DrawWindow(OFFSET_X+25,OFFSET_Y+30,110,22,MSGDIRECT_TESTPASSWORD);
    }
    else {
        DrawWindow(OFFSET_X+25,OFFSET_Y+30,110,22,MSGDIRECT_ENTERNEWPASSWORD);
    }
    FastStringXY(OFFSET_X+30,OFFSET_Y+42,MSGDIRECT_PASSWORD);

    is_password = 1;
    retval = DrawAndHandleInputField(OFFSET_X+79,OFFSET_Y+40,buffer1);
    is_password = 0;

    if (!retval) return 0;

    if (mode == PASSWORD_CHANGE) {
        DrawWindow(OFFSET_X+25,OFFSET_Y+30,110,22,MSGDIRECT_REENTERPASSWORD);
        FastStringXY(OFFSET_X+30,OFFSET_Y+42,MSGDIRECT_PASSWORD);
        is_password = 1;
        retval = DrawAndHandleInputField(OFFSET_X+79,OFFSET_Y+40,buffer2);
        is_password = 0;
        if (!retval || strcmp(buffer1,buffer2)) return 0;
    }

    for (retval=1;retval<8;retval++) buffer1[retval] ^= offsets[retval];

    if (mode == PASSWORD_TEST) return (!memcmp(configuration.pwd,buffer1,9));
    memcpy(configuration.pwd,buffer1,9);

    return 1;
}



//=============================================================================
// Revision History
//=============================================================================
//
// $Log: menu.c,v $
// Revision 1.13  2002/09/23 09:37:38  tnussb
// generic commit (see history.txt: changes up to v1.30 Beta 7)
//
// Revision 1.12  2002/02/25 12:54:45  tnussb
// minor size optimizations and beautifying
//
// Revision 1.11  2002/02/07 18:01:17  tnussb
// generic commit
//
// Revision 1.10  2001/02/10 10:25:29  Thomas Nussbaumer
// unnecessary code removed
//
// Revision 1.9  2001/02/04 13:11:27  Thomas Nussbaumer
// changes up to version 1.00 RC2 (see history.txt)
//
// Revision 1.8  2001/01/26 21:04:44  Thomas Nussbaumer
// changes for version 0.80 [see history.txt]
//
// Revision 1.7  2001/01/21 00:20:16  Thomas Nussbaumer
// additionally changes related to version 0.60
//
// Revision 1.6  2001/01/20 21:36:30  Thomas Nussbaumer
// changes due to version 0.60
//
// Revision 1.5  2001/01/17 23:38:41  Thomas Nussbaumer
// changes related to version 0.50 (see history.txt)
//
// Revision 1.4  2001/01/16 03:42:25  Thomas Nussbaumer
// see history.txt (up to version 0.40)
//
// Revision 1.3  2001/01/15 00:08:19  Thomas Nussbaumer
// see history.txt (up to v0.34) for what's new
//
// Revision 1.2  2001/01/06 23:15:29  Thomas Nussbaumer
// see history.txt file for changes (new in v0.27 till v0.29)
//
// Revision 1.1  2001/01/03 19:32:00  Thomas Nussbaumer
// initial version
//
//
//
