/******************************************************************************
*
* project name:  TICT-Explorer
* file name:     loadsave.c
* initial date:  24/01/2001
* author:        thomas.nussbaumer@gmx.net
*
* description:   stuff related to the configuration file and the favorites
*
* $Id: loadsave.c,v 1.4 2002/02/07 18:01:17 tnussb Exp $
*
******************************************************************************/

// tictexco.nfig  ... name of configfile

#define CONFIG_FILENAME  "main\\tictexco"

#define CONFIG_EXTENSION "nfig"

#define CONFIG_MAGIC     C4L('E','X','P','L')
#define CONFIG_VERSION   C4L('1','.','0','0')

//-----------------------------------------------------------------------------
// NOTE: if this TICTEX_CONFIG structure changes, please change the define
//       CONFIG_VERSION define, too !!!
//-----------------------------------------------------------------------------
typedef struct {
     unsigned long  magic;
     unsigned long  version;
     char           favorites[18][9];
     unsigned char  types[9];      // types of favorites
     char           last_folder[9];
     char           last_file[9];
     unsigned short entry_used;
     unsigned short flags;         // misc. flags (16)
     unsigned char  pwd[9];        //default password
} TICTEX_CONFIG;

#define EMPTY_CONFIG_INIT {0,0,{{}},{},{},{},0,0,{}}
#define CONFIG_SIZE       (sizeof(TICTEX_CONFIG)+2+7)

TICTEX_CONFIG configuration = EMPTY_CONFIG_INIT;

#define FAVORITE_USED(_nr_)     (configuration.entry_used & (1 << (_nr_)))
#define SET_FAVORITE_USED(_nr_) (configuration.entry_used = configuration.entry_used | (1 << (_nr_)))
#define SET_FAVORITE_EMPTY(_nr_)(configuration.entry_used = configuration.entry_used & (~(1 << (_nr_))))


/*===========================================================================*/
/* initializes configuration                                                 */
/*===========================================================================*/
void InitConfig(void) {
    memset(&configuration,0,sizeof(TICTEX_CONFIG));
    configuration.magic   = CONFIG_MAGIC;
    configuration.version = CONFIG_VERSION;
}


/*===========================================================================*/
/* loads configuration, will return 1 on success                             */
/*===========================================================================*/
short LoadConfig(void) {
    SYM_ENTRY* symptr = GetSymByName(CONFIG_FILENAME);
    short      retval = 0;
    if (symptr && symptr->handle && !symptr->flags.bits.archived && !symptr->flags.bits.twin) {
        HANDLE         h      = symptr->handle;
        unsigned char* src    = SaveHeapLock(h);
        unsigned short length = *(unsigned short*)src;

        symptr->flags.bits.hidden = 1;

        if (length == CONFIG_SIZE - 2) {
            src+=2;
            memcpy(&configuration,src,sizeof(TICTEX_CONFIG));
            if (configuration.magic   == CONFIG_MAGIC &&
                configuration.version == CONFIG_VERSION)
            {
                retval = 1;
            }
        }
        SaveHeapUnLock();
    }

    if (!retval) InitConfig();

    return retval;
}


/*===========================================================================*/
/* saves configuration, will return 1 on success                             */
/* (will save and restore background during operation)                       */
/*===========================================================================*/
short SaveConfig(short hide_it) {
    SYM_ENTRY*     symptr;
    char           tbuf[30];
    char*          tiosname = GenerateTIOSName(CONFIG_FILENAME,tbuf);
    unsigned char* src;
    HANDLE         h;
    short          retval = 1;

    LCD_save(pti->lcdbuffer);
    if ((h = HeapAlloc(CONFIG_SIZE))) {
        symptr = GetSymByName(tiosname);

        if (symptr) {
            if (symptr->flags.bits.archived ||
                symptr->flags.bits.twin     ||
                symptr->flags.bits.folder)
            {
                retval = 0;
            }
            else if (!SymDel(tiosname)) retval = 0;
        }

        if (retval) {
            if (!(symptr = DerefSym(SymAdd(tiosname)))) retval = 0;
            else {
                symptr->handle = h;
                symptr->flags.bits.hidden = hide_it;
                src = HeapDeref(h);
                (*(unsigned short*)src) = (unsigned short)(CONFIG_SIZE-2);
                src+=2;
                memcpy(src,&configuration,sizeof(TICTEX_CONFIG));
                src+=sizeof(TICTEX_CONFIG);
                *src++ = 0;
                strcpy(src,CONFIG_EXTENSION);
                src+=5;
                *src=OTH_TAG;
            }
        }
    }
    else {
        retval = 0;
    }

    LCD_restore(pti->lcdbuffer);
    return retval;
}


/*===========================================================================*/
/* sets favorite program/file                                                */
/*===========================================================================*/
void SetFavorite(char* msg, short nr,char* folder,char* file,char type) {
    SET_FAVORITE_USED(nr);
    strcpy(configuration.favorites[2*nr],folder);
    strcpy(configuration.favorites[2*nr+1],file);
    configuration.types[nr] = type;
    msg[0] = 0;
    if (!SaveConfig(1)) strcpy(msg,MSGDIRECT_WARNINGCANNOTSAVE);
}


/*===========================================================================*/
/* HandleFavoritePopup()                                                     */
/* returns true if a favorite should be started                              */
/*===========================================================================*/
short HandleSelectionPopup(short xpos,short ypos,const char* entries[],const char* shortcuts[]);
short HandleStart(file_t* data,char* folder);

// WARNING!!! NOT REALLY CONSTANT -- WE WRITE INTO IT IN HandleFavoriteMenu() !!!
const char* favorite_entries[] = {
    "1:--------\\-------- ",
    "2:--------\\-------- ",
    "3:--------\\-------- ",
    "4:--------\\-------- ",
    "5:--------\\-------- ",
    "6:--------\\-------- ",
    "7:--------\\-------- ",
    "8:--------\\-------- ",
    "9:--------\\-------- ",
    MSGDIRECT_CLEARALLFAVORITES,NULL
};
const char* favorite_shorts[]= {
    "\x7F\x31",
    "\x7F\x32",
    "\x7F\x33",
    "\x7F\x34",
    "\x7F\x35",
    "\x7F\x36",
    "\x7F\x37",
    "\x7F\x38",
    "\x7F\x39",
    "",NULL
};

short HandleFavoriteMenu(char* msg,short startone) {
    int i;
    file_t data;

    LCD_save(pti->lcdbuffer);

    if (startone == -1 || (!FAVORITE_USED(startone))) {
        for (i=0;i<9;i++) {
            if (FAVORITE_USED(i)) {
                sprintf(msg,"%s\\%s                ",
                        configuration.favorites[2*i],
                        configuration.favorites[2*i+1]);
                memcpy((char*)(favorite_entries[i]+2),msg,17);  // DIRTY DIRTY DIRTY -- WRITING TO CONST
            }
            else {
                memcpy((char*)(favorite_entries[i]+2),"--------\\--------",17);
            }
        }
        startone = HandleSelectionPopup(-1,OFFSET_Y+6,favorite_entries,favorite_shorts);
        LCD_restore(pti->lcdbuffer);
    }

    if (startone==9) {
        for (i=0;i<9;i++) {
            SET_FAVORITE_EMPTY(i);
            memset(configuration.favorites[2*i],0,9);
            memset(configuration.favorites[2*i+1],0,9);
        }
        startone = -1;
        if (!SaveConfig(1)) strcpy(msg,MSGDIRECT_WARNINGCANNOTSAVE);

    }
    else {
        msg[0] = 0;
    }

    if (startone == -1 || !FAVORITE_USED(startone)) return 0;

    strcpy(data.name,configuration.favorites[2*startone+1]);
    data.type = configuration.types[startone];

    pti->exemode = EXEMODE_NONE;
    i = HandleStart(&data,configuration.favorites[2*startone]);

    if (i != MSG_OKAY) {
        strcpy(msg,GetMsg(i));
        return 0;
    }

    return 1;
}


//=============================================================================
// Revision History
//=============================================================================
//
// $Log: loadsave.c,v $
// Revision 1.4  2002/02/07 18:01:17  tnussb
// generic commit
//
// Revision 1.3  2001/02/10 10:25:01  Thomas Nussbaumer
// using now macro to generate magic numbers
//
// Revision 1.2  2001/02/04 13:11:27  Thomas Nussbaumer
// changes up to version 1.00 RC2 (see history.txt)
//
// Revision 1.1  2001/01/26 21:04:21  Thomas Nussbaumer
// initial version
//
//
