/******************************************************************************
*
* project name:  TICT-Explorer
* file name:     interface.h
* initial date:  20/01/2001
* author:        thomas.nussbaumer@gmx.net
*
* description:   defines for interface between launcher and TICT-Explorer
*
* $Id: interface.h,v 1.14 2002/10/29 09:06:59 tnussb Exp $
*
******************************************************************************/

#if !defined(TICTEX_INTERFACE_H)
#define TICTEX_INTERFACE_H

#define C4L(a,b,c,d)   ((((unsigned long)(a)) << 24) | \
                        (((unsigned long)(b)) << 16) | \
                        (((unsigned long)(c)) <<  8) | \
                        (((unsigned long)(d))))


#define TICTEX_VERSION                C4L('1','.','3','0')
#define TICTEX_VERSION_STRING         "TICT-Explorer v1.30(B9)"

#define MAGIC_EXPLORER1               C4L('[','T','I','C')
#define MAGIC_EXPLORER2               C4L('T','E','X','0')

#define MAGIC_EXPLORER14              ((MAGIC_EXPLORER1 >> 16) & 0xFFFF)
#define MAGIC_EXPLORER24               (MAGIC_EXPLORER1        & 0xFFFF)
#define MAGIC_EXPLORER34              ((MAGIC_EXPLORER2 >> 16) & 0xFFFF)
#define MAGIC_EXPLORER44               (MAGIC_EXPLORER2        & 0xFFFF)

#define COMMAND_EXIT                  0x00
#define COMMAND_EXECUTE               0x01
#define COMMAND_FIRSTTIME             0x02
#define COMMAND_RUN                   0x03

#define EXEMODE_NONE                  0x00
#define EXEMODE_NORMAL                0x01
#define EXEMODE_PPG                   0x02
#define EXEMODE_BASIC                 0x04

#define EXEMODE_INTERPRET_FILE        0x10
#define EXEMODE_INTERPRET_FOLDERFILE  0x20

typedef struct {
    unsigned char* lcdbuffer;
    char           foldername[10];
    char           filename[10];
    char           interpret_folder[10];
    char           interpret_file[10];
    unsigned short exemode;
    unsigned short message;
    unsigned short command;
} TICTEX_INTERFACE;

#define EMPTY_INTERFACE_INIT {0,{},{},{},{},0,0,0};

#endif

//=============================================================================
// Revision History
//=============================================================================
//
// $Log: interface.h,v $
// Revision 1.14  2002/10/29 09:06:59  tnussb
// magic marker changed due to an important change in the launcher
//
// Revision 1.13  2002/10/01 09:08:35  tnussb
// version string set to B8
//
// Revision 1.12  2002/09/23 09:37:38  tnussb
// generic commit (see history.txt: changes up to v1.30 Beta 7)
//
// Revision 1.11  2002/09/10 11:28:42  tnussb
// changes up to v1.30 Beta 4 / examine history.txt for details
//
// Revision 1.10  2002/03/15 15:10:12  tnussb
// version changed to 1.30 (B) - its only a beta ...
//
// Revision 1.9  2002/02/25 11:08:37  tnussb
// changes due to portuguese version
//
// Revision 1.8  2002/02/21 09:32:59  tnussb
// version set to 1.11 for final second release of TICT-Explorer
//
// Revision 1.7  2002/02/07 18:01:17  tnussb
// generic commit
//
// Revision 1.6  2001/02/10 10:24:13  Thomas Nussbaumer
// (1) macro to generate unsigned longs out of 4 characters added
// (2) version number now 1.00 (its release time ;-)
//
// Revision 1.5  2001/02/05 21:35:03  Thomas Nussbaumer
// just version number changed
//
// Revision 1.4  2001/02/04 13:11:27  Thomas Nussbaumer
// changes up to version 1.00 RC2 (see history.txt)
//
// Revision 1.3  2001/01/26 21:04:44  Thomas Nussbaumer
// changes for version 0.80 [see history.txt]
//
// Revision 1.2  2001/01/21 17:05:09  Thomas Nussbaumer
// changes related to v0.65
//
// Revision 1.1  2001/01/20 21:33:37  Thomas Nussbaumer
// initial version
//
//
//
