/******************************************************************************
*
* project name:  TICT-Explorer
* file name:     viewpic.c
* initial date:  31/12/2000
* author:        thomas.nussbaumer@gmx.net
*
* description:   font 4x6 drawing routine
*
* $Id: font5x5.c,v 1.8 2002/09/23 09:37:38 tnussb Exp $
*
******************************************************************************/

short*         charwidth      = NULL;     // points to array with string widths
unsigned char* charset        = NULL;
unsigned char* used_lcdbuffer = LCD_MEM;


//=============================================================================
// returns with of string
//=============================================================================
unsigned short FastStringWidth(const unsigned char* s) {
    short width = 0;
    while (*s) {
        width += charwidth[*s++];
    }
    return width;
}


//=============================================================================
// draws string using own sprites (about 4 times faster than DrawStrXY)
//=============================================================================
void FastStringXY(short x,short y,const unsigned char* s) {
    unsigned char* sprite;
    long           addr;
    long           addr_offset = ((long)used_lcdbuffer)+(y<<5)-(y<<1);
    unsigned short cnt;
    long           mask;

    while (*s) {
        sprite = charset + (*s << 2) + *s;
        addr   = addr_offset + ((x>>3)&0xfffe);
        cnt    = 24-(x&15);
        mask = ~((long)(0xf8)<<cnt);

        // unrolled loop for more speed ...
        *(long*)addr&=mask; *(long*)addr |= (long)(*sprite++)<<cnt;addr+=30;
        *(long*)addr&=mask; *(long*)addr |= (long)(*sprite++)<<cnt;addr+=30;
        *(long*)addr&=mask; *(long*)addr |= (long)(*sprite++)<<cnt;addr+=30;
        *(long*)addr&=mask; *(long*)addr |= (long)(*sprite++)<<cnt;addr+=30;
        *(long*)addr&=mask; *(long*)addr |= (long)(*sprite)<<cnt;

        x+=charwidth[*s++];
    }
}


//=============================================================================
// initializes everything necessary for fast string drawing
//=============================================================================
short InitializeFastString(void) {
    short i;

    used_lcdbuffer = LCD_MEM;

    if (!(charset = malloc(256*5+256*sizeof(short)))) return 0;
    charwidth = (short*)(charset+256*5);

    SetCurAttr(A_NORMAL);
    FontSetSys(F_4x6);
    memset(charset,0,256*5);
    PortSet(charset,7,5*256-1);

    // now draw all characters into the buffer so that we can use it later
    // with Sprite8()
    for (i=0;i<256;i++) {
        charwidth[i] = FontCharWidth(i);
        DrawChar(0,i*5,i,A_REPLACE);
    }
    PortRestore();

    return 1;
}


//=============================================================================
// frees allocated memory used for fast string routine
//=============================================================================
void CleanupFastString(void) {
    if (charset) {
        free(charset);charset=NULL;
    }
}

//=============================================================================
// Revision History
//=============================================================================
//
// $Log: font5x5.c,v $
// Revision 1.8  2002/09/23 09:37:38  tnussb
// generic commit (see history.txt: changes up to v1.30 Beta 7)
//
// Revision 1.7  2002/03/15 15:07:13  tnussb
// uses now masking within FastDrawStringXY() (necessary for hex editor)
//
// Revision 1.6  2002/02/21 09:31:23  tnussb
// VERSION_TI89 and VERSION_TI92P replaced by new standard USE_TI89 and USE_TI92P
//
// Revision 1.5  2002/02/21 09:11:56  tnussb
// (1) FastStringXY replaced by faster version (not using Sprite8() anymore)
// (2) charset and charwidth not allocated separately anymore, but at once
//
// Revision 1.4  2002/02/07 18:01:17  tnussb
// generic commit
//
// Revision 1.3  2001/02/04 13:11:27  Thomas Nussbaumer
// changes up to version 1.00 RC2 (see history.txt)
//
//  