/******************************************************************************
*
* project name:  TICT-Explorer
* file name:     file.c
* initial date:  03/01/2001
* author:        thomas.nussbaumer@gmx.net
*
* description:   file handling functionalities
*
* $Id: file.c,v 1.12 2002/09/23 09:37:38 tnussb Exp $
*
******************************************************************************/


/*===========================================================================*/
/* handles archiving/unarchiving or locking/unlocking of files               */
/* returns count of changed files                                            */
/*                                                                           */
/* NOTE:  a popup about garbage collection may be thrown by the AMS          */
/* NOTE2: may change the font due to the popup                               */
/* NOTE3: (un)-locking operation is skipped if file is archived (it will     */
/*        stay locked)                                                       */
/*                                                                           */
/* We have to be very carefully about LOCKED or TWIN symbols                 */
/*===========================================================================*/
#define OPERATION_ARCHIVE 0
#define OPERATION_LOCK    1

short HandleArchiveOrLock(char* msg,short operation) {
    short      i;
    char       tname[30];
    char*      tiosname;
    short      change_count = 0;
    short      single       = 1;

    msg[0] = 0;

    for (i=0;i<file_count;i++) {
        if (file_list[i].marked == FILE_MARKED) {
            single = 0;
            break;
        }
    }

    if (global_mode==SCROLL_FOLDER && single) {
        strcpy(msg,MSGDIRECT_PLEASESELECT);
        return 0;
    }

    if (operation == OPERATION_ARCHIVE) DrawStatusLine(MSGDIRECT_PROCESSARCHIVE);
    else                                DrawStatusLine(MSGDIRECT_PROCESSLOCKING);

    for (i=0;i<file_count;i++) {
        file_t *f = &file_list[i];
        if ((single && i == active_file && !(f->flags.bits.hidden)) ||
            (f->marked == FILE_MARKED && !(f->flags.bits.hidden)))
        {
            tiosname = GenerateTIOSName(f->name,tname);

            //-------------------------------------------------------------
            // its important to make sure that that this file is not in use
            //-------------------------------------------------------------
            if (IsInUse(tiosname)) {
               sprintf(msg,MSGDIRECT_CURRENTINUSE,f->name);
               return change_count;
            }
            //HeapCompress(); // compress heap first !!!
            //EM_GC(FALSE);   // garbage collect archive

            //-----------------------------------------------------------------
            // handle (un)archiving ...
            //-----------------------------------------------------------------
            if (operation == OPERATION_ARCHIVE) {
                if (f->flags.bits.archived) {
                    if (!EM_moveSymFromExtMem(tiosname, HS_NULL)) {
                        strcpy(msg,MSGDIRECT_UNARCHIVEFAILED);
                        return change_count;
                    }
                }
                else {
                    if (!EM_moveSymToExtMem(tiosname, HS_NULL)) {
                        strcpy(msg,MSGDIRECT_ARCHIVEFAILED);
                        return change_count;
                    }
                }
            }
            //-----------------------------------------------------------------
            // handle (un)locking ...
            //-----------------------------------------------------------------
            else {
                 SYM_ENTRY* symptr = GetSymByName(tiosname);
                 if (symptr && !symptr->flags.bits.archived) {
                     symptr->flags.bits.locked = !(symptr->flags.bits.locked);
                 }
            }

            change_count++;
            f->marked = !FILE_MARKED;

            if (single) return change_count;
        }
    }

    if (!msg[0]) {
        if (!change_count) strcpy(msg,MSGDIRECT_NOFILEPROCESSED);
        else if (change_count == 1) strcpy(msg,MSGDIRECT_ONEFILEPROCESSED);
        else                        sprintf(msg,MSGDIRECT_MULTIFILEPROCESSED,change_count);
    }

    return change_count;
}


/*===========================================================================*/
/* handles creation of a folder                                              */
/* returns 1 if folder was created successfully                              */
/*===========================================================================*/
short HandleCreateFolder(char* msg) {
    char  buffer[9];
    char  tname[30];
    char* tiosname;

    DrawWindow(OFFSET_X+25,OFFSET_Y+30,110,22,MSGDIRECT_ENTERFOLDERTOCREATE);
    FastStringXY(OFFSET_X+30,OFFSET_Y+42,MSGDIRECT_FOLDERNAME);

    // check if user pressed ESCAPE or entered nothing
    if (!DrawAndHandleInputField(OFFSET_X+79,OFFSET_Y+40,buffer)) {
        msg[0] = 0;
        return 0;
    }

    // check if user entered an valid name
    if (buffer[0] >= '0' && buffer[0] <= '9') {
        strcpy(msg,MSGDIRECT_STARTWITHLETTER);
        return 0;
    }

    tiosname = GenerateTIOSName(buffer,tname);

    if (SymFindHome(tiosname).folder) {
        strcpy(msg,MSGDIRECT_FOLDEREXISTS);
        return 0;
    }

    if (!FolderAdd(tiosname)) {
        strcpy(msg,MSGDIRECT_FOLDERCREATIONFAILED);
        return 0;
    }

    sprintf(msg,MSGDIRECT_FOLDERSUCCESS,buffer);
    return 1;
}


/*===========================================================================*/
/* handles delete files                                                      */
/* returns 0 if no refresh is necessary                                      */
/*===========================================================================*/
short HandleDeleteFiles(char* msg) {
    char  tname[50];
    short del_active = 0;
    short del_count  = 0;
    short i;

    //-------------------------------------------------------------------------
    // treat deletion of folder
    //-------------------------------------------------------------------------
    if (global_mode == SCROLL_FOLDER) {
        short number;
        HSym hs;
        char* tiosname = GenerateTIOSName(folder_list[active_folder].name,tname);
        hs = SymFindHome(tiosname);
        if (!hs.folder) {
            sprintf(msg,MSGDIRECT_FOLDERNOTFOUND,folder_list[active_folder].name);
            return 0;
        }

        number = FolderCount(DerefSym(hs));

        if (number) {
            strcpy(msg,MSGDIRECT_FOLDERNOTEMPTY);
            return 0;
        }

        if (!strcmp(folder_list[active_folder].name,"main")) {
            strcpy(msg,MSGDIRECT_CANNOTDELETEMAIN);
            return 0;
        }

        DrawWindow(OFFSET_X+25,OFFSET_Y+30,110,22,MSGDIRECT_REQUEST);
        FastStringXY(OFFSET_X+30,OFFSET_Y+42,MSGDIRECT_SURETODELETEFOLDER);

        if (GetUserInput() != KEY_ENTER) return 0;

        if (FolderDel(tiosname)) {
            sprintf(msg,MSGDIRECT_SUCCESSDELFOLDER,folder_list[active_folder].name);
            if (active_folder < folder_count-2) active_folder++;
            else if (active_folder > 1)         active_folder--;
            return 1;
        }
        else {
            sprintf(msg,MSGDIRECT_FAILEDDELFOLDER,folder_list[active_folder].name);
            return 0;
        }
    }


    //-------------------------------------------------------------------------
    // if we come here we should to delete files ...
    //-------------------------------------------------------------------------

    // count files to delete ...
    for (i=0;i<file_count;i++) {
        if (file_list[i].marked == FILE_MARKED) del_count++;
    }

    if (!del_count) {
        char* act_name = file_list[active_file].name;
        if (IsInUse(act_name)) {
            sprintf(msg,MSGDIRECT_CURRENTINUSE,act_name);
            return 0;
        }
        else if (file_list[active_file].flags.bits.archived ||
                 file_list[active_file].flags.bits.locked)
        {
            sprintf(msg,MSGDIRECT_LOCKEDORARCHIVED,act_name);
            return 0;
        }
        else {
            del_active = 1;
        }
    }

    DrawWindow(OFFSET_X+25,OFFSET_Y+30,110,22,MSGDIRECT_REQUEST);


    if (del_active) FastStringXY(OFFSET_X+30,OFFSET_Y+42,MSGDIRECT_SUREDELACTIVE);
    else            FastStringXY(OFFSET_X+30,OFFSET_Y+42,MSGDIRECT_SUREDELMARKED);

    if (GetUserInput() != KEY_ENTER) return 0;

    del_count = 0;
    for (i=0;i<file_count;i++) {
        if (file_list[i].marked == FILE_MARKED ||
            (del_active && i == active_file))
        {
            char* act_name = file_list[i].name;
            char s[50];
            sprintf(s,"%s\\%s",folder_list[active_folder].name,act_name);
            if (file_list[i].flags.bits.locked || file_list[i].flags.bits.archived) {
                sprintf(msg,MSGDIRECT_LOCKEDORARCHIVED,act_name);
                return 1;
            }
            else if (IsInUse(s)) {
                sprintf(msg,MSGDIRECT_CURRENTINUSE,act_name);
                return 1;
            }

            if (!SymDel(GenerateTIOSName(s,tname))) {
                sprintf(msg,MSGDIRECT_FAILEDDELFILE,act_name);
                return 1;
            }
            del_count++;

            if (del_active) {
                sprintf(msg,MSGDIRECT_SUCESSDELFILE,act_name);
                if (active_file < file_count-2) active_file++;
                else if (active_file > 1)       active_file--;
                return 1;
            }
        }
    }

    if (del_count==1) {
        strcpy(msg,MSGDIRECT_SUCESSDELONEFILE);
    }
    else {
        sprintf(msg,MSGDIRECT_SUCESSDELMULTIFILE,del_count);
    }
    return 1;
}


/*===========================================================================*/
/* handles copying of one file                                               */
/* returns 1 if everything went okay                                         */
/*===========================================================================*/
short CopyOneFile(char* msg,char* srcfolder,char* srcname,char* destfolder) {
     char           source[50];
     char           destination[50];
     char           tname[50];
     SYM_ENTRY*     symptr;
     unsigned char* sbuf;
     unsigned char* dbuf;
     unsigned short len;
     HANDLE         sh;
     HANDLE         dh;
     HSym           hsym;

     sprintf(destination,"%s\\%s",destfolder,srcname);
     if (GetSymByName(destination)) {
         sprintf(msg,MSGDIRECT_FILENAMEEXISTS,destination);
         return 0;
     }

     sprintf(source,"%s\\%s",srcfolder,srcname);

     if (IsInUse(source)) {
         sprintf(msg,MSGDIRECT_CURRENTINUSE,source);
         return 0;
     }

     if (!(symptr=GetSymByName(source)) || !symptr->handle) {
         sprintf(msg,MSGDIRECT_CANNOTOPENFILE,source);
         return 0;
     }

     sh   = symptr->handle;
     sbuf = SaveHeapLock(sh);
     len  = *(unsigned short*)(sbuf) + 2;

     if (!(dh = HeapAlloc(len))) {
         strcpy(msg,GetMsg(MSG_ERR_OUTOFMEM));
         SaveHeapUnLock();
         return 0;
     }

     dbuf = HLock(dh);
     memcpy(dbuf,sbuf,len);
     SaveHeapUnLock();
     HeapUnlock(dh);

     hsym = SymAdd(GenerateTIOSName(destination,tname));
     if (!hsym.folder || !(symptr = DerefSym(hsym))) {
         sprintf(msg,MSGDIRECT_CANNOTCREATEFILE,destination);
         HeapFree(dh);
         return 0;
     }

     symptr->handle = dh;
     return 1;
}


/*===========================================================================*/
/* handles copying of files                                                  */
/*===========================================================================*/
#define OPERATION_COPY 0
#define OPERATION_MOVE 1
short HandleCopyOrMoveFiles(char* msg,short operation) {
    short process_count  = 0;
    short process_active = 1;
    short i;
    short dest_index;
    const char* postfix;
    char* act_name;

    for (i=0;i<file_count;i++) {
        if (file_list[i].marked == FILE_MARKED) {
            process_active = 0;
            break;
        }
    }

    if (process_active) {
        if (global_mode == SCROLL_FOLDER) {
            strcpy(msg,MSGDIRECT_PLEASESELECT);
            return 0;
        }

        act_name = file_list[active_file].name;
        if (IsInUse(act_name)) {
            sprintf(msg,MSGDIRECT_CURRENTINUSE,act_name);
            return 0;
        }
        else if (operation == OPERATION_MOVE) {
            if (IsHeapLocked(act_name) || file_list[active_file].flags.bits.locked)
            {
                sprintf(msg,MSGDIRECT_LOCKEDORARCHIVED,act_name);
                return 0;
            }
        }
    }

    DrawWindow(OFFSET_X+25,OFFSET_Y+30,110,22,MSGDIRECT_SELECTDESTINATION);
    if (operation == OPERATION_COPY) {
        FastStringXY(OFFSET_X+30,OFFSET_Y+42,MSGDIRECT_COPYTO);
        postfix = MSGDIRECT_COPYMSGPOSTFIX;
    }
    else {
        FastStringXY(OFFSET_X+30,OFFSET_Y+42,MSGDIRECT_MOVETO);
        postfix = MSGDIRECT_MOVEMSGPOSTFIX;
    }
    dest_index = DrawAndHandleFolderSelectField(OFFSET_X+79,OFFSET_Y+40);

    if (dest_index == -1 || dest_index == active_folder) {
        return 0;
    }

    process_count=0;
    for (i=0;i<file_count;i++) {
        if (file_list[i].marked == FILE_MARKED ||
            (process_active && i == active_file))
        {
            act_name = file_list[i].name;
            if (operation == OPERATION_COPY) {
                if (!CopyOneFile(msg,folder_list[active_folder].name,
                                 act_name,
                                 folder_list[dest_index].name))
                {
                    return 1;
                }
            }
            else {
                char source[50];
                char destination[50];
                char stios[50];
                char dtios[50];

                sprintf(source,"%s\\%s",folder_list[active_folder].name,act_name);
                sprintf(destination,"%s\\%s",folder_list[dest_index].name,act_name);
                if (IsHeapLocked(source)           ||
                    file_list[i].flags.bits.locked ||
                    IsInUse(source)                ||
                    GetSymByName(destination))
                {
                    sprintf(msg,MSGDIRECT_FAILEDMOVEFILE,act_name,folder_list[dest_index].name);
                    return 1;
                }
                if (!SymMove(GenerateTIOSName(source,stios),
                             GenerateTIOSName(destination,dtios)))
                {
                    sprintf(msg,MSGDIRECT_FAILEDMOVEFILE,act_name,folder_list[dest_index].name);
                    return 1;
                }

                if (process_active) {
                    if (active_file < file_count-2) active_file++;
                    else if (active_file > 1)       active_file--;
                }
            }
            process_count++;
            if (process_active) {
                sprintf(msg,MSGDIRECT_FILE_POSTFIX_TO_FILE,act_name,postfix,folder_list[dest_index].name);
                return 1;
            }
        }
    }

    if (process_count == 1) {
        sprintf(msg,MSGDIRECT_ONEFILE_POSTFIX,postfix);
    }
    else {
        sprintf(msg,MSGDIRECT_MULTIFILE_POSTFIX,process_count,postfix);
    }
    return 1;
}


/*===========================================================================*/
/* handles renaming of a file                                                */
/*===========================================================================*/
short HandleRenameFile(char* msg) {
    char   source[50];
    char   destination[50];
    char   stios[50];
    char   dtios[50];
    char   buffer[9];
    char*  act_name;


    if (global_mode == SCROLL_FILE) {
        act_name = file_list[active_file].name;
        if (IsInUse(act_name)) {
            sprintf(msg,MSGDIRECT_CURRENTINUSE,act_name);
            return 0;
        }
        else if (IsHeapLocked(act_name) || file_list[active_file].flags.bits.locked) {
            sprintf(msg,MSGDIRECT_LOCKEDORARCHIVED,act_name);
            return 0;
        }
        DrawWindow(OFFSET_X+25,OFFSET_Y+30,110,22,MSGDIRECT_ENTERNEWFILENAME);
    }
    else {
        act_name = folder_list[active_folder].name;
        if (!strcmp(act_name,"main")) {
            strcpy(msg,MSGDIRECT_CANNOTRENAMEMAIN);
            return 0;
        }
        DrawWindow(OFFSET_X+25,OFFSET_Y+30,110,22,MSGDIRECT_ENTERNEWFOLDERNAME);
    }

    FastStringXY(OFFSET_X+30,OFFSET_Y+42,MSGDIRECT_NEWNAME);

    if (!DrawAndHandleInputField(OFFSET_X+79,OFFSET_Y+40,buffer)) {
        return 0;
    }

    // check if user has entered a valid name (doesn't start with a number)
    if (buffer[0] >= '0' && buffer[0] <= '9') {
        if (global_mode == SCROLL_FILE) strcpy(msg,MSGDIRECT_INVALIDFILENAME);
        else                            strcpy(msg,MSGDIRECT_INVALIDFOLDERNAME);
        return 0;
    }

    if (global_mode == SCROLL_FILE) {
        if (GetSymByName(buffer)) {
            sprintf(msg,MSGDIRECT_FILENAMEEXISTS,buffer);
            return 0;
        }

        sprintf(source,     "%s\\%s",folder_list[active_folder].name,act_name);
        sprintf(destination,"%s\\%s",folder_list[active_folder].name,buffer);

        if (!SymMove(GenerateTIOSName(source,stios),
                     GenerateTIOSName(destination,dtios)))
        {
            sprintf(msg,MSGDIRECT_FAILEDRENAME,act_name,buffer);
            return 0;
        }
        sprintf(msg,MSGDIRECT_SUCCESSRENAME,act_name,buffer);
        strcpy(file_list[active_file].name,buffer);
    }
    else {
        char* dest = GenerateTIOSName(buffer,dtios);

        if (SymFindHome(GenerateTIOSName(buffer,dtios)).folder != H_NULL) {
            sprintf(msg,MSGDIRECT_FILENAMEEXISTS,buffer);
            return 0;
        }
        if (!FolderRename(GenerateTIOSName(act_name,stios),dest)) {
            sprintf(msg,MSGDIRECT_FAILEDRENAME,act_name);
            return 0;
        }
        sprintf(msg,MSGDIRECT_SUCCESSRENAME,act_name,buffer);
        strcpy(folder_list[active_folder].name,buffer);
    }

    return 1;
}


//=============================================================================
// Revision History
//=============================================================================
//
// $Log: file.c,v $
// Revision 1.12  2002/09/23 09:37:38  tnussb
// generic commit (see history.txt: changes up to v1.30 Beta 7)
//
// Revision 1.11  2002/09/10 11:28:41  tnussb
// changes up to v1.30 Beta 4 / examine history.txt for details
//
// Revision 1.10  2002/02/07 18:01:17  tnussb
// generic commit
//
// Revision 1.9  2001/02/04 13:11:27  Thomas Nussbaumer
// changes up to version 1.00 RC2 (see history.txt)
//
// Revision 1.8  2001/01/26 21:04:44  Thomas Nussbaumer
// changes for version 0.80 [see history.txt]
//
// Revision 1.7  2001/01/21 00:20:16  Thomas Nussbaumer
// additionally changes related to version 0.60
//
// Revision 1.6  2001/01/17 23:38:41  Thomas Nussbaumer
// changes related to version 0.50 (see history.txt)
//
// Revision 1.5  2001/01/16 03:42:25  Thomas Nussbaumer
// see history.txt (up to version 0.40)
//
// Revision 1.4  2001/01/15 00:08:19  Thomas Nussbaumer
// see history.txt (up to v0.34) for what's new
//
// Revision 1.3  2001/01/06 23:15:29  Thomas Nussbaumer
// see history.txt file for changes (new in v0.27 till v0.29)
//
// Revision 1.2  2001/01/03 19:32:40  Thomas Nussbaumer
// see history.txt file for changes (new in v0.25 and v0.26)
//
// Revision 1.1  2001/01/02 16:30:43  Thomas Nussbaumer
// initial version
//
//
//
