/******************************************************************************
*
* project name:  TICT-Explorer
* file name:     battery.c
* initial date:  31/12/2000
* author:        thomas.nussbaumer@gmx.net
*                Francesco Orabona (bremen79@infinito.it)
*                ExtendeD (ola.e-ml@wanadoo.fr)
*
* description:   battery state evaluation
*
* Credits go to Guillaume de Vivies (gdv@fr.fm) and Loic Minier (Lool@fr.fm)
* for the HW1 source written for TEX
*
*
* $Id: battery.c,v 1.6 2002/03/15 15:09:22 tnussb Exp $
*
******************************************************************************/

//----------------------------------------------------------------------------
// INFORMATIONS TAKEN FROM J89HW.TXT by Johan Eilert <johei804@student.liu.se>
//
// $600000 RW ($00)
//      :7      Keep clear (=0)
//      :6      Keep clear (=0)
//      :5-3    -
//      :2      Battery voltage level is *above* the trig level.
//              (see $600018).
//      :1-0    -
//
//$600018 RW ($0380)
//      :15-10  -
//      :9-7    Battery voltage trigger level (see $600000:2)
//              (HW2: must also enable batt checker at $70001D:3,0)
//                0: ~4.6V, 1: ~4.5V, 2: ~4.3V, 3: ~4.0V,
//                4: ~3.7V, 5: ~3.4V, 6: ~3.2V, (7: ~2.9V  calc resetted!)
//              Remember to wait a while (~250us) before reading from
//              $600000:2 to make sure that the hardware has stabilized.
//              Keep the trig level set to the lowest voltage (%111) when
//              its not in use (The keyboard does not work otherwise).
//              AMS displays "BATT" when the voltage drops below 4.3V and
//              4.0V, respectively.
//      :6-0    Keyboard col mask, bit =1 masks key column (vertical) from
//              being read at $60001B and generate interrupt on key pressed.
//      Note: Some interrupt handlers in AMS writes to this register, so it
//      is a very good idea to disable interrupts first!!!
//
//$70001D RW ($06)
//      :7      Toggles every FS (every time the LCD restarts at line 0)
//      :6-4    -
//      :3      Battery checker bit B (? ???)
//      :2      ? (set)
//      :1      Screen enable (clear this bit to shut down LCD)
//      :0      Battery checker bit A (? enable $600000:2)
//      The battery checker bits must both be set (AB=11) prior to checking
//      the voltage level with $600000:2.  Then, after use, bit B must be
//      cleared (AB=10) while the battery trig hardware settles to the
//      "rest" voltage value (%111).  Finally, both bits should be cleared.
//
//-----------------------------------------------------------------------------

/*===========================================================================*/
/* evaluates battery state (if argument is 0 it assumes HW1 else HW2)        */
/*                                                                           */
/* returns:                                                                  */
/*                                                                           */
/* 7 - full        battery state                                             */
/* 6 - ok          battery state                                             */
/* 5 - medium      battery state                                             */
/* 4 - low         battery state (battery symbol appears)                    */
/* 3 - very low    battery state (battery symbol darkened)                   */
/* 2 - starving    battery state (battery symbol darkened)                   */
/* 1 - almost dead battery state (battery symbol darkened)                   */
/* 0 - dead        battery state (calc resetted)                             */
/*                                                                           */
/* NOTE: The BATT symbol will be turned on by the AMS                        */
/*===========================================================================*/
unsigned short BatteryState(unsigned short is_hw_2);

asm("BatteryState:\n"
"           movem.l  %d1/%a0-%a1,-(%sp)\n"
"           tst.w   16(%sp)           | jump for HW1\n"
"           beq     _bat_h1_1\n"
"           lea     0x70001D,%a0\n"
"           move.b  (%a0),%d0\n"
"           ori.b   #9,%d0\n"
"           move.b  %d0,(%a0)\n"
"_bat_h1_1: moveq   #6,%d1\n"
"           lea     0x600018,%a1\n"
"_bat_loop: bsr.s   _bat_ini         | this initialization lacked in previous versions\n"
"           move.w  %d1,%d0\n"
"           lsl.w   #7,%d0\n"
"           move.w  %d0,(%a1)\n"
"           moveq   #0x6e,%d0\n"
"_bat_test: btst.b  #2,-0x18(%a1)\n"
"           dbeq    %d0,_bat_test\n"
"           beq.s   _bat_quit\n"
"           dbf     %d1,_bat_loop\n"
"_bat_quit: neg.w   %d1\n"
"           addq.w  #6,%d1\n"
"           tst.w   4(%sp)\n"
"           beq.s   _bat_h1_2        | jump for HW1\n"
"           and.b   #0xF7,(%a0)\n"
"           bsr.s   _bat_ini\n"
"           andi.b  #0xF6,(%a0)\n"
"_bat_h1_2: move.w  %d1,%d0\n"
"           movem.l (%sp)+,%d1/%a0-%a1\n"
"           rts\n"
"_bat_ini:  move.w  #0x380,(%a1)\n"
"           moveq   #52,%d0\n"
"_bat_wait: btst.b  #2,-0x18(%a1)\n"
"           dbeq    %d0,_bat_wait\n"
"           rts");


/*===========================================================================*/
/* battery state fetching routine                                            */
/*===========================================================================*/
unsigned short GetBatteryState(void) {
    unsigned long hwpb, *rombase;
    unsigned short level;

    rombase = (unsigned long *)((*(unsigned long *)0xC8) & 0x600000);
    hwpb = rombase[65];
    OSSetSR(0x700);
    level = BatteryState(((unsigned short)(hwpb - (unsigned long)rombase  < 0x10000 &&
                        *(unsigned short *)hwpb > 22 ? *(unsigned long *)(hwpb + 22) : 1) - 1L));
    OSSetSR(0);
    return level;
}


/*===========================================================================*/
/* battery state drawing routine                                             */
/*===========================================================================*/
void DrawBatteryState(short x, short y) {
    unsigned short bs = GetBatteryState();

    static const char* msg_level[] = {
        MSGDIRECT_BAT_RESET,
        MSGDIRECT_BAT_CHANGE,
        MSGDIRECT_BAT_ALMOSTDEAD,
        MSGDIRECT_BAT_VERYLOW,
        MSGDIRECT_BAT_LOW,
        MSGDIRECT_BAT_MEDIUM,
        MSGDIRECT_BAT_OK,
        MSGDIRECT_BAT_FULL};

    //unsigned short bs = random(8);  // for testing ONLY (randomize levels)
    static const unsigned char lev[] ={0, 1, 3, 6, 10, 15, 21, 28};

    WIN_RECT w = {x,y,x+29,y+5};
    SCR_RECT s = {{x,y,x+lev[bs],y+5}};

    ScrRectFill(&s,&fullscreen,A_NORMAL);
    DrawClipRect(&w,&fullscreen,A_NORMAL);

    DrawStr(x+4*8-2,y,msg_level[bs],A_REPLACE);
}


//=============================================================================
// Revision History
//=============================================================================
//
// $Log: battery.c,v $
// Revision 1.6  2002/03/15 15:09:22  tnussb
// uses now new detection routine from Extended
//
// Revision 1.5  2002/02/21 09:13:02  tnussb
// completely new battery state detection routine
//
// Revision 1.4  2002/02/07 18:01:17  tnussb
// generic commit
//
// Revision 1.3  2001/02/04 13:11:27  Thomas Nussbaumer
// changes up to version 1.00 RC2 (see history.txt)
//
// Revision 1.2  2001/01/26 21:04:44  Thomas Nussbaumer
// changes for version 0.80 [see history.txt]
//
// Revision 1.1  2001/01/16 03:41:29  Thomas Nussbaumer
// initial version
//
//
//

