#ifndef MATHS_H
#define MATHS_H

typedef unsigned char *PrimeSieve;

// n must be >= 2 and <= max
// yields nonzero if the number is composite
#define testPrimeSieve(sieve, n) ((sieve)[(n) >> 3] & ((unsigned char)1 << ((n) & 7)))

PrimeSieve makePrimeSieve(unsigned long max);

#endif