/*
 * Copyright (C) 2010 Joseph Adams <joeyadams3.14159@gmail.com>
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

#ifndef LEX_H
#define LEX_H

#include "lambda.h"

#define C_NONE      0
#define C_SPACE     1
#define C_DIGIT     2
#define C_HEX       4
#define C_UPPER     8
#define C_LOWER     16
#define C_SYMBOL    32
#define C_PRINTABLE 64

#define is_space(c)     (cclass(c) & C_SPACE)
#define is_digit(c)     (cclass(c) & C_DIGIT)
#define is_hex(c)       (cclass(c) & C_HEX)
#define is_upper(c)     (cclass(c) & C_UPPER)
#define is_lower(c)     (cclass(c) & C_LOWER)
#define is_symbol(c)    (cclass(c) & C_SYMBOL)

#define is_alpha(c)     (cclass(c) & (C_UPPER | C_LOWER))

#define is_binary(c)    ((c) == '0' || (c) == '1')
#define is_octal(c)     ((c) >= '0' && (c) <= '7')

#define is_int_start(c)  (is_digit(c) || (c) == '\xAD')
#define is_name_start(c) ((cclass(c) & (C_UPPER | C_LOWER | C_SYMBOL)) || (c) == '_')
#define is_var_char(c)   ((cclass(c) & (C_UPPER | C_LOWER | C_DIGIT)) || (c) == '\'' || (c) == '_')

#define cclass(c) (cclass[(int)(unsigned char)(c)])
extern unsigned char cclass[256];

void skipSpace(const char **sptr);
bool startsWithKeyword(const char *str, const char *start);
bool startsWithSymbol(const char *str, const char *start);

// ensure is_int_start(**sptr) before calling
long long parseInt(const char **sptr);
char *showInt(long long i, char buffer[22]);

// ensure is_name_start(**sptr) before calling
char *parseSymbol(const char **sptr);

Value *parseString(const char **sptr);
Value *parseChar(const char **sptr);
int    parseChar1(const char **sptr);

char *showChar(char c, char buffer[5]); // buffer size may be subject to change
void  showChar1(char c, char quoteChar, char **out);

#endif
