/*
 * Copyright (C) 2010 Joseph Adams <joeyadams3.14159@gmail.com>
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

#ifndef FIXITY_H
#define FIXITY_H

typedef enum {PREFIX, INFIXL, INFIX, INFIXR} FixityTag;
	// PREFIX means the symbol acts like a variable
	// if + were marked PREFIX, you would say + a b

typedef struct {
	const char *name;
	FixityTag   fixity;
	int         precedence; // doesn't apply to PREFIX
} Fixity;

typedef struct FixityList {
	const struct FixityList *next;
	Fixity                   f;
} FixityList;

extern const FixityList *customFixities;

const Fixity *getFixity(const char *name);
int compareFixity(const Fixity *a, const Fixity *b);

void setFixity(const char *name, FixityTag fixity, int precedence);

#endif