/*
 * Copyright (C) 2010 Joseph Adams <joeyadams3.14159@gmail.com>
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

#ifndef COMMON_H
#define COMMON_H

#include <assert.h>
#include <error.h>
#include <stdio.h>
#include <string.h>

typedef enum {false, true} bool;

extern bool suppressError;

#define error(fmt, ...) error_("error: " fmt "\n", ##__VA_ARGS__)
void error_(const char *fmt, ...) __attribute__ ((format (printf, 1, 2), noreturn));

#define streq(a,b) (strcmp(a,b) == 0)

static inline void memzero4(void *ptr, unsigned short size)
{
	unsigned long *lp __attribute__((may_alias)) = ptr;
	
	assert((size & 3) == 0);
	size >>= 2;
	
	while (size--)
		*lp++ = 0;
}

static inline char *show_ptr(void *ptr, char buffer[12])
{
	sprintf(buffer, "0x%05lX", (unsigned long)ptr);
	return buffer;
}

extern volatile int break_pressed;

void enable_break(void);
void disable_break(void);

// Pressing break doesn't throw an exception or anything.
// Make sure this function gets called regularly so ON key breaking will work.
static inline void check_break(void)
{
	if (break_pressed) {
		break_pressed = 0;
		ER_throw(ER_BREAK);
	}
}

#endif