// C Source File
// Created 10/19/2009; 10:26:01 PM

// NOTE: even though this program compiles with a bunch of warnings,
// they're only related with typecasting and printf arguments, and
// can be safely ignored

#include <tigcclib.h>

// thanks to TiEmu for the ROM call # for the heap table
// this isn't really necessary though, because the program only builds for the v200
#define HeapTable ((void*)_rom_call_addr(441))

// forward declarations of the utility methods
void hexview(unsigned char* start);
void heapwalk(void);

#define NUM_CHOICES 2

// Main Function
void _main(void)
{
	int curSel = 0, i;

	FontSetSys(F_6x8);
	ClrScr();
	while (1)
	{
		for (i = 0; i < (NUM_CHOICES << 3); i += 8)
			DrawChar(0, i, ' ', A_REPLACE);
		DrawChar(0, curSel << 3, (char)22, A_NORMAL);
		DrawStr(6, 0, "Hex Viewer", A_REPLACE);
		DrawStr(6, 8, "Heap Walker", A_REPLACE);
		short key = ngetchx();
		if (key == KEY_ESC)
			break;
		else if (key == KEY_DOWN)
			curSel++;
		else if (key == KEY_UP)
			curSel += 1;
		else if (key == KEY_ENTER)
		{
			switch (curSel)
			{
				case 0:
					// even though we're passing NULL as the address, we can still read from it (weird, no?)
					hexview(NULL);
					ClrScr();
					break;
				case 1:
					heapwalk();
					ClrScr();
					break;
			}
		}
		curSel %= NUM_CHOICES;
	}
}

void hexviewPrintRow(unsigned char* addr, int yPos)
{
// the following macro is a helper for the output
#define F(ch) ((ch) ? (ch) : '.')

	char buf[42];

	// create the entire row display string in one giant call to sprintf
	sprintf(buf, "%06lp: %02x %02x %02x %02x %02x %02x %02x %02x %c%c%c%c%c%c%c%c",
		(unsigned long)addr & 0x00FFFFFF,
		addr[0], addr[1], addr[2], addr[3], addr[4], addr[5], addr[6], addr[7],
		F(addr[0]), F(addr[1]), F(addr[2]), F(addr[3]), F(addr[4]), F(addr[5]), F(addr[6]), F(addr[7]));
	DrawStr(0, yPos, buf, A_REPLACE);
#undef F
}

void hexview(unsigned char* start)
{
	int i;
	unsigned char* addr = start;

	ClrScr();
	for (i = 0; i < 128; i += 8)
		hexviewPrintRow(addr + i, i);

	while (1)
	{
		short key = ngetchx();
		if (key == KEY_ESC)
			break;
		else if (key == KEY_UP)
		{
			addr -= 8;
			// scroll the screen contents down (240 = number of bytes in 8 rows)
			// we do this to avoid redrawing all of the rows
			memmove((unsigned char*)LCD_MEM + 240, LCD_MEM, LCD_SIZE - 240);
			hexviewPrintRow(addr, 0);
		}
		else if (key == KEY_DOWN)
		{
			addr += 8;
			// scroll the screen contents up (see above for info about 240)
			memmove(LCD_MEM, (unsigned char*)LCD_MEM + 240, LCD_SIZE - 240);
			// 120 (first param) = 15 rows x 8 bytes per row
			// 120 (second param) = 15 hex rows x 8 LCD rows per hex row
			hexviewPrintRow(addr + 120, 120);
		}
		else if (key == KEY_STO || key == 'R')
		{
			// 'R' is to refresh, but the store '->' key will also require a refresh
			if (key == KEY_STO)
			{
				// only prompt if the store '->' key was pressed
				clrscr();
				printf("new address (hex):");
				scanf("%p", &addr);
			}
			ClrScr();
			for (i = 0; i < 128; i += 8)
				hexviewPrintRow(addr + i, i);
		}
	}
}

void heapwalkPrintRow(int rowNum, int scroll)
{
	char buf[20];

	// I'm not even going to try to explain this
	// just know it prints out the information in a row
	unsigned char* addr = ((unsigned char**)HeapTable)[rowNum + scroll];
	unsigned long size = (rowNum + scroll) ? (unsigned long)(*((unsigned short*)(addr - 2))) : 0;
	// a short note on the size of a block:
	// the high bit (in unsigned short form) is set if the block is locked; cleared otherwise
	// the remaining part is actually (size in bytes) / 2 - 1
	// this has to do with a CPU instruction (db*) used in looping (where * is a condition code)
	// see a MC68K assembly reference for more information
	sprintf(buf, "%03lp %06lp %04lp %c", (unsigned long)(rowNum + scroll), (unsigned long)addr & 0x00FFFFFF,
		(rowNum + scroll) ? ((size & 0x00007FFF) - 1) << 1 : 0, (size & 0x8000) ? (char)14 : ' ');
	// char 14 (as used above, in the last parameter) is the padlock symbol in the TI68K font
	DrawStr(12, rowNum << 3, buf, A_REPLACE);
}

void heapwalk(void)
{
	unsigned int count = 0, scroll = 0, curSel = 0;
	unsigned long* tmp;
	int i;

	// get the # of heap table entries
	tmp = (unsigned long*)HeapTable;
	while (*(tmp++))
		count++;

	ClrScr();
	DrawChar(0, 0, (char)22, A_NORMAL);
	for (i = 0; i < 16; i++)
		heapwalkPrintRow(i, scroll);

	while (1)
	{
		for (i = 0; i < 16; i++)
		{
			// fairly small code to draw the arrows/colons, so go ahead and redraw all of them
			if (scroll && !i)
				DrawChar(6, 0, (char)23, A_REPLACE);
			else if (count > 16 && scroll != (count - 16) && i == 15)
				DrawChar(6, 120, (char)24, A_REPLACE);
			else
				DrawChar(6, i << 3, ':', A_REPLACE);
		}
		short key = ngetchx();
		if (key == KEY_DOWN || key == KEY_UP)
			DrawChar(0, (curSel - scroll) << 3, ' ', A_REPLACE); // erase the old arrow
		if (key == KEY_ESC)
			break;
		else if (key == KEY_DOWN)
		{
			if (curSel < count - 1)
			{
				curSel++;
				if (curSel - scroll >= 16)
				{
					scroll++;
					// scroll the screen up
					memmove(LCD_MEM, (unsigned char*)LCD_MEM + 240, LCD_SIZE - 240);
					heapwalkPrintRow(15, scroll);
				}
			}
		}
		else if (key == KEY_UP)
		{
			if (curSel > 0)
			{
				curSel--;
				if (curSel < scroll)
				{
					scroll--;
					// scroll the screen down
					memmove((unsigned char*)LCD_MEM + 240, LCD_MEM, LCD_SIZE - 240);
					heapwalkPrintRow(0, scroll);
				}
			}
		}
		else if (key == KEY_ENTER)
		{
			hexview(((unsigned char**)HeapTable)[curSel]);
			// hexview destroys the contents of the screen, so we gotta redraw everything (sigh)
			ClrScr();
			for (i = 0; i < 16; i++)
				heapwalkPrintRow(i, scroll);
		}
		if (key == KEY_DOWN || key == KEY_UP || key == KEY_ENTER)
			DrawChar(0, (curSel - scroll) << 3, (char)22, A_NORMAL); // redraw the arrow
	}
}
