#include <tigcclib.h>

static unsigned long pow_ten(char);

void _main(void)
{
	ESI argptr;

	InitArgPtr(argptr);

	if(GetArgType(argptr) == STR_TAG)
	{
		unsigned const char *input_string;
		unsigned char offset;
		long output = 0;

		input_string = GetStrnArg(argptr);

		do
		{
			switch(*input_string)
			{
				case '(':
				offset = (long)memchr(input_string, '|', strlen(input_string)) -
				(long)input_string + 1;
				if(input_string[3 * offset - 1] == '|' && (long)strlen(input_string) >= 4
				* offset && input_string[4 * offset - 1] == ')')
				{
					input_string += 4 * offset;
					output += 9 * pow_ten(offset + 1);
				}
				else if(input_string[2 * offset - 1] == '|' && (long)strlen(input_string)
				>= 3 * offset && input_string[3 * offset - 1] == ')')
				{
					input_string += 3 * offset;
					output += 4 * pow_ten(offset + 1);
				}
				else
				{
					input_string += 2 * offset - 1;
					output += pow_ten(offset + 1);
				}
				break;

				case '|':
				offset = 0;
				for(;;)
				{
					offset++;
					if(input_string[offset] != ')')
					{
						break;
					}
				}
				input_string += offset;
				output += 5 * pow_ten(offset);
				break;

				case 'M':
				switch(input_string[1])
				{
					case '(':
					input_string += 6;
					output += 9000;
					break;

					case '|':
					input_string += 4;
					output += 4000;
					break;

					default:
					input_string++;
					output += 1000;
				}
				break;

				case 'D':
				input_string++;
				output += 500;
				break;

				case 'C':
				switch(input_string[1])
				{
					case 'M':
					input_string += 2;
					output += 900;
					break;

					case 'D':
					input_string += 2;
					output += 400;
					break;

					default:
					input_string++;
					output += 100;
				}
				break;

				case 'L':
				input_string++;
				output += 50;
				break;

				case 'X':
				switch(input_string[1])
				{
					case 'C':
					input_string += 2;
					output += 90;
					break;

					case 'L':
					input_string += 2;
					output += 40;
					break;

					default:
					input_string++;
					output += 10;
				}
				break;

				case 'V':
				input_string++;
				output += 5;
				break;

				case 'I':
				switch(input_string[1])
				{
					case 'X':
					input_string += 2;
					output += 9;
					break;

					case 'V':
					input_string += 2;
					output += 4;
					break;

					default:
					input_string++;
					output++;
				}
				break;

				default:
				while(GetArgType(top_estack) != END_TAG) /*cleans the arguments of the
				program off the stack*/
				{
					top_estack = next_expression_index(top_estack);
				}
				top_estack--;

				push_expr_quantum(SYMSTR("Valid characters in input are ()CDILMVX|"), STR_TAG);
				return;
			}
		} while(strlen(input_string));

		while(GetArgType(top_estack) != END_TAG) /*cleans the arguments of the program
		off the stack*/
		{
			top_estack = next_expression_index(top_estack);
		}
		top_estack--;

		push_longint(output);
	}
	else if(GetArgType(argptr) == POSINT_TAG)
	{
		unsigned char *output_string, power;
		short i, string_length = 2;
		unsigned long input, length;

		input = length = GetIntArg(argptr);

		if(input > 0x7FFFFFFF)
		{
			while(GetArgType(top_estack) != END_TAG) /*cleans the arguments of the program
			off the stack*/
			{
				top_estack = next_expression_index(top_estack);
			}
			top_estack--;

			push_expr_quantum(SYMSTR("Argument too large"), STR_TAG);
			return;
		}

		do
		{
			if(length >= 4000)
			{
				power = 2;
				for(;;)
				{
					if(length >= 4 * pow_ten(power + 2))
					{
						power++;
					}
					else
					{
						if(length >= pow_ten(power + 2))
						{
							length -= pow_ten(power + 2);
							string_length += 2 * power + 1;
						}
						else if(length >= 9 * pow_ten(power + 1))
						{
							length -= 9 * pow_ten(power + 1);
							if(power == 2)
							{
								string_length++;
							}
							else
							{
								string_length += 2 * power - 1;
							}
							string_length += 2 * power + 1;
						}
						else if(length >= 5 * pow_ten(power + 1))
						{
							length -= 5 * pow_ten(power + 1);
							string_length += power + 1;
						}
						else if(length >= 4 * pow_ten(power + 1))
						{
							length -= 4 * pow_ten(power + 1);
							if(power == 2)
							{
								string_length++;
							}
							else
							{
								string_length += 2 * power - 1;
							}
							string_length += power + 1;
						}
						break;
					}
				}
			}
			else if(length >= 1000)
			{
				length -= 1000;
				string_length++;
			}
			else if(length >= 900)
			{
				length -= 900;
				string_length += 2;
			}
			else if(length >= 500)
			{
				length -= 500;
				string_length++;
			}
			else if(length >= 400)
			{
				length -= 400;
				string_length += 2;
			}
			else if(length >= 100)
			{
				length -= 100;
				string_length++;
			}
			else if(length >= 90)
			{
				length -= 90;
				string_length += 2;
			}
			else if(length >= 50)
			{
				length -= 50;
				string_length++;
			}
			else if(length >= 40)
			{
				length -= 40;
				string_length += 2;
			}
			else if(length >= 10)
			{
				length -= 10;
				string_length++;
			}
			else if(length == 9)
			{
				length -= 9;
				string_length += 2;
			}
			else if(length >= 5)
			{
				length -= 5;
				string_length++;
			}
			else if(length == 4)
			{
				length -= 4;
				length += 2;
			}
			else
			{
				length--;
				string_length++;
			}
		} while(length != 0);

		output_string = malloc(string_length);

		if(output_string == NULL)
		{
			while(GetArgType(top_estack) != END_TAG) /*cleans the arguments of the program
			off the stack*/
			{
				top_estack = next_expression_index(top_estack);
			}
			top_estack--;

			push_expr_quantum(SYMSTR("Memory Low"), STR_TAG);
		}

		memset(output_string, 0, string_length);

		string_length = 1;

		do
		{
			if(input >= 4000)
			{
				power = 2;
				for(;;)
				{
					if(input >= 4 * pow_ten(power + 2))
					{
						power++;
					}
					else
					{
						if(input >= pow_ten(power + 2))
						{
							input -= pow_ten(power + 2);

							for(i = 0; i < power; i++)
							{
								output_string[string_length] = '(';
								string_length++;
							}
							output_string[string_length] = '|';
							string_length++;
							for(i = 0; i < power; i++)
							{
								output_string[string_length] = ')';
								string_length++;
							}
						}
						else if(input >= 9 * pow_ten(power + 1))
						{
							input -= 9 * pow_ten(power + 1);

							if(power == 2)
							{
								output_string[string_length] = 'M';
								string_length++;
							}
							else
							{
								for(i = 0; i < power - 1; i++)
								{
									output_string[string_length] = '(';
									string_length++;
								}
								output_string[string_length] = '|';
								string_length++;
								for(i = 0; i < power - 1; i++)
								{
									output_string[string_length] = ')';
									string_length++;
								}
							}
							for(i = 0; i < power; i++)
							{
								output_string[string_length] = '(';
								string_length++;
							}
							output_string[string_length] = '|';
							string_length++;
							for(i = 0; i < power; i++)
							{
								output_string[string_length] = ')';
								string_length++;
							}
						}
						else if(input >= 5 * pow_ten(power + 1))
						{
							input -= 5 * pow_ten(power + 1);

							output_string[string_length] = '|';
							string_length++;
							for(i = 0; i < power; i++)
							{
								output_string[string_length] = ')';
								string_length++;
							}
						}
						else if(input >= 4 * pow_ten(power + 1))
						{
							input -= 4 * pow_ten(power + 1);

							if(power == 2)
							{
								output_string[string_length] = 'M';
								string_length++;
							}
							else
							{
								for(i = 0; i < power - 1; i++)
								{
									output_string[string_length] = '(';
									string_length++;
								}
								output_string[string_length] = '|';
								string_length++;
								for(i = 0; i < power - 1; i++)
								{
									output_string[string_length] = ')';
									string_length++;
								}
							}
							output_string[string_length] = '|';
							string_length++;
							for(i = 0; i < power; i++)
							{
								output_string[string_length] = ')';
								string_length++;
							}
						}
						break;
					}
				}
			}
			else if(input >= 1000)
			{
				input -= 1000;

				output_string[string_length] = 'M';
				string_length++;
			}
			else if(input >= 900)
			{
				input -= 900;

				output_string[string_length] = 'C';
				string_length++;
				output_string[string_length] = 'M';
				string_length++;
			}
			else if(input >= 500)
			{
				input -= 500;

				output_string[string_length] = 'D';
				string_length++;
			}
			else if(input >= 400)
			{
				input -= 400;

				output_string[string_length] = 'C';
				string_length++;
				output_string[string_length] = 'D';
				string_length++;
			}
			else if(input >= 100)
			{
				input -= 100;

				output_string[string_length] = 'C';
				string_length++;
			}
			else if(input >= 90)
			{
				input -= 90;

				output_string[string_length] = 'X';
				string_length++;
				output_string[string_length] = 'C';
				string_length++;
			}
			else if(input >= 50)
			{
				input -= 50;

				output_string[string_length] = 'L';
				string_length++;
			}
			else if(input >= 40)
			{
				input -= 40;

				output_string[string_length] = 'X';
				string_length++;
				output_string[string_length] = 'L';
				string_length++;
			}
			else if(input >= 10)
			{
				input -= 10;

				output_string[string_length] = 'X';
				string_length++;
			}
			else if(input == 9)
			{
				input -= 9;

				output_string[string_length] = 'I';
				string_length++;
				output_string[string_length] = 'X';
				string_length++;
			}
			else if(input >= 5)
			{
				input -= 5;

				output_string[string_length] = 'V';
				string_length++;
			}
			else if(input == 4)
			{
				input -= 4;

				output_string[string_length] = 'I';
				string_length++;
				output_string[string_length] = 'V';
				string_length++;
			}
			else
			{
				input--;

				output_string[string_length] = 'I';
				string_length++;
			}
		} while(input != 0);

		while(GetArgType(top_estack) != END_TAG) /*cleans the arguments of the program
		off the stack*/
		{
			top_estack = next_expression_index(top_estack);
		}
		top_estack--;

		push_expr_quantum(output_string + strlen(output_string + 1) + 1, STR_TAG);

		free(output_string);
	}
	else /*argument was not a string or a positive integer*/
	{
		while(GetArgType(top_estack) != END_TAG) /*cleans the arguments of the program
		off the stack*/
		{
			top_estack = next_expression_index(top_estack);
		}
		top_estack--;

		push_expr_quantum(SYMSTR("Argument must be a string or a positive integer"), STR_TAG);
	}
}

unsigned long pow_ten(char power)
{
	char i;
	unsigned long output = 1;

	for(i = 0; i < power; i++)
	{
		output *= 10;
	}

	return(output);
}
