; Gestion de l'allocation de la memoire

; Liste des fonctions :
;	genalib::init
;	genalib::alloc
;	genalib::free
;	genalib::sort_list
;	genalib::set_sort_list

	xdef	_library
	xdef	_ti89
	xdef	_ti92plus
	
	xdef	genalib@0000
	xdef	genalib@0001
	xdef	genalib@0002
	xdef	genalib@0003
	xdef	genalib@0004
	xdef	genalib@0005
	xdef	genalib@0006
	xdef	genalib@0007
	xdef	genalib@0008
	xdef	genalib@0009
	xdef	genalib@000A
	xdef	genalib@000B

	include "tios.h"


; Bloc Free:
;	taille.w
;	next.l
;	previous.l

; Definition du code de debuggage:
DEBUG_ALLOC	EQU	0
DEBUG_CODE	MACRO
	ifne	DEBUG_ALLOC
		\1
	endif
		ENDM

; Initalisation de la gestion de l'allocation
; In:
;	a0.l -> Debut
;	a1.l -> Fin
; Out:
;	Nothing
; Destroy:
; 	Nothing
genalib@0006:		; gla_init(void *start, void *end);
	move.l	8(a7),a1
	move.l	4(a7),a0
genalib@0000:		; genalib::init:
	movem.l	d0-d7/a0-a6,-(a7)
	
	lea	Alloc_ptr(Pc),a2
	move.l	a0,(a2)+
	move.l	a0,(a2)+
	
	move.l	a1,d0
	sub.l	a0,d0
	lsr.l	#2,d0
	
	lea	Alloc_size(pc),a1
	move.w	d0,(a0)+
	move.l	a1,(a0)+
	move.l	a1,(a0)+

	movem.l	(a7)+,d0-d7/a0-a6
	rts
	
	
; Sentinelle
Alloc_size	dc.w	0	; Taille = 0 pour sentinelle
Alloc_ptr	dc.l	0
Alloc_ptr2	dc.l	0


; Alloue un espace memoire de taille d0.l
; In:
;	d0.l = Taille a allouer
; Out:
;	a0.l -> Buffer de taille suffisante ou NULL
; Destroy:
;	a0
genalib@0007:	;gla_alloc(unsigned long l);
	move.l	4(a7),d0
genalib@0001:	;genalib::alloc:
	movem.l	d0-d2/a1-a2,-(a7)
	
	; Corrige la taille a allouer
	moveq	#8,d1
	cmp.l	d1,d0
	bls.s	\inf
		addq.l	#2,d0	; +2 pout stocker la taille allouee
		bra.s	\done
\inf:		moveq	#10,d0	; Taille la + petite allouable (= Taille buffer de liberation)
\done:	
	
	; Correction pour passer en morceau de 4 (word)
	addq.l	#3,d0
	lsr.l	#2,d0
	
	DEBUG_CODE	<bsr	printorg2>

	moveq	#0,d1

	; Recherche emplacement libre
	move.l	Alloc_ptr(Pc),a0
	bra.s	\test
\loop		move.l	(a0),a0
\test		move.w	(a0)+,d1
		beq.s	\erreur
		cmp.w	d1,d0
		bhi.s	\loop
	; On a trouve un emplacement
	
	; A-t-on la place derriere la zone alloue pour une taille minimale ? (=10 avec taille)
	move.w	d1,d2
	sub.w	d0,d2
	cmp.w	#2,d2		; 3*4 = 12
	bhi.s	\taille_suffisante
		; Correction pointeur
		move.l	(a0)+,a1	; &Ptr.next
		move.l	(a0),6(a1)	; Ptr.next.previous = Ptr.previous
		move.l	(a0),a1		; &Ptr.previous
		move.l	-(a0),2(a1)	; Ptr.previous.next = Ptr.next
		bra.s	\ret

\taille_suffisante:
	move.w	d0,-2(a0)		; Taille du bloc alloue
	lsl.l	#2,d0			; Correction taille
	lea	-2(a0,d0.l),a1		; a1 - Nouveau bloc free
	
	; Taille du nouvau bloc
	move.w	d2,(a1)
	
	; Correction pointeur
	move.l	(a0),a2		; &Ptr.next
	move.l	a1,6(a2)	; Ptr.next.previous = NewPtr
	move.l	a2,2(a1)	; NewPtr.next = Ptr.next
	move.l	4(a0),a2	; &Ptr.previous
	move.l	a1,2(a2)	; Ptr.previous.next = NewPtr
	move.l	a2,6(a1)	; NexPtr.previous = Ptr.previous
	bra.s	\ret
	
\erreur:
	suba.l	a0,a0
\ret	
	DEBUG_CODE	<bsr	print>
	movem.l	(a7)+,d0-d2/a1-a2
	rts


; ReAlloue un espace memoire de taille d0.l
; In:
;	d0.l = Nouvelle Taille
;	a0.l -> Buffer
; Out:
;	a0.l -> Buffer de taille suffisante ou NULL
; Destroy:
;	a0
genalib@0008:	;void *gla_realloc(void *adr, unsigned long size);
	move.l	8(a7),d0
	move.l	4(a7),a0
genalib@0003:	;genalib::realloc:
	movem.l	d0/a1,-(a7)
	
	move.l	a0,a1
	bsr	genalib@0001
	move.l	a0,d0
	beq.s	\ret
		; Copie
		move.l	a0,-(a7)
		move.l	a1,-(a7)

		move.w	-2(a0),d0
\loop:			move.l	(a1)+,(a0)+
			dbf	d0,\loop
		move.l	(a7)+,a0
		bsr.s	genalib@0002
		move.l	(a7)+,a0
\ret:
	movem.l	(a7)+,d0/a1
	rts


; Libere un espace memoire.
; In:
;	a0 -> Espace memoire
; Out:
;	Nothing
; Destroy:
;	Nothing
genalib@0009:	; gla_free(void *adr);
	move.l	4(a7),a0
genalib@0002:	;genalib::free:
	movem.l	d0-d2/a0-a2,-(a7)

	move.l	a0,d0
	beq	\quit	; Pointeur null
	
	DEBUG_CODE	<bsr	printorg>
	
	moveq	#0,d0
	moveq	#0,d2
	move.w	-(a0),d0
	
	; Pb si emplacement deja free ?

	; Recherche emplacement libre
	move.l	Alloc_ptr(Pc),a1
	lea	2(a1),a2
	; Test avant
	cmp.l	a0,a1
	beq	\quit				; Deja libere
	bls.s	\test
		lea	Alloc_ptr(pc),a2	; Fusion avant
		bra.s	\fusion2

	; Recherche emplacement libre
\loop		move.l	a1,a2
		move.l	(a1),a1
		cmp.l	a0,a1
		beq	\quit			; Cas ou c deja alloue
		bhi.s	\find
\test		move.w	(a1)+,d2
		bne.s	\loop
	; Erreur
	move.w	-2(a2),d2
	; Hum, c pas quoi faire dans ce cas la...
	; Pb cas ou la zone allouee est avant tout le monde
\find:
	; Test fusion 1
	lsl.l	#2,d2
	lea	-2(a2,d2.l),a1
	cmp.l	a0,a1
	bne.s	\fusion2
		ifne	DEBUG_ALLOC
			pea	fusion1(pc)
			bsr	cprint
			addq.l	#4,a7
		endif
		
		; La c facile : les deux espaces sont colles, l'un a l'autre.
		; Fusion de Ptr a a0
		add.w	d0,-2(a2)	; On augmente la taille de l'espace alloue
		
		; Test fusion current.next a ptr
		lsl.l	#2,d0
		lea	0(a0,d0.l),a1
		cmp.l	(a2),a1		; Ptr + Size = Current.next ?
		bne.s	\quit
			move.w	(a1)+,d0
			add.w	d0,-(a2)
			move.l	(a1),2(a2)	; Current.next = Current.next.next
			bra.s	\quit
\fusion2
	; Test fusion 2
	lsl.l	#2,d0
	lea	0(a0,d0.l),a1
	cmp.l	(a2),a1			; Ptr + Size = Current.next ?
	bne.s	\no2
		ifne	DEBUG_ALLOC
			pea	fusion2(pc)
			bsr	cprint
			addq.l	#4,a7
		endif
		; Fusion de Current.next a Ptr
		move.w	(a1)+,d0
		add.w	d0,(a0)		; On augmente la taille allouable
		move.l	(a1)+,a2
		move.l	a2,2(a0)	; Ptr.next = (Current.Next).next
		move.l	a0,6(a2)	; Current.next.next.previous = Ptr
		move.l	(a1)+,a2
		move.l	a2,6(a0)	; Ptr.previous = (Current.next).previous
		move.l	a0,2(a2)	; Current.next.previous.next = Ptr
		bra.s	\quit
\no2:	
		ifne	DEBUG_ALLOC
			pea	fusion0(pc)
			bsr	cprint
			addq.l	#4,a7
		endif
	; Nouveau bloc de libre
	move.l	(a2),a1			; Current.next
	move.l	a0,6(a1)		; Current.next.previous = Ptr
	move.l	a1,2(a0)		; Ptr.next = Current.next
	move.l	a0,(a2)			; Current.next = Ptr
	subq.l	#2,a2
	move.l	a2,6(a0)		; Ptr.previous = Current
\quit:
	DEBUG_CODE	<bsr	print>

	movem.l	(a7)+,d0-d2/a0-a2
	rts
		

; Sort a list.
; Warning: You should call set_sort_list first !
; In:
;	a0 -> List
; Out:
;	a0 -> Sorted List
; Destroy:
;	a0
genalib@000A:
	move.l	4(a7),a0
genalib@0004:	;genalib::sort_list:
	; Sauvegarde param
	movem.l	d0-d1/a1-a2,-(a7)
	move.l	a0,d0
	beq.s	\r
		bsr.s	SortList
\r	movem.l	(a7)+,d0-d1/a1-a2
	rts	
	

; Update the code of sorting of SortList
; Input:
;	d0.w = Size (0: Byte, 1: Word, 2: Long)
;	d1.w = Offset from the beginning of a element of the list (excluding the 'next adress')
;	d2.w = Way of sorting (GLA_INC_U, GLA_DEC_U, GLA_INC_S, GLA_DEC_S)
; Out / Return:
;	Nothing
genalib@000B:	; void	gla_set_sort_list(short size, short offset, short way_of_sorting);
	move.w	8(a7),d2
	move.w	6(a7),d1
	move.w	4(a7),d0
genalib@0005:
	movem.l	d0-d7/a0-a6,-(a7)
	; Default : byte
	move.w	#$1229,d3
	move.w	#$B228,d4
	addq.w	#4,d1
	subq.w	#1,d0
	bne.s	\no_word
		move.w	#$3229,d3
		move.w	#$B268,d4
\no_word
	subq.w	#2,d0
	bne.s	\no_long
		move.w	#$2229,d3
		move.w	#$B2A8,d4
\no_long:
	lea	SL_test1(Pc),a0
	bsr.s	update_code
	lea	SL_test2(Pc),a0
	bsr.s	update_code
	movem.l	(a7)+,d0-d7/a0-a6
	rts

; A0 -> Code a modifier
; d3.w = Taille1 00(byte), 01 word, 10 long
; d4.w = Taille2
; d1.w = Offset (corrigee)
; d2.w = Tri comment
update_code:
	move.w	d3,(a0)+	; move.bwl n(a1),d1
	move.w	d1,(a0)+	; Offset
	move.w	d4,(a0)+	; cmp.lbwl n(a1),d1
	move.w	d1,(a0)+	; Offset
	move.w	(a0),d0
	andi.w	#$F0FF,d0
	or.w	d2,d0
	move.w	d0,(a0)
	rts

SortList:
	move.l	(a0),d0
	beq.s	SL_ret		; 1 element
	
	move.l	d0,a1
	move.l	(a1),d0
	bne.s	SL_long
		; Seulement 2 elements
SL_test1	move.w	4(a1),d1
		cmp.w	4(a0),d1
		bcc.s	SL_ret		; Ok deja dans le bon ordre
			move.l	a0,(a1)
			move.l	d0,(a0)	; d0 = 0 !
			move.l	a1,a0
			bra.s	SL_ret
SL_long:
	; Separe en 2 listes
	move.l	a0,-(a7)
	move.l	a1,-(a7)

\loop_cut:
		; L1 ->next = L2  -> next
		move.l	(a1),a2
		move.l	a2,(a0)
		; L1 = L1-> next
		move.l	a2,a0
		; Tant que L1 != NULL
		move.l	a0,d0
		beq.s	\stop

		; L2 ->next = L2 -> next -> next
		move.l	(a2),d0
		move.l	d0,(a1)			
		; L2 = L2-> next
		move.l	d0,a1
		; et L2 != NULL
		move.l	a1,d0
		bne.s	\loop_cut
		bra.s	\done
\stop:
	move.l	d0,(a1)	; Fin de liste L1
\done:
	; Tri chacune des listes
	move.l	(a7)+,a0
	bsr	SortList
	move.l	(a7),a1
	move.l	a0,(a7)
	move.l	a1,a0
	bsr	SortList
	move.l	(a7)+,a1

	; Les 2 listes a0 et a1 sont triees.
	; Fusion des 2 listes triees.
	
	; 1er element
	subq.l	#4,a7
	move.l	a7,a2
	
	; On fusionne les 2 listes
SL_loop_fusion
SL_test2:
	move.w	4(a1),d1
	cmp.w	4(a0),d1
	bcc.s	\fa0
		move.l	a1,(a2)		; L -> next = L1
		move.l	a1,a2		; L = L1
		move.l	(a1),a1		; L1 = L1 -> next
		move.l	a1,d0
		bne.s	SL_loop_fusion
			move.l	a0,(a2)
			bra.s	\fin
\fa0:				
		move.l	a0,(a2)		; L -> next = L1
		move.l	a0,a2		; L = L1
		move.l	(a0),a0		; L1 = L1 -> next
		move.l	a0,d0
		bne.s	SL_loop_fusion
			move.l	a1,(a2)
\fin
	move.l	(a7)+,a0
SL_ret	rts









	ifne	DEBUG_ALLOC
	include "genlib.h"

printorg
	movem.l	d0-d7/a0-a6,-(a7)
	move.l	d0,-(a7)
	pea	free_str(pc)
	pea	Tampon(pc)
	jsr	tios::sprintf
	lea	(4*3)(a7),a7
	lea	Tampon(pc),a0
	bsr	console::print
	movem.l	(a7)+,d0-d7/a0-a6
	rts
	
printorg2
	movem.l	d0-d7/a0-a6,-(a7)
	move.l	d0,-(a7)
	pea	alloc_str(pc)
	pea	Tampon(pc)
	jsr	tios::sprintf
	lea	(4*3)(a7),a7
	lea	Tampon(pc),a0
	bsr	console::print
	movem.l	(a7)+,d0-d7/a0-a6
	rts

print:
	movem.l	d0-d7/a0-a6,-(a7)

	moveq	#0,d7
	lea	Alloc_size(pc),a5
	move.l	a5,a6
\loop	move.l	2(a6),a6
	cmp.l	a5,a6
	beq.s	\stop
		move.l	6(a6),-(a7)
		move.l	2(a6),-(a7)
		move.w	(a6),d7
		move.l	d7,-(a7)
		move.l	a6,-(a7)
		pea	chaine_str(pc)
		pea	Tampon(pc)
		jsr	tios::sprintf
		lea	(6*4)(a7),a7
		lea	Tampon(pc),a0
		bsr	console::print
		bra.s	\loop
\stop
	movem.l	(a7)+,d0-d7/a0-a6
	rts

fusion0		dc.b	"No Fusion",0
fusion1		dc.b	"Fusion 1",0
fusion2		dc.b	"Fusion 2",0
alloc_str	dc.b	"Alloc: %04lx",0
free_str	dc.b	"Free: %06lx",0
chaine_str	dc.b	":%06lx %04lx %06lx %06lx",0
Tampon		ds.b	256
	even
cprint
	move.l	a0,-(a7)
	move.l	(4+4)(a7),a0
	bsr.s	console::print
	move.l	(a7)+,a0
	rts
	
; Affiche une chaine de caractere a l'endroit courant sur l'ecran
; Scrolle si necessaire.
; Input : a0 -> String
console::print:
	movem.l	d0-d2/a1,-(a7)
	move.w	Current_y,d1
	moveq	#4,d2
	add.w	#10,d1
	cmp.w	#LCD_HEIGHT-10,d1
	blt.s	\ok
		move.l	#LCD_MEM,a1
		move.w	#960-30*10/4-1,d0
\Loop:			move.l	30*10(a1),(a1)+
			dbra	d0,\Loop
		move.w	#30*10/4-1,d0
\loop2:			clr.l	(a1)+
			dbra	d0,\loop2
		move.w	#LCD_HEIGHT-10,d1
;		bra.s	\print
\ok:	move.w	d1,Current_y
\print:
	moveq	#0,d0

	movem.l	d0-d2/a0-a1,-(a7)
	move.w	#4,-(a7)
	move.l	a0,-(a7)
	move.w	d1,-(a7)
	move.w	d0,-(a7)
	jsr	tios::DrawStrXY
	lea     10(a7),a7

        move.w  #1,-(sp)        		; Sp -= 2
        jsr     tios::FontSetSys 
	addq.l	#2,a7

	movem.l	(a7)+,d0-d2/a0-a1

	move.w	Current_stop,d2
	subq.w	#1,d2
	bne.s	\cont
		moveq	#10,d2
		jsr	genlib::wait_a_key
\cont	move.w	d2,Current_stop

	movem.l	(a7)+,d0-d2/a1
	rts

Current_y	dc.w	0
Current_stop	dc.w	10

	endif
	
	end
				

	