//	TstAlloc.c

#include <doors.h>
#include <all.h>

#include "genc.h"		// For timer & key only ;)
#include "gla.h"		// Alloc & List functions

#define	N 500			// Number of elements of the list
#define N_STR "1500"		// String

int	_ti92plus,_ti89;	// Compile for both 89 & 92+

int	_main()
{
	void	*a;		// Void ptr. Basic usage
	unsigned short i;	// Index of loop
	unsigned short rand;	// Random value
	LIST	*L = NULL;	// List
	char	buffer[100];	// Buffer for sprintf
	
	gl_init();		// Init Genlib
	gl_set_LCD_MEM();	// Init LCD_MEM int
	
	gl_put_small_string((SCREEN *) LCD_MEM, 0,0, "Sorting list of "N_STR" elements");
	gl_put_small_string((SCREEN *) LCD_MEM, 0,6, "You should not have too many files on your calc!");

	gla_list_set(1,0,GLA_INC_U);	// Sort of unsigned short value in inc mode

	// Test with malloc
	gl_put_small_string((SCREEN *) LCD_MEM, 0,20, "Test with malloc...");
	
	gl_timer = 0;		// Set timer to 0
	
	// Create the list (Slow !)
	L = NULL;
	rand = 1378;
	for( i = 0; i < N ; i++)
		{
		a = malloc(4+2);
		*((LIST **) a) = L;
		*((unsigned short *) (a + 4)) = rand;
		L = a;
		rand = (rand + 103 ) * 13711;
		}
	// Sorting (Fast !)
	L = gla_list_sort(L);

	// Free the list
	while (L)
		{
		a = (void *) *((LIST **) L);
		free(L);
		L = (LIST *) a;	
		}
	sprintf(buffer,"Tios time =%ld",gl_timer);
	gl_put_small_string((SCREEN *) LCD_MEM, 0,26, buffer);

	//asm("__stop: bra.s __stop");
	
	// Test with GenAlib
	gl_put_small_string((SCREEN *) LCD_MEM, 0, 40, "Test with GenAlib...");

	// Init Genalib
	// Alloc a big block for use with genalib
	a = malloc( GLA_ALLOC_MIN_SIZE * (N+1));
	// Set this block as the block to use for allocation
	gla_init(a, a + GLA_ALLOC_MIN_SIZE*(N+1));
		
	gl_timer = 0;
	L = gla_list_new();
	rand = 1378;
	// Allocation
	for( i = 0 ; i < N ; i++)
		{
		L = gla_list_add(L, sizeof(short));
		*(unsigned short *) gla_list_top(L) = rand;
		rand = (rand + 103 ) * 13711;
		}
	// Sorting
	L = gla_list_sort(L);
	// Free
	gla_list_del(L);
	
	sprintf(buffer,"GenAlib time =%ld",gl_timer);
	gl_put_small_string((SCREEN *) LCD_MEM, 0,46, buffer);

	// Free the big block
	free(a);
	gl_wait_a_key();	// Wait for a key
	gl_quit();		// Quit genlib
}
