
	include "tios.h"
	include "macros.h"
	include "genalib.h"
	
	xdef	_main
	xdef	_comment
	
	xdef	_ti89
	xdef	_ti92plus

ALLOC_SIZE	EQU	30000
LIST_SIZE	EQU	ALLOC_SIZE/GLA_ALLOC_MIN_SIZE
	
_main
	; Alloc mem
	pea	(ALLOC_SIZE).w
	jsr	tios::HeapAlloc		; Alloc from Ti alloc func
	addq.l	#4,a7
	move.w	d0,-(a7)
	
	; Init GenAlib
	DEREF	d0,a0			; Beginning
	lea	ALLOC_SIZE(a0),a1	; End
	jsr	genalib::init		; Init GenAlib
	
	jsr	tios::ScreenClear	; Clear Screen
	
	; Some Tests (Usefull for debugging theses functions)
	moveq	#100,d0
	jsr	genalib::alloc	; Alloc 100 bytes
	move.l	a0,a1
	moveq	#50,d0
	jsr	genalib::alloc
	move.l	a0,a2
	moveq	#1,d0
	jsr	genalib::alloc
	move.l	a0,a3
	move.l	#1005,d0
	jsr	genalib::alloc
	move.l	a0,a4
	moveq	#8,d0
	jsr	genalib::alloc
	jsr	genalib::free		; free dernier
	move.l	a2,a0
	jsr	genalib::free		; 2
	move.l	a3,a0
	jsr	genalib::free		; 3em => fusion
	suba.l	a0,a0
	jsr	genalib::free
	move.l	a1,a0
	jsr	genalib::free		; 1er => fusion
	move.l	a4,a0
	jsr	genalib::free
	; End of basic tests


	; Use of lists
	move.w	#LIST_SIZE-1,d7			; 10 
	move.w	#1378,d5		; Random value
	genalib::list_new	a5	; New list
\loop:
		genalib::list_add	a5,#2,quit	; Alloc a new element of size 2 and add it to the list
		genalib::list_top	a5,a0		; Get the first element from the list
		move.w	d5,(a0)				; Write the random value
		add.w	#103,d5				; Generate a new
		mulu.w	#13711,d5			; "random" value
		dbf	d7,\loop			; Add all the elements

	genalib::list_size	a5,d1			; Size of the list (== LIST_SIZE)
	genalib::list_sub	a5			; Delete the second element of the list
	genalib::list_size	a5,d1			; ReSize of the list: (== LIST_SIZE-1)

	moveq	#1,d0		; Sort Word
	moveq	#0,d1		; First 
	move.w	#GLA_INC_U,d2	; Sort 'U'nsigned words by increasing order
	jsr	genalib::list_set

	WriteStr	#0,#0,#4,sort_str
	move.l	a5,a0
	jsr	genalib::list_sort			; Sort the list (FAST).
	move.l	a0,a5					; Restore the list

	WriteStr	#0,#10,#4,free_str
	genalib::list_del	a5			; Free the lists

quit
	jsr	tios::HeapFree
	addq.l	#2,a7
	rts
	
_comment:	dc.b	"Example of GenAlib",0
sort_str	dc.b	"Sort of 2499 elements...",0
free_str	dc.b	"Free list (Worst case)...",0

	end
	