/*
 *
 *	GenALib
 *
 *	Ti-Gcc Header file
 *
 */


#ifndef	__GENALIB

#define	__GENALIB

typedef	struct _list LIST;

// Minimun size we can alloc
#define	GLA_ALLOC_MIN_SIZE	12

// Const for sorting lists
#define	GLA_INC_U	0x500		// 0b0101*256	//; bcs : 0101	<	u
#define	GLA_DEC_U	0x200		// 0b0010*256	//; bhi : 0010	>	u
#define	GLA_INC_S	0xD00		// 0b1101*256	//; blt : 1101	<	s
#define	GLA_DEC_S	0xE00		// 0b1110*256	//; bgt : 1110	>	s

// Functions
#define	gla_init	genalib__0006
#define	gla_alloc	genalib__0007
#define	gla_realloc	genalib__0008
#define	gla_free	genalib__0009
#define	gla_list_sort	genalib__000A
#define	gla_list_set	genalib__000B

void	gla_init(void *start, void *end);
void	*gla_alloc(unsigned long size);
void	*gla_realloc(void *address, unsigned long size);
void	gla_free(void *address);
LIST	*gla_list_sort(LIST *list);
void	gla_list_set(short size, short offset, short way);

/* Create a new empty List */
#define	gla_list_new()		((LIST *) NULL)

/* Acces data /*/
#define	gla_list_top(_list)	((void *) _list + 4)
#define	gla_list_tail(_list)	(*( (LIST **) (_list) ))
#define gla_list_empty(_list)	(_list == NULL)

/* Free a list */
void	gla_list_del(register LIST *l)
	{
	register LIST *p;
	while (l)
	 {
	 p = l;
	 l = gla_list_tail(l);
	 gla_free(p); 
	 }
	}
	
/* Add one element to a list */
LIST	*gla_list_add(register LIST *list,register unsigned short s)
	{
	 register LIST *pt = (LIST *) gla_alloc(s+4);
	 if (pt) gla_list_tail(pt) = list;
	 return pt;
	}

/* Free the second element of a list */
LIST	*gla_list_sub(register LIST *l)
	{
	register LIST *p = gla_list_tail(l);
	if (l && p)
	 {
	  gla_list_tail(l) = gla_list_tail(p);
	  gla_free(p);
	 }
	return l;
	}
	
#endif
