#define TI89_VERSION 1
#define INCLUDE_HELP

#if TI89_VERSION == 1
#define USE_TI89
#define calc(x, y) (x)
#else
#define USE_TI92PLUS
#define USE_V200
#define calc(x, y) (y)
#endif

#include <tigcclib.h>

#define RANDOM_STRENGTH 4

#include "extrand.h"
#include "extgraph.h"

#define VERSION_MAJOR 2
#define VERSION_MINOR 1

static void DrawPic(short, short, short);
static void Scramble(short[][11]);
static void DoMove(short[][11], short);
static void UnScramble(short[][11], short[][11]);
static void MainMenu(short[][11], short[][11]);
static void PrintTime(void);
static void Pause(void);

#ifdef INCLUDE_HELP
static void ShowHelp(short[][11], short[][11]);
#endif

static void PlayGame(short[][11], short[][11]);

volatile struct
{
	char ms : 6;
	unsigned short sec : 6, min : 7;
} Time = {-1, 0, 0};

DEFINE_INT_HANDLER(Int5Timer) /*this handles the timing of the game*/
{
	if(Time.ms != -1)
	{
		Time.ms++;
		if(Time.ms == 19)
		{
			Time.ms = 0;
			Time.sec++;
			if(Time.sec == 60)
			{
				Time.sec = 0;
				Time.min++;
			}
			PrintTime();
		}
	}
}

void _main(void)
{
	short grid[6][11] = {{1}, {1, 1, 1}, {1, 1, 1, 1, 1}, {2, 3, 3, 3, 3, 3, 4}, {2, 2, 2,
	3, 3, 3, 4, 4, 4}, {2, 2, 2, 2, 2, 3, 4, 4, 4, 4, 4}};
	short grid_win[6][11];
	short old_font;
	INT_HANDLER OldInt1;
	INT_HANDLER OldInt5;
	LCD_BUFFER buffer;

	FastCopyScreen_R(LCD_MEM, buffer);

	memcpy(&grid_win, &grid, sizeof(grid)); /*copy the origional to the duplicate*/

	randomize_long(); /*randomize the random number generator*/
	old_font = FontSetSys(F_4x6); /*set the font to 4x6*/
	OldInt1 = GetIntVec(AUTO_INT(1)); /*save the location of int 1*/
	OldInt5 = GetIntVec(AUTO_INT(5)); /*save the location of int 5*/
	SetIntVec(AUTO_INT(1), DUMMY_HANDLER); /*turn off status line indidcators*/
	SetIntVec(AUTO_INT(5), Int5Timer); /*"hook" in the custom timer*/

	MainMenu(grid, grid_win);

	FontSetSys(old_font); /*set the font back to what it was*/
	SetIntVec(AUTO_INT(1), OldInt1); /*turn the status line stuff back on*/
	SetIntVec(AUTO_INT(5), OldInt5); /*set int 5 back up*/

	FastCopyScreen_R(buffer, LCD_MEM);
	ST_helpMsg(EXTGRAPH_VERSION_PWDSTR);
}

void DrawPic(short x, short y, short type)
{
	#include "sprites.h"
	/*formulas to put the graphics in the right spot*/
	short xx = calc(69, 109) + 12 * (x - y), yy = calc(27, 55) + 12 * y;

	switch(type) /*which picture to do*/
	{
		case 1:
		if(x % 2) /*if the x coordinate is odd, then need to put the graphic upside down*/
		{
			Sprite32_XOR_R(xx, yy, 12, stone_down, LCD_MEM);
		}
		else
		{
			Sprite32_XOR_R(xx, yy, 12, stone_up, LCD_MEM);
		}
		break;

		case 2:
		if(x % 2)
		{
			Sprite32_XOR_R(xx, yy, 12, fish_down, LCD_MEM);
		}
		else
		{
			Sprite32_XOR_R(xx, yy, 12, fish_up, LCD_MEM);
		}
		break;

		case 3:
		if(x % 2)
		{
			Sprite32_XOR_R(xx, yy, 12, plus_down, LCD_MEM);
		}
		else
		{
			Sprite32_XOR_R(xx, yy, 12, plus_up, LCD_MEM);
		}
		break;

		case 4:
		if(x % 2)
		{
			Sprite32_XOR_R(xx, yy, 12, checkered_down, LCD_MEM);
		}
		else
		{
			Sprite32_XOR_R(xx, yy, 12, checkered_up, LCD_MEM);
		}
		break;

		case 5:
		if(x % 2)
		{
			Sprite32_XOR_R(xx, yy, 12, gray_down, LCD_MEM);
		}
		else
		{
			Sprite32_XOR_R(xx, yy, 12, gray_up, LCD_MEM);
		}
	}
}

void Scramble(short grid[][11])
{
	short i;
	short last = -1;
	short move;

	for(i = 0; i < 36; i++) /*do 36 moves*/
	{
		do
		{
			move = random_long(8);
		} while((last == move || (last ^ 1) == move) && last != -1);

		last = move;

		DoMove(grid, move);
	}

	for(i = 0; i < 4; i++) /*randomly tweak the four inner parts (very
	easy to solve)*/
	{
		DoMove(grid, 8 + i * 2 + random_long(2));
	}
}

void DoMove(short grid[][11], short move)
{
	char temp[3];
	short i;
	static short big_x[8][9] = {{2, 1, 0, 0, 1, 2, 8, 9, 8}, {0, 1, 2, 8, 9, 8, 2, 1, 0},
	{0, 1, 2, 3, 2, 3, 2, 1, 0}, {0, 1, 2, 3, 2, 3, 2, 1, 0}, {2, 3, 2, 3, 4, 5, 6, 7, 8},
	{8, 7, 6, 5, 4, 3, 2, 3, 2}, {8, 7, 6, 5, 4, 3, 2, 3, 2}, {2, 3, 2, 3, 4, 5, 6, 7,
	8}};
	static short big_y[8][9] = {{1, 1, 1, 4, 5, 5, 5, 5, 4}, {1, 1, 1, 4, 5, 5, 5, 5, 4},
	{4, 4, 4, 4, 3, 3, 2, 2, 1}, {1, 2, 2, 3, 3, 4, 4, 4, 4}, {1, 2, 2, 3, 3, 4, 4, 4, 4},
	{4, 4, 4, 4, 3, 3, 2, 2, 1}, {5, 5, 4, 4, 4, 4, 4, 5, 5}, {5, 5, 4, 4, 4, 4, 4, 5,
	5}};
	static short small_x[8][3] = {{0, 0, 10}, {0, 10, 0}, {0, 1, 0}, {0, 1, 0}, {4, 5, 6},
	{6, 5, 4}, {6, 5, 4}, {4, 5, 6}};
	static short small_y[8][3] = {{0, 5, 5}, {0, 5, 5}, {3, 3, 2}, {2, 3, 3}, {2, 3, 3},
	{3, 3, 2}, {5, 5, 5}, {5, 5, 5}};


	if(move < 8) /*if not moving just the inner part*/
	{
		for(i = 0; i < 3; i++) /*put the first three grid entries in temporary storage*/
		{
			temp[i] = grid[big_y[move][i]][big_x[move][i]];
		}
		for(i = 0; i < 6; i++) /*rotate the grid entries and change the pictures*/
		{
			DrawPic(big_x[move][i], big_y[move][i], grid[big_y[move][i]][big_x[move][i]]);
			grid[big_y[move][i]][big_x[move][i]] = grid[big_y[move][i + 3]][big_x[move][i
			+ 3]];
			DrawPic(big_x[move][i], big_y[move][i], grid[big_y[move][i]][big_x[move][i]]);
		}
		for(i = 6; i < 9; i++) /*put the grid entries in temporary
		storage back where they belong*/
		{
			DrawPic(big_x[move][i], big_y[move][i], grid[big_y[move][i]][big_x[move][i]]);
			grid[big_y[move][i]][big_x[move][i]] = temp[i - 6];
			DrawPic(big_x[move][i], big_y[move][i], grid[big_y[move][i]][big_x[move][i]]);
		}
	}
	else /*if just doing the inner part*/
	{
		move -= 8; /*shift the index*/
	}

	/*put one grid entry in temporary storage*/
	temp[0] = grid[small_y[move][0]][small_x[move][0]];
	for(i = 0; i < 3; i++) /*rotate the grid entries*/
	{
		DrawPic(small_x[move][i], small_y[move][i],
		grid[small_y[move][i]][small_x[move][i]]);
		grid[small_y[move][i]][small_x[move][i]] = grid[small_y[move][i +
		1]][small_x[move][i + 1]];
		DrawPic(small_x[move][i], small_y[move][i],
		grid[small_y[move][i]][small_x[move][i]]);
	}
	DrawPic(small_x[move][2], small_y[move][2], grid[small_y[move][2]][small_x[move][2]]);

	/*put the temporary storage back where it belongs*/
	grid[small_y[move][2]][small_x[move][2]] = temp[0];

	DrawPic(small_x[move][2], small_y[move][2], grid[small_y[move][2]][small_x[move][2]]);
}

void UnScramble(short grid[][11], short grid_win[][11])
{
	short ok = TRUE;
	short second = 0;

	Time.ms = 0; /*start the timer*/
	PrintTime();
	do
	{
		if(_rowread(0xFFFE)&calc(16, 1)) /*if [2nd] pressed*/
		{
			second ^= 8;
			DrawPic(-6, -2, 5);
			DrawPic(-5, -2, 5);
			DrawPic(-5, -1, 5);
			while(_rowread(0xFFFE)&calc(16, 1)); /*wait until [2nd] not pressed*/
		}

		if(_rowread(calc(0xFFEF, 0xFDFF))&calc(1, 32)) /*[0]*/
		{
			DoMove(grid, second);
			while(_rowread(calc(0xFFEF, 0xFDFF))&calc(1, 32)); /*wait until [0] not
			pressed*/
		}
		if(_rowread(calc(0xFFEF, 0xFFFD))&calc(2, 32)) /*[1]*/
		{
			DoMove(grid, second + 1);
			while(_rowread(calc(0xFFEF, 0xFFFD))&calc(2, 32));
		}
		if(_rowread(calc(0xFFEF, 0xFFFB))&calc(4, 32)) /*[4]*/
		{
			DoMove(grid, second + 3);
			while(_rowread(calc(0xFFEF, 0xFFFB))&calc(4, 32));
		}
		if(_rowread(calc(0xFFEF, 0xFFF7))&calc(8, 32)) /*[7]*/
		{
			DoMove(grid, second + 2);
			while(_rowread(calc(0xFFEF, 0xFFF7))&calc(8, 32));
		}
		if(_rowread(calc(0xFFF7, 0xFFFB))&calc(4, 64)) /*[5]*/
		{
			DoMove(grid, second + 5);
			while(_rowread(calc(0xFFF7, 0xFFFB))&calc(4, 64));
		}
		if(_rowread(0xFFF7)&calc(8, 64)) /*[8]*/
		{
			DoMove(grid, second + 4);
			while(_rowread(0xFFF7)&calc(8, 64));
		}
		if(_rowread(0xFFFB)&calc(4, 128)) /*[6]*/
		{
			DoMove(grid, second + 7);
			while(_rowread(0xFFFB)&calc(4, 128));
		}
		if(_rowread(calc(0xFFFB, 0xFFF7))&calc(8, 128)) /*[9]*/
		{
			DoMove(grid, second + 6);
			while(_rowread(calc(0xFFFB, 0xFFF7))&calc(8, 128));
		}

		if(_rowread(calc(0xFFBF, 0xFEFF))&calc(1, 64)) /*if [ESC] pressed*/
		{
			Time.ms = -1; /*stop the timer*/
			Time.sec = 0; /*and reset it*/
			Time.min = 0;

			ok = FALSE;
			while(_rowread(calc(0xFFBF, 0xFEFF))&calc(1, 64));
		}

		if(!memcmp(grid, grid_win, 132)) /*see if the puzzle is unscrambled*/
		{
			Time.ms = -1; /*stop the timer*/
			Time.sec = 0; /*and reset it*/
			Time.min = 0;

			calc(
			{
				FastFilledRect_Erase_R(LCD_MEM, 7, 2, 57, 27); /*erase the second indicator on 89*/
			}, {});

			FontSetSys(F_8x10);
			DrawStr(calc(46, 86), 0, "YOU WON!", A_REPLACE);
			FontSetSys(F_4x6);
			DrawStr(0, 10, "Press [2nd] to continue.", A_NORMAL);
			Pause();
			return;
		}
	} while(ok);
	FastFilledRect_Erase_R(LCD_MEM, calc(142, 222), 0, calc(159, 239), 5);
}

void MainMenu(short grid[][11], short grid_win[][11])
{
	char buffer[14]; /*a buffer for sprintf*/
	short go_on = 0; /*go_on is 0 for nothing pressed, 1 for [2nd] pressed, 2 for [F1]
	pressed, & 3 for [ESC] pressed*/

	do
	{
		ClrScr();
		sprintf(buffer, "Triaminx v%d.%d", VERSION_MAJOR, VERSION_MINOR);
		DrawStr((calc(160, 240) - DrawStrWidth(buffer, F_4x6)) / 2, 0, buffer, A_NORMAL);
		DrawStr(calc(52, 92), 6, "By Peter J. Rowe", A_NORMAL);
		DrawStr(calc(49, 89), 12, "mig53@yahoo.com", A_NORMAL);

		#ifdef INCLUDE_HELP
		DrawStr(0, 30, "Press [F1] for help or press [2nd] to start.", A_NORMAL);
		#else
		DrawStr(0, 30, "Press [2nd] to start.", A_NORMAL);
		#endif

		DrawStr(0, 36, "Press [ESC] to quit.", A_NORMAL);

		do
		{
			if(_rowread(0xFFFE)&calc(16, 1)) /*[2nd]*/
			{
				go_on = 1;
			}

			#ifdef INCLUDE_HELP
			if(_rowread(calc(0xFFDF, 0xFFBF))&calc(128, 16)) /*[F1]*/
			{
				go_on = 2;
			}
			#endif

			if(_rowread(calc(0xFFBF, 0xFEFF))&calc(1, 64)) /*[ESC]*/
			{
				go_on = 3;
				while(_rowread(calc(0xFFBF, 0xFEFF))&calc(1, 64));
			}
		} while(!go_on);

		#ifdef INCLUDE_HELP
		switch(go_on)
		{
			case 2: /*show help*/
			ShowHelp(grid, grid_win);
			/*Fall through*/

			case 1: /*play the actual game*/
		#else
		if(go_on == 1)
		{
		#endif

			PlayGame(grid, grid_win);

			go_on = 0;

		}
	} while(go_on != 3); /*loop until [ESC] pressed */
}

void PrintTime(void)
{
	char buffer[6];

	sprintf(buffer, "%02u:%02u", Time.min, Time.sec);
	DrawStr(calc(160, 240) - DrawStrWidth(buffer, F_4x6), 0, buffer, A_REPLACE);
}

void Pause(void)
{
	while(_rowread(0)); /*wait until all keys not pressed*/
	while(!_rowread(0)); /*wait until a key pressed*/
	while(_rowread(0)); /*wait until all keys not pressed*/
}

#ifdef INCLUDE_HELP
void ShowHelp(short grid[][11], short grid_win[][11])
{
	short x;
	short y;

	memcpy(grid, grid_win, 132);

	ClrScr();

	FastLine_Draw_R(LCD_MEM, calc(7, 47), calc(99, 127), calc(80, 120), calc(26, 54));
	FastLine_Draw_R(LCD_MEM, calc(80, 120), calc(26, 54), calc(153, 193), calc(99, 127));
	FastLine_Draw_R(LCD_MEM, calc(153, 193), calc(7, 47), calc(99, 127), calc(7, 47));

	for(y = 0; y < 6; y++)
	{
		for(x = 0; x < 2 * y + 5; x++)
		{
			DrawPic(x, y, grid[y][x]);
		}
	}
	FastFilledRect_Erase_R(LCD_MEM, calc(155, 195), calc(75, 103), calc(159, 227), calc(80, 114));

	DrawStr(0, 0, "The controls are the number keys, except for", A_NORMAL);
	DrawStr(0, 6, "[2] and [3], and the [2nd] key.  Here is a", A_NORMAL);
	DrawStr(0, 12, "demonstration of what the keys do.  Press", A_NORMAL);
	DrawStr(0, 18, "[2nd] to continue.", A_NORMAL);
	Pause();
	FastFilledRect_Erase_R(LCD_MEM, 1, 0, 155, 25);

	DrawStr(0, 12, "Press [2nd] to continue.", A_NORMAL);
	DrawStr(0, 0, "Key [0]", A_NORMAL);
	DoMove(grid, 0);
	Pause();
	DrawStr(0, 6, "Key [1]", A_NORMAL);
	DoMove(grid, 1);
	Pause();
	DrawStr(45, 0, "Key [7]", A_NORMAL);
	DoMove(grid, 2);
	Pause();
	DrawStr(45, 6, "Key [4]", A_NORMAL);
	DoMove(grid, 3);
	Pause();
	DrawStr(90, 0, "Key [8]", A_NORMAL);
	DoMove(grid, 4);
	Pause();
	DrawStr(90, 6, "Key [5]", A_NORMAL);
	DoMove(grid, 5);
	Pause();
	DrawStr(135, 0, "Key [9]", A_NORMAL);
	DoMove(grid, 6);
	Pause();
	DrawStr(135, 6, "Key [6]", A_NORMAL);
	DoMove(grid, 7);
	Pause();

	FastFilledRect_Erase_R(LCD_MEM, 1, 0, 159, 11);
	DrawStr(0, 0, "Also, if you press [2nd], it will only do the", A_NORMAL);
	DrawStr(0, 6, "inner part instead of the whole thing, like so:", A_NORMAL);
	DoMove(grid, 8);
	Pause();
	ClrScr();
	DrawStr(0, 0, "The triangle that you will see in the upper left", A_NORMAL);
	DrawStr(0, 6, "corner when playing the game is an indicator", A_NORMAL);
	DrawStr(0, 12, "of whether [2nd] is pressed or not.  Now, let", A_NORMAL);
	DrawStr(0, 18, "the game begin...", A_NORMAL);
	DrawStr(0, 24, "Press [2nd] to continue.", A_NORMAL);
	Pause();
	ClrScr();
	DoMove(grid, 9);
}
#endif

void PlayGame(short grid[][11], short grid_win[][11])
{
	short x;
	short y;

	ClrScr();
	FastLine_Draw_R(LCD_MEM, calc(7, 47), calc(99, 127), calc(80, 120), calc(26, 54));
	FastLine_Draw_R(LCD_MEM, calc(80, 120), calc(26, 54), calc(153, 193), calc(99, 127));
	FastLine_Draw_R(LCD_MEM, calc(153, 193), calc(7, 47), calc(99, 127), calc(7, 47));

	Scramble(grid); /*scramble the puzzle*/

	ClrScr();
	FastLine_Draw_R(LCD_MEM, calc(7, 47), calc(99, 127), calc(80, 120), calc(26, 54));
	FastLine_Draw_R(LCD_MEM, calc(80, 120), calc(26, 54), calc(153, 193), calc(99, 127));
	FastLine_Draw_R(LCD_MEM, calc(153, 193), calc(7, 47), calc(99, 127), calc(7, 47));

	for(y = 0; y < 6; y++)
	{
		for(x = 0; x < 2 * y + 1; x++)
		{
			DrawPic(x, y, grid[y][x]); /*draw the scrambled puzzle on the screen*/
		}
	}

	/*draw the [2nd] indicator*/
	FastLine_Draw_R(LCD_MEM, calc(7, 47), calc(2, 30), calc(57, 97), calc(2, 30));
	FastLine_Draw_R(LCD_MEM, calc(57, 97), calc(2, 30), calc(32, 72), calc(27, 55));
	FastLine_Draw_R(LCD_MEM, calc(32, 72), calc(27, 55), calc(7, 47), calc(2, 30));
	DrawPic(-7, -2, 5);
	DrawPic(-6, -2, 5);
	DrawPic(-5, -2, 5);
	DrawPic(-5, -1, 5);

	UnScramble(grid, grid_win); /*get input from the user to unscramble the
	puzzle*/
}