// C Source File
// Created 1/6/2006; 4:33:16 PM

/*
		This software was created by Steven Ford 
		This software may be distributed freely under 
		the terms of tne GNU General Public Licence
*/

#include <tigcclib.h>
#include "extgraph.h"

typedef struct bulstrct // Define the structure of a bullet
{
	BOOL active;	// Is the bullet in the air?
	short x;	    // X-Position
	short y;	    // Y-Position
	short dir;	  // Direction (LEFT or RIGHT)
}
BULLET;
// Initialize pointers to memory for buffers (two buffers to support grayscale)
	void* lightbuffer = NULL;
	void* darkbuffer  = NULL;
	BULLET* bullets     = NULL;
	
void allocate(void)
{
		// Allocate memory for the LCD buffers, if DMA failed quit the program
	if (((lightbuffer = (int *)malloc(LCD_SIZE)) == NULL)) 
	{
	 DlgMessage("DMA Failure","Unable to allocate space for LCD buffers",BT_OK,BT_NONE);
	 return;
  } else if (((darkbuffer = (int *)malloc(LCD_SIZE)) == NULL))
  {
   DlgMessage("DMA Failure","Unable to allocate space for LCD buffers",BT_OK,BT_NONE);
   free(lightbuffer);
   return;
  } else if (((bullets = (BULLET *)calloc(5,sizeof(BULLET))) == NULL))
  {
   DlgMessage("DMA Failure","Unable to allocate space for bullet structure array",BT_OK,BT_NONE);
   free(lightbuffer);
   free(darkbuffer);
   return;
  }
}
// bullet structure provided by Jonas Gehring
enum directions
{
	LEFT, RIGHT	// Define the direction equates
};

// Declare the sprites for drawing the tank going left and right (two sprites each, one for each buffer)
  static unsigned long tankRightLight[]={0xF, 0x7FFFF1, 0x1FFC001, 0x3FFFFF1, 0x7FFF00F, 0x7FFF000, 0xFFFFFE0, 0x10000010, 0x20000008, 0x20000008, 0x20000008, 0x7FFFFFFC, 0xCE3C78E6, 0xB5DBB75A, 0xB5DBB75A, 0x4DDBB764, 0x3E3C78F8, 0x1FFFFFF0};
	static unsigned long tankRightDark[]={0xF, 0x7FFFFF, 0x1807FFF, 0x2003FFF, 0x400100F, 0x4001000, 0xFFFFFE0, 0x1FFFFFF0, 0x3FFFFFF8, 0x3FFFFFF8, 0x3FFFFFF8, 0x7FFFFFFC, 0xB1C3871A, 0xFBE7CFBE, 0xFBE7CFBE, 0x73E7CF9C, 0x21C38708, 0x1FFFFFF0};
	static unsigned long tankLeftLight[]={0xF0000000, 0x8FFFFE00, 0x8003FF80, 0x8FFFFFC0, 0xF00FFFE0, 0xFFFE0, 0x7FFFFF0, 0x8000008, 0x10000004, 0x10000004, 0x10000004, 0x3FFFFFFE, 0x671E3C73, 0x5AEDDBAD, 0x5AEDDBAD, 0x26EDDBB2, 0x1F1E3C7C, 0xFFFFFF8};
	static unsigned long tankLeftDark[]={0xF0000000, 0xFFFFFE00, 0xFFFE0180, 0xFFFC0040, 0xF0080020, 0x80020, 0x7FFFFF0, 0xFFFFFF8, 0x1FFFFFFC, 0x1FFFFFFC, 0x1FFFFFFC, 0x3FFFFFFE, 0x58E1C38D, 0x7DF3E7DF, 0x7DF3E7DF, 0x39F3E7CE, 0x10E1C384, 0xFFFFFF8};

// Declare the sprite for a bullet fired from the tank
  static unsigned char shell[]={0xFF, 0xFF, 0xFF};


// Arguments are the position and direction of the tank
void ShootBullet(short x, short y, short dir)
{
	BULLET* bullet;

	// Search for an inavtice bullet
	for (bullet = bullets; bullet < bullets+5; bullet++)
	{
		// We've found one
		if (!bullet->active)
		{
			bullet->active = 1;
			bullet->dir = dir;
			bullet->x = x;
			bullet->y = y;
			GraySprite8_XOR_R(bullet->x,bullet->y,3,shell,shell,lightbuffer,darkbuffer);
			return;
		}		
	}	
}


void movebullets(BULLET *bullets)
{
 BULLET* bullet;
 // Search for active bullets and move them in the appropriate direction
 for (bullet = bullets; bullet < bullets+5; bullet++)
 {
 	// Test to see if the bullet is active
 	if (bullet->active)
 	{
   GraySprite8_XOR_R(bullet->x,bullet->y,3,shell,shell,lightbuffer,darkbuffer);
   if (bullet->dir == RIGHT)
   {
		bullet->x++;
   }else{
		bullet->x--;
   }
   if ((bullet->x > LCD_WIDTH-8) | (bullet->x < 2))
   {
   	bullet->active = 0;
   } else {
 	  GraySprite8_XOR_R(bullet->x,bullet->y,3,shell,shell,lightbuffer,darkbuffer);
   }
 	}
 }
}



// Main Function
void _main(void)
{	
  allocate();
  short int bulletfire = 0;
	short int bulletinc = 0;
  // Save AUTO-INT 1 and 5
	INT_HANDLER saveint1 = GetIntVec(AUTO_INT_1);
	INT_HANDLER saveint5 = GetIntVec(AUTO_INT_5);

	// Redirect AUTO-INT 1 and 5 to "nothing"
	SetIntVec(AUTO_INT_1, DUMMY_HANDLER);
	SetIntVec(AUTO_INT_5, DUMMY_HANDLER);
  
  // Declare the tanks position variable
	int tankpos = 0;
	
	// Declare the counter used to be sure that the tank does not move too fast
	int count = 0;
	
	// This variable tells us wheather the tank faces right or left (1=right, 0=left)
	unsigned short int tanksprite = 1;
	
	// Clear the screen
	ClrScr();
	
	// Turn on grayscale
  GrayOn();
  
  // Clear the buffers and the screen
  GrayClearScreen2B(GetPlane(0), GetPlane(1));
  GrayClearScreen2B(lightbuffer, darkbuffer);
  
  // Draw the sprites to the buffers
  GraySprite32_XOR_R(0,LCD_HEIGHT-25,18,tankRightLight,tankRightDark,lightbuffer,darkbuffer);

  // SHOW THE EXTGRAPH VERSION
  DrawGrayStr2B(0,0,EXTGRAPH_VERSION_PWDSTR,A_NORMAL,lightbuffer,lightbuffer);
  
  // Draw the ground
  FastDrawLine_R(darkbuffer,0,LCD_HEIGHT-1,LCD_WIDTH,LCD_HEIGHT-1,A_NORMAL);
  FastDrawLine_R(darkbuffer,0,LCD_HEIGHT-2,LCD_WIDTH,LCD_HEIGHT-2,A_NORMAL);
  FastDrawLine_R(darkbuffer,0,LCD_HEIGHT-3,LCD_WIDTH,LCD_HEIGHT-3,A_NORMAL);
  FastDrawLine_R(darkbuffer,0,LCD_HEIGHT-4,LCD_WIDTH,LCD_HEIGHT-4,A_NORMAL);
  FastDrawLine_R(darkbuffer,0,LCD_HEIGHT-5,LCD_WIDTH,LCD_HEIGHT-5,A_NORMAL);
  FastDrawLine_R(darkbuffer,0,LCD_HEIGHT-6,LCD_WIDTH,LCD_HEIGHT-6,A_NORMAL);
  FastDrawLine_R(darkbuffer,0,LCD_HEIGHT-7,LCD_WIDTH,LCD_HEIGHT-7,A_NORMAL);

  while (!_keytest(RR_ESC)) // Execute this block while the escape key is not pressed
  {
   if (_keytest(RR_RIGHT)) // Test if the right arrow key was pressed
   {
   	count++; // Increment the counter
   	if (count == 10 && tankpos<LCD_WIDTH-32) // These statements regulate the speed of the tank
   	{
     if (tanksprite == 1) // If tanksprite = 1, then the tank is facing right
     {
      GraySprite32_XOR_R(tankpos,LCD_HEIGHT-25,18,tankRightLight,tankRightDark,lightbuffer,darkbuffer);  // So XOR th sprite of the
                                                                                                        // tank facing right to the buffers, to erase it
     }
     if (tanksprite == 0) // If tanksprite = 0, then the tank is facing left
     {
      GraySprite32_XOR_R(tankpos,LCD_HEIGHT-25,18,tankLeftLight,tankLeftDark,lightbuffer,darkbuffer);  // So XOR the sprite of the
                                                                                                      // tank facing left to the buffers, to erase it
     }
     tankpos++; // This moves the tank roght 
     tanksprite = 1; // Set tanksprite to 1 because the tank is now facing to the right
     GraySprite32_XOR_R(tankpos,LCD_HEIGHT-25,18,tankRightLight,tankRightDark,lightbuffer,darkbuffer); // Since we just moved right, draw the sprite
      																																															  // of the tank facing right to the buffers	
     count = 0; // Reset the counter so the speed remains controlled
   	} else if (count == 10) // If the counter is at max but we are at the end of the screen,
   	{
   	 count = 0;      // and the counter
   	}
   }
   if (_keytest(RR_LEFT)) // Test if the left arrow key was pressed
   {
   	count--; // Decrement the counter
   	if (count == -10 && tankpos>0) // If the counter is at its minimum value and we are not at the end of the screen, move the tank one pixel left
   	{
     if (tanksprite == 1) // If the tank is facing right
     {
      GraySprite32_XOR_R(tankpos,LCD_HEIGHT-25,18,tankRightLight,tankRightDark,lightbuffer,darkbuffer); // XOR the sprite to the
      																																															   // buffers to erase it
     }
     if (tanksprite == 0) // if the tank is facing left
     {
      GraySprite32_XOR_R(tankpos,LCD_HEIGHT-25,18,tankLeftLight,tankLeftDark,lightbuffer,darkbuffer);  // XOR the sprite to the
      																																														    // buffers to erase it
     }
     tankpos--; // Move the tank left one pixel
     tanksprite = 0; // Set tanksprite to 0 because the tank is now facing left
     GraySprite32_XOR_R(tankpos,LCD_HEIGHT-25,18,tankLeftLight,tankLeftDark,lightbuffer,darkbuffer); // Since we just moved left, draw the
																																																    // sprite of the tank facing left
     count = 0; // Reset the counter so the tanks speed remains controlled
   	} else if (count == -10)  // If the counter is at min but we are at the end of the screen,
   	{
   	 count = 0;      // and the counter
   	}
   }
   if (_keytest(RR_HAND))
   {
    if (bulletinc > 20 && bulletfire == 0)
    {
     bulletfire = 1;
     bulletinc = 0;
     if (tanksprite == LEFT)
   	 {
   	  ShootBullet(tankpos-8,LCD_HEIGHT-24,LEFT);
     } else {
   	  ShootBullet(tankpos+32,LCD_HEIGHT-24,RIGHT);
   	 }
    }
   } else {
   	bulletfire = 0;
   }
   bulletinc++;
   // Advance the bullets on the screen
   movebullets(bullets);

   // Copy the buffers to the screen
   FastCopyScreen_R(lightbuffer, GetPlane(0));
   FastCopyScreen_R(darkbuffer,  GetPlane(1));
  }
  // Turn grayscale off
  GrayOff();
  
  // Free the memory allocated for the screen buffers
  free(lightbuffer);
  free(darkbuffer);
  free(bullets);
  
  // Clear keyboard queue
	while (_rowread(0));

	// Restore AUTO-INT 1 and 5
	SetIntVec(AUTO_INT_1, saveint1);
	SetIntVec(AUTO_INT_5, saveint5);
}
