// C Source File
// Created 4/9/2004; 9:25:41 PM

#include <tigcclib.h>
#include "extgraph.h"
#include "define.h"
#include "drawpattern.h"
#include "sprites.h"
#include "structures.h"
#include "string(eng).h"
//#include "string(fr).h"

// 23,061
// 22,199
// 21,899

/************************************************
*		All the prototypes
************************************************/
//misc function
void init_player_coords(char);
void slowdown(void);
static inline void pause(void);
void draw_the_string(char*,int);
//Link functions (from Fisch2)
static inline int Wait_2nd_Player(void);
//Ball movement functions
static inline float change_ball_vx(float);
static inline float change_ball_vy(float);
void collision_player(int);
static inline void move_ball(void);
//Multiple messages info drawing functions
void XOR_message(char);
void update_scores(void);
static inline void draw_round_number(void);
static inline void draw_new_ball(void);
static inline void draw_game_over(char);
void draw_animated_string(char*,int);
//Move (or not) the wall in the middle
static inline void move_wall();
//Get the "player[n].move" variable
static inline void get_move_arrows(int);
static inline void get_move_number(int);
static inline void get_move_ai(int);
//Move the players (according to the screen limit and to the position of the wall)
static inline void move_player_left(int);
static inline void move_player_right(int);
//Render different elements of the scene
void draw_player(int);
void draw_explosion(char);
static inline void draw_ball(void);
static inline void draw_wall(void);
//void DrawPattern_MASK(short,short,short,short,char,char,void);
static inline void draw_frame(void);
void RLE_Decompress(unsigned char*,unsigned char*,short,int);
static inline void draw_arena(void);
void drawpart1(void);
void drawpart2(void);
//Preferences Functions (from Backgammon by K Kofler)
void read_data(PREF_STRUCT*);
void write_data(PREF_STRUCT*);
//BIG functions
static inline int play(void);
void _main(void);

/************************************************
*		The globals
************************************************/
char mode;
char exeo;
int number_of_goals;
int playernum,otherplayernum;
int offsetx,offsety;
float real_player_weight,real_ball_weight;
PLAYER_STRUCT player[2];
BALL_STRUCT ball;
WALL_STRUCT obstacle;
PREF_STRUCT pref;
//char SLIMEBALL_VERSION_STR[16]=GAME_VERSION;
char *(virtual[5]);
void *X;
INT_HANDLER save_int_1;
INT_HANDLER save_int_5;


/************************************************
*		Function that slows down...
************************************************/
void slowdown() {
	int i;
	for (i=20; i--;) {
		pokeIO(0x600005,0b11111);				//That creates a delay without depleeting the batteries
	}																	//and without disturbing grayscale.
}

/************************************************
*		Function to synch the 2 calc (when in multiplayer mode)
************************************************/
static inline int Wait_2nd_Player()
{
	#define QUIT               13
	#define HOST_NO            53 // random
	#define JOIN_NO            47 // random
	// Tell the Host plr to wait and press Escape to cancel
	WINDOW w1;
	WinOpen(&w1,&(WIN_RECT){22,20,137,60},WF_SAVE_SCR|WF_ROUNDEDBORDER|WF_TITLE,"Link game");
	WinFont(&w1,F_4x6);
	WinActivate(&w1);
	WinStrXY(&w1,2,6,"Waiting for the other player.");
	WinStrXY(&w1,4,13,"Link code by Travis Fischer");
 	WinStrXY(&w1,6,20,"Press [ESC] to stop waiting");
	OSLinkOpen(); 
 	char Send, Signal = FALSE, Receive = 0;
 	while(OSReadLinkBlock(&Receive, 1) == 1) {
		if (Receive == HOST_NO)
		Signal = TRUE;
		else if (Receive == QUIT)
		Signal = QUIT;
	}
	if (Signal == TRUE) { // This calc is 2nd to join the game
		Send = JOIN_NO;
		OSWriteLinkBlock(&Send, 1);
		playernum = join_num;
	} else {
		Send = HOST_NO;
		OSWriteLinkBlock(&Send, 1);
		playernum = host_num;
		while(Receive != JOIN_NO) {  // Wait until a signal is received from the Joining Calc
			OSReadLinkBlock(&Receive, 1);
			if (Receive == HOST_NO) {
				// This calc entered Multiplayer before the other calc had even started the game.  Thus, this 
				// calc's original HOST_NO message to the other calc was disregarded by the other calc's AMS.
				Send = JOIN_NO;
				OSWriteLinkBlock(&Send, 1);
				playernum = join_num;
				break;
			}
			// Check if the Host wants to exit the game and send a Signal to the Other calc if so
			if (_keytest(RR_ESC)) {
				//if (kbhit() && ngetchx() == KEY_ESC) {
				Signal = QUIT;
		    OSWriteLinkBlock(&Signal, 1);
				WinClose(&w1);
				OSLinkClose();
				return(FALSE);
			}
		}
		WinClose(&w1);
	}
	// Connection successfully established
	return(TRUE);
}


/************************************************
*		Changes the horizontal vector of the ball: it depends where the ball hit the slime
************************************************/
static inline float change_ball_vx(float distance) {
	if (distance < ss1)
	return(ss1vx);
	if (distance > ss4)
	return(ss4vx);
	if (distance < ss2)
	return(ss2vx);
	if (distance > ss3)
	return(ss3vx);
	return(ss5vx);
}

/************************************************
*		Changes the vertical vector of the ball: it depends where the ball hit the slime
************************************************/
static inline float change_ball_vy(float distance) {
	if (distance < ss1)
	return(ss1vy);
	if (distance > ss4)
	return(ss4vy);
	if (distance < ss2)
	return(ss2vy);
	if (distance > ss3)
	return(ss3vy);
	return(ss5vy);
}

/************************************************
*		Changes the vector of the ball to make the direction a little bit chaotic
************************************************/
float randomize_a_bit(float v) {			//This makes the ball bounce a little bit randomly
	if (random(2)) {
		return(v-0.05);
	}
	else
	{
		return(v+0.05);
	}
}


/************************************************
*		Changes the vector of the ball to make the direction a little bit chaotic
************************************************/
static inline void pause() {
	while (_keytest(RR_F5)) {};
	while (!_keytest(RR_F5)) {
		slowdown();
		draw_the_string((char*)&"Pause:[F5]",40);
	}
	while (_keytest(RR_F5)) {};
}


/************************************************
*		Initialize the coordinate of the 2 players
************************************************/
void init_player_coords(char init_all) {
	int i;
	player[0].x = ip_player_left_x;
	player[1].x = ip_player_right_x;
	for (i = 2; i--;) {
		player[i].y = ip_player_y;
		player[i].vy = ip_player_vy;
		if (init_all) {
			player[i].move = 0;
			player[i].wins = 0;
			player[i].pref = 0;
		}
	}
}

/************************************************
*		Detect if the ball collides with the player 'p'
************************************************/
void collision_player(int p) {
	player[p].rx = player[p].x;
	player[p].ry = player[p].y;
	ball.rx = ball.x;
	ball.ry = ball.y;
	if (TestCollide16(ball.rx-8,ball.ry,player[p].rx,player[p].ry,16,spr_detection,slime_detection_sprite[0]) || TestCollide16(ball.rx-8,ball.ry,player[p].rx+16,player[p].ry,16,spr_detection,slime_detection_sprite[1])) {
		ball.y = ball.y-2;//Moves the ball just a little bit up
		ball.vx += randomize_a_bit(change_ball_vx((ball.x + ball_diameter/2)-player[p].x));
		ball.vy =  randomize_a_bit(change_ball_vy((ball.x + ball_diameter/2)-player[p].x));
		if (ball.vx < -ball_max_vector)
		ball.vx = -ball_max_vector;
		if (ball.vx > ball_max_vector)
		ball.vx = ball_max_vector;
	}
}

/************************************************
*		Draws a message at the bottom of the screen
************************************************/
void XOR_message(char n) {
	char str[30];
	sprintf(str,Zplayer_X_won,n+1);
	FontSetSys(F_4x6);
	PortSet (virtual[0], 239, 127);
	DrawStr(56,94,str,A_XOR);
}

//slimeballslimeballslimeballslimeballslimeballslimeballslimeballslimeballslimeballslimeball
//slimeballslimeballslimeballslimeballslimeballslimeballslimeballslimeballslimeballslimeball

void update_scores() {
	int i;
	DrawGrayRect2B(0,92,LCD_WIDTH-1,LCD_HEIGHT-1,COLOR_BLACK,RECT_FILLED,virtual[1],virtual[0]);
	for (i = 0; i < 6;i++) {
		Sprite8((i<<3),93,6,score_element,virtual[1],A_REVERSE);
		Sprite8(150-(i<<3),93,6,score_element,virtual[1],A_REVERSE);
		if (i<	player[0].wins) {
			Sprite8((i<<3),93,6,score_element,virtual[0],A_REVERSE);
			Sprite8((i<<3),93,6,score_element,virtual[1],A_NORMAL);
		}
		if (i<	player[1].wins) {
			Sprite8(150-(i<<3),93,6,score_element,virtual[0],A_REVERSE);
			Sprite8(150-(i<<3),93,6,score_element,virtual[1],A_NORMAL);
		}
	}
}

//slimeballslimeballslimeballslimeballslimeballslimeballslimeballslimeballslimeballslimeball
//slimeballslimeballslimeballslimeballslimeballslimeballslimeballslimeballslimeballslimeball
static inline void draw_round_number() {
	drawpart1();
	drawpart2();
	char str[20];
	sprintf(str,Zround_num,number_of_goals+1);
	draw_animated_string(str,50);
}


void draw_animated_string(char *str,int x) {
	int i;
	for (i=60;i--;) {
		draw_the_string(str, x);
	}
}

/************************************************
*		Simple routine, but nice effect nonetheless
************************************************/
void draw_the_string(char *str, int x) {
	FontSetSys (F_8x10);
	int j=0;
	drawpart1();
	while (str[j] != '\0') {
		GrayDrawChar2B(x+(j<<3),45+random(4),str[j],A_NORMAL,virtual[2],virtual[3]);
		j++;
	}
	drawpart2();
}


/************************************************
*		Routine called after before the start of a new round
************************************************/
static inline void draw_new_ball() {
	int i;
	int player_num_who_won = (ball.x < obstacle.x);
	player[player_num_who_won].wins ++;
	number_of_goals++;
	XOR_message(player_num_who_won);
	for (i=1;i<58;i=i+2) {
		drawpart1();
		if (pref.option[pexplo] == pref_on) {
			draw_explosion(i);
			}
		drawpart2();
		if (i>50)
			i--;
	}
	update_scores();
	if (player_num_who_won==0) {
		ball.x = ip_player_left_x+(player_width>>1);
	}
	else
	{
		ball.x = ip_player_right_x+(player_width>>1);
	}
	ball.y = ip_ball_y;
	ball.vx = ip_ball_vx;
	ball.vy = ip_ball_vy;
	init_player_coords(0);
	if (player[player_num_who_won].wins == num_of_point_to_win) {
			exeo = 1;
			draw_game_over(player_num_who_won);
	}
	else
	{
		draw_round_number();
	}
}

//slimeballslimeballslimeballslimeballslimeballslimeballslimeballslimeballslimeballslimeball
//slimeballslimeballslimeballslimeballslimeballslimeballslimeballslimeballslimeballslimeball

void move_ball() {
	if (ball.y > boob_down) {
		draw_new_ball();
	}
	if (ball.x < boob_left) {
		ball.vx = abs(ball.vx);
	}
	if (ball.x > boob_right) {
		ball.vx = - abs(ball.vx);
	}
	
	
	if (ball.y < boob_up) {
		ball.vy = abs(ball.vy);
	}
	
	if (ball.x+ball_diameter > obstacle.x && ball.x < obstacle.x+ip_wall_lenght && ball.y +ball_diameter > obstacle.y) {
		if (ball.y+ball_diameter > obstacle.y+wall_tip) {
			ball.vx = - ball.vx;
			ball.x +=ball.vx;
		}
		else
		{
			ball.vy = - abs(ball.vy);
			ball.y--;
		}
	}
	collision_player(0);
	collision_player(1);
	ball.vy += real_ball_weight;
	ball.x += ball.vx;
	ball.y += ball.vy;
}

//slimeballslimeballslimeballslimeballslimeballslimeballslimeballslimeballslimeballslimeball
//slimeballslimeballslimeballslimeballslimeballslimeballslimeballslimeballslimeballslimeball

static inline void move_wall() {
	if (pref.option[pwall] == pref_horizontal || pref.option[pwall] == pref_vert_and_hori) {
		obstacle.x += obstacle.vx;
		if (obstacle.x > 100 || obstacle.x < 60)
		obstacle.vx = - obstacle.vx;
	}
	if (pref.option[pwall] == pref_vertical || pref.option[pwall] == pref_vert_and_hori) {
		obstacle.y += obstacle.vy;
		if (obstacle.y > 90 || obstacle.y < 68) {
			obstacle.vy = - obstacle.vy;
		}
	}
}

//slimeballslimeballslimeballslimeballslimeballslimeballslimeballslimeballslimeballslimeball
//slimeballslimeballslimeballslimeballslimeballslimeballslimeballslimeballslimeballslimeball

static inline void get_move_arrows(int num) {
	player[num].move = 0;
	if (_keytest(RR_LEFT) || (_keytest(RR_4) /*&& mode !=Same_calc_mode*/))
	player[num].move = player[num].move | 0b10;
	if (_keytest(RR_RIGHT) || (_keytest(RR_6) /*&& mode !=Same_calc_mode*/))
	player[num].move = player[num].move | 0b100;
	if ((_keytest(RR_UP) || (_keytest(RR_8) /*&& mode !=Same_calc_mode*/)) && player[num].vy == 100)
	player[num].move = player[num].move | 0b1000;
	if (_keytest(RR_ESC)) {
		if (_keytest(RR_UP)) {
			player[num].pref = 1;
		}
		else
		{
			if (_keytest(RR_DOWN)) {
				player[num].pref = 0;
			}
			else
			{
				player[num].move = player[num].move | 0b10000;
			}
		}
	}
	if (player[num].pref == 1)
	player[num].move = player[num].move | 0b1;
}

//slimeballslimeballslimeballslimeballslimeballslimeballslimeballslimeballslimeballslimeball
//slimeballslimeballslimeballslimeballslimeballslimeballslimeballslimeballslimeballslimeball

void get_move_number(int num) {
	player[num].move = 0;
	if (_keytest(RR_4))
		player[num].move = player[num].move | 0b10;
	if (_keytest(RR_6))
		player[num].move = player[num].move | 0b100;
	if (_keytest(RR_5) && player[num].vy == 100)
		player[num].move = player[num].move | 0b1000;
}

//slimeballslimeballslimeballslimeballslimeballslimeballslimeballslimeballslimeballslimeball
//slimeballslimeballslimeballslimeballslimeballslimeballslimeballslimeballslimeballslimeball

void get_move_ai(int num) {
	if (ball.x > obstacle.x) {
		if (ball.x < player[num].x+(8) || (ball.x > 120 && ball.vx > 1.8 && ball.y < 45 && player[num].x > 100))//MOVE LEFT
		player[num].move = player[num].move | 0b10;
		if (ball.x > player[num].x+(14) && !(ball.x > 120 && ball.vx > 1.8 && ball.y < 45))//MOVE RIGHT
		player[num].move = player[num].move | 0b100;
		if (ball.x < player[num].x+(8) || (ball.x > 120 && ball.vx > 1.8 && ball.y < 45 && player[num].x > 100))//MOVE LEFT
		player[num].move = player[num].move | 0b10;
		if (ball.x > player[num].x+(14) && !(ball.x > 120 && ball.vx > 1.8 && ball.y < 45))//MOVE RIGHT
		player[num].move = player[num].move | 0b100;
	}
	else
	{
		if (player[num].x < ((obstacle.x + 15)))
		player[num].move = player[num].move | 0b100;//FORCE GO TO RIGHT
		if (player[num].x  > 160-50)
		player[num].move = player[num].move | 0b010;//FORCE GO TO LEFT
	}
	if (ball.y > 40 && ball.x > obstacle.x+20) //JUMP
	player[num].move = player[num].move | 0b1000;
}


//slimeballslimeballslimeballslimeballslimeballslimeballslimeballslimeballslimeballslimeball
//slimeballslimeballslimeballslimeballslimeballslimeballslimeballslimeballslimeballslimeball


void move_player_left(int num) {
	//MOVE LEFT
	if ((player[num].move & 0b10)==0b10 && player[num].x > 1) {
	player[num].x -= pmv_horizontal;
	}
	//MOVE RIGHT
	if ((player[num].move & 0b100)==0b100) {
	player[num].x += pmv_horizontal;
	}
	//CHECK IF COLLISION
	if (player[num].x > obstacle.x-player_width)
	player[num].x = obstacle.x-player_width;
	//JUMP
	if ((player[num].move & 0b1000)==0b1000 && player[num].vy == ip_player_vy) {
	player[num].vy = pmv_vertical;
	}
	//MOVE Y
	if (player[num].vy != ip_player_vy) {
		player[num].y += player[num].vy;
		
		if (player[num].y < 0)
		player[num].vy = abs(player[num].vy);
		
		if (player[num].y > ip_player_y) {
			player[num].vy = ip_player_vy;
			player[num].y = ip_player_y;
		}
		else
			player[num].vy += real_player_weight;
	}
}


//slimeballslimeballslimeballslimeballslimeballslimeballslimeballslimeballslimeballslimeball
//slimeballslimeballslimeballslimeballslimeballslimeballslimeballslimeballslimeballslimeball

void move_player_right(int num) {
	//MOVE LEFT
	if ((player[num].move & 0b10)==0b10)
		player[num].x -= pmv_horizontal;
	//MOVE RIGHT
	if ((player[num].move & 0b100)==0b100 && player[num].x < frame_coord_right-player_width)
		player[num].x += pmv_horizontal;
	//CHECK IF COLLISION
	if (player[num].x < obstacle.x)
		player[num].x = obstacle.x+1;
	//JUMP
	if ((player[num].move & 0b1000)==0b1000 && player[num].vy == ip_player_vy)
		player[num].vy = pmv_vertical;
	//MOVE Y
	if (player[num].vy != ip_player_vy) {
		player[num].y += player[1].vy;
		
		if (player[num].y < 0)
		player[num].vy = abs(player[num].vy);		
		
		if (player[num].y > ip_player_y) {
			player[num].vy = ip_player_vy;
			player[num].y = ip_player_y;
		}
		else
			player[num].vy += real_player_weight;
	}
}


//slimeballslimeballslimeballslimeballslimeballslimeballslimeballslimeballslimeballslimeball
//slimeballslimeballslimeballslimeballslimeballslimeballslimeballslimeballslimeballslimeball

void draw_player(int num) {
	GraySprite16_MASK_R(				//1st Sprite
		player[num].x,
		player[num].y,
		16,
		&slime_sprite[((player[num].move & 0b1)<<1)][0],
		&slime_sprite[((player[num].move & 0b1)<<1)][16],
		slime_mask_sprite[0],
		slime_mask_sprite[0],
		virtual[2],
		virtual[3]);
	GraySprite16_MASK_R(				//2nd Sprite
		player[num].x+16,
		player[num].y,
		16,
		&slime_sprite[1+((player[num].move & 0b1)<<1)][0],
		&slime_sprite[1+((player[num].move & 0b1)<<1)][16],
		slime_mask_sprite[1],
		slime_mask_sprite[1],
		virtual[2],
		virtual[3]);
}

//slimeballslimeballslimeballslimeballslimeballslimeballslimeballslimeballslimeballslimeball
//slimeballslimeballslimeballslimeballslimeballslimeballslimeballslimeballslimeballslimeball

void draw_explosion(char n) {
	PortSet (virtual[2], 239, 127);
	DrawClipEllipse (ball.x+4,ball.y+4, n, n, &(SCR_RECT){{frame_coord_left,frame_coord_up,frame_coord_right,frame_coord_down}}, A_NORMAL);
	if (n>24)
		DrawClipEllipse (ball.x+4,ball.y+4, n-24, n-24, &(SCR_RECT){{frame_coord_left,frame_coord_up,frame_coord_right,frame_coord_down}}, A_NORMAL);
	if (n>38)
		DrawClipEllipse (ball.x+4,ball.y+4, n-38, n-38, &(SCR_RECT){{frame_coord_left,frame_coord_up,frame_coord_right,frame_coord_down}}, A_NORMAL);
	if (n>44)
		DrawClipEllipse (ball.x+4,ball.y+4, n-44, n-44, &(SCR_RECT){{frame_coord_left,frame_coord_up,frame_coord_right,frame_coord_down}}, A_NORMAL);
}

//slimeballslimeballslimeballslimeballslimeballslimeballslimeballslimeballslimeballslimeball
//slimeballslimeballslimeballslimeballslimeballslimeballslimeballslimeballslimeballslimeball

static inline void draw_ball() {
	if (pref.option[pbckgnd] == pref_beach) {
		GraySprite8_MASK_R(ball.x,ball.y,8,spr,spr,spr2,spr2,virtual[3],virtual[2]);
	}
	else
	{
		GraySprite8_OR_R(ball.x,ball.y,8,spr,spr,virtual[3],virtual[2]);
	}
}

//slimeballslimeballslimeballslimeballslimeballslimeballslimeballslimeballslimeballslimeball
//slimeballslimeballslimeballslimeballslimeballslimeballslimeballslimeballslimeballslimeball

void draw_wall() {
	int x=obstacle.x;
	int y=obstacle.y;
	DrawPattern_MASK(x-1,y-1,frame_coord_down-(y-1),30,0b11001000,0b00000111,virtual[2]);
	DrawPattern_MASK(x-1,y-1,frame_coord_down-(y-1),30,0b10101000,0b00000111,virtual[3]);
	FastDrawGrayLine2B(x,y-2,x+2,y-2,COLOR_BLACK,virtual[3],virtual[2]);
}

//slimeballslimeballslimeballslimeballslimeballslimeballslimeballslimeballslimeballslimeball
//slimeballslimeballslimeballslimeballslimeballslimeballslimeballslimeballslimeballslimeball

static inline void draw_game_over(char p) {
	char message[20];
	int x;
	if (mode == Same_calc_mode) {
		sprintf(message,Zplayer_X_won2,p+1);
		x=20;
	}
	else
	{
		if (p==playernum) {
			strcpy(message, Zwell_done);
			x=37;
			}
			else
			{
			strcpy(message, Zsry_lost);
			x=20;
			}
	}
	draw_animated_string(message,x);
}


/************************************************
*		I separated "part1" and "part2" because I use draw something in between during the explosion of the ball.
************************************************/
void drawpart1() {
	//Copy the background (picture + frame) to two buffers
	FastCopyScreen_R(virtual[0],virtual[2]);
	FastCopyScreen_R(virtual[1],virtual[3]);
	//Draw the players, the ball and the wall in those two buffers
	draw_player(0);
	draw_player(1);
	draw_ball();
	move_wall();
	draw_wall();
}


/************************************************
*		part2...
************************************************/
void drawpart2() {
	//Copy the two buffers where all the drawing has been done to the two visibal ones
	FastCopyScreen_R(virtual[2],GrayGetPlane (DARK_PLANE));
	FastCopyScreen_R(virtual[3],GrayGetPlane (LIGHT_PLANE));
}

//slimeballslimeballslimeballslimeballslimeballslimeballslimeballslimeballslimeballslimeball
//slimeballslimeballslimeballslimeballslimeballslimeballslimeballslimeballslimeballslimeball

void draw_frame() {
	//well... it does what it is supposed to do!: it draws a frame !
	ScrRectFill(&(SCR_RECT){{0,frame_coord_down,LCD_WIDTH-1,LCD_HEIGHT-1}},&(SCR_RECT){{0,0,240,128}},A_NORMAL);
	ScrRectFill(&(SCR_RECT){{0,0,LCD_WIDTH-1,frame_coord_up}},&(SCR_RECT){{0,0,240,128}},A_NORMAL);
	ScrRectFill(&(SCR_RECT){{LCD_WIDTH-1,frame_coord_up,frame_coord_right,frame_coord_down}},&(SCR_RECT){{0,0,240,128}},A_NORMAL);
	ScrRectFill(&(SCR_RECT){{0,0,frame_coord_left,LCD_HEIGHT-1}},&(SCR_RECT){{0,0,240,128}},A_NORMAL);
}

//slimeballslimeballslimeballslimeballslimeballslimeballslimeballslimeballslimeballslimeball
//slimeballslimeballslimeballslimeballslimeballslimeballslimeballslimeballslimeballslimeball

void RLE_Decompress(unsigned char *src, unsigned char *dest, short size,int n) //a waste of memory ?
{
	int i = 0, j,l=100;
	int pos = 0;
	int dcmpNum = 0;
	while (dcmpNum < size)
	{
		//decompress a run
		if (src[i] == 0x91)
		{
			i++;
			for(j = 0; j < src[i + 1]; j++)
			{
				dest[pos] = src[i];
				pos += n;
				if (pos > n * l)
				{
					pos -= n * l;
					pos++;
				}
			}
			i++;
			dcmpNum += src[i];
		}
		else
		{
			dest[pos] = src[i];
			pos += n;
			if (pos > n * l)
			{
				pos -= n * l;
				pos++;
			}
			dcmpNum++;
		}
		i++;
	}
}

//slimeballslimeballslimeballslimeballslimeballslimeballslimeballslimeballslimeballslimeball
//slimeballslimeballslimeballslimeballslimeballslimeballslimeballslimeballslimeballslimeball

void draw_arena() {
	ClearGrayScreen2B(virtual[0],virtual[1]);
	if (pref.option[pbckgnd] == pref_beach) {
	RLE_Decompress(beach_d_pic,virtual[0], 3000,30);
	RLE_Decompress(beach_l_pic,virtual[1], 3000,30);
	}
	if (pref.option[pbckgnd] == pref_brick) {
	RLE_Decompress(brick_pic,virtual[1], 3000,30);
	}
	PortSet (virtual[0], 239, 127);
	draw_frame();
	PortSet (virtual[1], 239, 127);
	draw_frame();
}

//slimeballslimeballslimeballslimeballslimeballslimeballslimeballslimeballslimeballslimeball
//slimeballslimeballslimeballslimeballslimeballslimeballslimeballslimeballslimeballslimeball

static inline int play() {
	int j=0,k;
	exeo = 0;
	if (mode == Link_mode) {
		if (Wait_2nd_Player()==FALSE)
		return(RETURN_TO_MENU);
	}	else playernum = 0;
	otherplayernum = !playernum;
	read_data(&pref);
	if (mode == Link_mode) {
		if (playernum == host_num) {
			LIO_SendData(&pref, sizeof(PREF_STRUCT));
		}
		else
		{
			LIO_RecvData(&pref, sizeof(PREF_STRUCT), 30);
		}
	}
	//APPLY THE GRAVITY FROM THE PREF MENU:
	float factor=1;
	if (pref.option[pgravity] == pref_jupiter)
		factor = 1.3;
	if (pref.option[pgravity] == pref_moon)
		factor = 0.7;
	if (pref.option[pgravity] == pref_zero_grav)
		factor = 0.2;		
	real_player_weight=fmul(player_weight,factor);
	real_ball_weight=fmul(ball_weight,factor);

	if (pref.magic != magic_key) {
		WINDOW w1;
		WinOpen(&w1,&(WIN_RECT){22,20,137,60},WF_SAVE_SCR|WF_ROUNDEDBORDER|WF_TITLE,"Link error");
		WinFont(&w1,F_4x6);
		WinActivate(&w1);
		WinStrXY(&w1,2,6,Zsame_version_needed);
		WinStrXY(&w1,6,13,Zsame_version_needed2);
		WinStrXY(&w1,6,20,Zsame_version_needed3);
	
		while (!_keytest(RR_ENTER)) {}
		WinClose(&w1);
		return(RETURN_TO_MENU);
	}

	if (!GrayOn())
	return(EXIT_NOW);
	draw_arena();
	update_scores();
	drawpart1();
	drawpart2();
	srand(pref.random_seed);


	if (mode != Same_calc_mode) {
		for (k=0;k<15;k++,j++) {
			drawpart1();
			drawpart2();
			Sprite8(25+(playernum*100),60+j,9,arrowX,GrayGetPlane (LIGHT_PLANE),A_NORMAL);
			Sprite8(25+(playernum*100),60+j,9,arrowX,GrayGetPlane (DARK_PLANE),A_NORMAL);
			if (j==5)
				j=0;
			slowdown();
		}
	}

	//Start of:
	//SlimeBall's most important loop;
	while (!exeo) {

		player[0].move = 0b00000000;
		player[1].move = 0b00000000;

		//Get the move of the main player
		get_move_arrows(playernum);

		if (mode == Link_mode) {
      if (playernum == host_num) {
        if (LIO_SendData (&player[0].move, 1)) {
          player[1].move = 0b10000;
        }
        else
        {
	        if (LIO_RecvData(&player[1].move, 1, 20))
	        player[1].move = 0b10000;         	
        }
      }
      else 
      {
				if (LIO_RecvData(&player[0].move, 1, 20)) {
        	player[0].move = 0b10000;
        }
        else
        {
         	if (LIO_SendData (&player[1].move, 1))
       	  	player[0].move = 0b10000;   		
        }
      }
    }
    else
    {
    	if (_keytest(RR_F5))
    	pause();
    }
    
		if (mode == Vs_IA_mode)
			get_move_ai(otherplayernum);
		if (mode == Same_calc_mode)
			get_move_number(otherplayernum);


		//Apply the moves to the players
		move_player_left(0);
		move_player_right(1);

		if (((player[0].move | player[1].move ) & 0b10000)==0b10000)
			exeo = 1;
		move_ball();		//Two small "move_ball()" (instead of one big) for a better collision detection.
		move_ball();
		drawpart1();		//Render the complete scene
		drawpart2();
		
		short a;
		// Control the game's speed according to the user's preference setting
		for(a = p9; a > pref.option[pspeed]; a--)
			pokeIO(0x600005,0b11111);
	}


	if (mode == Link_mode)
		OSLinkClose();
	
	while (_keytest(RR_ESC)) {};
		
	return(RETURN_TO_MENU);
}

/************************************************
*		the menu from where you change the prefs
************************************************/
void change_prefs() {
	read_data(&pref);
	HANDLE dlg = H_NULL, menu[5] = {H_NULL,H_NULL,H_NULL,H_NULL};
	int i,j;

	int width = 150;
	if (!TI89)
		width = 234;

	if ((dlg = DialogNewSimple(width,75)) == H_NULL) {
		return;
	}
	for (i=0;i<5;i++) {
		if ((menu[i] = PopupNew(NULL,0)) == H_NULL) {
			HeapFree(dlg);
			for (j=0;j<=i;j++) {
				HeapFree(menu[j]);
			}
			return;
		}
	}
	PopupAddText(menu[pbckgnd],-1,Zbrick,pref_brick);
	PopupAddText(menu[pbckgnd],-1,Zbeach,pref_beach);
	PopupAddText(menu[pbckgnd],-1,Zblank,pref_blank);
	PopupAddText(menu[pwall],-1,Zmotionless,pref_motionless);
	PopupAddText(menu[pwall],-1,Zvert,pref_vertical);
	PopupAddText(menu[pwall],-1,Zhor,pref_horizontal);
	PopupAddText(menu[pwall],-1,Zhor_and_vert,pref_vert_and_hori);
	PopupAddText(menu[pgravity],-1,Zjup,pref_jupiter);
	PopupAddText(menu[pgravity],-1,Zearth,pref_earth);
	PopupAddText(menu[pgravity],-1,Zmoon,pref_moon);
	PopupAddText(menu[pgravity],-1,Zzero_grav,pref_zero_grav);	
	PopupAddText(menu[pexplo],-1,Zon,pref_on);
	PopupAddText(menu[pexplo],-1,Zoff,pref_off);
	
	PopupAddText(menu[pspeed],-1,Z1, p0);
	PopupAddText(menu[pspeed],-1,"2", p1);
	PopupAddText(menu[pspeed],-1,"3", p2);
	PopupAddText(menu[pspeed],-1,"4", p3);
	PopupAddText(menu[pspeed],-1,"5", p4);
	PopupAddText(menu[pspeed],-1,"6", p5);
	PopupAddText(menu[pspeed],-1,"7", p6);
	PopupAddText(menu[pspeed],-1,"8", p7);
	PopupAddText(menu[pspeed],-1,"9", p8);
	PopupAddText(menu[pspeed],-1,Z10, p9);
	
	DialogAddTitle(dlg,Zpref,BT_OK,BT_NONE);
	DialogAddPulldown(dlg,5,15,Zchoose,menu[pbckgnd],pbckgnd);
	DialogAddPulldown(dlg,5,24,Zmove,menu[pwall],pwall);
	DialogAddPulldown(dlg,5,33,Zgrav,menu[pgravity],pgravity);
	DialogAddPulldown(dlg,5,42,Zexpl,menu[pexplo],pexplo);
	DialogAddPulldown(dlg,5,51,Zspeed,menu[pspeed],pspeed);
	if (DialogDo(dlg,CENTER,CENTER,NULL,pref.option) == KEY_ENTER) {
		write_data(&pref);
	}
	for (i=0;i<5;i++) {
		HeapFree(menu[i]);
	}
	HeapFree(dlg);
}


//slimeballslimeballslimeballslimeballslimeballslimeballslimeballslimeballslimeballslimeball
//slimeballslimeballslimeballslimeballslimeballslimeballslimeballslimeballslimeballslimeball


void load_preferences() {
	read_data(&pref);
	if (pref.magic != magic_key) {
		pref.option[pbckgnd]=pref_brick;
		pref.option[pwall]=pref_motionless;
		pref.option[pgravity]=pref_earth;
		pref.option[pexplo]=pref_on;
		pref.option[pspeed] = p6;
		pref.magic = magic_key;
		pref.random_seed = random(250);
		write_data(&pref);
	}
}

//slimeballslimeballslimeballslimeballslimeballslimeballslimeballslimeballslimeballslimeball
//slimeballslimeballslimeballslimeballslimeballslimeballslimeballslimeballslimeballslimeball
void about() {
	WINDOW w1;
	WinOpen(&w1,&(WIN_RECT){15,12,145,90},WF_SAVE_SCR|WF_ROUNDEDBORDER|WF_TITLE,Zs0);
	WinFont(&w1,F_4x6);
	WinActivate(&w1);
	WinStrXY(&w1,4,2,GAME_VERSION);
	WinStrXY(&w1,4,11,Zs1);
	WinStrXY(&w1,4,17,Zs2);
	WinStrXY(&w1,4,24,Zs3);
	WinStrXY(&w1,4,30,Zs4);
	WinStrXY(&w1,4,36,Zs5);
	WinStrXY(&w1,4,42,EXTGRAPH_VERSION_PWDSTR);
	WinStrXY(&w1,4,49,Zs6);
	WinStrXY(&w1,4,55,Zs7);
	while (ngetchx()!=13) {};
	WinClose(&w1);
}


/************************************************
*		The function menu wich return what was chosen in the menu
************************************************/
int menu() {
	short result = 0;
	clrscr();
	do {
		//It's (also) an adaptation of the TIGCC doc:
		HANDLE handle = PopupNew (GAME_VERSION, 60);
		PopupAddText (handle, 0, Zm1, 3);
		PopupAddText (handle, 3, Zm2, Vs_IA_mode);
		PopupAddText (handle, 3, Zm3, Same_calc_mode);
		PopupAddText (handle, 3, Zm4, Link_mode);
		PopupAddText (handle, -1,Zm5, 7);
		PopupAddText (handle, -1,Zm6, 1);
		PopupAddText (handle, -1,Zm7, 2);
		result = PopupDo (handle, CENTER, CENTER, 0);
		HeapFree (handle);
		if (result == 1)
			about();
		if (result == 7)
			change_prefs();
	}
	while (result == 1 || result == 7);
	if (result == 2 || result == 0) {
		return(EXIT_NOW);
	}
	mode = result;
	return(CONTINUE);
}


/************************************************
*		The _main function...
************************************************/
void _main(void)
{
	
	offsetx = (LCD_WIDTH-160)>>1;
	offsety = (LCD_HEIGHT-100)>>1;

	X = malloc(LCD_SIZE*5);
	if (!X) {
	ST_helpMsg(Zno_mem);
	exit(0);
	}
	
	int i;
	for (i=5; i--;) {
		virtual[i] = X+i*LCD_SIZE;
	}
	LCD_save (virtual[4]);
		i=CONTINUE;

		do {
		load_preferences();

		i=menu();

		init_player_coords(1);
		number_of_goals = 0;
		ball.x = ip_ball_x;
		ball.y = ip_ball_y;
		ball.vy = ip_ball_vy;
		ball.vx = ip_ball_vx;
		obstacle.x = ip_wall_x;
		obstacle.y = ip_wall_y;
		obstacle.vx = ip_wall_vx;
		obstacle.vy = ip_wall_vy;

		save_int_1 = GetIntVec (AUTO_INT_1);
		SetIntVec (AUTO_INT_1, DUMMY_HANDLER);
		save_int_5 = GetIntVec (AUTO_INT_5);
		SetIntVec (AUTO_INT_5, DUMMY_HANDLER);
		if (i!=EXIT_NOW)
		i=play();
		GrayOff();
		SetIntVec (AUTO_INT_1, save_int_1);
		SetIntVec (AUTO_INT_5, save_int_5);
	} while (i!=EXIT_NOW);
	
	LCD_restore(virtual[4]);
	free(X);
}
