#define TI89_VERSION 1

#if TI89_VERSION == 1
#define USE_TI89
#define calc(x, y) (x)
#else
#define USE_TI92PLUS
#define USE_V200
#define calc(x, y) (y)
#endif

#include <tigcclib.h>

#include "extgraph.h"

#define VERSION_MAJOR 1
#define VERSION_MINOR 9

typedef struct
{
	char initials[3];
	unsigned char calc : 1, padding : 7;
} FILE_VERSION;

typedef struct
{
	char connect[8], cars[9];
} PACKED_LEVEL; /*this is the structure that my bitpacked levels have.  At 2 bits per car,
you get 9 bytes for the 36 cars, and at 1 bit per connector, you get 7.5 (rounded up to
eight) bytes for the 60 connectors.*/

typedef struct
{
	unsigned char car : 2, con_up : 1, con_right : 1, con_down : 1, con_left : 1;
} SQUARE; /*The level is composed of these "square" objects.  The car component determines
if the square has nothing in it, has a gray car in it, or has a white car in it.  The
other four components tell how this square is connected to its neighbors.*/

typedef struct
{
	struct
	{
		short size;
		FILE_VERSION version;
	} header;
	struct
	{
		char max_level[5];
	} data;
	struct
	{
		char hash[16];
		char type[7];
	} footer;
} DATA_FILE;

static short Menu(char[]);
static short Wrap(short, short, short);
static void Unpack(SQUARE[][6], short, unsigned char[], unsigned char[], unsigned short[],
unsigned short[], unsigned short[]);
static short PlayGame(SQUARE[][6], unsigned char[], unsigned char[], unsigned short[], unsigned short[],
unsigned short[]);
static short LevelCleared(SQUARE[][6]);
static void MoveCar(short *, short *, SQUARE[][6], unsigned char[], unsigned char[], unsigned short[],
unsigned short[], unsigned short[]);

void _main(void)
{
	char *buffer;
	char hash[16];
	short cur_level;
	short old_font;
	short go_on;
	static unsigned char con_g_v[15] = {0x40, 0xE0, 0, 0xE0, 0, 0xE0, 0, 0xE0, 0, 0xE0, 0,
	0xE0, 0, 0xE0, 0x40};
	static unsigned char con_w_v[15] = {0x40, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0,
	0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0x40};
	static unsigned short box_gray[15] = {0xFFFE, 0xD556, 0xAAAA, 0xD556, 0xAAAA, 0xD556,
	0xAAAA, 0xD556, 0xAAAA, 0xD556, 0xAAAA, 0xD556, 0xAAAA, 0xD556, 0xFFFE};
	static unsigned short box_white[15] = {0xFFFE, 0x8002, 0x8002, 0x8002, 0x8002, 0x8002,
	0x8002, 0x8002, 0x8002, 0x8002, 0x8002, 0x8002, 0x8002, 0x8002, 0xFFFE};
	static unsigned short con_g_h[3] = {0x5554, 0xD556, 0x5554};
	DATA_FILE *filep = NULL;
	static FILE_VERSION Check = {{'P', 'J', 'R'}, TI89_VERSION, 0};
	INT_HANDLER OldInt1;
	INT_HANDLER OldInt5;
	MD5_CTX ctx;
	SQUARE level[6][6];
	SYM_ENTRY *file_vat;

	buffer = malloc(3840);
	if(!buffer)
	{
		ST_helpMsg("Memory Low");
		return;
	}
	FastCopyScreen_R(LCD_MEM, buffer);

	file_vat = SymFindPtr($(rushdat), 0); /*see if the data file exists*/
	if(file_vat != NULL) /*if it exists*/
	{
		if(file_vat->flags.bits.archived) /*and it is archived*/
		{
			EM_moveSymFromExtMem($(rushdat), HS_NULL); /*unarchive it*/
		}
		filep = HeapDeref(file_vat->handle);

		MD5Init(&ctx);
		MD5Update(&ctx, (char *)&filep->data, sizeof(filep->data));
		MD5Final(hash, &ctx);
	}

	if(file_vat == NULL || memcmp(&filep->header.version, &Check, sizeof(FILE_VERSION)) ||
	memcmp(hash, filep->footer.hash, 16))
	/*if the file does not exist or is the wrong version*/
	{
		static char max_level[5] = {};
		/*create it*/
		file_vat = DerefSym(SymAdd($(rushdat)));
		file_vat->handle = HeapAlloc(sizeof(DATA_FILE));
		filep = HeapDeref(file_vat->handle);

		filep->header.size = sizeof(DATA_FILE) - 2;
		memcpy(&filep->header.version, &Check, sizeof(FILE_VERSION));
		memcpy(filep->data.max_level, max_level, 5);

		MD5Init(&ctx);
		MD5Update(&ctx, (char *)&filep->data, sizeof(filep->data));
		MD5Final(filep->footer.hash, &ctx);
		memcpy(filep->footer.type, &(char []){0, 'D', 'a', 't', 'a', 0, OTH_TAG}, 7);
	}

	OldInt1 = GetIntVec(AUTO_INT(1)); /*get the address of the current int 1 handler to
	restore it later*/
	SetIntVec(AUTO_INT(1), DUMMY_HANDLER); /*turn off the status line stuff*/
	OldInt5 = GetIntVec(AUTO_INT(5)); /*get the address of the current int 5 handler to
	restore it later*/
	SetIntVec(AUTO_INT(5), DUMMY_HANDLER); /*turn off the timer*/
	old_font = FontSetSys(F_4x6); /*set the font to small*/

	do
	{
		cur_level = Menu(filep->data.max_level); /*figure out which level the player wants
		to do*/

		if(cur_level >= 0) /*if you did not press esc in the menu*/
		{
			do
			{
				Unpack(level, cur_level, con_g_v, con_w_v, box_gray, box_white,
				con_g_h); /*unpack the level to a more usable form*/
				go_on = PlayGame(level, con_g_v, con_w_v, box_gray, box_white, con_g_h);
				/*actually play the game*/
			} while(go_on == 1); /*loop if apps (reset level) was pressed*/
			if(go_on) /*if esc was not pressed*/
			{
				/*all these check to see if you were playing the last level in the
				difficulty set that you are currently allowed to play and if so, allow you
				to play another level*/
				if(cur_level < 10 && cur_level == filep->data.max_level[0])
				{
					filep->data.max_level[0] = min(filep->data.max_level[0] + 1, 9);
				}
				else if(cur_level < 40 && cur_level - 10 == filep->data.max_level[1])
				{
					filep->data.max_level[1] = min(filep->data.max_level[1] + 1, 29);
				}
				else if(cur_level < 70 && cur_level - 40 == filep->data.max_level[2])
				{
					filep->data.max_level[2] = min(filep->data.max_level[2] + 1, 29);
				}
				else if(cur_level < 100 && cur_level - 70 == filep->data.max_level[3])
				{
					filep->data.max_level[3] = min(filep->data.max_level[3] + 1, 29);
				}
				else if(cur_level - 100 == filep->data.max_level[4])
				{
					filep->data.max_level[4] = min(filep->data.max_level[4] + 1, 19);
				}
			}
		}
	} while(cur_level >= 0); /*loop while esc not pressed*/

	FontSetSys(old_font); /*set the font back*/
	SetIntVec(AUTO_INT_1, OldInt1); /*turn the int 1 handler back on*/
	SetIntVec(AUTO_INT_5, OldInt5); /*turn the int 5 handler back on*/

	MD5Init(&ctx);
	MD5Update(&ctx, (char *)&filep->data, sizeof(filep->data));
	MD5Final(filep->footer.hash, &ctx);

	EM_moveSymToExtMem($(rushdat), HS_NULL); /*archive the data file*/
	FastCopyScreen(buffer, LCD_MEM);
	free(buffer);
	ST_helpMsg(EXTGRAPH_VERSION_PWDSTR);
}

short Menu(char maxlevels[]) /*allows you to pick which level to do*/
{
	char buffer[15];
	short row = 0;
	short row_setting[5] = {maxlevels[0], maxlevels[1], maxlevels[2], maxlevels[3],
	maxlevels[4]};
	short key;
	static char arrow[5] = {0x20, 0x10, 0xF8, 0x10, 0x20};

	ClrScr();
	sprintf(buffer, "Rush Hour v%d.%d", VERSION_MAJOR, VERSION_MINOR);
	DrawStr((calc(160, 240) - DrawStrWidth(buffer, F_4x6)) / 2, 0, buffer, A_NORMAL);
	DrawStr(calc(52, 92), 6, "By Peter J. Rowe", A_NORMAL);
	DrawStr(calc(49, 89), 12, "mig53@yahoo.com", A_NORMAL);
	DrawStr(calc(19, 59), 88, "Up/Down: Select Difficulty ESC: Quit", A_NORMAL);
	DrawStr(calc(11, 51), 94, "Left/Right: Select Level 2nd: Start Game", A_NORMAL);
	Sprite8_OR_R(0, 24, 5, arrow, LCD_MEM);

	do
	{
		printf_xy(5, 24, "Beginner: %d  ", row_setting[0] + 1);
		printf_xy(5, 30, "Intermediate: %d  ", row_setting[1] + 1);
		printf_xy(5, 36, "Advanced: %d  ", row_setting[2] + 1);
		printf_xy(5, 42, "Expert: %d  ", row_setting[3] + 1);
		printf_xy(5, 48, "Grandmaster: %d  ", row_setting[4] + 1);

		key = _rowread(0xFFFE);
		if(key & calc(5, 160)) /*if up or down pressed*/
		{
			Sprite8_XOR_R(0, 6 * row + 24, 5, arrow, LCD_MEM); /*clear the arrow off the
			screen*/
		}
		if(key & calc(1, 32)) /*if up pressed*/
		{
			row--;
			while(_rowread(0xFFFE) & calc(1, 32)); /*wait until up not pressed*/
		}
		if(key & calc(2, 16)) /*if left pressed*/
		{
			row_setting[row]--;
			while(_rowread(0xFFFE) & calc(2, 16));
		}
		if(key & calc(4, 128)) /*if down pressed*/
		{
			row++;
			while(_rowread(0xFFFE) & calc(4, 128));
		}
		if(key & calc(8, 64)) /*if right pressed*/
		{
			row_setting[row]++;
			while(_rowread(0xFFFE) & calc(8, 64));
		}
		row = Wrap(row, 0, 4); /*keep the row within the alowable range*/
		row_setting[row] = Wrap(row_setting[row], 0, maxlevels[row]); /*keep the picked
		level within the allowable range*/
		if(key & calc(5, 160)) /*if up or down pressed*/
		{
			Sprite8_OR_R(0, 6 * row + 24, 5, arrow, LCD_MEM); /*put the arrow on the screen
			at its new location*/
		}
		if(_rowread(calc(0xFFBF, 0xFEFF)) & calc(1, 64)) /*if esc pressed*/
		{
			return(-1);
		}
	} while(!(key & calc(16, 1))); /*loop unitl 2nd pressed*/
	while(_rowread(0xFFFE) & calc(16, 1));
	return(row == 0 ? row_setting[0] : (row == 1 ? row_setting[1] + 10 : (row == 2 ?
		row_setting[2] + 40 : (row == 3 ? row_setting[3] + 70 : row_setting[4] + 100))));
	/*return which level was picked*/
}

short Wrap(short input, short lower, short upper) /*take the input value and put it
between the lower and upper bound with wrapping around the ends*/
{
	return(input >= lower ? (input <= upper ? input : lower) : upper);
}

void Unpack(SQUARE level[][6], short cur_level, unsigned char con_g_v[], unsigned
char con_w_v[], unsigned short box_gray[], unsigned short box_white[], unsigned short
con_g_h[])
{
	short i;
	short j;
	#include "levels.h"

	ClrScr();
	memset(level, 0, 36 * sizeof(SQUARE)); /*initialize the level*/

	/*draw the box around the level*/
	FastOutlineRect_R(LCD_MEM, calc(31, 71), calc(0, 14), calc(129, 169), calc(98, 112), A_NORMAL);
	FastLine_Erase_R(LCD_MEM, calc(129, 169), calc(33, 47), calc(129, 169), calc(49, 63));

	for(i = 0; i < 6; i++)
	{
		for(j = 0; j < 6; j++)
		{
			level[i][j].car = levels[cur_level].cars[(6 * i + j) / 4] >> (6 - ((6 * i + j)
			% 4 * 2)) & 3; /*unbitpack the square parts of the cars and put it in the
			level variable*/
			switch(level[i][j].car)
			{
				/*draw the square parts of the cars*/
				case 1:
				Sprite16_XOR_R(16 * j + calc(33, 73), 16 * i + calc(2, 16), 15, box_gray,
				LCD_MEM);
				break;

				case 2:
				Sprite16_XOR_R(16 * j + calc(33, 73), 16 * i + calc(2, 16), 15, box_white,
				LCD_MEM);
			}
			if(j < 5)
			{
				level[i][j].con_right = level[i][j + 1].con_left =
				levels[cur_level].connect[(5 * i + j) / 8] >> (7 - (5 * i + j) % 8) & 1;
				/*unbitpack the information about horizontal connections and put it in the
				level variable*/
				if(level[i][j].con_right)
				{
					/*draw the connections*/
					if(level[i][j].car != 2)
					{
						Sprite8_XOR_R(16 * j + calc(47, 87), 16 * i + calc(2, 16), 15,
						con_g_v, LCD_MEM);
					}
					else
					{
						Sprite8_XOR_R(16 * j + calc(47, 87), 16 * i + calc(2, 16), 15,
						con_w_v, LCD_MEM);
					}
				}
				level[j][i].con_down = level[j + 1][i].con_up =
				levels[cur_level].connect[(5 * i + j + 30) / 8] >> (7 - (5 * i + j + 30) %
				8) & 1; /*unbitpack the information about vertical connections and put it
				in the level variable*/
				if(level[j][i].con_down)
				{
					/*draw the connections*/
					Sprite16_XOR_R(16 * i + calc(33, 73), 16 * j + calc(16, 30), 3, con_g_h,
					LCD_MEM);
				}
			}
		}
	}
}

short PlayGame(SQUARE level[][6], unsigned char con_g_v[], unsigned char con_w_v[],
unsigned short box_gray[], unsigned short box_white[], unsigned short con_g_h[])
{
	short go_on = 3;
	short key;
	short x = 0;
	short y = 0;
	static unsigned long cursor[17] = {0xFFFF8000, 0x80008000, 0x80008000, 0x80008000,
	0x80008000, 0x80008000, 0x80008000, 0x80008000, 0x80008000, 0x80008000, 0x80008000,
	0x80008000, 0x80008000, 0x80008000, 0x80008000, 0x80008000, 0xFFFF8000};

	Sprite32_XOR_R(16 * x + calc(32, 72), 16 * y + calc(1, 15), 17, cursor, LCD_MEM);

	do
	{
		key = _rowread(0xFFFE);

		if(key & calc(31, 241)) /*if an arrow key or second was pressed*/
		{
			Sprite32_XOR_R(16 * x + calc(32, 72), 16 * y + calc(1, 15), 17, cursor,
			LCD_MEM); /*erase the cursor*/
		}
		if(key & calc(1, 32)) /*if up pressed*/
		{
			y--;
			while(_rowread(0xFFFE) & calc(1, 32));
		}
		if(key & calc(2, 16)) /*if left pressed*/
		{
			x--;
			while(_rowread(0xFFFE) & calc(2, 16));
		}
		if(key & calc(4, 128)) /*if down pressed*/
		{
			y++;
			while(_rowread(0xFFFE) & calc(4, 128));
		}
		if(key & calc(8, 64)) /*if right pressed*/
		{
			x++;
			while(_rowread(0xFFFE) & calc(8, 64));
		}
		/*keep the x & y coordinates in the box*/
		x = Wrap(x, 0, 5);
		y = Wrap(y, 0, 5);
		if(key & calc(16, 1)) /*if second pressed*/
		{
			if(level[y][x].car) /*if the cursor is on a part of a car*/
			{
				MoveCar(&x, &y, level, con_g_v, con_w_v, box_gray, box_white, con_g_h);
				/*move the car*/
			}
			while(_rowread(0xFFFE) & calc(16, 1));
		}
		if(key & calc(31, 241)) /*if an arrow key or second was pressed*/
		{
			Sprite32_XOR_R(16 * x + calc(32, 72), 16 * y + calc(1, 15), 17, cursor,
			LCD_MEM); /*put the cursor at its new location*/
		}
		if(_rowread(calc(0xFFBF, 0xFEFF)) & calc(1, 64)) /*if esc was pressed*/
		{
			go_on = 0; /*go back to the menu*/
			while(_rowread(calc(0xFFBF, 0xFEFF)) & calc(1, 64));
		}
		if(_rowread(calc(0xFFDF, 0xFF7F)) & calc(1, 64)) /*if apps was pressed*/
		{
			go_on = 1; /*reset the level*/
			while(_rowread(calc(0xFFDF, 0xFF7F)) & calc(1, 64));
		}
		if(LevelCleared(level)) /*if you have won*/
		{
			FontSetSys(F_8x10);
			DrawStr(calc(48, 88), calc(45, 59), "YOU WON!", A_REPLACE);
			FontSetSys(F_4x6);
			while(_rowread(0xFFFE) & calc(16, 1));
			while(!(_rowread(0xFFFE) & calc(16, 1))); /*wait until second pressed*/
			while(_rowread(0xFFFE) & calc(16, 1));
			go_on = 2; /*go back to the menu*/
		}
	} while(go_on == 3); /*loop while apps or esc not pressed and you have not won*/
	return(go_on);
}

short LevelCleared(SQUARE level[][6]) /*see if you have won*/
{
	register short i, j;
	short result = 1;

	for(i = 0; i < 6; i++)
	{
		for(j = 0; j < 6; j++)
		{
			result &= (level[i][j].car != 2); /*return 1 if there are no white cars in the
			level, 0 otherwise*/
		}
	}
	return(result);
}

void MoveCar(short *xp, short *yp, SQUARE level[][6], unsigned char con_g_v[], unsigned
char con_w_v[], unsigned short box_gray[], unsigned short box_white[], unsigned short
con_g_h[]) /*actually move the cars around*/
{
	short offset = 0; /*offset from starting position*/

	if(*yp < 5 && level[*yp][*xp].con_up && level[*yp + 1][*xp].car == 0) /*if the cursor
	is on the bottom end of a car, the car will not go off the edge of the level, and
	there is a place for the car to move to*/
	{
		while(TRUE)
		{
			/*move the first piece of the car down*/
			switch(level[*yp - offset][*xp].car)
			{
				case 1:
				Sprite16_XOR_R(16 * (*xp) + calc(33, 73), 16 * (*yp - offset) + calc(2, 16),
				15, box_gray, LCD_MEM);
				Sprite16_XOR_R(16 * (*xp) + calc(33, 73), 16 * (*yp - offset) + calc(18,
				32), 15, box_gray, LCD_MEM);
				break;

				case 2:
				Sprite16_XOR_R(16 * (*xp) + calc(33, 73), 16 * (*yp - offset) + calc(2, 16),
				15, box_white, LCD_MEM);
				Sprite16_XOR_R(16 * (*xp) + calc(33, 73), 16 * (*yp - offset) + calc(18,
				32), 15, box_white, LCD_MEM);
			}
			if(level[*yp - offset][*xp].con_up)
			{
				Sprite16_XOR_R(16 * (*xp) + calc(33, 73), 16 * (*yp - offset) + calc(0, 14),
				3, con_g_h, LCD_MEM);
				Sprite16_XOR_R(16 * (*xp) + calc(33, 73), 16 * (*yp - offset) + calc(16,
				30), 3, con_g_h, LCD_MEM);
			}
			memcpy(&level[*yp - offset + 1][*xp], &level[*yp - offset][*xp],
			sizeof(SQUARE));
			memset(&level[*yp - offset][*xp], 0, sizeof(SQUARE));

			if(!level[*yp - offset + 1][*xp].con_up) /*if this was the last piece of the
			car, quit*/
			{
				break;
			}
			/*else, move the next piece of the car down*/
			offset++;
		}
		(*yp)++; /*move the cursor down*/
	}
	/*the method works the same for the other three directions*/
	else if(*xp > 0 && level[*yp][*xp].con_right && level[*yp][*xp - 1].car == 0)
	{
		while(TRUE)
		{
			switch(level[*yp][*xp + offset].car)
			{
				case 1:
				Sprite16_XOR_R(16 * (*xp + offset) + calc(33, 73), 16 * (*yp) + calc(2, 16),
				15, box_gray, LCD_MEM);
				Sprite16_XOR_R(16 * (*xp + offset) + calc(17, 57), 16 * (*yp) + calc(2, 16),
				15, box_gray, LCD_MEM);
				break;

				case 2:
				Sprite16_XOR_R(16 * (*xp + offset) + calc(33, 73), 16 * (*yp) + calc(2, 16),
				15, box_white, LCD_MEM);
				Sprite16_XOR_R(16 * (*xp + offset) + calc(17, 57), 16 * (*yp) + calc(2, 16),
				15, box_white, LCD_MEM);
			}
			if(level[*yp][*xp + offset].con_right)
			{
				if(level[*yp][*xp + offset].car != 2)
				{
					Sprite8_XOR_R(16 * (*xp + offset) + calc(47, 87), 16 * (*yp) + calc(2,
					16), 15, con_g_v, LCD_MEM);
					Sprite8_XOR_R(16 * (*xp + offset) + calc(31, 71), 16 * (*yp) + calc(2,
					16), 15, con_g_v, LCD_MEM);
				}
				else
				{
					Sprite8_XOR_R(16 * (*xp + offset) + calc(47, 87), 16 * (*yp) + calc(2,
					16), 15, con_w_v, LCD_MEM);
					Sprite8_XOR_R(16 * (*xp + offset) + calc(31, 71), 16 * (*yp) + calc(2,
					16), 15, con_w_v, LCD_MEM);
				}
			}
			memcpy(&level[*yp][*xp + offset - 1], &level[*yp][*xp + offset],
			sizeof(SQUARE));
			memset(&level[*yp][*xp + offset], 0, sizeof(SQUARE));
			if(!level[*yp][*xp + offset - 1].con_right)
			{
				break;
			}
			offset++;
		}
		(*xp)--;
	}
	else if(*yp > 0 && level[*yp][*xp].con_down && level[*yp - 1][*xp].car == 0)
	{
		while(TRUE)
		{
			switch(level[*yp + offset][*xp].car)
			{
				case 1:
				Sprite16_XOR_R(16 * (*xp) + calc(33, 73), 16 * (*yp + offset) + calc(2, 16),
				15, box_gray, LCD_MEM);
				Sprite16_XOR_R(16 * (*xp) + calc(33, 73), 16 * (*yp + offset) - calc(14, 0),
				15, box_gray, LCD_MEM);
				break;

				case 2:
				Sprite16_XOR_R(16 * (*xp) + calc(33, 73), 16 * (*yp + offset) + calc(2, 16),
				15, box_white, LCD_MEM);
				Sprite16_XOR_R(16 * (*xp) + calc(33, 73), 16 * (*yp + offset) - calc(14, 0),
				15, box_white, LCD_MEM);
			}
			if(level[*yp + offset][*xp].con_down)
			{
				Sprite16_XOR_R(16 * (*xp) + calc(33, 73), 16 * (*yp + offset) + calc(16,
				30), 3, con_g_h, LCD_MEM);
				Sprite16_XOR_R(16 * (*xp) + calc(33, 73), 16 * (*yp + offset) + calc(0, 14),
				3, con_g_h, LCD_MEM);
			}
			memcpy(&level[*yp + offset - 1][*xp], &level[*yp + offset][*xp],
			sizeof(SQUARE));
			memset(&level[*yp + offset][*xp], 0, sizeof(SQUARE));
			if(!level[*yp + offset - 1][*xp].con_down)
			{
				break;
			}
			offset++;
		}
		(*yp)--;
	}
	else if(*xp < 5 && level[*yp][*xp].con_left && level[*yp][*xp + 1].car == 0)
	{
		while(TRUE)
		{
			switch(level[*yp][*xp - offset].car)
			{
				case 1:
				Sprite16_XOR_R(16 * (*xp - offset) + calc(33, 73), 16 * (*yp) + calc(2, 16),
				15, box_gray, LCD_MEM);
				Sprite16_XOR_R(16 * (*xp - offset) + calc(49, 89), 16 * (*yp) + calc(2, 16),
				15, box_gray, LCD_MEM);
				break;

				case 2:
				Sprite16_XOR_R(16 * (*xp - offset) + calc(33, 73), 16 * (*yp) + calc(2, 16),
				15, box_white, LCD_MEM);
				Sprite16_XOR_R(16 * (*xp - offset) + calc(49, 89), 16 * (*yp) + calc(2, 16),
				15, box_white, LCD_MEM);
			}
			if(level[*yp][*xp - offset].con_left)
			{
				if(level[*yp][*xp - offset].car != 2)
				{
					Sprite8_XOR_R(16 * (*xp - offset) + calc(31, 71), 16 * (*yp) + calc(2,
					16), 15, con_g_v, LCD_MEM);
					Sprite8_XOR_R(16 * (*xp - offset) + calc(47, 87), 16 * (*yp) + calc(2,
					16), 15, con_g_v, LCD_MEM);
				}
				else
				{
					Sprite8_XOR_R(16 * (*xp - offset) + calc(31, 71), 16 * (*yp) + calc(2,
					16), 15, con_w_v, LCD_MEM);
					Sprite8_XOR_R(16 * (*xp - offset) + calc(47, 87), 16 * (*yp) + calc(2,
					16), 15, con_w_v, LCD_MEM);
				}
			}
			memcpy(&level[*yp][*xp - offset + 1], &level[*yp][*xp - offset],
			sizeof(SQUARE));
			memset(&level[*yp][*xp - offset], 0, sizeof(SQUARE));
			if(!level[*yp][*xp - offset + 1].con_left)
			{
				break;
			}
			offset++;
		}
		(*xp)++;
	}
	else if(*xp == 5 && *yp == 2 && level[2][5].con_left) /*if you are trying to move one
	of the cars through the opening*/
	{
		while(TRUE)
		{
			if(level[2][5 - offset].car != 2) /*if you have run out of car parts to
			erase*/
			{
				break;
			}
			/*erase the first part of the car*/
			Sprite16_XOR_R(calc(113, 153) - 16 * offset, calc(34, 48), 15, box_white,
			LCD_MEM);
			if(level[2][5 - offset].con_left)
			{
				Sprite8_XOR_R(calc(111, 151) - 16 * offset, calc(34, 48), 15, con_w_v,
				LCD_MEM);
			}
			memset(&level[2][5 - offset], 0, sizeof(SQUARE));
			offset++; /*do the next one*/
		}
	}
}
