// Header File
// Created 12/21/2003; 3:32:15 PM
// All of the Game's 24x24 Bike Graphics

/* Slanting Backwards (6)
6 is the First step in the Tile Backwards
5 when going up Long_Bump
4 is Default off of a Normal Bump (Small, Medium, Large, Finish, Slanted Right)
3 is Default off of a Tall Bump

1 is how far back you can tilt, and then there is a small pause before going to 0 and flipping
0 is the start of the flip
*/

/* Slanting Forwards (4)
2 when going up Long_Bump
3 is Default off of a Normal Bump (Small, Medium, Large, Finish, Slanted Right)
4 is Default off of a Tall Bump
*/

unsigned long BikeGfx[23][24*3] = {
// 0
{0x00000000,0x00070000,0x000d8000,0x0e18c000,0x04104000,0x40004000,0x0408c000,0x018d8000,0x00070000,0x20800000,
0x201e0000,0x31800000,0x0e000000,0x00020000,0x00700000,0x00600000,0x00610000,0x00618000,0x0000c000,0x00104000,
0x00104000,0x0018c000,0x000d8000,0x00070000, // Light
0x00000000,0x02070000,0x070d8000,0x7e58c000,0x04504000,0x70404000,0x3c48c000,0x3d8d8000,0x38a70000,0x3ff80000,
0x2f3e0000,0x319f0000,0x0e3e0000,0x003e0000,0x007c0000,0x00700000,0x00790000,0x00798000,0x0058c000,0x00504000,
0x00504000,0x0058c000,0x000d8000,0x00070000, // Dark
0xc3ffffff,0x81f8ffff,0x80f27fff,0x81a73fff,0x81a9bfff,0x80a1bfff,0x03a73fff,0x02027fff,0x0718ffff,0x0007ffff,
0x0001ffff,0x8000ffff,0x8001ffff,0xc001ffff,0xe183ffff,0xff83ffff,0xff80ffff,0xff807fff,0xffa53fff,0xffadbfff,
0xffadbfff,0xffa73fff,0xfff27fff,0xfff8ffff}, // Mask...
// 1
{0x00000000,0x00000000,0x00000000,0x0e038000,0x0486c000,0x40cc6000,0x08002000,0x01002000,0x400c6000,0x2006c000,
0x1c438000,0x03300000,0x00100000,0x0e000000,0x0f100000,0x08800000,0x00000000,0x00400000,0x0c600000,0x08200000,
0x09200000,0x0c600000,0x06c00000,0x03800000,
0x00000000,0x02000000,0x07080000,0x7e138000,0x0496c000,0x70ec6000,0x38802000,0x3f002000,0x7e6c6000,0x38f6c000,
0x1c638000,0x03700000,0x00780000,0x0ef80000,0x0ff00000,0x1fa00000,0x37000000,0x26400000,0x4e600000,0x08200000,
0x09200000,0x0c600000,0x06c00000,0x03800000,
0xc3ffffff,0x81ffffff,0x80f7ffff,0x81ec7fff,0x81693fff,0x80139fff,0x0703dfff,0x00c0dfff,0x01939fff,0x00093fff,
0x801c7fff,0xc00fffff,0xf807ffff,0xf007ffff,0xf00fffff,0xe01fffff,0xc83fffff,0xd93fffff,0xb11fffff,0xf75fffff,
0xf65fffff,0xf39fffff,0xf93fffff,0xfc7fffff},
// 2
{0x00000000,0x00000000,0x00000000,0x0e01c000,0x04436000,0x40263000,0x04001000,0x40441000,0x20063000,0x00036000,
0x1291c000,0x1c080000,0x01800000,0x03800000,0x07400000,0x06080000,0x00400000,0x00100000,0x02180000,0x02080000,
0x02080000,0x03180000,0x01b00000,0x00e00000,
0x00000000,0x02000000,0x07040000,0x7e0dc000,0x044b6000,0x70363000,0x3c401000,0x79c41000,0x3fbe3000,0x1f3b6000,
0x1299c000,0x1c180000,0x01b80000,0x03fc0000,0x07fe0000,0x07980000,0x0bc00000,0x0b900000,0x1b180000,0x02080000,
0x02080000,0x03180000,0x01b00000,0x00e00000,
0xc3ffffff,0x81ffffff,0x80fbffff,0x81f23fff,0x81b49fff,0x80c9cfff,0x03806fff,0x061b6fff,0x0041cfff,0x80049fff,
0x80063fff,0xc007ffff,0xc007ffff,0xe003ffff,0xf801ffff,0xf807ffff,0xf41fffff,0xf44fffff,0xe4c7ffff,0xfdd7ffff,
0xfdd7ffff,0xfce7ffff,0xfe4fffff,0xff1fffff},
// 3
{0x00000000,0x00000000,0x00000000,0x07000000,0x02000000,0x20400000,0x04400000,0x00a70000,0x200d8000,0x2000c000,
0x21104000,0x1c104000,0x0358c000,0x180d8000,0x32070000,0x02000000,0x02000000,0x24200000,0x61000000,0x41000000,
0x49000000,0x63000000,0x36000000,0x1c000000,
0x00000000,0x01000000,0x03800000,0x3f000000,0x02000000,0x38440000,0x1c480000,0x1fff0000,0x3f1d8000,0x2cc0c000,
0x21f04000,0x1c704000,0x0358c000,0x18cd8000,0x7fe70000,0x5ff00000,0x9ef80000,0x3c600000,0x61000000,0x41000000,
0x49000000,0x63000000,0x36000000,0x1c000000,
0xe1ffffff,0xc0ffffff,0xc07fffff,0xc0ffffff,0xc0ffffff,0xc03bffff,0x83b7ffff,0x8000ffff,0x80827fff,0x83033fff,
0x8009bfff,0x800dbfff,0xc0273fff,0xe0327fff,0x8018ffff,0xa00fffff,0x6007ffff,0xc09fffff,0x9cffffff,0xb8ffffff,
0xb2ffffff,0x9cffffff,0xc9ffffff,0xe3ffffff},
// 4
{0x00000000,0x00000000,0x00000000,0x00000000,0x07000000,0x02000000,0x20200000,0x02200000,0x00500000,0x10038000,
0x1806c000,0x08006000,0x0e082000,0x01482000,0x1c0c6000,0x3406c000,0x00038000,0x44000000,0xc0200000,0x82000000,
0x92000000,0xc6000000,0x6c000000,0x38000000,
0x00000000,0x00000000,0x01000000,0x03800000,0x3f000000,0x02000000,0x38200000,0x1e240000,0x1ffc0000,0x1f938000,
0x1846c000,0x08706000,0x0e782000,0x01682000,0x1c4c6000,0xfdc6c000,0x3be38000,0x7df00000,0xd8e00000,0x82000000,
0x92000000,0xc6000000,0x6c000000,0x38000000,
0xffffffff,0xe1ffffff,0xc0ffffff,0xc07fffff,0xc0ffffff,0xc0ffffff,0xc05fffff,0xc1dbffff,0xc003ffff,0xc04c7fff,
0xc3813fff,0xc0839fff,0xe003dfff,0xe010dfff,0xe0339fff,0x00393fff,0xc41c7fff,0x800fffff,0x211fffff,0x79ffffff,
0x61ffffff,0x39ffffff,0x93ffffff,0xc7ffffff},
// 5
{0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00e00000,0x00400000,0x04000000,0x00000000,0x00040000,
0x04140000,0x04040000,0x06000000,0x0101c000,0x0c816000,0x01443000,0x31041000,0x61061000,0xc4063000,0x90036000,
0x8221c000,0xc6000000,0x6c000000,0x38000000,
0x00000000,0x00000000,0x00000000,0x00200000,0x00700000,0x07e00000,0x00400000,0x07000000,0x03800000,0x03f40000,
0x05fc0000,0x04078000,0x06300000,0x0139c000,0x3cb96000,0x4f5c3000,0x3f241000,0x6de61000,0xc4e63000,0x90f36000,
0x8261c000,0xc6000000,0x6c000000,0x38000000,
0xffffffff,0xffffffff,0xfc3fffff,0xf81fffff,0xf80fffff,0xf81fffff,0xf81fffff,0xf80fffff,0xf87fffff,0xf00bffff,
0xf003ffff,0xf0e07fff,0xf043ffff,0xf0003fff,0xc0009fff,0xb001cfff,0xc0186fff,0x90196fff,0x3919cfff,0x610c9fff,
0x659e3fff,0x39ffffff,0x93ffffff,0xc7ffffff},
// 6
{0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00380000,0x00100000,0x01000000,0x00000000,
0x01000000,0x02020000,0x020a0000,0x03020000,0x01800000,0x06800000,0x3140c000,0x61006000,0xc0163000,0x90141000,
0x80049000,0xc6063000,0x6c236000,0x3801c000,
0x00000000,0x00000000,0x00000000,0x00000000,0x00080000,0x001c0000,0x01f80000,0x00100000,0x01c00000,0x00e00000,
0x01c00000,0x02fa0000,0x027e0000,0x03020000,0x399bc000,0x06982000,0x3f5cc000,0x6f186000,0xccf63000,0x90f41000,
0x80e49000,0xc6f63000,0x6c236000,0x3801c000,
0xffffffff,0xffffffff,0xffffffff,0xff0fffff,0xfe07ffff,0xfe03ffff,0xfe07ffff,0xfe07ffff,0xfe03ffff,0xfc1fffff,
0xf81fffff,0xf805ffff,0xf801ffff,0xf801ffff,0xc0003fff,0xf8001fff,0xc0003fff,0x90009fff,0x3008cfff,0x600a6fff,
0x611b6fff,0x3909cfff,0x93dc9fff,0xc7fe3fff},
// 7
{0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00700000,0x00200000,0x02000000,0x00000000,
0x02000000,0x04000000,0x04000000,0x06040000,0x03140000,0x01040000,0x0e800000,0x3e010000,0x42208000,0x80244000,
0x80282000,0x82082000,0xcc4c6000,0x78078000,
0x00000000,0x00000000,0x00000000,0x00000000,0x00100000,0x00380000,0x03f00000,0x00200000,0x03800000,0x01c00000,
0x03800000,0x05800000,0x05c00000,0x06f40000,0x037c0000,0x01040000,0x7eb78000,0x3e314000,0x5ff88000,0x9df44000,
0x99e82000,0x83e82000,0xcc4c6000,0x78078000,
0xffffffff,0xffffffff,0xffffffff,0xfe1fffff,0xfc0fffff,0xfc07ffff,0xfc0fffff,0xfc0fffff,0xfc07ffff,0xf83fffff,
0xf03fffff,0xf03fffff,0xf03fffff,0xf00bffff,0xf803ffff,0xfc23ffff,0x80007fff,0xc000bfff,0xa0017fff,0x6008bfff,
0x4014dfff,0x7c17dfff,0x33b39fff,0x87f87fff},
// 8
{0x00000000,0x00000000,0x00000000,0x00000000,0x008e0000,0x00840000,0x01100000,0x00000000,0x02000000,0x01800000,
0x04000000,0x3b048000,0x61610000,0xc1010000,0x91100000,0x80100000,0xc4358000,0x6c04c000,0x388c6000,0x00082000,
0x00082000,0x000c6000,0x0006c000,0x00038000,
0x00000000,0x00000000,0x00020000,0x00070000,0x00fe0000,0x00840000,0x01f00000,0x00e00000,0x32f00000,0x19f00000,
0x047c0000,0x3f3e8000,0x6f610000,0xcf8d0000,0x97dd8000,0x81fc4000,0xc5fd8000,0x6cc4c000,0x38ec6000,0x00082000,
0x00082000,0x000c6000,0x0006c000,0x00038000,
0xffffffff,0xffc3ffff,0xff81ffff,0xff80ffff,0xfe01ffff,0xfc01ffff,0xf800ffff,0xf81fffff,0xc80fffff,0xe00fffff,
0xf803ffff,0xc0017fff,0x900cffff,0x3000ffff,0x68007fff,0x6001bfff,0x38007fff,0x93393fff,0xc7119fff,0xfff5dfff,
0xfff4dfff,0xfff39fff,0xfff93fff,0xfffc7fff},
// 9
{0x00000000,0x00000000,0x00000000,0x00200000,0x00238000,0x00c10000,0x00800000,0x00000000,0x3b000000,0x68000000,
0xc0a00000,0x9122c000,0x83048000,0xc0000000,0x6c000000,0x39000000,0x00050000,0x00098000,0x0018c000,0x00104000,
0x00104000,0x0018c000,0x000d8000,0x00070000,
0x00000000,0x00000000,0x00008000,0x0021c000,0x003f8000,0x02e10000,0x02fc0000,0x02780000,0x3f700000,0x6f3c0000,
0xc7be0000,0x9326c000,0x838d8000,0xc1dc0000,0x6de90000,0x39ecc000,0x00cd4000,0x00498000,0x0018c000,0x00104000,
0x00104000,0x0018c000,0x000d8000,0x00070000,
0xffffffff,0xfff0ffff,0xffe07fff,0xff003fff,0xfe007fff,0xfc007fff,0xfc003fff,0xfc07ffff,0xc00fffff,0x9003ffff,
0x3801ffff,0x6c093fff,0x60007fff,0x3801ffff,0x9014ffff,0xc6113fff,0xff30bfff,0xffb07fff,0xffe33fff,0xffe9bfff,
0xffe9bfff,0xffe73fff,0xfff27fff,0xfff8ffff},
// 10
{0x00000000,0x00000000,0x00000000,0x00080000,0x0008e000,0x38204000,0x6c010000,0xc6000000,0x80a00000,0x90100000,
0xc2128000,0x68a10000,0x38010000,0x00880000,0x00080000,0x00900000,0x00050000,0x000d8000,0x0018c000,0x00104000,
0x00104000,0x0018c000,0x000d8000,0x00070000,
0x00000000,0x00000000,0x00002000,0x00087000,0x020fe000,0x39384000,0x6c3f0000,0xc7380000,0x83bc0000,0x939e0000,
0xc3968000,0x68a10000,0x386d0000,0x00fd0000,0x00fd8000,0x00f0c000,0x00650000,0x002d8000,0x0018c000,0x00104000,
0x00104000,0x0018c000,0x000d8000,0x00070000,
0xffffffff,0xfffc3fff,0xfff81fff,0xffc00fff,0xfd801fff,0xc6001fff,0x93000fff,0x3807ffff,0x7c03ffff,0x6c01ffff,
0x20017fff,0x9006ffff,0xc600ffff,0xff00ffff,0xff007fff,0xff0d3fff,0xff98ffff,0xffd07fff,0xffe53fff,0xffedbfff,
0xffedbfff,0xffe73fff,0xfff27fff,0xfff8ffff},
// 11
{0x00000000,0x00000000,0x38100000,0x6c11c000,0xc6108000,0x90620000,0x80000000,0xc4800000,0x64800000,0x31000000,
0x02400000,0x00140000,0x00000000,0x00430000,0x04020000,0x00000000,0x00600000,0x00c80000,0x018c0000,0x01040000,
0x01040000,0x018c0000,0x00d80000,0x00700000,
0x00000000,0x00004000,0x3910e000,0x6d1fc000,0xc7108000,0x927e0000,0x873c0000,0xc7b80000,0x67b00000,0x313c0000,
0x035c0000,0x031c0000,0x07920000,0x07fb0000,0x06360000,0x02040000,0x00620000,0x00ca0000,0x018c0000,0x01040000,
0x01040000,0x018c0000,0x00d80000,0x00700000,
0xfff87fff,0xfff03fff,0xc6801fff,0x92803fff,0x38003fff,0x6c001fff,0x6803ffff,0x2007ffff,0x900fffff,0xc003ffff,
0xfc03ffff,0xfc03ffff,0xf82dffff,0xf804ffff,0xf9c1ffff,0xfdf3ffff,0xff85ffff,0xff25ffff,0xfe63ffff,0xfecbffff,
0xfedbffff,0xfe73ffff,0xff27ffff,0xff8fffff},
// 12
{0x38000000,0x6c000000,0xc6000000,0x82000000,0x80000000,0xc4000000,0x64c00000,0x20c40000,0x02c40000,0x00040000,
0x00020000,0x20400000,0x003c8000,0x06004000,0x00204000,0x38000000,0x6c700000,0xc4000000,0x80004000,0x82040000,
0xc6360000,0x6de00000,0x38f00000,0x00000000,
0x38000000,0x6c000000,0xc60f0000,0x82470000,0x83470000,0xc7470000,0x67c00000,0x23c40000,0x03c40000,0x0e040000,
0x1f020000,0x3f400000,0x1e3c8000,0x171fc000,0x07bfc000,0x3a23c000,0x6c77c000,0xc443c000,0x8041c000,0x82440000,
0xc677c000,0x6dfc0000,0x38f80000,0x00000000,
0xc7ffffff,0x93ffffff,0x39f0ffff,0x6db8ffff,0x4cb8ffff,0x28b8ffff,0x8030ffff,0xc430ffff,0xf431ffff,0xf031ffff,
0xe000ffff,0xc0003fff,0xe0001fff,0xe8000fff,0xf8400fff,0xc51c0fff,0x90080fff,0x38bc0fff,0x61a01fff,0x65b03fff,
0x39883fff,0x92003fff,0xc7003fff,0xfff87fff},
// 13
{0x000e0000,0x001b0000,0x00318000,0x00248000,0x00208000,0x00218000,0x00090000,0x00100000,0x00020000,0x38160000,
0x6c060000,0xc6a40000,0x82100000,0x820c4000,0xc0028000,0x68020000,0x38218000,0x00800000,0x00700000,0x0080c000,
0x01c40000,0x00040000,0x00040000,0x00000000,
0x000e0000,0x001b0000,0x00318000,0x00248000,0x00208000,0x00218000,0x008f0000,0x01dec800,0x03cf9800,0x3bdf3800,
0x6c863800,0xc6a47800,0x83901000,0x83cc4000,0xc1c28000,0x684e0000,0x3b3f8000,0x04ff8000,0x087f8000,0x0087c000,
0x01fe0000,0x03840000,0x01040000,0x00000000,
0xfff1ffff,0xffe4ffff,0xffce7fff,0xffd37fff,0xffc77fff,0xffce7fff,0xff40ffff,0xfe0137ff,0xfc3067ff,0xc400c7ff,
0x9301c7ff,0x390387ff,0x6c010fff,0x64000fff,0x30300fff,0x90303fff,0xc4403fff,0xfb001fff,0xf4001fff,0xfe001fff,
0xfe001fff,0xfc007fff,0xfe01ffff,0xff0fffff},
// 14
{0x00000000,0x3801c000,0x6c436000,0xc6063000,0x82001000,0x82809000,0xc6843000,0x64086000,0x3028c000,0x00160000,
0x00180000,0x040c0000,0x05040000,0x0405c000,0x00090000,0x000a0000,0x00080000,0x01080000,0x01000000,0x04200000,
0x0e000000,0x00000000,0x00000000,0x00000000,
0x00000000,0x3801c000,0x6c436000,0xc6f63000,0x82701000,0x82f09000,0xc6f73000,0x658f6000,0x33afc000,0x01960000,
0x3d99c000,0x040c0000,0x07c42400,0x05e5fc00,0x00e93c00,0x007a3800,0x00780000,0x01f80000,0x01f00000,0x04200000,
0x0fc00000,0x1c000000,0x08000000,0x00000000,
0xffffffff,0xc7fe3fff,0x93bc9fff,0x3909cfff,0x6d886fff,0x6d036fff,0x2100cfff,0x92009fff,0xc0003fff,0xf809ffff,
0xc0403fff,0xf8c1ffff,0xf8001bff,0xfa0003ff,0xff0003ff,0xff8047ff,0xff80ffff,0xfe03ffff,0xe003ffff,0xf007ffff,
0xf03fffff,0xe03fffff,0xf03fffff,0xf87fffff},
// 15
{0x00000000,0x38000000,0x6c000000,0xc6000000,0x82000000,0x82000000,0xc6200000,0x64038000,0x3106c000,0x01006000,
0x00002000,0x10902000,0x12806000,0x2440c000,0x00238000,0x00200000,0x00100000,0x00100000,0x01000000,0x04200000,
0x0e000000,0x00000000,0x00000000,0x00000000,
0x00000000,0x38000000,0x6c000000,0xc6000000,0x82000000,0x82000000,0xc6e00000,0x64638000,0x3176c000,0x47f06000,
0x37202000,0x169c2000,0x129e6000,0x2fcec000,0x07e78000,0x01e00000,0x01f38000,0x00f00000,0x01e00000,0x04200000,
0x0fc00000,0x1c000000,0x08000000,0x00000000,
0xffffffff,0xc7ffffff,0x93ffffff,0x39ffffff,0x65ffffff,0x75ffffff,0x311fffff,0x939c7fff,0xc6893fff,0xb0039fff,
0xc000dfff,0xe003dfff,0xe4019fff,0xd0013fff,0xf8007fff,0xfe03ffff,0xfe007fff,0xff07ffff,0xe007ffff,0xf007ffff,
0xf00fffff,0xe03fffff,0xf03fffff,0xf87fffff},
// 16
{0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00800000,0x00400000,0x00c00000,0x003e0000,
0x00000000,0x00204000,0x04108000,0x050f8000,0x45018000,0xe6950000,0xf88c0000,0xc00c4000,0xc0183000,0x40181800,
0x3c009800,0x00009800,0x00005800,0x00003000,
0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00820000,0x005c0000,0x00fe0000,0x01bf8000,
0x01c3e000,0x01e0e000,0x05d08000,0x3dff8000,0x7d798000,0xfe9d0000,0xfe9cf000,0xc61c7800,0xc0fe3000,0x40f81800,
0x3ce09800,0x00709800,0x00005800,0x00003000,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xff87ffff,0xff03ffff,0xff01ffff,0xff01ffff,0xfe00ffff,0xfc007fff,
0xfc001fff,0xfc001fff,0xf8007fff,0xc0007fff,0x80003fff,0x00003fff,0x00000fff,0x000007ff,0x00010fff,0x800707ff,
0xc31f07ff,0xff8f07ff,0xffff87ff,0xffffcfff},
// 17
{0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00180000,0x00080000,0x00000000,0x00010000,0x00060000,
0x000c0000,0x02140000,0x02000000,0x13800000,0x18418000,0x0c008000,0x01144000,0x70144000,0xc1144000,0xc104c000,
0xc4468000,0xc4430000,0xfc000000,0x78000000,
0x00000000,0x00000000,0x00000000,0x00000000,0x000c0000,0x00fc0000,0x01080000,0x02cf0000,0x01ff0000,0x01fe0000,
0x007c0000,0x02140000,0x02300000,0x13938000,0x785bc000,0xff188000,0xff7c4000,0x7ef44000,0xcdf44000,0xc1f4c000,
0xc4f68000,0xc4430000,0xfc000000,0x78000000,
0xffffffff,0xffffffff,0xffffffff,0xfe0fffff,0xfc03ffff,0xfc03ffff,0xfc07ffff,0xfc00ffff,0xf800ffff,0xf001ffff,
0xf003ffff,0xf023ffff,0xf003ffff,0xe0007fff,0x80003fff,0x00017fff,0x0000bfff,0x800abfff,0x300bbfff,0x320b3fff,
0x23097fff,0x3bbcffff,0x03ffffff,0x87ffffff},
// 18
{0x00000000,0x00000000,0x00000000,0x0000e000,0x0021b000,0x3c3b1800,0x14000800,0x60400800,0x10001800,0x0000b000,
0x0098e000,0x004c0000,0x22040000,0x18000000,0x01040000,0x02200000,0x00200000,0x00300000,0x03180000,0x02080000,
0x02480000,0x03180000,0x01b00000,0x00e00000,
0x01000000,0x01c00000,0x01c20000,0x1c04e000,0x3e25b000,0x3c3f1800,0x1c200800,0x7cc00800,0x739c1800,0x773cb000,
0x7f98e000,0x3e5c0000,0x3e1e0000,0x183e0000,0x013c0000,0x03680000,0x0de00000,0x09b00000,0x13980000,0x02080000,
0x02480000,0x03180000,0x01b00000,0x00e00000,
0xfeffffff,0xfe3fffff,0x863dffff,0x027b1fff,0x005a4fff,0x0040e7ff,0x00c0f7ff,0x000037ff,0x0003e7ff,0x00034fff,
0x00071fff,0x0003ffff,0x8001ffff,0x8001ffff,0xc003ffff,0xe017ffff,0xf21fffff,0xf64fffff,0xec67ffff,0xfdf7ffff,
0xfdb7ffff,0xfce7ffff,0xfe4fffff,0xff1fffff},
// 19
{0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,
0x00000000,0x00000000,0x00000000,0x00003800,0x00006c00,0x00014c00,0x0184dc00,0x00e03800,0x7809b800,0xc0793800,
0x817b7000,0xff7bf000,0xff3be000,0x7e01c000,
0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,
0x00000000,0x00000000,0x00000000,0x0000f800,0x0001ec00,0x0001cc00,0x0187dc00,0x7dfc3800,0xfe0fb800,0xc47d3800,
0x817b7000,0xff7bf000,0xff3be000,0x7e01c000,
0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,
0xffffffff,0xffffffff,0xffffffff,0xffff07ff,0xfffe13ff,0xfffe33ff,0xfe7823ff,0x800007ff,0x000007ff,0x3802c7ff,
0x60048fff,0x00840fff,0x00c41fff,0x81fe3fff},
// 20
{0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00380000,0x00100000,0x01000000,0x00000000,
0x01000000,0x02020000,0x020a0000,0x03020000,0x01800000,0x06800000,0x3140c000,0x61006000,0xc2163000,0x90141000,
0x81041000,0xc6063000,0x6ca36000,0x3801c000,
0x00000000,0x00000000,0x00000000,0x00000000,0x00080000,0x001c0000,0x01f80000,0x00100000,0x01c00000,0x00e00000,
0x01c00000,0x02fa0000,0x027e0000,0x03020000,0x019bc000,0x06982000,0x3f5cc000,0x6f186000,0xcef63000,0x90f41000,
0x81e41000,0xc7f63000,0x6fa36000,0x39c1c000,
0xffffffff,0xffffffff,0xffffffff,0xff0fffff,0xfe07ffff,0xfe03ffff,0xfe07ffff,0xfe07ffff,0xfe03ffff,0xfc1fffff,
0xf81fffff,0xf805ffff,0xf801ffff,0xf871ffff,0xf8203fff,0xf801dfff,0xc0003fff,0x90049fff,0x3008cfff,0x6c0a6fff,
0x601b6fff,0x3809cfff,0x905c9fff,0xc63e3fff},
// 21
{0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x200000,0x100000,0x4E0000,0x0,0x80000,0x0,0x6207000,0x380D800,0x3CC09800,
0x60C61800,0xC0351800,0x80ED3800,0xC6593000,0xFE397000,0x7C01E000,0xC000,
0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xA10000,0x19F0000,0x3CE0000,0x3803000,0x1E87800,0x20FAF000,0x7E38F000,
0x7F81D800,0x7FFC9800,0x67FE1800,0xC0351800,0x80EF3800,0xC7DF3000,0xFFF97000,0x7CC1E000,0xC000,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFC3FFFF,0xFF81FFFF,0xFF81FFFF,0xFE00FFFF,
0xFC00FFFF,0xF801FFFF,0xF861CFFF,0xF81387FF,0xD8050FFF,0x80020FFF,0x800827FF,0x800067FF,0x980027FF,
0x3C02A7FF,0x6000C7FF,0x3800CFFF,0x68FFF,0x83361FFF,0xFFFF3FFF},
// 22
{0x0,0x0,0x0,0x0,0x0,0x0,0x1C000,0x8000,0x40000,0x0,0x400000,0x10820000,0xB018000,0x4000000,0x0,
0x1800000,0x600000,0x1C04B800,0x30058C00,0x653D0400,0x40BD0400,0x61BD8C00,0x3F01FC00,0x1E00F800,
0x0,0x0,0x0,0x0,0x4000,0xE000,0xFC000,0x8000,0xF03C0000,0x703C0000,0x607E0000,0x108E0000,0xB018000,
0x4000000,0x30000,0x1F877800,0x3FF0800,0x1F8FB800,0x33058C00,0x673D0400,0x40FD0400,0x61FD8C00,
0x3FE1FC00,0x1E70F800,
0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFF87FFF,0xFFF03FFF,0xFFF01FFF,0xFFF03FFF,0xFFF07FFF,0xF831FFF,
0x8F03FFFF,0x8601FFFF,0x8001FFFF,0x80067FFF,0xE03E7FFF,0xF01C7FFF,0xE00807FF,0xFC0037FF,0xE00007FF,
0xCC0213FF,0x9802DBFF,0xB002DBFF,0x9E0273FF,0xC01E03FF,0xE18F07FF},
}; // Converted using ImageStudio v1.1 and TTTiler v1.06

unsigned char Shadow[3] = {0x38, 0xFE, 0x7C};  // Shadow for Bike

unsigned short Rider[3][16 * 3] = {
// Rider being tossed off Bike
{0x0,0x0,0x0,0x38,0x28,0x0,0x38,0x8B1C,0xC604,0xC664,0x4018,0x0,0x0,0x0,0x0,0x0,
0x0,0x30,0x78,0x3F,0x28,0x1,0xC1FF,0xFB1F,0xFF07,0xFFE7,0x63DF,0x3C1,0x780,0x780,0x0,0x0,
0xFFE1,0xFFC0,0xFF80,0xFFC0,0xFFC0,0xFFC0,0x2000,0x0,0x0,0x0,0x9C00,0xFC08,0xF879,0xF87F,
0xFFFF,0xFFFF},
// Rider Running Animation Step 1
{0x0,0x0,0x0,0x7000,0x5000,0x0,0xC00,0x0,0x80,0x840,0xC80,0x80,0x0,0x0,0x0,0x0,
0x0,0x7000,0xF000,0x7EC0,0x51E0,0x3C0,0x1D80,0x1100,0x3080,0x7840,0x2C80,0x80,0x40,0x780,0x3C0,0x380,
0xC3FF,0x81FF,0x1FF,0x813F,0x801F,0x800F,0xE04F,0x207F,0x3F,0x803F,0xD03F,0xF03F,0xF83F,0xF87F,
0xFC3F,0xFC7F},
// Rider Running Animation Step 2
{0x0,0x0,0x0,0x7000,0x5000,0x0,0x1800,0x0,0x0,0x0,0x0,0x3A00,0x100,0x0,0x0,0x0,
0x0,0x7000,0xF000,0x7E00,0x5000,0x200,0x3F00,0x700,0x1740,0x1EE0,0x3E70,0x7A70,0x7110,0x7000,0xF000,0xE000,
0xC3FF,0x81FF,0x1FF,0x81FF,0x81FF,0x81FF,0xC0FF,0xE0FF,0x80BF,0x801F,0xC00F,0x800F,0x882F,0x8C7F,
0xFFF,0x1FFF},
};

unsigned char Starting_Blocks[2][10 * 2] = {
{0x46, 0xF3, 0xF5, 0xF6, 0xF6, 0xF6, 0xF6, 0xFA, 0xFC, 0xFE, 
0xB1, 0x0, 0x0, 0x76, 0x40, 0x40, 0x40, 0x40, 0x40, 0x7E}, 
{0x4E, 0xFF, 0xFF, 0xC0, 0xDE, 0xDE, 0xDE, 0xDE, 0xDE, 0xC0, 
0xB1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0}, 
};

unsigned char Sparks[2][8] = {
{0x0, 0x8, 0x80, 0x32, 0xC, 0x47, 0x9, 0x16},
{0x40, 0xAC, 0x50, 0x18, 0x22, 0x48, 0x32, 0x1},
};

unsigned char ExciteBike_Title[2][18 * 16] = {  // ExciteBike Titlescreen! (144x16)
{0x00,0x01,0x81,0x81,0xC0,0x03,0x01,0x00,0x01,0x00,0x01,0x00,0x03,0x01,0x03,0x01,  // Dark
0x00,0x01,0x00,0x01,0x81,0x81,0x80,0x01,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x01,
0x03,0x01,0x00,0x01,0x7F,0xFD,0xBD,0xBD,0xBF,0xE1,0x7D,0x7F,0xFD,0x7F,0xFD,0x7F,
0xC1,0x7D,0x43,0x7D,0x7F,0xFD,0x00,0x01,0x91,0x89,0x80,0x11,0x01,0x00,0x01,0x00,
0x01,0x00,0x11,0x01,0x23,0x31,0x00,0x01,0x83,0xFF,0xCB,0xD3,0xA3,0xD1,0xA3,0xFA,
0x3F,0x83,0xFF,0x83,0xD1,0xA3,0xA3,0xA3,0x83,0xFF,0xA3,0xFF,0xE1,0x87,0xA3,0xC1,
0xA3,0xFA,0x3F,0xA3,0xFF,0xA3,0xD1,0xA3,0xA3,0x07,0xA3,0xFF,0xA0,0x0F,0xF0,0x0F,
0xA3,0xFF,0xA3,0xFA,0x3F,0xA0,0x0F,0xA0,0x01,0xA3,0xA2,0x0F,0xA0,0x0F,0xA0,0x0F,
0xFA,0x1F,0xA3,0xFF,0xA3,0xFA,0x3F,0xA0,0x0F,0xA0,0x03,0xA3,0xA0,0x1F,0xA0,0x0F,
0xA7,0xEF,0xFB,0x9F,0xA3,0xFF,0xA3,0xFA,0x3F,0xA7,0xEF,0xA7,0xC3,0xA3,0xA0,0x9F,
0xA7,0xEF,0xA0,0x0F,0xF0,0x0F,0xA3,0xFF,0xA3,0xFA,0x3F,0xA0,0x0F,0xA0,0x11,0xA3,
0xA2,0x4F,0xA0,0x0F,0xA3,0xFF,0xE1,0x87,0xA3,0xC1,0xA3,0xFA,0x3F,0xA3,0xFF,0xA3,
0xD1,0xA3,0xA3,0x27,0xA3,0xFF,0x83,0xFF,0xC3,0xC3,0xA3,0xC1,0xA3,0xFA,0x3F,0x83,
0xFF,0x83,0xD1,0xA3,0xA3,0xA3,0x83,0xFF,0x00,0x01,0x81,0x81,0x80,0x01,0x01,0xF0,
0x1F,0x00,0x01,0x00,0x11,0x01,0x03,0x01,0x00,0x01,0x00,0x01,0xBD,0xBD,0x8F,0xE1,
0x41,0xF4,0x1F,0x00,0x01,0x00,0x01,0x41,0x43,0x79,0x00,0x01,0x7F,0xFD,0x81,0x81,
0x80,0x01,0x01,0xF0,0x1F,0x7F,0xFD,0x7F,0xC1,0x01,0x03,0x01,0x7F,0xFD,0x00,0x01,
0x81,0x81,0xC0,0x03,0x01,0xF0,0x1F,0x00,0x01,0x00,0x03,0x01,0x03,0x01,0x00,0x01},
{0x00,0x01,0x81,0x81,0xC0,0x03,0x01,0x00,0x01,0x00,0x01,0x00,0x03,0x01,0x83,0x01,  // Light
0x00,0x01,0x00,0x01,0x81,0x81,0x80,0x01,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x01,
0x03,0x01,0x00,0x01,0x7F,0xFD,0xBD,0xFD,0xBF,0xF9,0x7D,0x7F,0xFD,0x7F,0xFD,0x7F,
0xF9,0x7D,0xFF,0xFD,0x7F,0xFD,0xFF,0xFF,0xFF,0xFF,0xFF,0xFD,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFD,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFC,0x0F,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFC,0x0F,0xFC,0xFF,0xFF,0xFF,0xFF,0xFC,0x0F,0xF8,0x0F,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xF8,0x0F,0xF8,0x3F,0xFF,0xFF,0xFF,0xF8,0x0F,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xF9,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xC1,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFD,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xE1,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xF8,0x01,0xF9,0xF1,0xF8,0x3F,0xF9,0xFF,
0x9F,0xF8,0x01,0xF8,0xFF,0xF9,0xFF,0xE1,0xF8,0x01,0x80,0x01,0xFD,0xFD,0xFF,0xFF,
0xFD,0xFF,0xDF,0x80,0x01,0x80,0x3F,0xFD,0xFF,0xF9,0x80,0x01,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF},
};

unsigned char Trophy[2][2 * 15] = {
{0xFF,0xFF,0xF1,0x5F,0xF7,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF},
{0xE0,0x07,0xE0,0x07,0x80,0x01,0x20,0x04,0x60,0x06,0x20,0x04,0x80,0x01,0xF0,0x0F,
0xF8,0x1F,0xFC,0x7F,0xFE,0x7F,0xFC,0x3F,0xFE,0x7F,0xFC,0x3F,0xF8,0x1F},
};

unsigned char Star[2][8] = {
{0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF},
{0xEF,0xEF,0xC7,0x1,0x83,0xC7,0x93,0xBB},
};

unsigned char Podium[3 * 16] = {
0xFF,0x00,0xFF,0xFF,0x08,0xFF,0xFF,0x18,0xFF,0xFF,0x08,0xFF,0xFF,0x08,0xFF,0xFF,
0x08,0xFF,0xFF,0x1C,0xFF,0xFF,0x00,0xFF,0x00,0xCC,0x00,0x18,0xCC,0x18,0x24,0x33,
0x24,0x04,0x33,0x08,0x18,0xCC,0x04,0x20,0xCC,0x24,0x3C,0x33,0x18,0x00,0x33,0x00};

unsigned char Dots[8] = {0xF, 0xF, 0xF, 0xF, 0xF0, 0xF0, 0xF0, 0xF0};

unsigned char Celebrating[4][2 * 16] = {
// First Place Rider with hands in air (or other Rider jumping)
{0xFF,0xC7,0x43,0x56,0x5E,0x3C,0x10,0x1,0x83,0x83,0x83,0x83,0x93,0x93,0x93,0x11,  // Dark
0x7F,0x3E,0x7C,0x46,0x42,0x4,0x28,0x79,0xC7,0xFF,0xFF,0xFF,0xFF,0x93,0xFF,0xFF},  // Light
// Rider who is jumping up and down and is currently squatting
{0xFF,0xFF,0xC7,0xC3,0xD7,0x5F,0x7E,0x10,0x0,0x1,0x83,0x83,0x1,0x39,0x93,0x11,
0xFF,0xFF,0xFF,0xFF,0x4,0x2,0x46,0x28,0x7C,0x45,0xFF,0xFF,0xFF,0xFF,0x93,0xFF},
// Rider facing Left on the Podium (2nd place)
{0xFF,0xE3,0xC2,0xEA,0xFA,0xFE,0x88,0x1,0x1D,0x41,0x21,0xB1,0xC9,0xC9,0xC9,0x88,
0xFE,0xFC,0xFE,0xE2,0xC2,0xE2,0x94,0x3D,0x23,0x7F,0x1F,0x81,0xC9,0xC9,0xFF,0xFF},
// Rider facing Right on the Podium (3rd place)
{0xFF,0xC7,0x43,0x57,0x5F,0x7F,0x11,0x80,0xB8,0x82,0x84,0x8D,0x93,0x93,0x93,0x11,
0x7F,0x3F,0x7F,0x47,0x43,0x47,0x29,0xBC,0xC4,0xFE,0xF8,0x81,0x93,0x93,0xFF,0xFF},
};

unsigned char Mask[10] = 
{0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0};
unsigned short Beep_Mask[16] = 
{0xF81F,0xE007,0xC003,0x8001,0x8001,0x0,0x0,0x0,0x0,0x0,0x0,0x8001,0x8001,0xC003,0xE007,0xF81F};
unsigned short Beep[4][16 * 2] = {
{0x7E0,0x1FF8,0x381C,0x6006,0x6066,0xC013,0xC013,0xC003,0xC003,0xC003,0xC003,0x6006,0x6006,0x381C,
0x1FF8,0x7E0,
0x7E0,0x1818,0x2004,0x4002,0x4002,0x8001,0x8001,0x8001,0x8001,0x8001,0x8001,0x4002,0x4002,0x2004,
0x1818,0x7E0},
{0x7E0,0x1FF8,0x3FFC,0x7FFE,0x7F9E,0xFFEF,0xFFEF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0x7FFE,0x7FFE,0x3FFC,
0x1FF8,0x7E0,
0x7E0,0x1818,0x2004,0x4002,0x4002,0x8001,0x8001,0x8001,0x8001,0x8001,0x8001,0x4002,0x4002,0x2004,
0x1818,0x7E0},
{0x7E0,0x1818,0x2004,0x4002,0x4062,0x8011,0x8011,0x8001,0x8001,0x8001,0x8001,0x4002,0x4002,0x2004,
0x1818,0x7E0,
0x7E0,0x1FF8,0x3FFC,0x7FFE,0x7F9E,0xFFEF,0xFFEF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0x7FFE,0x7FFE,0x3FFC,
0x1FF8,0x7E0},
{0x7E0,0x1FF8,0x3FFC,0x7FFE,0x7F9E,0xFFEF,0xFFEF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0x7FFE,0x7FFE,0x3FFC,
0x1FF8,0x7E0,
0x7E0,0x1FF8,0x3FFC,0x7FFE,0x7FFE,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0x7FFE,0x7FFE,0x3FFC,
0x1FF8,0x7E0},
};