#ifndef __WEAPONS_H_
#define __WEAPONS_H_

#define BULLETSPEED 6
#define LINEDELAY 12

#include "sprites.h"

typedef struct {
	short currentShotType;
	short oldShotType;
	short previousShotType;
	short primitiveShotType;
	short delayFireLine;
} Weapon;

typedef struct smallshot {
	unsigned char type;
	unsigned char subtype;	//up to 127, used for damage
	short x;
	short y;
	char fragmentx;		//used for fireline direction
	char fragmenty;		//used for fireline direction
	unsigned char *pos;	//(in video memory)
	char dir;
	unsigned char tile_under;
} Smallshot;

void weapon_init(void);
void shoot(void);
void spawnLineShot(void);
void spawnPrimitiveShot(short);
void moveShots(void);
void adjustShotPos(short scrollX, short scrollY);

void shooter(Sprite * s);
void spawnShooterShot(Sprite * s, short dir);
void moveEnemyShots(void);
void adjustEnemyShotPos(short scrollX, short scrollY);

extern short bullet[8];

extern Weapon weapon;
extern Smallshot *smallshot;
extern Smallshot *enemyshot;
extern char damages[4];
extern char ammos[4];

#define FIRELINE 64

#endif
