#include "all.h"



Weapon weapon;
Smallshot *smallshot;
Smallshot *enemyshot;

char damages[] = { 2, 7, 1, 1 };	//Weapon damages
char ammos[] = { -1, 30, -1, -1 };	//Weapon ammo's

short bullet[8] =
    { 0x07c0, 0x0aa0, 0x0aa0, 0x07c0, 0x07c0, 0x0c60, 0x0c60, 0x07c0 };
short bullet_mask[] = { ~0x07c0, ~0x0fe0, ~0x0fe0, ~0x07c0 };




//Player (and enemyshot is for enemies)
void weapon_init(void)
{
	short i;
	weapon.primitiveShotType = 1;
	if (episode_score == 0 && player.score == 0) {

		weapon.previousShotType = weapon.primitiveShotType;
		weapon.currentShotType = weapon.primitiveShotType;
		weapon.oldShotType = weapon.primitiveShotType;
	}

	weapon.delayFireLine = 0;
	for (i = 0; i < 20; ++i) {
		smallshot[i].type = 0;
		enemyshot[i].type = 0;		
	}
}

//Player
void shoot(void)
{
	short i;
	if (player.isControlledByEngine)
		return;
	if ((weapon.currentShotType & 0b01111111) !=
	    (weapon.oldShotType & 0b01111111)) {
		player.ammo =
		    ammos[(weapon.currentShotType & 0b01111111) - 1];
	}
	weapon.oldShotType = weapon.currentShotType;
	if (!player.isMoving && level_num_cur != 11) {
		if (keystat.fire == oldkeystat.fire && keystat.fire) {
			if ((weapon.delayFireLine > LINEDELAY)
			    && (weapon.currentShotType & 0b01111111) ==
			    1) {
				weapon.previousShotType =
				    weapon.currentShotType;
				    beep(233,2,VTI,hardwarever);
				spawnLineShot();
				weapon.currentShotType |= 0b10000000;
			} else {
				++weapon.delayFireLine;
			}
		} else {
			weapon.delayFireLine = 0;

			if (weapon.currentShotType != (weapon.previousShotType & 0b01111111))	//was just a fireline
			{
				for (i = 0; i < 20; ++i) {
					smallshot[i].type = 0;
				}
			}

			weapon.currentShotType =
			    (weapon.previousShotType & 0b01111111);
		}
	}
	if (keystat.fire != oldkeystat.fire && keystat.fire
	    && (player.ammo > 0 || player.ammo == -1)) {
	    	beep(233,2,VTI,hardwarever);
		spawnPrimitiveShot(player.face ? 0 : 16);
		if (player.ammo != -1)
			player.ammo--;
	}
	if (player.ammo == 0) {
		weapon.oldShotType = 1;
		weapon.previousShotType = 1;
		weapon.currentShotType = 1;
		player.ammo = -1;
	}
	if (player.ammo == -1) {
		weapon.currentShotType |= 0b00000001;
	}
}


//Enemies
void shooter(Sprite * s)
{
	char direction = 1;
	if (!((s->dir) < 0))
		direction = 1;
	else
		direction = 0;
	if (s->major != 0)
		spawnShooterShot(s, direction ? 0 : 16);
}

short firelinedir = 0;
//Player
void spawnLineShot(void)
{
	if (weapon.currentShotType !=
	    (weapon.currentShotType | 0b10000000)) {
		firelinedir = player.face ? 0 : 16;
	}
	if (keystat.left) {
		--firelinedir;
	}
	if (keystat.right) {
		++firelinedir;
	}
	if ((firelinedir > 24) || (firelinedir <= 8)) {
		player.face = 1;
		player.sprite = aniMapRight[player.animationStep];
		player.mask = aniMaskRight[player.animationStep];
	}


	else {
		player.face = 0;
		player.sprite = aniMapLeft[player.animationStep];
		player.mask = aniMaskLeft[player.animationStep];
	}

	firelinedir &= 0x1f;
	spawnPrimitiveShot(firelinedir);
}

//Player
void spawnPrimitiveShot(short dir)
{
	short i;
	Smallshot *currentshot;
	for (i = 0; i < 20; ++i) {
		if (smallshot[i].type == 0)
			break;
	}
	if (i == 20)
		return;

	currentshot = smallshot + i;
	currentshot->type = weapon.currentShotType & 0b01111111;
	currentshot->subtype =
	    damages[(weapon.currentShotType & 0b01111111) - 1];
	currentshot->x =
	    (player.x >> 3) + player.face +
	    ((currentshot->type == 2) ? (player.face ? 1 : -1) : 0)
	    - (player.face ? -1 : 1) +
	    ((level_num_cur == 11) ? (player.face ? 1 : -1) : 0);
	currentshot->y = ((player.y & ~7) >> 3) + level.shootfactor;	/* - level.correction + 1 */
	currentshot->fragmentx = 0;
	currentshot->fragmenty = 0;
	currentshot->dir = dir;
	currentshot->pos =
	    vidmem + 21 * currentshot->y + currentshot->x/* +
	    ((int) (fillform ? 0 : 21))*/;
	currentshot->tile_under = *currentshot->pos;
}

//Player and enemy
void draw_bullets(void)
{
	short i;
	short tempval = -8 + (level.correction << 3);
	for (i = 0; i < 20; ++i) {
		if (enemyshot[i].type != 0) {
			if (!(enemyshot[i].dir)) {
				Sprite16_OR_GS(enemyshot[i].x + 4,
					       enemyshot[i].y, 4, bullet,
					       bullet_mask);
				Sprite16_OR_GS(enemyshot[i].x + 2,
					       enemyshot[i].y, 4, bullet,
					       bullet_mask);
				Sprite16_OR_GS(enemyshot[i].x,
					       enemyshot[i].y, 4, bullet,
					       bullet_mask);
			} else {
				Sprite16_OR_GS(enemyshot[i].x - 4,
					       enemyshot[i].y, 4, bullet,
					       bullet_mask);
				Sprite16_OR_GS(enemyshot[i].x - 2,
					       enemyshot[i].y, 4, bullet,
					       bullet_mask);
				Sprite16_OR_GS(enemyshot[i].x,
					       enemyshot[i].y, 4, bullet,
					       bullet_mask);
			}
		}
	}
	for (i = 0; i < 20; ++i) {
		switch (smallshot[i].type) {

		case 1:
			if (weapon.currentShotType ==
			    (weapon.currentShotType & 0b01111111)) {
				Sprite16_OR_GS((smallshot[i].x << 3) -
					       (player.face ? 4 : -4),
					       (smallshot[i].y << 3) + 4 +
					       tempval, 4, bullet,
					       bullet_mask);
				Sprite16_OR_GS((smallshot[i].x << 3) -
					       (player.face ? 2 : -2),
					       (smallshot[i].y << 3) + 4 +
					       tempval, 4, bullet,
					       bullet_mask);
			}
			Sprite16_OR_GS(smallshot[i].x << 3,
				       (smallshot[i].y << 3) + 4 + tempval,
				       4, bullet, bullet_mask);
			break;
		case 2:
			Sprite16_OR_GS((smallshot[i].x << 3),
				       (smallshot[i].y << 3) + 1 + tempval,
				       12,
				       player.
				       face ? (short *) rocket : (short *)
				       rocket_left,
				       player.
				       face ? (short *) rocket_mask
				       : (short *) rocket_left_mask);
			break;
		}
	}
}

//Enemy
void spawnShooterShot(Sprite * s, short dir)
{
	short i;
	Smallshot *currentshot;
	char direction;
	dir = dir;
	if (!((s->dir) < 0))
		direction = 1;
	else
		direction = 0;
	for (i = 0; i < 20; ++i) {
		if (enemyshot[i].type == 0)
			break;
	}
	if (i == 20)
		return;
		
		if(level_num_cur!=11) beep(277,2,VTI,hardwarever);
		
	currentshot = enemyshot + i;
	currentshot->type = 1;
	currentshot->subtype = 0;
	currentshot->x =
	    (s->x) + (direction << 3) +
	    ((level_num_cur == 11) ? (direction ? 1 : -1) : 0);
	currentshot->y =
	    (s->y) + ((((s->height) > 16) ? 12 : 8)) +
	    (level.enemyfactor << 3) + ((level_num_cur == 11) ? (-2) : 0);
	currentshot->fragmentx = 0;
	currentshot->fragmenty = 0;
	currentshot->dir = direction;
	currentshot->pos = vidmem + 21 * currentshot->y + currentshot->x;
	currentshot->tile_under = *currentshot->pos;
}

//Player
void moveShot_smallshot(short i);
void moveShots(void)
{
	short i;
	for (i = 19; i >= 0; --i) {
		if (smallshot[i].type != 0) {
			*smallshot[i].pos = smallshot[i].tile_under;
		}
	}
	for (i = 0; i < 20; ++i) {
		if (smallshot[i].type != 0) {
			moveShot_smallshot(i);
		}
	}
}

//Player
short dir_to_deltax[] =
    { 4, 4, 4, 4, 4, 3, 2, 1, 0, -1, -2, -3, -4, -4, -4, -4, -4, -4, -4,
	-4, -4, -3, -2, -1, 0, 1, 2, 3, 4, 4, 4, 4,
};
short dir_to_deltay[] =
    { 0, 1, 2, 3, 4, 4, 4, 4, 4, 4, 4, 4, 4, 3, 2, 1, 0, -1, -2, -3, -4,
	-4, -4, -4, -4, -4, -4, -4, -4, -3, -2, -1,
};
//Player
void moveShot_smallshot(short i)
{
	short speed;
	Smallshot *currentshot = smallshot + i;
	if ((weapon.currentShotType >> 7) == 1) {
		speed = 1;
	} else {
		speed = 2;
		if ((weapon.currentShotType & 0x01111111) == 2)
			speed = 1;
	}
	if (currentshot->x < 0 || currentshot->x > 20) {
		currentshot->type = 0;
		return;
	}
	if (currentshot->y < 0 || currentshot->y > 12) {
		currentshot->type = 0;
		return;
	}
	currentshot->pos = vidmem + 21 * currentshot->y + currentshot->x;
//Position checking     
	if (currentshot->type != 0) {
		unsigned short current =
		    (((((currentshot->dir > 24)
			|| (currentshot->dir <=
			    8))) ? 1 : 0) + ((weapon.currentShotType !=
					      (weapon.
					       currentShotType | 0b10000000))
					     ? (((currentshot->dir > 24)
						 || (currentshot->dir <=
						     8)) ? 1 : -1)
					     : 0));
		if (attribs
		    [*
		     (vidmem + 21 * currentshot->y + currentshot->x +
		      current)] ==
		    1 /* || (attribs[*currentshot->pos]==1) */ ) {
			currentshot->type = 0;

			return;
		}
		current =
		    ((weapon.currentShotType !=
		      (weapon.
		       currentShotType | 0b10000000)) ? (((currentshot->
							    dir > 24)
							   ||
							   (currentshot->
							    dir <=
							    8)) ? 1 : -1) :
		     0);
// If the tile is a shootable tile...
		if (attribs
		    [*
		     (vidmem + 21 * currentshot->y + currentshot->x +
		      current + 21 * level.shootingfactor)] == 6) {
			if (currentshot->y >= 0 && currentshot->y < 12
			    && currentshot->x >= 0
			    && currentshot->x < 20) {
				unsigned char *destroyed;
				destroyed =
				    level.baseptr +
				    level.yHard * level.xSize +
				    level.xHard + current +
				    level.xSize * currentshot->y +
				    currentshot->x +
				    level.xSize * level.shootingfactor;
				*destroyed = 255;
				destroyed =
				    vidmem + 21 * currentshot->y +
				    currentshot->x + current +
				    21 * level.shootingfactor;
				*destroyed = 255;
				currentshot->type = 0;
				player.score += 10;
			}
			return;
		}
// For the rotating fireline                    
		currentshot->fragmentx +=
		    dir_to_deltax[(int) currentshot->dir];
		if (currentshot->fragmentx < 0) {
			currentshot->x -= speed;
			currentshot->pos -= speed;
			currentshot->fragmentx += 4;
		} else if (currentshot->fragmentx > 3) {
			currentshot->x += speed;
			currentshot->pos += speed;
			currentshot->fragmentx -= 4;
		}
		currentshot->fragmenty +=
		    dir_to_deltay[(int) currentshot->dir];
		if (currentshot->fragmenty < 0) {
			currentshot->y -= speed;
			currentshot->pos -= speed * 21;
			currentshot->fragmenty += 4;
		} else if (currentshot->fragmenty > 3) {
			currentshot->y += speed;
			currentshot->pos += speed * 21;
			currentshot->fragmenty -= 4;
		}
		if (currentshot->x < 0 || currentshot->x > 20) {
			currentshot->type = 0;
		}
		if (currentshot->y < 0 || currentshot->y > 12) {
			currentshot->type = 0;
		}
		currentshot->tile_under = *currentshot->pos;
	}
}

//Player
void adjustShotPos(short scrollX, short scrollY)
{
	short i;
	Smallshot *currentshot;
	for (i = 0; i < 20; ++i) {
		currentshot = smallshot + i;
		if (currentshot->type != 0) {
			currentshot->x -= scrollX;
			currentshot->y -= scrollY;
			if (currentshot->x < 0 || currentshot->x > 20) {
				currentshot->type = 0;
			} else {
				currentshot->pos -= scrollX;
			}
			if (currentshot->y < 0 || currentshot->y > 12) {
				currentshot->type = 0;
			} else {
				currentshot->pos -= 21 * scrollY;
			}
		}
	}
}














/*--------------------------------------------*/
/* All of the below functions are for enemies.*/
/*--------------------------------------------*/
void moveShot_enemyshot(short i);
void moveEnemyShots(void)
{
	short i;
	for (i = 0; i < 20; ++i) {
		if (enemyshot[i].type == 1) {
			moveShot_enemyshot(i);
		}
	}
}

void moveShot_enemyshot(short i)
{
	short speed;
	Smallshot *currentshot = enemyshot + i;
	speed = BULLETSPEED;

	enemyshot[i].pos =
	    vidmem + 21 * (enemyshot[i].y >> 3) + (enemyshot[i].x >> 3);
	if (currentshot->type != 0) {
		unsigned short current =
		    (((((currentshot->dir > 24)
			|| (currentshot->dir <=
			    8))) ? 1 : 0) + ((weapon.currentShotType !=
					      (weapon.
					       currentShotType | 0b10000000))
					     ? (((currentshot->dir > 24)
						 || (currentshot->dir <=
						     8)) ? 1 : -1)
					     : 0)) - 21;
		if (attribs
		    [*
		     (vidmem + 21 * currentshot->y + currentshot->x +
		      current)] == 1
		    ||
		    attribs[*
			    (vidmem + 21 * currentshot->y +
			     currentshot->x + current)] == 6) {
			currentshot->type = 0;
			return;
		}

		if (!(currentshot->dir))
			currentshot->x -= speed;
		if ((currentshot->dir))
			currentshot->x += speed;

		if (currentshot->x < 0 || currentshot->x > 160) {
			currentshot->type = 0;
		}
		if (currentshot->y < 0 || currentshot->y > 96) {
			currentshot->type = 0;
		}

	}

}

void adjustEnemyShotPos(short scrollX, short scrollY)
{
	short i;
	Smallshot *currentshot;
	for (i = 0; i < 20; ++i) {
		currentshot = enemyshot + i;
		if (currentshot->type != 0) {
			if (currentshot->x < 0 * 8
			    || currentshot->x > 20 * 8) {
				currentshot->type = 0;
			} else {
				currentshot->x -= (scrollX << 3);
			}
			if (currentshot->y < 0 * 8
			    || currentshot->y > 12 * 8) {
				currentshot->type = 0;
			} else {
				currentshot->y -= (scrollY << 3);
			}
		}
	}
}
