#ifndef _SPRITES_H_
#define _SPRITES_H_

typedef struct {
	// data a sprite must have
	short major;		// 0: free, 1..15: major type
	short minor;
	short x;
	short y;
	unsigned short *image;
	unsigned short *mask;
	short height;
	short width;		// only for collision detection
	short life;		// -1: invulnerable
	// persistency information
	unsigned char *_list_entry;
	unsigned char _minor_major;
	// mostly useful
	short dir;		//direction
	short dx;		//dx and dy are mostly delays between movements
	short dy;
	short abs_x;		//absolute x, in tiles, for items and such; reloaded every frame
	short abs_y;		//absolute y, in tiles, for items and such; reloaded every frame
	short ani_step;		//animation step
	short data0;		//delay before animation steps
	short data1;		//used with shooting (delay)
	short shooting;		//used with shooting (amount of delay)
} Sprite;

#define SPRITE_NO 20
extern Sprite *sprites;

// The sprite funcs are for all types of sprites, and set in level.c
typedef struct {
	void (*init) (Sprite * s);
	void (*run) (Sprite * s);
	void (*erase) (Sprite * s);
	void (*kill) (Sprite * s);
	void (*draw) (Sprite * s);
} Sprite_funcs;


extern Sprite_funcs sprite_funcs[];

// The enemy matrix is originally held in the level
// and holds level size, player spawn points, and
// enemy types/ coordinates.
typedef struct {
	char width;
	char height;
	short *offsets;
	unsigned char *matrix;
} Enemy_matrix;
extern Enemy_matrix enemy_matrix;

void init_sprites(void);
short find_free_sprite(void);
void adjust_sprite_pos(short dx, short dy);
void kill_sprites_oos(void);
void erase_all_sprites(void);
short sprite_player_collision(Sprite * s);
void handle_sprites(void);
void Sprite16_OR_GS(short x, short y, short h, unsigned short *sprite,
		    unsigned short *mask);
void Sprite32_OR_GS(short x, short y, short h, unsigned long *sprite,
		    unsigned long *mask);
void draw_bullets(void);
void draw_sprites(void);
void sprite_draw_std(Sprite * s);
void enemy_draw_std(Sprite * s);
void sprite_set_default(Sprite * s);
void spawn_enemies(void);
void persistent_sprite(Sprite * s);
void spawn_all_buttons(void);

void duke_init(void);
#endif
