#include "all.h"



// Memory is allocated to this in _main function
Sprite *sprites;

Sprite_funcs sprite_funcs[16];

//Bullet damage
#define DAMAGE (4*difficulty)

Enemy_matrix enemy_matrix;

void init_sprites(void)
{
	short i;
	for (i = 0; i < SPRITE_NO; ++i) {
		sprites[i].major = 0;
		sprites[i].data1 = 0;
	}
}

short find_free_sprite(void)
{
	short i;
	for (i = 0; i < SPRITE_NO; ++i) {

		if (sprites[i].major == 0) {
			return i;
		}
	}
	return -1;
}

void adjust_sprite_pos(short dx, short dy)
{
	short i;
	for (i = 0; i < SPRITE_NO; ++i) {
		if (sprites[i].major != 0) {
			sprites[i].x -= dx;
			sprites[i].y -= dy;
		}

	}
}

// Kill sprites that are out of sight
// (should rather be erase_sprites_oos due to the new naming convention)
void kill_sprites_oos(void)
{
	short i;
	Sprite *s = sprites;
	for (i = 0; i < SPRITE_NO; ++i, ++s) {
//Unless they don't exist, are exit/save points, or buttons, or bosses

// this is not supposed to be evaluated here, if a sprite wants to be
// persistent it has to say so when being killed, there should be no sprite
// hanging around in the far umbra
		if (s->major == 0 || s->major == 15 || s->data1 == 99
		    || s->major == 8 || s->major == 10 || s->major == 4)
			continue;
		if (s->x < -100 || s->x > 260) {
			sprite_funcs[s->major].erase(s);
			s->major = 0;
		} else if (s->y < -100 || s->y > 200) {
			sprite_funcs[s->major].erase(s);
			s->major = 0;

		}
	}
}

// don't call init_sprites if player respawns, persistency is handled here
void erase_all_sprites(void)
{
	Sprite *s = sprites;
	int i;

	for (i = 0; i < SPRITE_NO; ++i, ++s) {
		if (s->major) {
			sprite_funcs[s->major].erase(s);
			s->major = 0;
		}
	}
}

// For sprite_shot_collision
static short get_shot_power(short x, short y)
{
	short i;
	if (x < 0 || x >= 20)
		return 0;
	if (y < 0 || y >= 12)
		return 0;
	for (i = 0; i < 20; ++i) {
		if ((smallshot[i].x == x) && (smallshot[i].y == y)
		    && (smallshot[i].type != 0)) {
			smallshot[i].type = 0;
			return smallshot[i].subtype;
		}

	}
	return 0;
}

//To see if Duke bullets hit level sprites
static void sprite_shot_collision()
{
	short i;
	short x, y;
	short pow;

	Sprite *s = sprites;
	for (i = 0; i < SPRITE_NO; ++i, ++s) {
		if (s->major == 0)
			continue;
		if (s->life < 0)
			continue;
		x = s->x >> 3;
		if (level_num_cur == 12)
			x--;
		y = s->y >> 3;
		if (level_num_cur == 12)
			y -= 2;
		pow = get_shot_power(x, y);
		if (pow)
			s->life -= pow;
		++x;
		pow = get_shot_power(x, y);
		if (pow)
			s->life -= pow;
		++y;
		pow = get_shot_power(x, y);
		if (pow)
			s->life -= pow;
		--x;
		pow = get_shot_power(x, y);
		if (pow)
			s->life -= pow;
		if (s->height >= 16) {
			++y;
			pow = get_shot_power(x, y);
			if (pow)
				s->life -= pow;
			++x;
			pow = get_shot_power(x, y);
			if (pow)
				s->life -= pow;
		}
		if (s->life <= 0) {
			sprite_funcs[s->major].kill(s);
			s->major = 0;
		}
	}
}

//To see if enemy bullets hit Duke
static void player_shot_collision()
{

	short x, y, i;

	for (i = 0; i < 20; ++i) {
		x = ((player.x) >> 3);
		y = ((player.y + 4) >> 3);
		if (level_num_cur == 11)
			y -= 2;
		if (x == (enemyshot[i].x >> 3)
		    && y == (enemyshot[i].y >> 3)
		    && enemyshot[i].type != 0) {
			player.life -= DAMAGE;
			enemyshot[i].type = 0;
			break;
		}
		player.face ? ++x : --x;
		if (x == (enemyshot[i].x >> 3)
		    && y == (enemyshot[i].y >> 3)
		    && enemyshot[i].type != 0) {
			player.life -= DAMAGE;
			enemyshot[i].type = 0;
			break;
		}
		player.face ? --x : ++x;
		player.face ? --x : ++x;
		if (x == (enemyshot[i].x >> 3)
		    && y == (enemyshot[i].y >> 3)
		    && enemyshot[i].type != 0) {
			player.life -= DAMAGE;
			enemyshot[i].type = 0;
			break;
		}
		++y;
		if (x == (enemyshot[i].x >> 3)
		    && y == (enemyshot[i].y >> 3)
		    && enemyshot[i].type != 0) {
			player.life -= DAMAGE;
			enemyshot[i].type = 0;
			break;
		}
		player.face ? ++x : --x;
		if (x == (enemyshot[i].x >> 3)
		    && y == (enemyshot[i].y >> 3)
		    && enemyshot[i].type != 0) {
			player.life -= DAMAGE;
			enemyshot[i].type = 0;
			break;
		}
		player.face ? ++x : --x;
		if (x == (enemyshot[i].x >> 3)
		    && y == (enemyshot[i].y >> 3)
		    && enemyshot[i].type != 0) {
			player.life -= DAMAGE;
			enemyshot[i].type = 0;
			break;
		}
		if (level_num_cur == 11) {
			++y;
			if (x == (enemyshot[i].x >> 3)
			    && y == (enemyshot[i].y >> 3)
			    && enemyshot[i].type != 0) {
				player.life -= DAMAGE;
				enemyshot[i].type = 0;
				break;
			}
			player.face ? --x : +x;
			if (x == (enemyshot[i].x >> 3)
			    && y == (enemyshot[i].y >> 3)
			    && enemyshot[i].type != 0) {
				player.life -= DAMAGE;
				enemyshot[i].type = 0;
				break;
			}
			player.face ? --x : ++x;
			if (x == (enemyshot[i].x >> 3)
			    && y == (enemyshot[i].y >> 3)
			    && enemyshot[i].type != 0) {
				player.life -= DAMAGE;
				enemyshot[i].type = 0;
				break;
			}
		}
	}

	if (player.life <= 0) {
		player.exit_hit = -1;
	}

}

//To check if Duke hits (is very near) an onscreen sprite.
//See enemies.c.
short sprite_player_collision(Sprite * s)
{
	if (s->x > player.x + 16)
		return 0;
	if (s->x + s->width < player.x)
		return 0;
	if (s->y > player.y + 16)
		return 0;
	if (s->y + s->height < player.y)
		return 0;
	return 1;
}

//Run sprite functions
void handle_sprites(void)
{
	short i;
	Sprite *s = sprites;

	sprite_shot_collision();
	player_shot_collision();
	for (i = 0; i < SPRITE_NO; ++i, ++s) {
		if (s->major != 0) {
			sprite_funcs[s->major].run(s);
		}
	}
}

// also performs clipping for a 160x96 screen
// this may cause debris on a ti92 screen
void Sprite16_OR_GS(short x, short y, short height, unsigned short *sprite,
		    unsigned short *mask)
{
	register long addr0 = (long) GrayDBufGetHiddenPlane(0);
	register long addr1 = (long) GrayDBufGetHiddenPlane(1);
	register unsigned short cnt = 16 - (x & 15);
	char mask_exists = 1;
	unsigned short *sprite2 = sprite + height;
	unsigned short *masktwo = mask;
	if (y <= -height || y > 96)
		return;
	if (x <= -16 || x > 160)
		return;
	if (x < 0) {
		addr0 -= 2;
		addr1 -= 2;
	} else {
		addr0 += (x >> 3) & 0xfffe;
		addr1 += (x >> 3) & 0xfffe;
	}
	if (mask == NULL)
		mask_exists = 0;
	if (y <= 0) {
		if (x < 0) {	// makes clipping a bit easier
			--y;
			addr0 += 30;
			addr1 += 30;
		}
		sprite -= y;
		sprite2 -= y;
		if (mask_exists) {
			mask -= y - 1;
			masktwo -= y - 1;
		}
		height += y;
	} else {
		addr0 += (y << 5) - (y << 1);
		addr1 += (y << 5) - (y << 1);
	}
	if (y > (95 - height)) {
		height = 96 - y;
	}
	if (!mask_exists && sprite == NULL)
		return;	
	if (!mask_exists) {	
		for (; height; height--, addr0 += 30, addr1 += 30) {
			*(long *) addr0 |= (long) (*sprite++) << cnt;
			*(long *) addr1 |= (long) (*sprite2++) << cnt;
		}
	} else if (sprite == NULL) {
		for (; height; height--, addr0 += 30, addr1 += 30) {
			*(long *) addr0 &= ~((long) ~(*mask++) << cnt);
			*(long *) addr1 &= ~((long) ~(*masktwo++) << cnt);
		}
	} else if (sprite != NULL) {
		for (; height; height--, addr0 += 30, addr1 += 30) {
			*(long *) addr0 &= ~((long) ~(*mask++) << cnt);
			*(long *) addr1 &= ~((long) ~(*masktwo++) << cnt);
			*(long *) addr0 |= (long) (*sprite++) << cnt;
			*(long *) addr1 |= (long) (*sprite2++) << cnt;
		}
	}
}

// also performs clipping for a 160x96 screen
// this may cause debris on a ti92 screen
void Sprite32_OR_GS(short x, short y, short h, unsigned long *sprite,
		    unsigned long *mask)
{
	register long addr0 = (long) GrayDBufGetHiddenPlane(0);
	register long addr1 = (long) GrayDBufGetHiddenPlane(1);
	register unsigned short cnt = x & 15;
	register unsigned short ccnt = 32 - cnt;

	register unsigned long data;
	unsigned long *sprite2 = sprite + h;

	if (y <= -h || y > 96)
		return;
	if (x <= -16 || x > 160)
		return;
	if (x < 0) {
		addr0 -= 2;
		addr1 -= 2;
	} else {
		addr0 += (x >> 3) & 0xfffe;
		addr1 += (x >> 3) & 0xfffe;
	}
	if (y <= 0) {
		if (x < 0) {	// makes clipping a bit easier
			--y;
			addr0 += 30;
			addr1 += 30;
		}
		sprite -= y;
		sprite2 -= y;
		mask -= y;
		h += y;
	} else {
		addr0 += (y << 5) - (y << 1);
		addr1 += (y << 5) - (y << 1);
	}
	if (y > (95 - h)) {
		h = 96 - y;
	}
	if (sprite == NULL) {
		for (; h; h--, addr0 += 30, addr1 += 30) {
			data = ~(*mask++);
			*(long *) addr0 &=
			    ~(data >> cnt), *(long *) (addr0 + 4) &=
			    ~(data << ccnt);
			*(long *) addr1 &=
			    ~(data >> cnt), *(long *) (addr1 + 4) &=
			    ~(data << ccnt);
		}
	} else if (sprite != NULL) {
		for (; h; h--, addr0 += 30, addr1 += 30) {
			data = ~(*mask++);
			*(long *) addr0 &=
			    ~(data >> cnt), *(long *) (addr0 + 4) &=
			    ~(data << ccnt);
			*(long *) addr1 &=
			    ~(data >> cnt), *(long *) (addr1 + 4) &=
			    ~(data << ccnt);
			data = *sprite++;
			*(long *) addr0 |=
			    (data >> cnt), *(long *) (addr0 + 4) |=
			    (data << ccnt);
			data = *sprite2++;
			*(long *) addr1 |=
			    (data >> cnt), *(long *) (addr1 + 4) |=
			    (data << ccnt);
		}
	}
}

//Draw sprites
void draw_sprites(void)
{
	short i;
	Sprite *s = sprites;

	for (i = 0; i < SPRITE_NO; ++i, ++s) {
		if (s->major != 0)
			sprite_funcs[s->major].draw(s);
	}
}

void sprite_draw_std(Sprite * s)
{
	Sprite16_OR_GS(s->x, s->y, s->height, s->image, s->mask);
}

void enemy_draw_std(Sprite * s)
{
//Note that the following lines of mask drawing may
//look a little strange. However, they are the easiest way
//to add a white border around enemies so that they are
//more visible.
if (s->y > 1) {
Sprite16_OR_GS(s->x - 1, s->y - 1, s->height, NULL, s->mask);
Sprite16_OR_GS(s->x + 1, s->y - 1, s->height, NULL, s->mask);
				}
Sprite16_OR_GS(s->x - 1, s->y + 1, s->height, NULL, s->mask);
Sprite16_OR_GS(s->x + 1, s->y + 1, s->height, NULL, s->mask);
//Draw the sprite normally now.
Sprite16_OR_GS(s->x, s->y, s->height, s->image, s->mask);
}

void sprite_set_default(Sprite * s)
{
	s->x = 0;
	s->y = 0;
	// no default for major, minor
	s->image = NULL;
	s->mask = NULL;
	s->height = 16;
	s->width = 16;
	s->_list_entry = NULL;
	s->dy = 0;
	s->life = -1;
	s->shooting = 0;
}

void spawn_enemies(void)
{
	short x, y;
	static short q = 0;
	unsigned char *list;
	unsigned char *list_end;
	short offset;
	short sprite_no;
	Sprite *s;
	short type;

	// matrix is sorted into 32x32 areas
	x = level.xHard >> 5;
	y = level.yHard >> 5;

	// it's possible to have a total of 4 areas to check at intersections,
	// q determines the sector, limiting the search effort
	if ((q & 1) && (x < enemy_matrix.width - 1))
		++x;
	if ((q & 2) && (y < enemy_matrix.height - 1))
		++y;

	list = enemy_matrix.matrix;
	list_end = enemy_matrix.matrix;
	offset = enemy_matrix.width * y + x;
	list += *(enemy_matrix.offsets + offset);
	list_end += *(enemy_matrix.offsets + offset + 1);

	sprite_no = find_free_sprite();
	while (sprite_no != -1) {
		if (list == list_end)
			break;
		type = list[0];
		if ((type & 15) == 0) {	// removed from list
			list += 5;
			continue;
		}
		// make positions relative to screen
		x = (list[1]) << 8;
		x += list[2];
		sprites[sprite_no].abs_x = x;
		x -= level.xHard;
		y = (list[3]) << 8;
		y += list[4];
		sprites[sprite_no].abs_y =
		    y /* - level.correction */  +
		    (((type & 15) >= 14) ? level.correction : 0);
		y -= level.yHard + ((level.yHard == 0) ? 1 : 0);
		y -= level.correction;
		if ((type & 15) >= 14)
			y += level.correction;
		if (((type & 15) != 6) && ((type & 15) != 4)
		    && ((type & 15) != 1) && ((type & 15) != 2)
		    && ((type & 15) != 3)) {
			if (x < -1 || x > 22) {	// not on screen
				list += 5;
				continue;
			}
			if (y < -1 || y > 14) {	//0,14
				list += 5;
				continue;
			}
		}
		// preparation
		s = &sprites[sprite_no];
		sprite_set_default(s);
		s->x = x << 3;
		s->y = (y << 3);	//+(fillform ? 8 : 0)

		s->major = type & 15;
		if ((s->major == 6)) {
			type -= 2;
			s->major = 4;
			s->data1 = 99;
		}
		if (s->major == 10 && level_num_cur != 11) {
			type = 1;
			s->major = 1;
		}
		if (s->major == 14)
			s->y += level.correction * 8;
		s->minor = (type >> 4) & 15;
		// if sprite wants to be persistent
		s->_list_entry = list;
		s->_minor_major = type;
		sprite_funcs[type & 15].init(s);
		// spawned, remove from list
		// persitency is handled when sprite is killed
		list[0] = 0;
		list += 5;
		sprite_no = find_free_sprite();
	}
	++q;
}

// call this if the sprite gets killed and wants to respawn the next time,
// important for tag sprites
void persistent_sprite(Sprite * s)
{
	if (s->_list_entry) {
		if (s->data1 == 99 && s->major == 4) {
			s->_minor_major += 2;
		}
		*s->_list_entry = s->_minor_major;
	}
}


void spawn_all_buttons(void)
{
	short x = 0, y = 0;
	short matx = 0, maty = 0;
	static short qq = 0;
	unsigned char *list;
	unsigned char *list_end;
	short offset;
	short sprite_no;
	Sprite *s;
	short type;
	while (maty < enemy_matrix.height) {
		while (matx < enemy_matrix.width) {
			// it's possible to have a total of 4 areas to check at intersections,
			// q determines the sector, limiting the search effort
			if ((qq & 1) && (x < enemy_matrix.width - 1))
				++x;
			if ((qq & 2) && (y < enemy_matrix.height - 1))
				++y;


			list = enemy_matrix.matrix;
			list_end = enemy_matrix.matrix;
			offset = enemy_matrix.width * maty + matx;
			list += *(enemy_matrix.offsets + offset);
			list_end += *(enemy_matrix.offsets + offset + 1);
			sprite_no = find_free_sprite();
			while (sprite_no != -1) {
				if (list == list_end)
					break;
				type = list[0];
				if ((type & 15) != 6) {	// not a pressed button
					list += 5;
					continue;
				}
				// make positions relative to screen
				x = (list[1]) << 8;
				x += list[2];
				sprites[sprite_no].abs_x = x;
				x -= level.xHard;
				y = (list[3]) << 8;
				y += list[4];
				sprites[sprite_no].abs_y = y - 1;
				y -= level.yHard +
				    ((level.yHard == 0) ? 1 : 0);
				y -= level.correction;
				// preparation
				s = &sprites[sprite_no];
				sprite_set_default(s);
				s->x = x << 3;
				s->y = (y << 3);
				s->major = 4;
				type -= 2;
				s->data1 = 99;
				s->minor = (type >> 4) & 15;
				// if sprite wants to be persistent
				s->_list_entry = list;
				s->_minor_major = type;
				sprite_funcs[type & 15].init(s);
				// spawned, remove from list
				// persitency is handled when sprite is killed
				list[0] = 0;
				list += 5;
				sprite_no = find_free_sprite();
			}
			++qq;
			matx++;
		}
		maty++;
	}

}
