#include "all.h"

/* Note: If you wish to use the engine with modules (4x4 or 2x2 tile blocks),
		you must decomment the support below (fillupX/Y_module4/2)              */



Level level;


// Note: prepVidmem assumes that there is at least one screen to
// the right, it prepares the initial screen by hard scrolling
void prepVidmem(void)
{
	short x;

	level.xHard += 21;
	for (x = 0; x < 21; ++x) {
		hardscrollX_std(-1);
	}
}

// draw the tiles in vidmem to the non-active planes
void drawVidmem(void)
{
	short x, y;
	unsigned char *plane0;
	unsigned char *plane1;
	unsigned char *vidmem_cur;
	unsigned char *tile;


	plane0 = GrayDBufGetHiddenPlane(0);
	plane1 = GrayDBufGetHiddenPlane(1);

	vidmem_cur = vidmem;
	for (x = 0; x < 21; ++x) {
		tile = tiles;
		tile += (*vidmem_cur) << 4;
		tile += level.ySoft * 2;
		*plane0 = *tile++;
		*plane1 = *tile++;
		if (level.ySoft <= 6) {
			*(plane0 + 30) = *tile++;
			*(plane1 + 30) = *tile++;
		}
		if (level.ySoft <= 5) {
			*(plane0 + 60) = *tile++;
			*(plane1 + 60) = *tile++;
		}
		if (level.ySoft <= 4) {
			*(plane0 + 90) = *tile++;
			*(plane1 + 90) = *tile++;
		}
		if (level.ySoft <= 3) {
			*(plane0 + 120) = *tile++;
			*(plane1 + 120) = *tile++;
		}
		if (level.ySoft <= 2) {
			*(plane0 + 150) = *tile++;
			*(plane1 + 150) = *tile++;
		}
		if (level.ySoft <= 1) {
			*(plane0 + 180) = *tile++;
			*(plane1 + 180) = *tile++;
		}
		if (level.ySoft <= 0) {
			*(plane0 + 210) = *tile++;
			*(plane1 + 210) = *tile++;
		}
		++plane0;
		++plane1;
		++vidmem_cur;
	}
	plane0 += (7 - level.ySoft) * 30 + 9;
	plane1 += (7 - level.ySoft) * 30 + 9;
	for (y = 0; y < 11; ++y) {
		for (x = 0; x < 21; ++x) {
			tile = tiles;
			tile += (*vidmem_cur) << 4;
			*plane0 = *tile++;
			*plane1 = *tile++;
			*(plane0 + 30) = *tile++;
			*(plane1 + 30) = *tile++;
			*(plane0 + 60) = *tile++;
			*(plane1 + 60) = *tile++;
			*(plane0 + 90) = *tile++;
			*(plane1 + 90) = *tile++;
			*(plane0 + 120) = *tile++;
			*(plane1 + 120) = *tile++;
			*(plane0 + 150) = *tile++;
			*(plane1 + 150) = *tile++;
			*(plane0 + 180) = *tile++;
			*(plane1 + 180) = *tile++;
			*(plane0 + 210) = *tile++;
			*(plane1 + 210) = *tile++;
			++plane0;
			++plane1;
			++vidmem_cur;
		}
		plane0 += 219;
		plane1 += 219;
	}
	if (level.ySoft != 0) {
		for (x = 0; x < 21; ++x) {
			tile = tiles;
			tile += (*vidmem_cur) << 4;
			*plane0 = *tile++;
			*plane1 = *tile++;
			if (level.ySoft > 1) {
				*(plane0 + 30) = *tile++;
				*(plane1 + 30) = *tile++;
			}
			if (level.ySoft > 2) {
				*(plane0 + 60) = *tile++;
				*(plane1 + 60) = *tile++;
			}
			if (level.ySoft > 3) {
				*(plane0 + 90) = *tile++;
				*(plane1 + 90) = *tile++;
			}
			if (level.ySoft > 4) {
				*(plane0 + 120) = *tile++;
				*(plane1 + 120) = *tile++;
			}
			if (level.ySoft > 5) {
				*(plane0 + 150) = *tile++;
				*(plane1 + 150) = *tile++;
			}
			if (level.ySoft > 6) {
				*(plane0 + 180) = *tile++;
				*(plane1 + 180) = *tile++;
			}
			++plane0;
			++plane1;
			++vidmem_cur;
		}
	}

}

// scroll screen by count pixels
// count = [-8, 8]
//
// returns the number of actually scrolled pixels
short scrollX(short count)
{
	short actualcount = 0;

	if (level.disableScrollX)
		return 0;

	if (count < 0) {
		if (level.xHard == 0 && level.xSoft < -count) {
			actualcount = -level.xSoft;
			level.xSoft = 0;
		} else {
			level.xSoft += count;
			if (level.xSoft < 0) {
				level.xSoft += 8;
				hardscrollX_std(-1);
			}
			actualcount = count;
		}
	}
	if (count > 0) {
		if (level.xHard == (level.xSize - 21)) {
			if (count > (7 - level.xSoft)) {
				actualcount = 7 - level.xSoft;
				level.xSoft = 7;
			} else {
				actualcount = count;
				level.xSoft += count;
			}
		} else {
			level.xSoft += count;
			if (level.xSoft > 7) {
				level.xSoft -= 8;
				hardscrollX_std(1);
			}
			actualcount = count;
		}
	}
	return actualcount;
}

short scrollY(short count)
{
	short actualcount = 0;

	if (level.disableScrollY)
		return 0;

	if (count < 0) {
		if (level.yHard == 0 && level.ySoft < -count) {
			actualcount = -level.ySoft;
			level.ySoft = 0;
		} else {
			level.ySoft += count;
			if (level.ySoft < 0) {
				level.ySoft += 8;
				hardscrollY_std(-1);
			}
			actualcount = count;
		}
	}
	if (count > 0) {
		if (level.yHard == (level.ySize - 13)) {	//13
			if (count > (7 - level.ySoft)) {
				actualcount = 7 - level.ySoft;
				level.ySoft = 7;
			} else {
				actualcount = count;
				level.ySoft += count;
			}
		} else {
			level.ySoft += count;
			if (level.ySoft > 7) {
				level.ySoft -= 8;
				hardscrollY_std(1);
			}
			actualcount = count;
		}
	}
	return actualcount;
}

// scroll vidmem one tile to the left/right and fill the gap
void hardscrollX_std(short dir)
{
	level.xHard += dir;
	if (dir == 1)
		memmove(vidmem, vidmem + 1, (13 * 21) - 1);
	else
		memmove(vidmem + 1, vidmem, (13 * 21) - 1);
	level.fillupX(dir);
	adjustShotPos(dir, 0);
	adjustEnemyShotPos(dir, 0);
}

void hardscrollY_std(short dir)
{
	level.yHard += dir;
	if (dir == 1)
		memmove(vidmem, vidmem + 21, 12 * 21);
	else
		memmove(vidmem + 21, vidmem, 12 * 21);
	level.fillupY(dir);
	adjustShotPos(0, dir);
	adjustEnemyShotPos(0, dir);
}

/*
void fillupX_module4(short edge)
{
	unsigned char *dest;
	unsigned char *levelsrc;
	short row, col;
	unsigned char *module;
	short modulenr;
	short y;

	levelsrc =
	    level.baseptr + (level.yHard >> 2) * (level.xSize >> 2) +
	    (level.xHard >> 2);
	row = level.yHard & 3;
	col = level.xHard & 3;
	dest = vidmem;
	if (edge == 1) {	// right edge
		dest += 20;
		levelsrc += 5;
	}
	modulenr = *levelsrc;
	module = modules + (modulenr << 4) + 4 * row + col;
	for (y = 0; y < 13; ++y) {
		*dest = *module;
		dest += 21;
		module += 4;
		++row;
		if (row == 4) {
			row = 0;
			levelsrc += level.xSize >> 2;
			//modulenr = *levelsrc << 4;
			modulenr = *levelsrc;
			module = modules + (modulenr << 4) + col;
		}
	}
}

void fillupY_module4(short edge)
{
	unsigned char *dest;
	unsigned char *levelsrc;
	short row, col;
	unsigned char *module;
	short modulenr;
	short x;

	levelsrc =
	    level.baseptr + (level.yHard >> 2) * (level.xSize >> 2) +
	    (level.xHard >> 2);
	row = level.yHard & 3;
	col = level.xHard & 3;
	dest = vidmem;
	if (edge == 1) {	// lower edge
		dest += 12 * 21;
		levelsrc += 3 * (level.xSize >> 2);
	}
	modulenr = *levelsrc++;
	module = modules + (modulenr << 4) + 4 * row + col;
	for (x = 0; x < 21; ++x) {
		*dest++ = *module++;
		++col;
		if (col == 4) {
			col = 0;
			modulenr = *levelsrc++;
			module = modules + (modulenr << 4) + 4 * row;
		}
	}
}*/
/*
static void fillupX_module2(short edge)
{
	unsigned char *dest;
	unsigned char *levelsrc;
	short row, col;
	unsigned char *module;
	short modulenr;
	short y;

	levelsrc =
	    level.baseptr + (level.yHard >> 2) * (level.xSize >> 1) +
	    (level.xHard >> 2);
	row = level.yHard & 1;
	col = level.xHard & 1;
	dest = vidmem;
	if (edge == 1) {	/ / right edge
		dest += 20;
		levelsrc += 10;
	}
	modulenr = *levelsrc;
	module = modules + (modulenr << 2) + 2 * row + col;
	for (y = 0; y < 13; ++y) {
		*dest = *module;
		dest += 21;
		module += 2;
		++row;
		if (row == 2) {
			row = 0;
			levelsrc += level.xSize >> 1;
			modulenr = *levelsrc;
			module = modules + (modulenr << 2) + col;
		}
	}
}

static void fillupY_module2(short edge)
{
	unsigned char *dest;
	unsigned char *levelsrc;
	short row, col;
	unsigned char *module;
	short modulenr;
	short x;

	levelsrc =
	    level.baseptr + (level.yHard >> 2) * (level.xSize >> 1) +
	    (level.xHard >> 2);
	row = level.yHard & 1;
	col = level.xHard & 1;
	dest = vidmem;
	if (edge == 1) {	/ / lower edge
		dest += 12 * 21;
		levelsrc += 6 * (level.xSize >> 1);
	}
	modulenr = *levelsrc++;
	module = modules + (modulenr << 2) + 2 * row + col;
	for (x = 0; x < 21; ++x) {
		*dest++ = *module++;
		++col;
		if (col == 2) {
			col = 0;
			modulenr = *levelsrc++;
			module = modules + (modulenr << 2) + 2 * row;
		}
	}
}
*/
void fillupX_tile(short edge)
{
	unsigned char *dest;
	unsigned char *levelsrc;
	short y;

	levelsrc = level.baseptr + level.yHard * level.xSize + level.xHard;
	dest = vidmem;
	if (edge == 1) {	// right edge
		dest += 20;
		levelsrc += 20;
	}
	for (y = 0; y < 13; ++y) {
		*dest = *levelsrc;
		dest += 21;
		levelsrc += level.xSize;
	}
}

void fillupY_tile(short edge)
{
	unsigned char *dest;
	unsigned char *levelsrc;
	short x;

	levelsrc = level.baseptr + level.yHard * level.xSize + level.xHard;
	dest = vidmem;
	if (edge == 1) {	// lower edge
		dest += 12 * 21;
		levelsrc += 12 * level.xSize;
	}
	for (x = 0; x < 21; ++x) {
		*dest++ = *levelsrc++;
	}
}

// after drawing the tiles, the planes can be scrolled up to 7 pixels to
// the right
// note: the core scroller can scroll up to 16 pixels without modification,
// but you'll need an extra column of tiles to provide the extra information
void softscrollX(void)
{
	unsigned short *plane0, *plane1;
	short shift;
	short y;

	if (level.xSoft == 0)
		return;

	plane0 = GrayDBufGetHiddenPlane(0);
	plane1 = GrayDBufGetHiddenPlane(1);
	//shift = 16 - level.xSoft;
	shift = level.xSoft;

	for (y = 0; y < 12 * 8; ++y) {
		// note: with -O2 the compiler translates each of the double lines
		// below into 5 assembly instructions (one of them is non-sense)
		// even if there's a faster method, this one is pretty fast
		*plane0 =
		    (short) (((*(unsigned long *) plane0) << shift) >> 16);
		++plane0;
		*plane1 =
		    (short) (((*(unsigned long *) plane1) << shift) >> 16);
		++plane1;
		*plane0 =
		    (short) (((*(unsigned long *) plane0) << shift) >> 16);
		++plane0;
		*plane1 =
		    (short) (((*(unsigned long *) plane1) << shift) >> 16);
		++plane1;
		*plane0 =
		    (short) (((*(unsigned long *) plane0) << shift) >> 16);
		++plane0;
		*plane1 =
		    (short) (((*(unsigned long *) plane1) << shift) >> 16);
		++plane1;
		*plane0 =
		    (short) (((*(unsigned long *) plane0) << shift) >> 16);
		++plane0;
		*plane1 =
		    (short) (((*(unsigned long *) plane1) << shift) >> 16);
		++plane1;
		*plane0 =
		    (short) (((*(unsigned long *) plane0) << shift) >> 16);
		++plane0;
		*plane1 =
		    (short) (((*(unsigned long *) plane1) << shift) >> 16);
		++plane1;
		*plane0 =
		    (short) (((*(unsigned long *) plane0) << shift) >> 16);
		++plane0;
		*plane1 =
		    (short) (((*(unsigned long *) plane1) << shift) >> 16);
		++plane1;
		*plane0 =
		    (short) (((*(unsigned long *) plane0) << shift) >> 16);
		++plane0;
		*plane1 =
		    (short) (((*(unsigned long *) plane1) << shift) >> 16);
		++plane1;
		*plane0 =
		    (short) (((*(unsigned long *) plane0) << shift) >> 16);
		++plane0;
		*plane1 =
		    (short) (((*(unsigned long *) plane1) << shift) >> 16);
		++plane1;
		*plane0 =
		    (short) (((*(unsigned long *) plane0) << shift) >> 16);
		++plane0;
		*plane1 =
		    (short) (((*(unsigned long *) plane1) << shift) >> 16);
		++plane1;
		*plane0 =
		    (short) (((*(unsigned long *) plane0) << shift) >> 16);
		++plane0;
		*plane1 =
		    (short) (((*(unsigned long *) plane1) << shift) >> 16);
		++plane1;
		// note: with -O2 the compiler translates each of the lines
		// below into 3 assembly instructions, they're slower for
		// shifts between 0..12, but faster for shifts between
		// 12..16, i.e. not very useful
		//
		//replace 'shift=level.xSoft;' with 'shift=15-level.xSoft;'!
		//*plane0=(short)((*(long *)plane0)>>shift); ++plane0;
		//*plane1=(short)((*(long *)plane1)>>shift); ++plane1;

		plane0 += 5;
		plane1 += 5;
	}
}

// for TI92+: delete the soft scroll buffer at the right egde
// (also non-clipped sprites at the right edge)
// (not seen on a TI89)
void cutEdge(void)
{
	short *plane0, *plane1;
	short y;

	plane0 = (short *) (GrayDBufGetHiddenPlane(0) + 20);
	plane1 = (short *) (GrayDBufGetHiddenPlane(1) + 20);

	for (y = 0; y < 12 * 8; ++y) {
		*plane0 = 0;
		*plane1 = 0;
		*(plane0 + 1) = 0;
		*(plane1 + 1) = 0;
		*(plane0 + 4) = 0;
		*(plane1 + 4) = 0;
		plane0 += 15;
		plane1 += 15;
	}
}
