#ifndef __PLAYER_H_
#define __PLAYER_H_

typedef struct {
	// shared with sprites, must follow this order!
	short x;
	short y;
	unsigned short *sprite;
	unsigned short *mask;
	short height;
	// end shared
	short face;		// 0=left, 1=right
	short old_face;		// 0=left, 1=right      
	short isMoving;
	short isControlledByEngine;
	unsigned char *head;	//Pointer to place in vidmem where player's head is
	unsigned char *feet;	//Pointer to place in vidmem where player's feet place is
	short isAscending;
	short isInWater;
	short isGassed;		//Note that this hasn't been used yet, but is available for external levels
	short gravity;
	short low_gravity;	// 1: player jumps higher (1st level!)
	short data0;
	short animationStep;
	short exit_hit;
	short life;		//0 to 100
	short lives;
	short fallingDamage;
	short ammo;
	// save points
	short saved_x;
	short saved_y;
	//score
	unsigned long score;
} Player;
extern Player player;

//extern unsigned short int dukes[6][38];
//extern unsigned short int mask[6][19];
extern unsigned short *aniMapRight[4];
extern unsigned short *aniMapLeft[4];
extern unsigned short *aniJump[2];
extern unsigned short *aniMaskRight[4];
extern unsigned short *aniMaskLeft[4];
extern unsigned short *aniMaskJump[2];


void player_init(short x, short y);
void player_respawn(void);
void drawPlayer(void);
void drawPlayerLife(short reset_display);
void movePlayer(void);
void contrastchk(void);
short isFreeRight(void);
short isFreeLeft(void);
#endif
