#include "all.h"

//Duke ship defines (for level 11)
#define dukeship(a) ((long*)spritegfx+1122+64*a)	//128
#define dukeshipmask(a) ((long*)spritegfx+1250+32*a)	//64

Player player;




// Draw Duke
void drawPlayer(void)
{
	switch (level_num_cur) {
	case 11:		// If level 11, draw the Duke ship
		Sprite32_OR_GS(player.x - 1 - 8, player.y - 1 - 16, 32,
			       NULL, dukeshipmask(player.face));
		Sprite32_OR_GS(player.x + 1 - 8, player.y - 1 - 16, 32,
			       NULL, dukeshipmask(player.face));
		Sprite32_OR_GS(player.x - 1 - 8, player.y + 1 - 16, 32,
			       NULL, dukeshipmask(player.face));
		Sprite32_OR_GS(player.x + 1 - 8, player.y + 1 - 16, 32,
			       NULL, dukeshipmask(player.face));
		Sprite32_OR_GS(player.x - 8, player.y - 16, 32,
			       dukeship(player.face),
			       dukeshipmask(player.face));
		break;
	default:		//Otherwise just draw Duke
		Sprite16_OR_GS(player.x - 1, player.y - 1 - 3, 19, NULL,
			       player.mask);
		Sprite16_OR_GS(player.x + 1, player.y - 1 - 3, 19, NULL,
			       player.mask);
		Sprite16_OR_GS(player.x - 1, player.y + 1 - 3, 19, NULL,
			       player.mask);
		Sprite16_OR_GS(player.x + 1, player.y + 1 - 3, 19, NULL,
			       player.mask);
		Sprite16_OR_GS(player.x, player.y - 3, 19, player.sprite,
			       player.mask);
		break;
	}

}

//Function to draw Duke's life (and ammo)
static void display_life(char *plane, short len)
{
	short i;
	short count;

	// full 8-pixel blocks
	for (i = 0; i < len / 8; ++i) {
		*plane = 0xff;
		*(plane + 30) = 0xff;
		*(plane + 60) = 0xff;
		++plane;
	}
	// the rest
	count = 8 - (len & 7);
	*plane = 0xff << count;
	*(plane + 30) = 0xff << count;
	*(plane + 60) = 0xff << count;
}

//drawPlayerLife draws life, ammo, lives, score, etc
void drawPlayerLife(short reset_display)
{
	static short disp_life = 0;
	char *plane0 = (char *) GrayDBufGetHiddenPlane(0);
	char *plane1 = (char *) GrayDBufGetHiddenPlane(1);
	short life = player.life;
	short extralife = 0;
	short ammo = player.ammo;
	char buffer[80] = { 0 };

// If weapon isn't bullets (unlimited), use its ammo
	if (ammo != -1) {
		ammo =
		    (ammo << 4) /
		    (ammos[(weapon.currentShotType & 0b01111111) - 1]);
	}
// If weapon is bullets, set 'ammo' to the Fireline delay
// This shows a progress meter before the fireline is shot.
	if (ammo == -1) {
		ammo = (weapon.delayFireLine * 16) / (LINEDELAY + 1);
	}

	if (reset_display) {
		disp_life = 0;
		return;
	}


	plane0 += 30 * 95;
	plane1 += 30 * 95;

	life = (life * 14) / 25;
	// sanity
	if (life < 0)
		life = 0;
	if (life > 56) {
		extralife = life - 56;
		life = 56;
	}
//The adjustment below is so that it fits in a certain area.
	extralife = (extralife * 8) / 25;

	// nice progress bar effect if player receives health
	if (disp_life < life) {
		disp_life += 2;
	} else {
		disp_life = life;
	}


/*           HUD                    */
	display_life(plane0, 56);	//life
	display_life(plane1, disp_life);
	display_life(plane1 + 7, extralife);
	sprintf(buffer, " Lives:%i  %lu", player.lives,
		episode_score + player.score);
	DrawGrayStrExt2B(76, 95, buffer, A_NORMAL, F_4x6,
			 GrayDBufGetHiddenPlane(0),
			 GrayDBufGetHiddenPlane(1));
	if (player.ammo != -1)
		display_life(plane0 + 9 * 2, 16);
	else {
		if (ammo > 1)
			display_life(plane0 + 9 * 2, 16);
		else
			display_life(plane0 + 9 * 2, ammo);
	}

	display_life(plane1 + 9 * 2, ammo);
/*       end of    HUD                */


#ifdef DEBUG
	{
		char debug2[20];
		sprintf(debug2, "%i  %i", level.xHard + (player.x >> 3),
			level.yHard + (player.y >> 3));
		DisplayOffSpriteString(0, 0, debug2);
	}
#endif


}

// Initialize Duke, and his various values
void player_init(short x, short y)
{
	player.x = x;
	player.y = y;
	player.sprite = aniMapRight[0];
	player.mask = aniMaskRight[0];
	player.height = 19;
	player.face = 1;
	player.isMoving = 0;
	player.isControlledByEngine = 0;
	player.isAscending = 0;
	player.isInWater = 0;
//      player.isGassed = 0;
	player.gravity = 0;
	player.animationStep = 0;
	player.exit_hit = 0;
	player.life = 100;
	player.fallingDamage = 0;
	player.data0 = 0;
	player.ammo = -1;
	if (level_num_cur == 11)
		player.life += 100;
}

void player_respawn()
{
	if (player.saved_x != -1) {	// player respawns
		level.xHard = player.saved_x - 4;
		level.yHard = player.saved_y - 4;
	} else {		// player enters the level for the first time
		player.saved_x = 4;
		player.saved_y = 4;
	}
	player_init(4 * 8, 4 * 8);
	//Reset some various stuff
	level.xSoft = 0;
	level.ySoft = 0;
	level.disableScrollX = 0;
	level.disableScrollY = 0;
	weapon.previousShotType = weapon.primitiveShotType;
	weapon.currentShotType = weapon.primitiveShotType;
	weapon.oldShotType = weapon.primitiveShotType;
}

/*-------------------------------------------------------------*/
/*           Duke Collision Detection functions                */
/*          Names are pretty self-explanatory.                 */
/*-------------------------------------------------------------*/
static short isFreeBelow()
{
	if (player.feet - vidmem >= 21 * 12)
		return 1;
	if ((player.feet + 2 - vidmem >= 20 * 12)
	    && level.yHard > (level.ySize - 13))
		return 1;
	if ((attribs[player.feet[2]] == 1) ||
	    (attribs[player.feet[2]] == 2) ||
	    (attribs[player.feet[2]] == 6))
		return 0;
	if ((attribs[player.feet[(player.face ? 1 : 3)]] == 1) ||
	    (attribs[player.feet[(player.face ? 1 : 3)]] == 2) ||
	    (attribs[player.feet[(player.face ? 1 : 3)]] == 6))
		return 0;
	return 1;
}



inline short isFreeRight()
{
	if ((attribs[player.head[24]] == 1)
	    || (attribs[player.head[24]] == 6))
		return 0;
	if ((attribs[player.head[45]] == 1)
	    || (attribs[player.head[45]] == 6)) {
		if (((attribs[player.head[3]] == 1)
		     || (attribs[player.head[3]] == 6)))
			return 0;
	}


	return 1;
}

inline short isFreeLeft()
{
	if ((attribs[player.head[22]] == 1)
	    || (attribs[player.head[22]] == 6))
		return 0;
	if ((attribs[player.head[43]] == 1)
	    || (attribs[player.head[43]] == 6)) {
		if (((attribs[player.head[1]] == 1)
		     || (attribs[player.head[1]] == 6)))
			return 0;
	}

	return 1;
}

static short isFreeAbove()
{
	if ((attribs[player.head[2]] == 1)
	    || (attribs[player.head[2]] == 6))
		return 0;
	if ((attribs[player.head[(player.face ? 1 : 3)]] == 1)
	    || (attribs[player.head[(player.face ? 1 : 3)]] == 6))
		return 0;
	return 1;
}

/*-------------------------------------------------------------*/
/*                 Duke Movement functions                     */
/*          Names are pretty self-explanatory.                 */
/*-------------------------------------------------------------*/


static void moveRight()
{
	player.face = 1;
	if (!isFreeRight())
		return;

	if ((attribs[player.head[45]] == 1)
	    || (attribs[player.head[45]] == 6)) {
		player.y -= 4;
	}

	if (player.x < 140) {
		player.x += ((player.isInWater > 0) ? 2 : 4);
	}
}

static void moveLeft()
{
	player.face = 0;
	if (!isFreeLeft())
		return;

	if ((attribs[player.head[43]] == 1)
	    || (attribs[player.head[43]] == 6)) {
		player.y -= 4;
	}

	if (player.x > 10) {
		player.x -= ((player.isInWater > 0) ? 2 : 4);
	}
}

static void jumpPlayer()
{
	if (!isFreeAbove() || player.y < 10) {
		player.gravity = 0;
	}
	player.y += player.gravity;
	if (player.gravity >= 0) {
		player.isAscending = 0;
	} else {
		player.isAscending = 1;
	}
	if (player.gravity < 4) {
		if (player.low_gravity == 0) {
			if (player.isInWater <= 0)
				++player.gravity;
			if ((player.isInWater > 0) && keystat.down)
				++player.gravity;
		} else {
			++player.low_gravity;
			if (player.low_gravity ==
			    ((player.isInWater > 0) ? 2 : 4)) {
				player.low_gravity = 1;
				if (player.isInWater <= 0)
					++player.gravity;
				if ((player.isInWater > 0) && keystat.down)
					++player.gravity;
			}
		}
	}
	player.sprite = aniJump[player.face];
	player.mask = aniMaskJump[player.face];
	if (keystat.right) {
		moveRight();
	} else if (keystat.left) {
		moveLeft();
	}
}

// Adjusts contrast if +/- pressed.
void contrastchk(void)
{
	if (keystat.plus) {
		contrast.cur++;
		if (contrast.cur == 4) {
			contrast.cur = 0;
			OSContrastUp();
		}
	}
	if (keystat.minus) {
		contrast.cur++;
		if (contrast.cur == 4) {
			contrast.cur = 0;
			OSContrastDn();
		}
	}
}

void movePlayer()
{
// Set pointers, for collision detection
	player.head =
	    vidmem + 21 * ((player.y + level.ySoft - 8) >> 3) +
	    ((player.x - 8) >> 3);
	player.feet = player.head + 3 * 21;

	if (player.isControlledByEngine) {
		if (isFreeBelow()) {
			if (player.gravity < 4) {
				++player.gravity;
			}
			player.y += player.gravity;
		} else
			player.gravity = 0;
		return;
	}


	player.isMoving = 0;

//This is the end-of-level Duke-auto-walking thing.     
	if (player.exit_hit) {
		level.disableScrollX = 1;
		level.disableScrollY = 1;
		++player.data0;
		if (player.data0 == 3) {
			player.data0 = 0;
			++player.animationStep;
		}
		if (player.animationStep == 4)
			player.animationStep = 0;
		player.sprite = aniMapRight[player.animationStep];
		player.mask = aniMaskRight[player.animationStep];
		player.x += 4;


		if (isFreeBelow()) {
			if (player.gravity < 4) {
				++player.gravity;
			}
if(player.y>=81) player.gravity=0;			
			player.y += player.gravity;
		} else
			player.gravity = 0;


		keystat.escape = 0;
		keystat.f3 = 0;
		keystat.f5 = 0;

		if (player.x > 180) {
			level.disableScrollX = 0;
			level.disableScrollY = 0;
			player.exit_hit = 2;
		}
		return;
	}
//Attrib 4 is water
	if ((player.feet - vidmem < 21 * 12)
	    && ((attribs[player.feet[2]] == 4)
		|| (attribs[player.feet[(player.face ? 1 : 3)]] == 4)
		|| (attribs[player.head[2]] == 4)
		|| (attribs[player.head[(player.face ? 1 : 3)]] == 4))) {
		if (player.isInWater < 0)
			player.isInWater = 0;
		player.isInWater++;
		player.isAscending = 0;
		player.gravity = 0;
		if (player.isInWater > 100) {
			player.life--;
			if (level_num_cur == 11)
				player.life++;	//To equalize for the space boss level thing
			player.isInWater = 95;
		}
	} else {
		if (player.isInWater > 0) {
			if (player.life < 100)
				player.life += 10;
			player.fallingDamage = 0;
		}
		if (player.isInWater > 0
		    && ((attribs[player.feet[23]] == 4)
			|| (attribs[player.feet[(player.face ? 22 : 24)]]
			    == 4)))
			player.gravity -= 4;
		if (player.isInWater > 0)
			player.low_gravity = 0;
		player.isInWater = 0;
	}

/*
//Attrib 5 is poisonous gas	
if ((attribs[player.feet[2]] == 5) || (attribs[player.feet[3]] == 5) || (attribs[player.head[2]] == 5) || (attribs[player.head[3]] == 5))
	{
player.isGassed++;
if(player.isGassed>5)
{
	player.isGassed = 1;
	player.life-=1*difficulty;
}
	}
	else player.isGassed = 0;	

*/



	if (weapon.currentShotType >> 7 == 1)	//If is a fireline
		return;
	if ((attribs[player.head[2]] == 3))
		keystat.jump = 0;
	if (player.isAscending) {
		if (keystat.jump) {
			jumpPlayer();
		} else {
			player.isAscending = 0;
			player.gravity = 0;
		}
		player.isMoving = 1;
	} else {
		if (isFreeBelow()) {
			if (player.gravity < 4) {
				if (player.isInWater <= 0)
					++player.gravity;
				if ((player.isInWater > 0)
				    && (!keystat.jump) && isFreeBelow()) {
					if ((level_num_cur == 11
					     && keystat.down))
						player.y++;
					if (level_num_cur != 11) {
						player.y++;
						if (keystat.down)
							player.y += 2;
					}
					player.gravity = 0;
				}
			}
			player.y += player.gravity;
			player.fallingDamage++;
			if ((player.isInWater > 0) && isFreeAbove()
			    && keystat.jump) {
				if (keystat.jump != oldkeystat.jump)
					player.y -= 4;
				else
					player.y -= 1;
				player.isAscending = 0;
			}
			player.sprite = aniJump[player.face];
			player.mask = aniMaskJump[player.face];
			if (keystat.right) {
				moveRight();
			} else if (keystat.left) {
				moveLeft();
			}
			player.isMoving = 1;
		} else {
			player.gravity = 0;
// Falling damage                       
			if (player.fallingDamage >
			    (player.low_gravity ? 27 * 3 : 27)
			    && player.isInWater <= 0 && isFreeLeft()) {
				short a;
				long c;
				player.life -=
				    player.fallingDamage /
				    (player.low_gravity ? 6 : 2);
				for (a = 0; a < 4; a++) {
					OSContrastUp();
					for (c = 0; c < 160000; c++);
				}
				delayt(1);
				for (a = 0; a < 4; a++) {
					OSContrastDn();
					for (c = 0; c < 160000; c++);
				}


			}

		

			// fix player to a (scrolled) tile alignment
			player.y += level.ySoft & 7;
			player.y &= ~7;
			player.y -= level.ySoft & 7;
if(player.fallingDamage>4)
{
beep(262,2,VTI,hardwarever);
beep(196,3,VTI,hardwarever);
}
			player.fallingDamage = 0;

			if (keystat.jump) {
				if ((player.isInWater <=
				     0)
				    /*&& (keystat.jump != oldkeystat.jump) */
				    ) {
					player.gravity = -9;
beep(131,2,VTI,hardwarever);
beep(196,3,VTI,hardwarever);
					jumpPlayer();
				} else if ((player.isInWater > 0)
					   && isFreeAbove()
					   && (keystat.jump !=
					       oldkeystat.jump)) {
					player.isAscending = 0;
					player.y -= 4;
				}

				player.isMoving = 1;
			} else {
// Movement left and right, and handling the animation
				if (keystat.right) {
					++player.data0;
					if (player.data0 == 3) {
						player.data0 = 0;
						++player.animationStep;
					}
					if (player.animationStep == 4)
						player.animationStep = 0;
					player.sprite =
					    aniMapRight[player.
							animationStep];
					player.mask =
					    aniMaskRight[player.
							 animationStep];
					moveRight();
					player.isMoving = 1;
				} else if (keystat.left) {
					++player.data0;
					if (player.data0 == 3) {
						player.data0 = 0;
						++player.animationStep;
					}
					if (player.animationStep == 4)
						player.animationStep = 0;
					player.sprite =
					    aniMapLeft[player.
						       animationStep];
					player.mask =
					    aniMaskLeft[player.
							animationStep];
					moveLeft();
					player.isMoving = 1;
				}
			}
		}
	}


	if (!player.isMoving) {
		player.data0 = 0;
		player.animationStep = 0;
		switch (player.face) {
		case 0:
			player.sprite = aniMapLeft[0];
			player.mask = aniMaskLeft[0];
			break;
		case 1:
			player.sprite = aniMapRight[0];
			player.mask = aniMaskRight[0];
			break;
		}

	}
//Attrib 3 is the "lifting" elevator tube tile
	if ((attribs[player.feet[player.face ? 1 : 3]] == 3)
	    || (attribs[player.feet[2]] == 3)) {
		if (isFreeAbove()) {
			player.gravity = -4;

			jumpPlayer();
			player.isMoving = 1;
			player.fallingDamage = 0;
		}
	}

}
