#include "all.h"

#define STARTLEVEL 1		//starting level, normally 1
#define LIFECOUNT 4		//how many lives Duke has/episode... he also gets 2/3 more/level completed

#define ONLYLEVEL 1		//for if LEVELONLY is defined

char intropref = 1;
char game_speed = 5;

// number of tiles in the menu BG data
#define TILENUMBER_BG 10

// height of one tile in the menu BG data
#define TILEHEIGHT_BG 100

// macro returns the address of tile nr of plane p from the menu BG data
#define TILEADDR_BG(p,nr) ((unsigned short *)menugfx+((p*1000)+(nr*100)))
//Duke ship defines (for level 11)
#define dukeship(a) ((long*)spritegfx+1122+64*a)	//128
#define dukeshipmask(a) ((long*)spritegfx+1250+32*a)	//64



void error_handle(short int error);


void displaybg(void)
{
	short x;
	short tilewidth = 16;
	short hcount = 10;
	ClearGrayScreen2B(GrayDBufGetHiddenPlane(0),
			  GrayDBufGetHiddenPlane(1));
	for (x = 0; x < hcount; x++) {
		Sprite16_OR(x * tilewidth + xoffset, 0 + yoffset,
			    TILEHEIGHT_BG, TILEADDR_BG(0, x),
			    GrayDBufGetHiddenPlane(0));
		Sprite16_OR(x * tilewidth + xoffset, 0 + yoffset,
			    TILEHEIGHT_BG, TILEADDR_BG(1, x),
			    GrayDBufGetHiddenPlane(1));
	}


}

static int animframe = 0;

/* Erase 16x16 box (space taken by rad symbol) */
void eraserad(char x, char y)
{
	DrawGrayRect(x + xoffset, y + yoffset, x + 15 + xoffset,
		     y + 15 + yoffset, COLOR_WHITE, RECT_FILLED);
}

/* Sprites for radiactive symbol */
void spinrad(char x, char y)
{

	Sprite16_AND(x + xoffset, y + yoffset, 16,
		     spinner + 16 * (animframe * 2), GetPlane(DARK_PLANE));
	Sprite16_AND(x + xoffset, y + yoffset, 16,
		     spinner + 16 * (animframe * 2 + 1),
		     GetPlane(LIGHT_PLANE));
	Sprite16_OR(x + xoffset, y + yoffset, 16,
		    spinner + 16 * (animframe * 2), GetPlane(DARK_PLANE));
	Sprite16_OR(x + xoffset, y + yoffset, 16,
		    spinner + 16 * (animframe * 2 + 1),
		    GetPlane(LIGHT_PLANE));
	animframe++;
	if (animframe == 8)
		animframe = 0;
}







/* Structure of menus */
typedef struct {
	char name[13];
} menu;



int cycle = 0;			// spin pause state

void showinstr(void);
void showstory(void);

/* Spin Radiactive symbol */
void alwaysspin(int w, int y)
{
	if (cycle == 300) {
		spinrad(15, 10 * w + y - 4);
		cycle = 0;
	}
	cycle++;
}



/* Wait for menu keys to be released */
void Xpsk(int w, int y)
{
	do {
		alwaysspin(w, y);

		keyscan();
	} while (keystat.up || keystat.down || keystat.left
		 || keystat.right || keystat.enter || keystat.second);
}



/* inverse rectangle */
void inverserectangle(int w, int xa, int xb)
{
	InvertGrayRect(xa + xoffset, w + yoffset, xb + xoffset,
		       w + 10 + yoffset);
}



/* Function for displaying and returning selected menu option */
int domenu(char x, char y, menu setmenu[], char comps, short choice)
{
	int w = 0, changed = 1, i, exit = 0;
	w = choice;
	SetPlane(0);
	ClrScr();
	SetPlane(1);
	ClrScr();
	while (exit == 0) {
		if (changed == 1) {
			//      displaybg();
			FastCopyScreen(GrayDBufGetHiddenPlane(1),
				       GrayDBufGetActivePlane(1));
			FastCopyScreen(GrayDBufGetHiddenPlane(0),
				       GrayDBufGetActivePlane(0));
			for (i = 0; i < comps; i++) {
				DisplaySpriteString(x + xoffset,
						    10 * i + y + yoffset,
						    setmenu[i].name);
			}
			inverserectangle(10 * w + y - 1, x - 1, 145);
			changed = 0;
			Xpsk(w, y);
		}
		keyscan();
		if (keystat.up || keystat.down) {
			inverserectangle(10 * w + y - 1, x - 1, 145);
			eraserad(15, 10 * w + y - 4);
			cycle = 0;
			if (keystat.up)
				w--;
			else
				w++;
			if (w < 0)
				w = comps - 1;
			if (w >= comps)
				w = 0;
			changed = 1;
		}
		/*
		if (keystat.down) {
			inverserectangle(10 * w + y - 1, x - 1, 145);
			eraserad(15, 10 * w + y - 4);
			cycle = 0;
			if (w == comps - 1)
				w = -1;
			if (w < comps - 1)
				w++;
			if (w == -1)
				w = 0;
			changed = 1;
		}
		*/
		alwaysspin(w, y);
		if (keystat.enter || keystat.second) {
			while (keystat.enter || keystat.second)
				keyscan();
			return w + 1;
		}

		if (keystat.escape) {
			exit++;
			while (keystat.escape) {
				keyscan();
			}
		}
	}
	return 0;
}



/* Menu cases */
void menus(void)
{
	char exit = 0;
	static menu main_menu[] =
	    { {"new game"}, {"resume"}, {"options"}, {"doc/story"},
	{"highscores"}, {"credits"}, {"quit"}
	};
	static menu start_menu[] = { {"easy"}, {"difficult"} };
	static menu restore_menu[] =
	    { {"quick"}, {"save1"}, {"save2"}, {"save3"} };
	static menu option_menu[] = { {"Speed   "}, {"Intro    "},{"Sound    "} };
	static menu story_menu[] = { {"instructions"}, {"story"} };
	int choice = 0;
// LEVELONLY can be defined in global.h to skip intro/menu and run only 1 level.        
#ifdef LEVELONLY
	level_num_cur = ONLYLEVEL;
	episode_score = 0;
	player.lives = LIFECOUNT;
	is_loaded = 0;
	difficulty = 1;
      redoonly:
	choice = gameloop();
	if (choice == -6)
		goto redoonly;
	error_handle(choice);

	while (keystat.escape || keystat.enter) {
		FastCopyScreen(GetDPlane(1, 1), GetDPlane(0, 1));
		FastCopyScreen(GetDPlane(1, 0), GetDPlane(0, 0));
		keyscan();
	}
	exit++;
#endif


	displaybg();
	while (exit == 0) {
		switch (domenu(35, 28, main_menu, 7, 0)) {
		case 0:	//0: Something went wrong
			exit++;
			break;
		case 1:	//1: New Game
//Inits         
			level_num_cur = STARTLEVEL;
			if (extname[0])
				level_num_cur = 0;
			episode_score = 0;
			is_loaded = 0;
			player.lives = LIFECOUNT;
//Then load the difficulty                      
			difficulty = domenu(35, 28, start_menu, 2, 0);
			if (!difficulty)
				break;
/* Gameloop() is the actual gameplay. 0 means no errors, and -6 also
		means no errors, although -6 means that the player died on level 10,
		and to restart it.*/
			choice = 0;
			while ((choice == 0 || choice == -7)
			       && level_num_cur <= level_num_max) {
				choice = gameloop();
				if (choice == -7)
					level_num_cur--;
				level_num_cur++;
			}
			// If there was another return value, display an error
			error_handle(choice);
// If the player completed the last level & there aren't errors, show the ending.                       
			if (player.exit_hit == 2 && !choice) {
				congrats();
			}
			highscore_handle();
			displaybg();
			while (keystat.escape) {
				FastCopyScreen(GrayDBufGetHiddenPlane(0),
					       GrayDBufGetActivePlane(0));
				FastCopyScreen(GrayDBufGetHiddenPlane(0),
					       GrayDBufGetActivePlane(1));
				keyscan();
			}
			displaybg();
			break;
		case 2:	//2: Load a save game
			choice = domenu(35, 28, restore_menu, 4, 0);
			choice = loadsaved(choice - 1);
			error_handle(choice);
			if (choice) {
				displaybg();
				break;
			}
			choice = 0;
			while ((choice == 0 || choice == -7)
			       && level_num_cur <= level_num_max) {
				choice = gameloop();
				if (choice == -7)
					level_num_cur--;
				level_num_cur++;
			}
			error_handle(choice);
			if (player.exit_hit == 2 && !choice) {
				congrats();
			}
			highscore_handle();
			displaybg();
			break;
		case 3:	//3: Options
			choice = 1;
		      speed:
			sprintf(option_menu[0].name, "Speed %i",
				game_speed);
			sprintf(option_menu[1].name,
				intropref ? "Intro On " : "Intro Off");
			sprintf(option_menu[2].name,
				sound ? "Sound On " : "Sound Off");				
			choice =
			    domenu(35, 28, option_menu, 3, choice - 1);
			if (choice == 1) {
				game_speed++;
				if (game_speed == 10)
					game_speed = 0;
				goto speed;
			}
			if (choice == 2) {
				intropref++;
				if (intropref == 2)
					intropref = 0;
				goto speed;
			}
			if (choice == 3) {
				sound++;
				if (sound == 2)
					sound = 0;
				goto speed;
			}			
			break;
		case 4:	//4: Instructions and story
			choice = domenu(35, 28, story_menu, 2, 0);
			if (choice == 1)
				showinstr();
			if (choice == 2)
				showstory();
			break;
		case 5:	//5: High Scores
			displayscores();
			break;
		case 6:	//6: Credits     
			showcredits();
			break;
		case 7:
			exit++;
			break;
		}
	}
}



/* Note: Strings should be const char *const, but this gives warnings due
 * to non-const declarations. Anyway, it would not save a single byte either.
 */

typedef struct {
	short offset_to;
	char *text;
} instr_t;

void showinstr(void)
{
	short a = 28 + yoffset;
	unsigned int i;
	static instr_t instructions[]={
		{13, (char*)"Arrows = Move", },
		{9,  (char*)"2nd:Hand = Jump", },
		{9,  (char*)"<>:F5 = Fire", },
		{14, (char*)"Control Duke;", },
		{9,  (char*)"Stay alive;", },
		{9,  (char*)"Destroy the Grolidin.", },
	};
//DrawGrayRect(13,23,145,99,COLOR_BLACK,RECT_FILLED);
	FastCopyScreen(GrayDBufGetHiddenPlane(0),
		       GrayDBufGetActivePlane(0));
	FastCopyScreen(GrayDBufGetHiddenPlane(1),
		       GrayDBufGetActivePlane(1));

	text(a, (char*)"Instructions");
	for(i=0; i<sizeof(instructions)/sizeof(instructions[0]); ++i){
		a += instructions[i].offset_to;
		DrawGrayStrExt(0, a, instructions[i].text,
				A_NORMAL | A_CENTERED, F_6x8);
	}
	/*
	a += 13;
	DrawGrayStrExt(0, a, "Arrows = Move", A_NORMAL | A_CENTERED,
		       F_6x8);
	a += 9;
	DrawGrayStrExt(0, a, "2nd:Hand = Jump", A_NORMAL | A_CENTERED,
		       F_6x8);
	a += 9;
	DrawGrayStrExt(0, a, "<>:F5 = Fire", A_NORMAL | A_CENTERED, F_6x8);
	a += 14;
	DrawGrayStrExt(0, a, "Control Duke;", A_NORMAL | A_CENTERED,
		       F_6x8);
	a += 9;
	DrawGrayStrExt(0, a, "Stay alive;", A_NORMAL | A_CENTERED, F_6x8);
	a += 9;
	DrawGrayStrExt(0, a, "Destroy the Grolidin.",
		       A_NORMAL | A_CENTERED, F_6x8);
	a += 9;
	*/
	while (!(keystat.enter || keystat.escape || keystat.second)) {
		keyscan();
	}
	while ((keystat.enter || keystat.escape || keystat.second)) {
		keyscan();
	}	
}
void showstory(void)
{
	int i = 0, n;
	void *plane10 = GrayDBufGetHiddenPlane(0);
	void *plane11 = GrayDBufGetHiddenPlane(1);
	void Sto_Drawtext(int y, char string[50]) {
		y += 26;
		if (y >= 26 + yoffset && y < 100 + yoffset) {
			DrawGrayStrExt2B(0, y + yoffset, string,
					 A_NORMAL | A_CENTERED, F_4x6,
					 plane10, plane11);
		}
	}



	DrawGrayRect2B(13 + xoffset, 23 + yoffset, 145 + xoffset,
		       99 + yoffset, COLOR_WHITE, RECT_FILLED, plane10,
		       plane11);

	while (i < 432) {
		keyscan();
		if (keystat.escape)
			break;
//                      if(keystat.up && i>=32) i-=32;
//                      if(keystat.down) i+=32;
		//      displaybg();
		DrawGrayRect2B(13 + xoffset, 23 + yoffset, 145 + xoffset,
			       99 + yoffset, COLOR_WHITE, RECT_FILLED,
			       plane10, plane11);
		for (n = 0; n < 36; n++)
			Sto_Drawtext(n * 8 - i, storystr + 28 * n);	// displays text from above,12
		FastCopyScreen(plane10, GrayDBufGetActivePlane(0));
		FastCopyScreen(plane11, GrayDBufGetActivePlane(1));
//delayt(1);
//if(i>47)delayt(1);
		keyscan();
		i++;
	}
	displaybg();
	FastCopyScreen(plane10, GrayDBufGetActivePlane(0));
	FastCopyScreen(plane11, GrayDBufGetActivePlane(1));
	while (keystat.escape)
		keyscan();

}




/*
 * POSSIBLE ERROR MESSAGES
 *  2: User Died, Game Over
 *  1: User Pressed Esc
 *  0: OK (i.e. none)
 * -1: Level was not found
 * -2: Level was not a valid archive
 * -3: Not enough memory to unpack level
 * -4: Level unpack error
 * -5: Save Game Not Found
 * -6: User Completed User Level
 * -7: User died, restart level 10
 */
void error_handle(short int error)
{
	static char *error_msg[]={
		(char*)"",
		(char*)"Level Not Found!",
		(char*)"Invalid Level!",
		(char*)"Out of Memory!",
		(char*)"Level Unpack Error",
		(char*)"Save Game Not Found",
		(char*)"User Level Completed!",
		(char*)"Error...",
	};
	if (error == 0 || error == 1 || error == 2 || error == -7)
		return;
	displaybg();

	if(error < -6 || error > -1){
		error = -7;	// for array indexing only
	}
	DrawGrayStrExt2B(0, 36 + yoffset, error_msg[-error],
		 A_NORMAL | A_CENTERED, F_6x8,
		 GrayDBufGetHiddenPlane(0),
		 GrayDBufGetHiddenPlane(1));
	DrawGrayStrExt2B(0, 66 + yoffset, (char*)"Press Esc/Enter",
		 A_NORMAL | A_CENTERED, F_6x8,
		 GrayDBufGetHiddenPlane(0),
		 GrayDBufGetHiddenPlane(1));		 
	/*
	switch (error) {
	case -1:
		DrawGrayStrExt2B(0, 28 + yoffset, "Level Not Found!",
				 A_NORMAL | A_CENTERED, F_6x8,
				 GrayDBufGetHiddenPlane(0),
				 GrayDBufGetHiddenPlane(1));
		break;
	case -2:
		DrawGrayStrExt2B(0, 28 + yoffset, "Invalid Level!",
				 A_NORMAL | A_CENTERED, F_6x8,
				 GrayDBufGetHiddenPlane(0),
				 GrayDBufGetHiddenPlane(1));
		break;
	case -3:
		DrawGrayStrExt2B(0, 28 + yoffset, "Out of Memory!",
				 A_NORMAL | A_CENTERED, F_6x8,
				 GrayDBufGetHiddenPlane(0),
				 GrayDBufGetHiddenPlane(1));
		break;
	case -4:
		DrawGrayStrExt2B(0, 28 + yoffset, "Level Unpack Error",
				 A_NORMAL | A_CENTERED, F_6x8,
				 GrayDBufGetHiddenPlane(0),
				 GrayDBufGetHiddenPlane(1));
		break;
	case -5:
		DrawGrayStrExt2B(0, 28 + yoffset, "Save Game Not Found",
				 A_NORMAL | A_CENTERED, F_6x8,
				 GrayDBufGetHiddenPlane(0),
				 GrayDBufGetHiddenPlane(1));
		break;
	default:
		DrawGrayStrExt2B(0, 28 + yoffset, "Error...",
				 A_NORMAL | A_CENTERED, F_6x8,
				 GrayDBufGetHiddenPlane(0),
				 GrayDBufGetHiddenPlane(1));
		break;
	}
*/
	FastCopyScreen(GrayDBufGetHiddenPlane(0),
		       GrayDBufGetActivePlane(0));
	FastCopyScreen(GrayDBufGetHiddenPlane(1),
		       GrayDBufGetActivePlane(1));
	keyscan();
	while (!(keystat.escape || keystat.enter))
		keyscan();
	while ((keystat.escape || keystat.enter))
		keyscan();
}

void displayscores(void)
{
	short a;
	displaybg();
	DisplayOffSpriteString(40 + xoffset, 28 + yoffset, (char*)"High Scores");
	for (a = 0; a < 5; a++) {
		/* There's absolutely no need to set the entire buffer to 0,
		 * sprintf handles everything for you. What's more important:
		 * you save about 20 bytes of code!
		 */
		//char buf[15] = { 0 };
		char buf[15];
		DrawGrayStrExt2B(25 + xoffset, 48 + a * 9 + yoffset,
				 highscores[a].name, A_NORMAL, F_6x8,
				 GrayDBufGetHiddenPlane(0),
				 GrayDBufGetHiddenPlane(1));
		sprintf(buf, "%lu", highscores[a].score);
		DrawGrayStrExt2B(95 + xoffset, 48 + a * 9 + yoffset, buf,
				 A_NORMAL, F_6x8,
				 GrayDBufGetHiddenPlane(0),
				 GrayDBufGetHiddenPlane(1));
	}
	FastCopyScreen(GrayDBufGetHiddenPlane(0),
		       GrayDBufGetActivePlane(0));
	FastCopyScreen(GrayDBufGetHiddenPlane(1),
		       GrayDBufGetActivePlane(1));
	displaybg();
	keyscan();
	while (!(keystat.enter || keystat.escape || keystat.second))
		keyscan();
	while ((keystat.enter || keystat.escape || keystat.second))
		keyscan();

}

// maybe merge this with the struct used earlier
typedef struct {
	short offset_to;
	char *text;
	short font;
} credits_t;

void showcredits(void)
{
	short a = 28 + yoffset;
	long int timer;
	short i;
	static credits_t credits[]={
		{13, (char*)"Malcolm Smith", F_6x8, },
		{11, (char*)"Project Head, Graphics Designer,", F_4x6, },
		{7,  (char*)"Programmer, Public Relations", F_4x6, },
		{15, (char*)"Stephan Effelsberg", F_6x8, },
		{11, (char*)"Engine Work, Programmer", F_4x6,		 },
		//Second Screen
		{20,(char*)"Michael Holt",F_6x8},
		{11,(char*)"Levels,Font,Graphics",F_4x6},
		{8,(char*)"Menu Design, Introduction",F_4x6}};

	DrawGrayRect(13 + xoffset, 23 + yoffset, 145 + xoffset,
		     99 + yoffset, COLOR_WHITE, RECT_FILLED);
	DisplaySpriteString(52, a, (char*)"Credits");;
	for(i=0; i<5; ++i){
		a += credits[i].offset_to;
		DrawGrayStrExt(0, a, credits[i].text,
			A_NORMAL | A_CENTERED | A_SHADOWED, credits[i].font);
	}
		while (!(keystat.enter || keystat.second)) {
		keyscan();
		if (keystat.escape)
			goto superbreak;
	}
	for (a = 0; a < 7; a++) {
		OSContrastDn();
		for (timer = 0; timer < 500000; timer++);
	}	
	
	a = 28 + yoffset;
	DrawGrayRect(13 + xoffset, 23 + yoffset, 145 + xoffset,
		     99 + yoffset, COLOR_WHITE, RECT_FILLED);
	DisplaySpriteString(52, a, (char*)"Credits");
	for(i=5; i<8; ++i){
		a += credits[i].offset_to;
		DrawGrayStrExt(0, a, credits[i].text,
			A_NORMAL | A_CENTERED | A_SHADOWED, credits[i].font);
	}
	/*
	a += 13;
	DrawGrayStrExt(0, a, "Malcolm Smith",
		       A_NORMAL | A_CENTERED | A_SHADOWED, F_6x8);
	a += 11;
	DrawGrayStrExt(0, a,
		       "Project Head, Graphics Designer,",
		       A_NORMAL | A_CENTERED | A_SHADOWED, F_4x6);
	a += 7;
	DrawGrayStrExt(0, a,
		       "Programmer, Public Relations",
		       A_NORMAL | A_CENTERED | A_SHADOWED, F_4x6);
	a += 7;
	a += 8;
	DrawGrayStrExt(0, a, "Stephan Effelsberg",
		       A_NORMAL | A_CENTERED | A_SHADOWED, F_6x8);
	a += 11;
	DrawGrayStrExt(0, a, "Engine Work, Programmer",
		       A_NORMAL | A_CENTERED | A_SHADOWED, F_4x6);
	a += 7;
	while (!(keystat.enter || keystat.second)) {
		keyscan();
		if (keystat.escape)
			goto superbreak;
	}
	for (a = 0; a < 7; a++) {
		OSContrastDn();
		for (timer = 0; timer < 500000; timer++);
	}
	DrawGrayRect(13 + xoffset, 23 + yoffset, 145 + xoffset,
		     99 + yoffset, COLOR_WHITE, RECT_FILLED);
	a = 28 + yoffset;
	DrawGrayStrExt(0, a, "Michael Holt",
		       A_NORMAL | A_CENTERED | A_SHADOWED, F_6x8);
	a += 11;
	DrawGrayStrExt(0, a,
		       "Levels, Font, Graphics",
		       A_NORMAL | A_CENTERED | A_SHADOWED, F_4x6);
	a += 7;
	DrawGrayStrExt(0, a, "Menu Design, Introduction",
		       A_NORMAL | A_CENTERED | A_SHADOWED, F_4x6);
	a += 7;
	a += 8;
	DrawGrayStrExt(0, a, "Jon Eriksson",
		       A_NORMAL | A_CENTERED | A_SHADOWED, F_6x8);
	a += 11;
	DrawGrayStrExt(0, a,
		       "Graphics Designer, Misc. Programmer",
		       A_NORMAL | A_CENTERED | A_SHADOWED, F_4x6);
	a += 7;
	*/
	for (a = 0; a < 7; a++) {
		OSContrastUp();
		for (timer = 0; timer < 500000; timer++);
	}
	keyscan();
	while (!(keystat.enter || keystat.second)) {
		if (keystat.escape)
			goto superbreak;
		keyscan();
	}
	for (a = 0; a < 7; a++) {
		OSContrastDn();
		for (timer = 0; timer < 500000; timer++);
	}
	DrawGrayRect(13 + xoffset, 23, 145 + xoffset, 99, COLOR_WHITE,
		     RECT_FILLED);
	for (timer = 80000; timer > 0; timer--);
	for (a = 0; a < 7; a++) {
		OSContrastUp();
		for (timer = 0; timer < 500000; timer++);
	}
      superbreak:
	for (timer = 80000; timer > 0; timer--);
}

typedef struct {
	short yPos;
	char *text;
	short font;
} grats_t;

void congrats(void)
{
	short a;
	long c;
	short i;
	static grats_t grats[]={
		{32, (char*)"Duke returns to Earth and", F_6x8, },
		{42, (char*)"is met with the thanks of", F_6x8, },
		{52, (char*)"everyone for protecting", F_6x8, },
		{62, (char*)"the planet.", F_6x8, },
		{88, (char*)"Press 2nd / Hand", F_4x6, },
		// 2nd screen
		{32, (char*)"He also kept his ship,", F_6x8, },
		{42, (char*)"and has been known to", F_6x8, },
		{52, (char*)"take it back through", F_6x8, },
		{62, (char*)"space on occasion...", F_6x8, },
		{88, (char*)"Press 2nd / Hand", F_4x6, },
	};

	void *plane00 = GrayDBufGetActivePlane(0);
	void *plane01 = GrayDBufGetActivePlane(1);
	void *plane10 = GrayDBufGetHiddenPlane(0);
	void *plane11 = GrayDBufGetHiddenPlane(1);
	ClearGrayScreen2B(plane10, plane11);
	ClearGrayScreen2B(plane00, plane01);
	/*
	ClearGrayScreen2B(GrayDBufGetHiddenPlane(0),
			  GrayDBufGetHiddenPlane(1));
	ClearGrayScreen2B(GrayDBufGetActivePlane(0),
			  GrayDBufGetActivePlane(1));
	*/
	InvertGrayRect(0, 0, 159, 99);
	for(i=0; i<5; ++i){
		DrawGrayStrExt2B(0, grats[i].yPos, grats[i].text,
			 A_NORMAL | A_CENTERED | A_SHADOWED, grats[i].font,
			 plane10, plane11);
	}
	/*
	DrawGrayStrExt2B(0, 32, "Duke returns to Earth and",
			 A_NORMAL | A_CENTERED | A_SHADOWED, F_6x8,
			 plane10, plane11);
	DrawGrayStrExt2B(0, 42, "is met with the thanks of",
			 A_NORMAL | A_CENTERED | A_SHADOWED, F_6x8,
			 plane10, plane11);
	DrawGrayStrExt2B(0, 52, "everyone for protecting",
			 A_NORMAL | A_CENTERED | A_SHADOWED, F_6x8,
			 plane10, plane11);
	DrawGrayStrExt2B(0, 62, "the planet.",
			 A_NORMAL | A_CENTERED | A_SHADOWED, F_6x8,
			 plane10, plane11);
	DrawGrayStrExt2B(0, 88, "Press 2nd / Hand",
			 A_NORMAL | A_CENTERED | A_SHADOWED, F_4x6,
			 plane10, plane11);
	*/
	for (a = 0; a < 3000; a += 30) {
		memcpy(plane00 + a, plane10 + a, 30);
		memcpy(plane01 + a, plane11 + a, 30);
		for (c = 0; c < 320000; c++);
	}
	keyscan();
	while (!keystat.second) {
		keyscan();
	}
	ClearGrayScreen2B(GrayDBufGetHiddenPlane(0),
			  GrayDBufGetHiddenPlane(1));
	InvertGrayRect(0, 0, 159, 99);

	for(i=5; i<10; ++i){
		DrawGrayStrExt2B(0, grats[i].yPos, grats[i].text,
			 A_NORMAL | A_CENTERED | A_SHADOWED, grats[i].font,
			 plane10, plane11);
	}
	/*
	DrawGrayStrExt2B(0, 32, "He also kept his ship,",
			 A_NORMAL | A_CENTERED | A_SHADOWED, F_6x8,
			 plane10, plane11);
	DrawGrayStrExt2B(0, 42, "and has been known to",
			 A_NORMAL | A_CENTERED | A_SHADOWED, F_6x8,
			 plane10, plane11);
	DrawGrayStrExt2B(0, 52, "take it back through",
			 A_NORMAL | A_CENTERED | A_SHADOWED, F_6x8,
			 plane10, plane11);
	DrawGrayStrExt2B(0, 62, "space on occasion...",
			 A_NORMAL | A_CENTERED | A_SHADOWED, F_6x8,
			 plane10, plane11);
	DrawGrayStrExt2B(0, 88, "Press 2nd / Hand",
			 A_NORMAL | A_CENTERED | A_SHADOWED, F_4x6,
			 plane10, plane11);
	*/
	for (a = 0; a < 3000; a += 30) {
		memcpy(plane00 + a, plane10 + a, 30);
		memcpy(plane01 + a, plane11 + a, 30);
		for (c = 0; c < 320000; c++);
	}
	keyscan();
	while (!keystat.second) {
		keyscan();
	}
	ClearGrayScreen2B(plane10, plane11);

	{
		short x, a;
		for (x = 0; x <= 128; x++) {
			for (a = 0; a < 10; a++) {
				Sprite16_OR(a * 16, 0, 100,
					    (stars + a * 100), plane10);
				Sprite16_OR(a * 16, 0, 100,
					    (stars + 1000 + a * 100),
					    plane11);
			}
			GraySprite32_MASK(x, 30, 32, dukeship(1),
					  dukeship(1) + 32,
					  dukeshipmask(1), dukeshipmask(1),
					  plane10, plane11);
			FastCopyScreen(plane11, plane01);
			FastCopyScreen(plane10, plane00);
			delayt(1);
		}
//GraySprite32_MASK(x, 30, 32, dukeship(1),dukeship(1)+32,dukeshipmask(1),dukeshipmask(1),
//GrayDBufGetActivePlane(0),GrayDBufGetActivePlane(1));
	}

	{
		short y1, y2;
		for (y1 = 0, y2 = 92; y1 <= 40; y1++, y2--) {
			text1(y1, (char*)"The End");
			text1(y2, (char*)"Press Enter");
			delayt(1);
			FastCopyScreen(plane11, plane01);
			FastCopyScreen(plane10, plane00);
			if (keystat.enter)
				break;
		}
	}
grabbag(&count1,VTI,hardwarever);
	while (keystat.enter) {
		keyscan();
	}
}
