// C Header File
// Created 6/24/2002; 7:02:17 PM


enum FileConstants { HOWMANY = 50, MAXLEN = 9 };

short int isMyTypeSet(const char *filename, const char *mytype)
{
	FILE *f = fopen(filename, "rb");
	unsigned char ftype;
	char type[5];
	short int yes = 0;

	fseek(f, -1, SEEK_END);	// go to the file tag
	ftype = (unsigned char) fgetc(f);

	if (ftype == OTH_TAG) {	// do we have an other-type file
		// we're now at SEEK_END
		fseek(f, -6, SEEK_CUR);

		if (getc(f) != 0) {
			fseek(f, -1, SEEK_CUR);
		}

		fread(type, 5, 1, f);

		if (strcmp(type, mytype) == 0) {
			yes = 1;
		}
	}

	fclose(f);

	return yes;
}

short int findAllFilesSet(char *buffer, const char *mytype,
			  const char *mytype2, short int max)
{
	short int counter = 0;
	SYM_ENTRY *SymPtr;
	FontSetSys(F_4x6);
	FolderOp(SYMSTR("\x7F"), FOP_LOCK);
	SymPtr = SymFindFirst(SYMSTR("main"), FO_SINGLE_FOLDER);
	while (SymPtr && counter < max) {
		if ((isMyTypeSet(SymPtr->name, mytype))
		    || (isMyTypeSet(SymPtr->name, mytype2))) {
			if (strcmp(SymPtr->name, "dlevel11")) {
				strcpy(buffer + (counter * MAXLEN),
				       SymPtr->name);
				counter++;
			}

		}

		SymPtr = SymFindNext();
	}
	FolderOp(SYMSTR("\x7F"), FOP_UNLOCK);

	return counter;
}
