#include "extgraph.h"
#include "keyscan.h"
#include "font.h"

#define spinner _DLL_reference(unsigned short,14)
extern unsigned char xoffset;
extern unsigned char yoffset;

unsigned short *menugfx = NULL;

// number of tiles in the menu BG data
#define TILENUMBER_BG 10

// height of one tile in the menu BG data
#define TILEHEIGHT_BG 100

// macro returns the address of tile nr of plane p from the menu BG data
#define TILEADDR_BG(p,nr) ((unsigned short *)menugfx+((p*1000)+(nr*100)))

void delay(long int del)
{
	long int del2 = 0;
	while (del > 0) {
		del--;
		del2++;
	}
}


void displaybg(void)
{
	short x;
	short tilewidth = 16;
	short hcount = 10;
	ClearGrayScreen2B(GrayDBufGetHiddenPlane(0),
			  GrayDBufGetHiddenPlane(1));
	for (x = 0; x < hcount; x++) {
		Sprite16_OR(x * tilewidth + xoffset, 0 + yoffset,
			    TILEHEIGHT_BG, TILEADDR_BG(0, x),
			    GrayDBufGetHiddenPlane(0));
		Sprite16_OR(x * tilewidth + xoffset, 0 + yoffset,
			    TILEHEIGHT_BG, TILEADDR_BG(1, x),
			    GrayDBufGetHiddenPlane(1));
	}


}

static int animframe = 0;

/* Erase 16x16 box (space taken by rad symbol) */
void eraserad(char x, char y)
{
	DrawGrayRect(x + xoffset, y + yoffset, x + 15 + xoffset,
		     y + 15 + yoffset, COLOR_WHITE, RECT_FILLED);
}

/* Sprites for radiactive symbol */
void spinrad(char x, char y)
{

	Sprite16_AND(x + xoffset, y + yoffset, 16,
		     spinner + 16 * (animframe * 2), GetPlane(DARK_PLANE));
	Sprite16_AND(x + xoffset, y + yoffset, 16,
		     spinner + 16 * (animframe * 2 + 1),
		     GetPlane(LIGHT_PLANE));
	Sprite16_OR(x + xoffset, y + yoffset, 16,
		    spinner + 16 * (animframe * 2), GetPlane(DARK_PLANE));
	Sprite16_OR(x + xoffset, y + yoffset, 16,
		    spinner + 16 * (animframe * 2 + 1),
		    GetPlane(LIGHT_PLANE));
	animframe++;
	if (animframe == 8)
		animframe = 0;
}








int cycle = 0;			// spin pause state


/* Spin Radioactive symbol */
void alwaysspin(int w, int y)
{
	if (cycle == 300) {
		spinrad(15, 10 * w + y - 4);
		cycle = 0;
	}
	cycle++;
}



/* Wait for menu keys to be released */
void Xpsk(int w, int y)
{
	do {
		alwaysspin(w, y);

		keyscan();
	} while (keystat.up || keystat.down || keystat.enter
		 || keystat.second);
}



/* inverse rectangle */
void inverserectangle(int w, int xa, int xb)
{
	InvertGrayRect(xa + xoffset, w + yoffset, xb + xoffset,
		       w + 10 + yoffset);
}



/* Function for displaying and returning selected menu option */
int domenu(char x, char y, char setmenu[], char comps, short choice)
{
	int w = 0, changed = 1, i, j, exit = 0;
	int total = comps;
	int totalplace = 0;
	if (comps > 7)
		comps = 7;
	w = choice;
	SetPlane(0);
	ClrScr();
	SetPlane(1);
	ClrScr();
	while (exit == 0) {
		if (changed == 1) {
			//      displaybg();
			FastCopyScreen(GrayDBufGetHiddenPlane(1),
				       GrayDBufGetActivePlane(1));
			FastCopyScreen(GrayDBufGetHiddenPlane(0),
				       GrayDBufGetActivePlane(0));
			if (totalplace < 0)
				totalplace = 0;
			comps = total - totalplace;
			if (comps > 7)
				comps = 7;
			for (i = totalplace, j = 0; i < comps + totalplace;
			     i++, j++) {
				DisplaySpriteString(x + xoffset,
						    10 * j + y + yoffset,
						    setmenu + 9 * i);
			}
			inverserectangle(10 * w + y - 1, x - 1, 145);
			changed = 0;
			Xpsk(w, y);
		}
		keyscan();
		if (keystat.up) {
			inverserectangle(10 * w + y - 1, x - 1, 145);
			eraserad(15, 10 * w + y - 4);
			cycle = 0;
			if (w == 0) {
				if (totalplace > 7) {
					totalplace -= 7;
					w = 7;
				} else {
					//w = comps;
				}
			}

			if (w > 0)
				w--;
			changed = 1;
		}
		if (keystat.down) {
			inverserectangle(10 * w + y - 1, x - 1, 145);
			eraserad(15, 10 * w + y - 4);
			cycle = 0;
			if (w == comps - 1) {
				if (total > totalplace + 7) {
					totalplace += 7;
				} else
					totalplace = 0;
				w = -1;
			}

			if (w < comps - 1)
				w++;
			if (w == -1)
				w = 0;
			changed = 1;
		}
		if (keystat.enter || keystat.second) {

			while (keystat.enter || keystat.second)
				keyscan();
			return w + totalplace;


		}

		else if (keystat.escape) {

			exit++;
			while (keystat.escape) {
				keyscan();
			}

		}
		alwaysspin(w, y);
	}
	return -1;
}
