#include "all.h"




short level_num_max = 11;
short level_num_cur = 1;	// modified in the menu

/* pointers for allocated memory */
#define NR_LEVEL_ARCHIVE_ENTRIES 5
static unsigned char *memptrs[] = { NULL, NULL, NULL, NULL, NULL };

/*
 * return values:
 *  0: OK
 * -1: file not found
 * -2: not a valid archive
 * -3: not enough memory
 * -4: unpack error
 */
short load_level()
{
	SYM_ENTRY *symptr;
	unsigned char *archive;
	short i;
	short modulesize;
	char name[9]="dlevel\0\0\0";
	char number[4];
		
	sprintf(number,"%i",level_num_cur);
	strcat(name,number);	
	
	switch (level_num_cur) {
	case 0:
		symptr = DerefSym(SymFind(SYMSTR(extname)));
		level.init=no_init;
		break;
	case 1:
		symptr = DerefSym(SymFind(SYMSTR(name)));
		level.init = level1_init;
		break;
	case 2 ... 10:
		symptr = DerefSym(SymFind(SYMSTR(name)));
		level.init = no_init;
		break;
	case 11:
		symptr = DerefSym(SymFind(SYMSTR(name)));
		level.init = level11_init;
		break;
	default:
		symptr = NULL;
	}
	if (!symptr) {
		return -1;
	}


	archive = HLock(symptr->handle);
	archive += 2;

	if (!ttarchive_valid(archive)) {
		HeapUnlock(symptr->handle);
		return -2;
	}

	for (i = 0; i < NR_LEVEL_ARCHIVE_ENTRIES; ++i) {
		short retval;
		unsigned long entry_size;
		void *memptr;

		entry_size = ttunpack_size(ttarchive_data(archive, i));
		memptr = (unsigned char *) malloc(entry_size);
//              while(!keystat.second) keyscan();
		if (!memptr) {
			free_level();
			HeapUnlock(symptr->handle);
			return -3;
		}
		//*memptrs[i]=memptr;
		memptrs[i] = memptr;
		retval =
		    ttunpack_decompress(ttarchive_data(archive, i),
					memptr);
		if (retval) {
			free_level();
			HeapUnlock(symptr->handle);
			return -4;
		}
	}
	HeapUnlock(symptr->handle);

	level.xSize = *(short *) (memptrs[0]);
	level.ySize = *(short *) (memptrs[0] + 2);
	level.baseptr = memptrs[0] + 4;
	level.correction = 0;
	level.shootfactor = 0;
	level.shootingfactor = 0;
	level.enemyfactor = 0;
	player.low_gravity = 0;

	modulesize = *(memptrs[1] + 1);
	//fillform = (char) modulesize;
	switch (modulesize) {
/*	case 2:
		level.fillupX = fillupX_module2;
		level.fillupY = fillupY_module2;
		level.xSize *= 2;
		level.ySize *= 2;
		break;
	case 4:
		level.fillupX = fillupX_module4;
		level.fillupY = fillupY_module4;
		level.xSize *= 4;
		level.ySize *= 4;
		break;*/
	default:
		level.fillupX = fillupX_tile;
		level.fillupY = fillupY_tile;
		break;
	}
	if (modulesize == 2 || modulesize == 4)
		modules = memptrs[1] + 4;
	else
		modules = NULL;
// Some level initialization stuff
	level.disableScrollX = 0;
	level.disableScrollY = 0;

	level.xHard = 0;
	level.yHard = 0;

	level.xSoft = 0;
	level.ySoft = 0;
//-------------------------------



	if (!is_loaded) {	//If this is a new game, not a saved game...
		player.saved_x = *(short *) (memptrs[4]);
		player.saved_y = *(short *) (memptrs[4] + 2);
	}
//More level init stuff, from the level itself (.enm/sprite file)
//0-parallax1
//1-parallax_normal
//2-parallax_downright
//6-parallax6
//level.parallax,level.correction,level.shootfactor,level.shootingfactor,level.enemyfactor
	switch ((char) *(memptrs[4] + 4)) {
	case 0:
		level.parallax = parallax1;
		break;
	case 1:
		level.parallax = parallax_normal;
		break;
	case 2:
		level.parallax = parallax_downright;
		break;
	case 6:
		level.parallax = parallax6;
		break;
	default:
		level.parallax = parallax1;
		break;
	}
	level.correction = *(char *) (memptrs[4] + 5);
	level.shootfactor = *(char *) (memptrs[4] + 6);
	level.shootingfactor = *(char *) (memptrs[4] + 7);
	level.enemyfactor = *(char *) (memptrs[4] + 8);

	enemy_matrix.width = (char) *(memptrs[4] + 10);
	enemy_matrix.height = (char) *(memptrs[4] + 11);
	enemy_matrix.offsets = (short *) (memptrs[4] + 12);
	enemy_matrix.matrix = (unsigned char *) (memptrs[4] + 12 +
						 sizeof(short) *
						 (enemy_matrix.width *
						  enemy_matrix.height +
						  1));
/*#ifdef DEBUG

printf("\n%i-%i-%i-%i-%i-%i-%i-%i-%i-%i-%i-%i",*(char *)(memptrs[4]+0),*(char *)(memptrs[4]+1),
*(char *)(memptrs[4]+2),
*(char *)(memptrs[4]+3),*(char *)(memptrs[4]+4),*(char *)(memptrs[4]+5),*(char *)(memptrs[4]+6),
*(char *)(memptrs[4]+7),*(char *)(memptrs[4]+8),*(char *)(memptrs[4]+9),
*(char *)(memptrs[4]+10),*(char *)(memptrs[4]+11));

	while(!keystat.fire) keyscan();
#endif

*/

	tiles = memptrs[2];
	attribs = memptrs[3];

// Some sprite function initialization stuff

	sprite_funcs[1] = enemy_mine_funcs;
	sprite_funcs[2] = enemy_bot_funcs;
	sprite_funcs[3] = enemy_masked_funcs;
	sprite_funcs[4] = access_a_button_funcs;
	sprite_funcs[5] = access_a_block_funcs;
	sprite_funcs[6] = enemy_mine_funcs;	// Only exists for save game stuff!!!
	sprite_funcs[7] = access_b_block_funcs;
	sprite_funcs[8] = enemy_mb1_funcs;
	sprite_funcs[9] = palace_collapse_funcs;
	sprite_funcs[10] = enemy_boss_funcs;
	/*-------------------------------------
	Note that sprite types 11 through 13 are
				unused right now.
	----------------------------------------*/
	sprite_funcs[11] = enemy_mine_funcs;
	sprite_funcs[12] = enemy_mine_funcs;
	sprite_funcs[13] = enemy_mine_funcs;
	/*----------------------------------------*/
	sprite_funcs[14] = item_funcs;
	sprite_funcs[15] = tag_position_funcs;
//-------------------------------------------

	player.exit_hit = 0;
	return 0;
}

void free_level(void)
{
	short i;

	for (i = 0; i < NR_LEVEL_ARCHIVE_ENTRIES; ++i) {
		if (memptrs[i]) {
			free(memptrs[i]);
			memptrs[i] = NULL;
		}
	}
}


void lev_prep(void)
{
	char buffer[10];
	char x = 0;
	ClearGrayScreen2B(GrayDBufGetHiddenPlane(0),
			  GrayDBufGetHiddenPlane(1));
	for (x = 0; x < 10; x++) {
		Sprite16_OR(x * 16, 0, 100,
			    (unsigned short *) (levprep + ((x * 100))),
			    GrayDBufGetHiddenPlane(0));
		Sprite16_OR(x * 16, 0, 100,
			    (unsigned short *) (levprep +
						(1000 + (x * 100))),
			    GrayDBufGetHiddenPlane(1));
	}
	if (level_num_cur == 0)
		sprintf(buffer, "User Lev");
	else
		sprintf(buffer, "Level %i", level_num_cur);
	GrayDBufToggleSync();
	ClearGrayScreen2B(GrayDBufGetHiddenPlane(0),
			  GrayDBufGetHiddenPlane(1));
	DisplaySpriteString(2, 3, buffer);
	do {
		keyscan();
	}
	while (!
	       (keystat.escape || keystat.up || keystat.fire
		|| keystat.enter));
	ClearGrayScreen2B(GrayDBufGetActivePlane(0),
			  GrayDBufGetActivePlane(1));
}

void makesaved(void)
{
	int y = 35, oldy = 35, choice = 1;
	DrawGrayRect2B(10, 9, 149, 90, COLOR_LIGHTGRAY, RECT_FILLED,
		       GrayDBufGetActivePlane(0),
		       GrayDBufGetActivePlane(1));
	DisplaySpriteString(40, 11, (char*)"Save Game");
	DisplaySpriteString(40, 35, (char*)"save 1");
	DisplaySpriteString(40, 50, (char*)"save 2");
	DisplaySpriteString(40, 65, (char*)"save 3");
	do {
		keyscan();
		DrawGrayRect(20, oldy, 28, oldy + 8, COLOR_LIGHTGRAY,
			     RECT_FILLED);
		DisplaySpriteString(20, y, (char*)"-");
		if (keystat.down) {
			choice++;
			oldy = y;
			y += 15;
			if (y == 80) {
				y = 35;
				choice = 1;
			}
		}
		if (keystat.up) {
			choice--;
			oldy = y;
			y -= 15;
			if (y == 20) {
				y = 65;
				choice = 3;
			}
		}
		do {
			keyscan();
		}
		while (keystat.up || keystat.down);
		delayt(1);
	}
	while (!(keystat.escape || keystat.enter));
	if (!(keystat.escape)) {
		char str[9] = "dukesav \0";
		FILE *f;
		short int n;	//,o;

		typedef struct {
			short level_num_cur;
			short xHard;
			short yHard;
			short saved_x;
			short saved_y;
			short life;
			short lives;
			unsigned long score;
			unsigned long episodescore;
			Sprite sprite1[SPRITE_NO];
			unsigned char difficulty;
		} save_struct;

		save_struct save_data;
		char buf[10];

		save_data.level_num_cur = level_num_cur;
		save_data.xHard =
		    (player.x >> 3) + level.xHard - 4 -
		    (((level.xHard >= level.xSize - 13)
		      && player.x > 32) ? ((player.x - 32) >> 3) : 0);
		save_data.yHard =
		    (player.x >> 3) + level.xHard - 4 -
		    (((level.yHard >= level.ySize - 13)
		      && player.y > 32) ? ((player.y - 32) >> 3) : 0);
		save_data.saved_x =
		    (player.x >> 3) + level.xHard -
		    (((level.xHard >= level.xSize - 13)
		      && player.x > 32) ? ((player.x - 32) >> 3) : 0);
		save_data.saved_y =
		    (player.y >> 3) + level.yHard -
		    (((level.yHard >= level.ySize - 13)
		      && player.y > 32) ? ((player.y - 32) >> 3) : 0);
		save_data.life = player.life;
		save_data.lives = player.lives;
		save_data.score = player.score;
		save_data.episodescore = episode_score;
		{
			int i;
			for (i = 0; i < SPRITE_NO; ++i) {
				save_data.sprite1[i] = sprites[i];
			}
		}
		save_data.difficulty = difficulty;

		sprintf(buf, "%i", choice);
		*(str + 7) = buf[0];
		f = fopen(str, "wb");

// we must check to see if we opened the file successfully
		if (f != NULL) {
//Writes stuff
			n = fwrite(&save_data, sizeof(save_struct), 1, f);

			if (n != 1) {
//DrawGrayStr(50,50,"Save Error",A_NORMAL);delayt(4);
			}
			fputc(0, f);
			fputs("duk ", f);
			fputc(0, f);
			fputc(OTH_TAG, f);
			fclose(f);
		} else {
			DrawGrayStr(50, 50, (char*)"Save Error", A_REPLACE);
			delayt(8);
		}
	}
	while(keystat.escape) keyscan();
}

char loadsaved(int choice)
{
//Sprite sprite1[SPRITE_NO];
	short i, n;
	typedef struct {
		short level_num_cur;
		short xHard;
		short yHard;
		short saved_x;
		short saved_y;
		short life;
		short lives;
		unsigned long score;
		unsigned long episodescore;
		Sprite sprite1[SPRITE_NO];
		unsigned char difficulty;
	} save_struct;
	save_struct load_data;
	FILE *f;
	char filename[9] = "dukesav \0";
	char buf[5];
	sprintf(buf, "%i", choice);
	*(filename + 7) = buf[0];
	f = fopen(filename, "rb");
// we must check to see if we opened the file successfully
	if (f != NULL) {
//Reads stuff
		n = fread(&load_data, sizeof(save_struct), 1, f);
		fclose(f);
		if (n != 1) {
//DrawGrayStr(50,50,"Error",A_NORMAL);delayt(4);
		}
		level_num_cur = load_data.level_num_cur;
		player.saved_x = load_data.saved_x;
		player.saved_y = load_data.saved_y;
		level.xHard = load_data.xHard;
		level.yHard = load_data.yHard;
		player.life = load_data.life;
		player.lives = load_data.lives;
		player.score = load_data.score;
		episode_score = load_data.episodescore;
		init_sprites();
		for (i = 0; i < SPRITE_NO; ++i) {
			sprites[i] = load_data.sprite1[i];
		}
		difficulty = load_data.difficulty;
		is_loaded = 1;


	} else {
		level_num_cur = 1;
		is_loaded = 0;
		return -5;
	}
	return 0;
}



void makequick(void)
{
	{
		char str[9] = "dukesav0\0";
		FILE *f;
		short int n;	//,o;

		typedef struct {
			short level_num_cur;
			short xHard;
			short yHard;
			short saved_x;
			short saved_y;
			short life;
			short lives;
			unsigned long score;
			unsigned long episodescore;
			Sprite sprite1[SPRITE_NO];
			unsigned char difficulty;
		} save_struct;
		save_struct save_data;


		save_data.level_num_cur = level_num_cur;
		save_data.xHard =
		    (player.x >> 3) + level.xHard - 4 -
		    (((level.xHard >= level.xSize - 13)
		      && player.x > 32) ? ((player.x - 32) >> 3) : 0);
		save_data.yHard =
		    (player.x >> 3) + level.xHard - 4 -
		    (((level.yHard >= level.ySize - 13)
		      && player.y > 32) ? ((player.y - 32) >> 3) : 0);
		save_data.saved_x =
		    (player.x >> 3) + level.xHard -
		    (((level.xHard >= level.xSize - 13)
		      && player.x > 32) ? ((player.x - 32) >> 3) : 0);
		save_data.saved_y =
		    (player.y >> 3) + level.yHard -
		    (((level.yHard >= level.ySize - 13)
		      && player.y > 32) ? ((player.y - 32) >> 3) : 0);
		save_data.life = player.life;
		save_data.lives = player.lives;
		save_data.score = player.score;
		save_data.episodescore = episode_score;
		save_data.difficulty = difficulty;
		{
			int i;
			for (i = 0; i < SPRITE_NO; ++i) {
				save_data.sprite1[i] = sprites[i];
			}
		}

		f = fopen(str, "wb");

// we must check to see if we opened the file successfully
		if (f != NULL) {
//Writes stuff
			n = fwrite(&save_data, sizeof(save_struct), 1, f);

			if (n != 1) {
//DrawGrayStr(50,50,"Quick Error",A_NORMAL);delayt(4);
			}
			fputc(0, f);
			fputs("duk ", f);
			fputc(0, f);
			fputc(OTH_TAG, f);
			fclose(f);
		} else {
			DrawGrayStr(50, 50, (char*)"Quick Error", A_REPLACE);
			delayt(8);
		}
	}
}
