#include <mem.h>
#include <system.h>
#include <compat.h>
#include <kbd.h>
#include "keyscan.h"

Keystat keystat;
Keystat oldkeystat;
void (*keyscan) (void) = keyscan_89;

void keyscan_init(void)
{
	if (CALCULATOR==1) {
		keyscan = keyscan_92p;
	}
	else if (CALCULATOR==3) {
		keyscan = keyscan_v200;
	} else {
		keyscan = keyscan_89;
	}
}

void keyscan_89(void)
{
	unsigned char row0, row1, row3, row5, row6;
	memcpy(&oldkeystat, &keystat, sizeof keystat);
	row0 = _rowread(~0x0001);
	keystat.up = row0 & 0x01;
	keystat.down = row0 & 0x04;
	keystat.left = row0 & 0x02;
	keystat.right = row0 & 0x08;
	keystat.second = row0 & 0x10;
	keystat.jump = row0 & 0x11;	// second or up
	keystat.shift = row0 & 0x20;
	keystat.diamond = row0 & 0x40;
	keystat.fire = keystat.diamond;
	row1 = _rowread(~0x0002);
	keystat.enter = row1 & 0x01;
	keystat.plus = row1 & 0x02;
	keystat.minus = row1 & 0x04;
	keystat.f5 = row1 & (1 << 7);
	row3 = _rowread(~((short) (1 << 3)));
	keystat.f3 = row3 & (1 << 7);
	row5 = _rowread(~((short) (1 << 5)));
	keystat.f1 = row5 & (1 << 7);
	row6 = _rowread(~((short) (1 << 6)));
	keystat.escape = row6 & 0x01;
}

void keyscan_92p(void)
{
	unsigned char row0, row4, row6, row7, row8, row9;
	memcpy(&oldkeystat, &keystat, sizeof keystat);
	row0 = _rowread(~0x0001);
	keystat.up = row0 & 0x20;
	keystat.down = row0 & 0x80;
	keystat.left = row0 & 0x10;
	keystat.right = row0 & 0x40;
	keystat.shift = row0 & 0x04;
	keystat.second = row0 & 0x08;	//not second, but hand (for easy playing)
	keystat.jump = row0 & 0x28;	// second(hand) or up
	row4 = _rowread(~((short) (1 << 4)));
	keystat.f3 = row4 & 0x10;	//This is really F2
	row6 = _rowread(~((short) (1 << 6)));
	keystat.f1 = row6 & (1 << 4);
	row7 = _rowread(~((short) (1 << 7)));
	keystat.diamond = row7 & 0x10;	//not diamond, but f5
	keystat.fire = keystat.diamond;	//not diamond, but f5
	row8 = _rowread(~0x0100);
	keystat.escape = row8 & 0x40;
	keystat.plus = row8 & 0x10;
	row9 = _rowread(~0x0200);
	keystat.f5 = row9 & 0x10;	//This is really F4
	keystat.enter = row9 & 0x02;
	keystat.enter |= row6 & 0x40;	// enter2
}

void keyscan_v200(void)
{
	unsigned char row0,row2, row4, row6, row8, row9;
	memcpy(&oldkeystat, &keystat, sizeof keystat);
	row0 = _rowread(~0x0001);
	keystat.up = row0 & 0x20;
	keystat.down = row0 & 0x80;
	keystat.left = row0 & 0x10;
	keystat.right = row0 & 0x40;
	keystat.shift = row0 & 0x04;
	keystat.second = row0 & 0x08;	//not second, but hand (for easy playing)
	keystat.jump = row0 & 0x28;	// second(hand) or up
	row2 = _rowread(~((short) (1 << 2)));
	keystat.f5 = row2 & (1 << 4);	//This is really F3	
	row4 = _rowread(~((short) (1 << 4)));
	keystat.f3 = row4 & 0x10;	//This is really F2
	row6 = _rowread(~((short) (1 << 6)));
	keystat.f1 = row6 & (1 << 4);
	row8 = _rowread(~0x0100);
	keystat.escape = row8 & 0x40;
	keystat.plus = row8 & 0x10;
	row9 = _rowread(~0x0200);
	keystat.enter = row9 & 0x02;
	keystat.enter |= row6 & 0x40;	// enter2
	keystat.diamond = row9 & (1 << 3);	//not diamond, but Q
	keystat.fire = keystat.diamond;	//not diamond, but Q
}