#include "all.h"

// Pointers to sprite data
unsigned short *introgfx = NULL;
unsigned short *menugfx = NULL;
unsigned short *levprep = NULL;
unsigned short *scorepic = NULL;
unsigned short *landgfx = NULL;
unsigned short *spritegfx = NULL;

/* all known pointers for allocated GFX */
unsigned short **gfxptrs[] =
    { &introgfx, &menugfx, &levprep, &scorepic, &landgfx, &spritegfx };

/*
 * return values:
 *  0: OK
 * -1: file not found
 * -2: not a valid archive
 * -3: not enough memory
 * -4: unpack error
 */
// Loads the external file dukegfx.pak
short loadgfx()
{
	SYM_ENTRY *symptr;
	void *archive;
	short i;

	symptr = DerefSym(SymFind($(dukegfx)));
	if (!symptr)
		return -1;

	archive = HLock(symptr->handle);
	archive += 2;

	if (!ttarchive_valid(archive)) {
		HeapUnlock(symptr->handle);
		return -2;
	}

	for (i = 0; i < 6; ++i) {
		short retval;
		unsigned short entry_size;
		void *memptr;

		entry_size = ttunpack_size(ttarchive_data(archive, i));
		memptr = (unsigned short *) malloc(entry_size);
		if (!memptr) {
#ifdef DEBUG
			printf("\nGfx %i Size %i", i + 1, entry_size);
#endif
			HeapUnlock(symptr->handle);
			return -3;
		}
#ifdef DEBUG
		printf("\nGfx %i Size %i", i + 1, entry_size);
		printf("\nGfx %i OK", i + 1);
#endif
		*gfxptrs[i] = memptr;
		retval =
		    ttunpack_decompress(ttarchive_data(archive, i),
					memptr);
		if (retval) {
			HeapUnlock(symptr->handle);
			return -4;
		}
	}
	HeapUnlock(symptr->handle);
	{

	}
#ifdef DEBUG
	while (!keystat.enter)
		keyscan();
	while (keystat.enter)
		keyscan();
#endif
	return 0;
}

// Free the GFX ptr memory
void freegfx(void)
{
	short i;
	void *memptr;
	for (i = 0; i < 6; ++i) {
		memptr = *gfxptrs[i];
		if (memptr) {
			free(memptr);
			memptr = NULL;
		}
	}
}

// This pauses when in-game.
void do_pause(void)
{
	char buffer[11];
	DrawGrayRect2B(39, 9, 120, 90, COLOR_LIGHTGRAY, RECT_FILLED,
		       GrayDBufGetActivePlane(0),
		       GrayDBufGetActivePlane(1));
	DisplaySpriteString(45, 11, (char *) "Paused");
	DisplaySpriteString(45, 25, (char *) "Lev Score");
	sprintf(buffer, "%li", player.score);
	DisplaySpriteString(45, 35, buffer);
	DisplaySpriteString(45, 55, (char *) "Health");
	sprintf(buffer, "%i", player.life);
	DisplaySpriteString(45, 65, buffer);
	sprintf(buffer, "Lives: %i", player.lives);
	DisplaySpriteString(45, 75, buffer);
	do {
		keyscan();
	}
	while (!
	       (keystat.escape || keystat.up || keystat.fire
		|| keystat.enter));
	while (keystat.escape)
		keyscan();
}


// This shows the post-level summary.
void show_summary(void)
{
	char buffer[18];
	void *plane0, *plane1;
	unsigned long int bonus = 0;
	unsigned long int level_score = 0;
	unsigned char x_o=xoffset;
	char x = 0;
	ClearGrayScreen2B(GrayDBufGetHiddenPlane(0),
			  GrayDBufGetHiddenPlane(1));
	ClearGrayScreen2B(GrayDBufGetActivePlane(0),
			  GrayDBufGetActivePlane(1));

// Loads the BONUS screen.
	for (x = 0; x < 10; x++) {
		Sprite16_OR(x * 16 + x_o, 0, 100,
			    (unsigned short *) (scorepic + ((x * 100))),
			    GrayDBufGetHiddenPlane(0));
		Sprite16_OR(x * 16 + x_o, 0, 100,
			    (unsigned short *) (scorepic +
						(1000 + (x * 100))),
			    GrayDBufGetHiddenPlane(1));
	}
	level_score = player.score;
// Adds the level score to the cumulative score.
	episode_score += player.score;
//Resets level score
	player.score = 0;

//Displays scores
	GrayDBufToggleSync();
	plane0 = GrayDBufGetActivePlane(0);
	plane1 = GrayDBufGetActivePlane(1);
	sprintf(buffer, "%lu", episode_score);
	DisplaySpriteString(69 + x_o, 32, buffer);
	text(68, (char *) "Bonuses");
	delayt(18);
	sprintf(buffer, " Life %i  ", player.life);
	DrawGrayRect2B(24 + x_o, 67, 132 + x_o, 75, COLOR_BLACK,
		       RECT_FILLED, plane0, plane1);
	text(68, buffer);
	delayt(14);
	DrawGrayRect2B(34 + x_o, 67, 122 + x_o, 75, COLOR_BLACK,
		       RECT_FILLED, plane0, plane1);
	text(68, (char *) "x 125");
	delayt(14);
//The following code counts down bonus while adding them to the score.
	if (player.life > 0) {
		for (bonus = player.life * 125; bonus > 51; bonus -= 51) {
			episode_score += 51;
			sprintf(buffer, "%lu", episode_score);
			DrawGrayRect2B(67 + x_o, 32, 67 + 60 + x_o,
				       41, COLOR_BLACK, RECT_FILLED,
				       plane0, plane1);
			DisplaySpriteString(67 + x_o, 32, buffer);
			sprintf(buffer, "%lu", bonus);
			DrawGrayRect2B(34 + x_o, 67, 122 + x_o, 75,
				       COLOR_BLACK, RECT_FILLED, plane0,
				       plane1);
			text(68, buffer);
			keyscan();
			if (keystat.escape)
				break;
		}
		episode_score += bonus;
	}
	if (keystat.escape)
		episode_score -= 51;
	bonus = 0;

//Shows the final score.
	sprintf(buffer, "%lu", episode_score);
	DrawGrayRect2B(67 + x_o, 32, 67 + 60 + x_o, 41,
		       COLOR_BLACK, RECT_FILLED, plane0, plane1);
	DisplaySpriteString(67 + x_o, 32, buffer);
	sprintf(buffer, "%lu", bonus);
	DrawGrayRect2B(34 + x_o, 67, 122 + x_o, 75, COLOR_BLACK,
		       RECT_FILLED, plane0, plane1);
	text(68, buffer);
	if (!keystat.escape)
		delayt(18);
	sprintf(buffer, "x Difficulty %i  ", difficulty);
	DrawGrayRect2B(24 + x_o, 67, 132 + x_o, 75, COLOR_BLACK,
		       RECT_FILLED, plane0, plane1);
	text(68, buffer);
// Uses the difficulty multiplier.
	if (difficulty == 2)
		episode_score += level_score;
	delayt(14);

	sprintf(buffer, "%lu", episode_score);
	DrawGrayRect2B(67 + x_o, 32, 67 + 60 + x_o, 41,
		       COLOR_BLACK, RECT_FILLED, plane0, plane1);
	DisplaySpriteString(67 + x_o, 32, buffer);
	if (level_num_cur == 11) {
		delayt(5);
		sprintf(buffer, "Lives %i x 1000 ", player.lives);
		DrawGrayRect2B(24 + x_o, 67, 132 + x_o, 75,
			       COLOR_BLACK, RECT_FILLED, plane0, plane1);
		text(68, buffer);
		episode_score += player.lives * 1000;
		delayt(20);
		sprintf(buffer, "%lu", episode_score);
		DrawGrayRect2B(67 + x_o, 32, 67 + 60 + x_o, 41,
			       COLOR_BLACK, RECT_FILLED, plane0, plane1);
		DisplaySpriteString(67 + x_o, 32, buffer);
	}
	sprintf(buffer, "Congratulations");
	DrawGrayRect2B(22 + x_o, 67, 122 + x_o, 75, COLOR_BLACK,
		       RECT_FILLED, plane0, plane1);
	text(68, buffer);

// Increases the player's lives 
	player.lives += ((difficulty));
keyscan();
//Waits until a key is pressed
{
short freq[]=
{466,440,392,349,311,349,392,440,466,466,466};
char duree[]=
{9,9,9,9,9,9,9,9,18,18,18};
unsigned short current=0;
while (!(keystat.escape || keystat.second || keystat.enter))
{
if(current<11) {beep(freq[current],duree[current],VTI,hardwarever);
current++;}
keyscan();
}
}



//Waits until that key is released              
	do {
		keyscan();
	}
	while ((keystat.escape || keystat.second || keystat.enter));
}

// Loads the dukecfg file, which stores the intro and speed preferences, and highscores.
void loadcfg(void)
{
	short n;
	short a = 0;
//This structure holds the data to be loaded.
	typedef struct {
		char game_speed;
		char intropref;
		short snd;
		Score highscore[5];
	} save_struct;
	save_struct load_data;
	FILE *f;
	f = fopen("dukecfg", "rb");
// we must check to see if we opened the file successfully
	if (f != NULL) {
//Reads stuff
		n = fread(&load_data, sizeof(save_struct), 1, f);
		fclose(f);
		game_speed = load_data.game_speed;
		intropref = load_data.intropref;
		sound=load_data.snd;
		for (a = 0; a < 5; a++) {
			highscores[a] = load_data.highscore[a];
		}
	} else {
//Error, oh well
	}
}



void savecfg(void)
{
	short n;
	short a = 0;
//Holds the data to save:
	typedef struct {
		char game_speed;
		char intropref;
		short snd;
		Score highscore[5];
	} save_struct;
	save_struct save_data;
	FILE *f;

	save_data.game_speed = game_speed;
	save_data.intropref = intropref;
	save_data.snd=sound;
	for (a = 0; a < 5; a++) {
		save_data.highscore[a] = highscores[a];
	}

	if ((SymFindPtr(SYMSTR("dukecfg"), 0)->flags.bits.archived) == 1)
		return;

	f = fopen("dukecfg", "wb");
// we must check to see if we opened the file successfully
	if (f != NULL) {
//Writes stuff
		n = fwrite(&save_data, sizeof(save_struct), 1, f);
		fputc(0, f);
		fputs("dcfg", f);
		fputc(0, f);
		fputc(OTH_TAG, f);
		fclose(f);

	} else {
//Error, oh well
	}
}


/*

All this stuff uses vat.h, but is incomplete.
Maybe I'll use it in v2.

void savecfg(void)
{
void AppendCharToFile (HANDLE h, char c)
{
  char *base = HeapDeref(h);
  unsigned short len = *(unsigned short*)base;
  if (len > HeapSize(h) - 10) return;
  *(unsigned short*)base = 2;
  base[len+2] = c;
}
  HANDLE h;
  SYM_ENTRY *sym_entry;

  if (!(h = HeapAlloc (HeapMax ()))) return H_NULL;
  if (!(sym_entry = DerefSym (SymAdd ($(dukecfg)))))
    {
      HeapFree (h);
      return H_NULL;
    }
  *(long*) HeapDeref (sym_entry->handle = h) = 0x00010000;




char data[2];
data[0] = game_speed;
data[1] = intropref;
  HANDLE h;
  AppendCharToFile (h, game_speed);
  AppendCharToFile(h,0);
  AppendCharToFile(h,'d');
  AppendCharToFile(h,'u');
  AppendCharToFile(h,'k');
  AppendCharToFile(h,0);
  AppendCharToFile(h,0xF8);
  HeapUnlock (h);
  HeapRealloc (h, *(unsigned short*)HeapDeref(h) + 7);

}







}


void loadcfg(void)
{
	
}*/
