#include "all.h"


BossStruct boss;
ContrastStruct contrast;


short gameloop(void)
{
	short count_current;
	short levelerror;
	CustomStruct custom;
	
	custom_init(&custom);
	
	ClearGrayScreen2B(GrayDBufGetHiddenPlane(0),
			  GrayDBufGetHiddenPlane(1));
	ClearGrayScreen2B(GrayDBufGetActivePlane(0),
			  GrayDBufGetActivePlane(1));

	if (difficulty != 1 && difficulty != 2)
		difficulty = 1;
	if (is_loaded != 1 && is_loaded != 0)
		is_loaded = 0;

	if ((levelerror = load_level()) != 0)
		return levelerror;
		
	pokeIO(0x600017,257-(game_speed*8)-35);      // Force timer to work faster
	if (!is_loaded) {
		init_sprites();
		player.score = 0;
	}
	lev_prep();
	level.init();
	level.yHard++;
	level.xHard++;


	if (!is_loaded)
		drawPlayerLife(1);	// reset life bar
	if (is_loaded) {
		erase_all_sprites();
		player.exit_hit = 0;
		spawn_all_buttons();
		is_loaded = 0;
	}

	player_respawn();

	weapon_init();

	custom.scrollSpeedX = 0;
	custom.scrollSpeedY = 0;


	prepVidmem();

	player.old_face = 1;
	do {
		count_current = count;

		keyscan();
		kill_sprites_oos();
		moveShots();
		moveEnemyShots();
		movePlayer();
		spawn_enemies();
		handle_sprites();

		shoot();

		// scrolling hysteresis

		//if facing left...
		if (level.xHard >= 4) {
			if (player.face == 0) {
				if (player.x < 160 - 40 - 16)
					custom.scrollSpeedX = -4;
				if (player.x <= 40 + 10 + 32)
					custom.scrollSpeedX = -8;
				if (player.old_face != player.face)
					custom.scrollSpeedX = -4;
				if (player.x > 160 - 40 - 16)
					custom.scrollSpeedX = 0;
				player.old_face = player.face;
			}
		}
		//if facing right...
		if (level.xHard <= (level.xSize - 4 - 1)) {
			if (player.face == 1) {
				if (player.x > 40 + 10)
					custom.scrollSpeedX = 4;
				if (player.x >= 150 - 40 - 16 - 32)
					custom.scrollSpeedX = 8;
				if (player.old_face != player.face)
					custom.scrollSpeedX = 4;
				if (player.x < 40)
					custom.scrollSpeedX = 0;
				player.old_face = player.face;
			}
		}

		{
//vertical hysteresis
			unsigned char downkey = keystat.down;
			
/*-----------Specific to Duke 68k----------*/			
			if (level_num_cur == 11) {
				keystat.down = 0;			}
/*-----------------------------------------*/

			if (player.y > (keystat.down ? 15 : 40)
			    && player.y < 50)
				custom.scrollSpeedY = 0;


			if (player.y < (keystat.down ? 14 : 39))
				custom.scrollSpeedY = -4;
			if (player.y > ((keystat.down) ? 26 : 51))
				custom.scrollSpeedY = 4;
			keystat.down = downkey;
		}


		// actual scroll speed may differ from wanted speed (at edges)
		custom.scrollSpeedX = scrollX(custom.scrollSpeedX);
		custom.scrollSpeedY = scrollY(custom.scrollSpeedY);
		player.x -= custom.scrollSpeedX;
		player.y -= custom.scrollSpeedY;
		adjust_sprite_pos(custom.scrollSpeedX, custom.scrollSpeedY);
		level.parallax(custom.scrollSpeedX, custom.scrollSpeedY);

		drawVidmem();
		softscrollX();
		draw_sprites();
		drawPlayer();
		draw_bullets();
		if (CALCULATOR)  //If the calc is a 92+
			cutEdge();
		memset(GrayDBufGetHiddenPlane(0) + 94 * 30, 0, 6 * 30);
		memset(GrayDBufGetHiddenPlane(1) + 94 * 30, 0, 6 * 30);
		drawPlayerLife(0);

		custom_before_switch(&custom);

		contrastchk();

		// back buffer now becomes the active screen
		GrayDBufToggleSync();

custom_after_switch(&custom);

//Synchronizes to Auto Int 5, for game speed
if(game_speed)		while (count_current == count);


	} while (!
		 (custom.force_quit || player.exit_hit == 2
		  || player.exit_hit == -2 || player.exit_hit == -6));
		  
		free_level();
		pokeIO(0x600017, 0xB2);	// Restore normal timer speed

{
	short retval = custom_exit(&custom);
	return retval;
}

}
