#include "all.h"

/* Shade Font by Michael Holt (PsiGoo) */

#define letter1 _DLL_reference(unsigned char,19)
#define letter2 _DLL_reference(unsigned char,20)
#define letterm _DLL_reference(unsigned char,21)
#define number1 _DLL_reference(unsigned char,22)
#define number2 _DLL_reference(unsigned char,23)
#define numberm _DLL_reference(unsigned char,24)
#define sprcolon1 _DLL_reference(unsigned char,41)
#define sprdash1 _DLL_reference(unsigned char,42)
#define sprcolon2 _DLL_reference(unsigned char,43)
#define sprdash2 _DLL_reference(unsigned char,44)
#define sprcolonm _DLL_reference(unsigned char,45)
#define sprdashm _DLL_reference(unsigned char,46)
//#define DisplayLetter _DLL_call(void,(int,int,unsigned char*,unsigned char*,unsigned char*),47)
//#define DisplayOffLetter _DLL_call(void,(int,int,unsigned char*,unsigned char*,unsigned char*),48)
//#define DisplaySpriteString _DLL_call(void,(int,int,unsigned char*),49)
//#define DisplayOffSpriteString _DLL_call(void,(int,int,unsigned char*),50)

// Displays a letter on the current screen
void DisplayLetter(int x, int y, unsigned char *sprite1,
		   unsigned char *sprite2, unsigned char *spritem)
{
	void *p0 = GrayDBufGetActivePlane(0);
	void *p1 = GrayDBufGetActivePlane(1);
	Sprite8_AND(x, y, 8, spritem, p0);
	Sprite8_AND(x, y, 8, spritem, p1);

	Sprite8_OR(x, y, 8, sprite1, p0);
	Sprite8_OR(x, y, 8, sprite2, p1);
}

// Displays a letter on the nonActive screen
void DisplayOffLetter(int x, int y, unsigned char *sprite1,
		      unsigned char *sprite2, unsigned char *spritem)
{
	void *p0 = GrayDBufGetHiddenPlane(0);
	void *p1 = GrayDBufGetHiddenPlane(1);
	Sprite8_AND(x, y, 8, spritem, p0);
	Sprite8_AND(x, y, 8, spritem, p1);

	Sprite8_OR(x, y, 8, sprite1, p0);
	Sprite8_OR(x, y, 8, sprite2, p1);
}

/*
// Displays a letter on screen one (1)
void DisplayLetter1(int x, int y, unsigned char *sprite1,
		    unsigned char *sprite2, unsigned char *spritem)
{
	Sprite8_AND(x, y, 8, spritem, GetDPlane(1, 0));
	Sprite8_AND(x, y, 8, spritem, GetDPlane(1, 1));

	Sprite8_OR(x, y, 8, sprite1, GetDPlane(1, 0));
	Sprite8_OR(x, y, 8, sprite2, GetDPlane(1, 1));
}

*/
void DisplaySpriteString(int x, int y, unsigned char *string)
{
	unsigned int i;
	for (i = 0; i < strlen(string); i++) {

/*  Displays a letter */
		if (string[i] >= 65 && string[i] <= 90)
			string[i] += 32;
		if (string[i] >= 97 && string[i] <= 122) {
			DisplayLetter(x, y, letter1 + (string[i] - 97) * 8,
				      letter2 + (string[i] - 97) * 8,
				      letterm + (string[i] - 97) * 8);
			x += ((char[]) {
			      9, 7, 7, 7, 7, 7, 8, 8, 8, 9, 8, 7, 9, 9, 8,
			      7, 8, 7, 9, 8, 8, 8, 9, 9, 8,
			      9})[string[i] - 97];
		}


/* Displays a character */
		if (string[i] == ' ')
			x += 6;
		if (string[i] == ':') {
			DisplayLetter(x, y, sprcolon1, sprcolon2,
				      sprcolonm);
			x += 4;
		}
		if (string[i] == '-') {
			DisplayLetter(x, y, sprdash1, sprdash2, sprdashm);
			x += 9;
		}


/* Displays a number */
		if (string[i] >= 47 && string[i] <= 57) {
			DisplayLetter(x, y, number1 + (string[i] - 47) * 8,
				      number2 + (string[i] - 47) * 8,
				      numberm + (string[i] - 47) * 8);
			x += ((char[]) {
			      7, 7, 5, 9, 7, 8, 9, 7, 7, 7,
			      7})[string[i] - 47];
		}





	}
}

void DisplayOffSpriteString(int x, int y, unsigned char *string)
{
	unsigned int i;
	for (i = 0; i < strlen(string); i++) {

/*  Displays a letter */
		if (string[i] >= 65 && string[i] <= 90)
			string[i] += 32;
		if (string[i] >= 97 && string[i] <= 122) {
			DisplayOffLetter(x, y,
					 letter1 + (string[i] - 97) * 8,
					 letter2 + (string[i] - 97) * 8,
					 letterm + (string[i] - 97) * 8);
			x += ((char[]) {
			      9, 7, 7, 7, 7, 7, 8, 8, 8, 9, 8, 7, 9, 9, 8,
			      7, 8, 7, 9, 8, 8, 8, 9, 9, 8,
			      9})[string[i] - 97];
		}


/* Displays a character */
		if (string[i] == ' ')
			x += 6;
		if (string[i] == ':') {
			DisplayOffLetter(x, y, sprcolon1, sprcolon2,
					 sprcolonm);
			x += 4;
		}
		if (string[i] == '-') {
			DisplayOffLetter(x, y, sprdash1, sprdash2,
					 sprdashm);
			x += 9;
		}


/* Displays a number */
		if (string[i] >= 47 && string[i] <= 57) {
			DisplayOffLetter(x, y,
					 number1 + (string[i] - 47) * 8,
					 number2 + (string[i] - 47) * 8,
					 numberm + (string[i] - 47) * 8);
			x += ((char[]) {
			      7, 7, 5, 9, 7, 8, 9, 7, 7, 7,
			      7})[string[i] - 47];
		}





	}
}
void text(int y, unsigned char *string)
{
	unsigned int x = 0, i;	//,text_offset=0;
	for (i = 0; i < strlen(string); i++) {

		if (string[i] >= 65 && string[i] <= 90)
			string[i] += 32;
		if (string[i] >= 97 && string[i] <= 122)
			x += ((char[]) {
			      9, 7, 7, 7, 7, 7, 8, 8, 8, 9, 8, 7, 9, 9, 8,
			      7, 8, 7, 9, 8, 8, 8, 9, 9, 8, 9}
		)[string[i] - 97];
		if (string[i] == ' ')
			x += 6;
		if (string[i] == ':')
			x += 4;
		if (string[i] == '-')
			x += 9;
		if (string[i] >= 47 && string[i] <= 57)
			x += ((char[]) {
			      7, 7, 5, 9, 7, 8, 9, 7, 7, 7, 7}
		)[string[i] - 47];
	}
	DisplaySpriteString(80 + xoffset - x / 2, y, string);
}


void text1(int y, unsigned char *string)
{
	unsigned int x = 0, i;
	for (i = 0; i < strlen(string); i++) {

		if (string[i] >= 65 && string[i] <= 90)
			string[i] += 32;
		if (string[i] >= 97 && string[i] <= 122)
			x += ((char[]) {
			      9, 7, 7, 7, 7, 7, 8, 8, 8, 9, 8, 7, 9, 9, 8,
			      7, 8, 7, 9, 8, 8, 8, 9, 9, 8, 9}
		)[string[i] - 97];
		if (string[i] == ' ')
			x += 6;
		if (string[i] == ':')
			x += 4;
		if (string[i] == '-')
			x += 9;
		if (string[i] >= 47 && string[i] <= 57)
			x += ((char[]) {
			      7, 7, 5, 9, 7, 8, 9, 7, 7, 7, 7}
		)[string[i] - 47];
	}
	DisplayOffSpriteString(80 + xoffset - x / 2, y, string);
}
